/*
 * Decompiled with CFR 0.152.
 */
package org.lsc.jndi;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingException;
import org.mozilla.javascript.NativeJavaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptableObject {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScriptableObject.class);

    public List<String> wrap(String methodName, Object a, Object b, boolean listable) throws NamingException {
        Method method = null;
        try {
            List<String> aList = this.getList(a);
            List<String> bList = this.getList(b);
            if (listable) {
                method = this.getClass().getDeclaredMethod(methodName, List.class, List.class);
                return (List)method.invoke((Object)this, aList, bList);
            }
            if (aList == null || bList == null) {
                return null;
            }
            method = this.getClass().getDeclaredMethod(methodName, String.class, String.class);
            ArrayList<String> results = new ArrayList<String>();
            for (String aValue : aList) {
                for (String bValue : bList) {
                    List res = (List)method.invoke((Object)this, aValue, bValue);
                    if (res == null) continue;
                    results.addAll(res);
                }
            }
            return results;
        }
        catch (SecurityException e) {
            LOGGER.error("Programmatic error", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            LOGGER.error("Programmatic error", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Programmatic error", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOGGER.error("Programmatic error", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            LOGGER.error("Programmatic error", (Throwable)e);
        }
        return null;
    }

    public List<String> getList(Object a) {
        ArrayList<String> aList = null;
        if (a == null) {
            return null;
        }
        if (String.class.isAssignableFrom(a.getClass())) {
            aList = new ArrayList<String>();
            aList.add((String)a);
            return aList;
        }
        if (List.class.isAssignableFrom(a.getClass())) {
            aList = (List)a;
            return aList;
        }
        if (NativeJavaObject.class.isAssignableFrom(a.getClass())) {
            aList = this.getList(((NativeJavaObject)a).unwrap());
            return aList;
        }
        return null;
    }

    public List<String> wrapList(String methodName, Object a, Object b) throws NamingException {
        return this.wrap(methodName, a, b, true);
    }

    public List<String> wrapString(String methodName, Object a, Object b) throws NamingException {
        return this.wrap(methodName, a, b, false);
    }
}

