/*
 * Decompiled with CFR 0.152.
 */
package org.lsc.jndi;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import javax.naming.CommunicationException;
import javax.naming.NamingException;
import javax.naming.directory.SearchResult;
import org.lsc.LscDatasets;
import org.lsc.LscModifications;
import org.lsc.beans.IBean;
import org.lsc.configuration.LdapServiceType;
import org.lsc.configuration.TaskType;
import org.lsc.exception.LscServiceCommunicationException;
import org.lsc.exception.LscServiceConfigurationException;
import org.lsc.exception.LscServiceException;
import org.lsc.jndi.AbstractSimpleJndiService;
import org.lsc.jndi.JndiModificationType;
import org.lsc.jndi.JndiModifications;
import org.lsc.service.IWritableService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleJndiDstService
extends AbstractSimpleJndiService
implements IWritableService {
    private Class<IBean> beanClass;
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleJndiDstService.class);
    private List<String> writableDatasetIds;

    public SimpleJndiDstService(TaskType task) throws LscServiceConfigurationException {
        super(task.getLdapDestinationService());
        this.writableDatasetIds = task.getLdapDestinationService().getFetchedAttributes().getString();
        try {
            this.beanClass = Class.forName(task.getBean());
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Bean class {} not found. Check this class name really exists.", (Object)task.getBean());
            throw new LscServiceConfigurationException(e);
        }
    }

    public SimpleJndiDstService(LdapServiceType ldapService, List<String> writableDatasetIds, Class<IBean> beanClass) throws LscServiceConfigurationException {
        super(ldapService);
        this.writableDatasetIds = writableDatasetIds;
        this.beanClass = beanClass;
    }

    @Override
    public final IBean getBean(String pivotName, LscDatasets pivotAttributes, boolean fromSameService) throws LscServiceException {
        try {
            SearchResult srObject = this.get(pivotName, pivotAttributes, this.filterIdSync);
            Method method = this.beanClass.getMethod("getInstance", SearchResult.class, String.class, Class.class);
            return (IBean)method.invoke(null, srObject, this.jndiServices.completeDn(this.getBaseDn()), this.beanClass);
        }
        catch (SecurityException e) {
            LOGGER.error("Unable to get static method getInstance on {} ! This is probably a programmer's error ({})", (Object)this.beanClass.getName(), (Object)e.toString());
            LOGGER.debug(e.toString(), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            LOGGER.error("Unable to get static method getInstance on {} ! This is probably a programmer's error ({})", (Object)this.beanClass.getName(), (Object)e.toString());
            LOGGER.debug(e.toString(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Unable to get static method getInstance on {} ! This is probably a programmer's error ({})", (Object)this.beanClass.getName(), (Object)e.toString());
            LOGGER.debug(e.toString(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOGGER.error("Unable to get static method getInstance on {} ! This is probably a programmer's error ({})", (Object)this.beanClass.getName(), (Object)e.toString());
            LOGGER.debug(e.toString(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            LOGGER.error("Unable to get static method getInstance on {} ! This is probably a programmer's error ({})", (Object)this.beanClass.getName(), (Object)e.toString());
            LOGGER.debug(e.toString(), (Throwable)e);
        }
        catch (NamingException e) {
            throw new LscServiceException(e);
        }
        return null;
    }

    @Override
    public Map<String, LscDatasets> getListPivots() throws LscServiceException {
        try {
            return this.jndiServices.getAttrsList(this.getBaseDn(), this.getFilterAll(), 2, this.getAttrsId());
        }
        catch (NamingException e) {
            throw new LscServiceException(e);
        }
    }

    public boolean apply(JndiModifications jm) throws LscServiceCommunicationException {
        try {
            return this.jndiServices.apply(jm);
        }
        catch (CommunicationException e) {
            throw new LscServiceCommunicationException(e);
        }
    }

    @Override
    public boolean apply(LscModifications lm) throws LscServiceException {
        JndiModifications jm = new JndiModifications(JndiModificationType.getFromLscModificationType(lm.getOperation()), lm.getTaskName());
        jm.setDistinguishName(lm.getMainIdentifier());
        jm.setNewDistinguishName(lm.getNewMainIdentifier());
        jm.setModificationItems(JndiModifications.fromLscAttributeModifications(lm.getLscAttributeModifications()));
        try {
            return this.jndiServices.apply(jm);
        }
        catch (CommunicationException e) {
            throw new LscServiceException(e);
        }
    }

    @Override
    public List<String> getWriteDatasetIds() {
        return this.writableDatasetIds;
    }
}

