/*
 * Decompiled with CFR 0.152.
 */
package org.lsc.jndi.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lsc.jndi.parser.LdapAttributeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapObjectClass {
    private static final int MAX_PASS_BEFORE_FAILING = 100;
    private String oid;
    private String name;
    private Map<String, String> x = new HashMap<String, String>();
    private String inheritFrom;
    private String description;
    private String type;
    private List<String> monoAttrs = new ArrayList<String>();
    private List<String> multiAttrs = new ArrayList<String>();
    private static final Logger LOGGER = LoggerFactory.getLogger(LdapAttributeType.class);

    public static String[] execRegex(String value, String pattern) {
        Pattern ocPattern = Pattern.compile(pattern, 2);
        Matcher ocMatcher = ocPattern.matcher(value);
        if (ocMatcher.matches()) {
            return new String[]{ocMatcher.group(1), ocMatcher.group(2)};
        }
        return null;
    }

    public static String[] execRegex3(String value, String pattern) {
        Pattern ocPattern = Pattern.compile(pattern, 2);
        Matcher ocMatcher = ocPattern.matcher(value);
        if (ocMatcher.matches()) {
            return new String[]{ocMatcher.group(1), ocMatcher.group(2), ocMatcher.group(3)};
        }
        return null;
    }

    public static LdapObjectClass parse(String ocStr, Map<String, LdapAttributeType> ats) {
        int maxPass;
        LdapObjectClass loc = new LdapObjectClass();
        String rest = ocStr;
        ArrayList<String> attrs = new ArrayList<String>();
        String[] ret = LdapObjectClass.execRegex(rest, "\\(\\s+([0-9\\.]+)(.*)\\s*\\)\\s*");
        if (ret == null) {
            LOGGER.error("Unable to match the oid in \"{}\"", (Object)ocStr);
            return null;
        }
        loc.oid = ret[0];
        rest = ret[1];
        ret = LdapObjectClass.execRegex(rest, "\\s*NAME\\s+(\\([^\\)]+\\)|[^ ]+)(.*)\\s*");
        if (ret != null) {
            if (ret[0].startsWith("(")) {
                ret[0] = ret[0].substring(1, ret[0].length() - 1);
            }
            StringTokenizer names = new StringTokenizer(ret[0], " ");
            loc.setName(names.nextToken());
            if (names.hasMoreElements()) {
                LOGGER.debug("Multiple names not supported. Using first one ({}) for \"{}\"", (Object)loc.name, (Object)ocStr);
            }
        } else {
            LOGGER.error("Unable to match the name in \"{}\"", (Object)ocStr);
            return null;
        }
        rest = ret[1];
        for (maxPass = 0; rest != null && rest.length() > 0 && maxPass < 100; ++maxPass) {
            LOGGER.debug("Re/Starting analysis with rest=\"{}\"", (Object)rest);
            ret = LdapObjectClass.execRegex(rest, "\\s*SUP\\s+(\\([^\\)]+\\)|[^\\s]+)?\\s*(.*)\\s*");
            if (ret != null) {
                if (ret[0].startsWith("(")) {
                    ret[0] = ret[0].substring(1, ret[0].length() - 2);
                }
                StringTokenizer sups = new StringTokenizer(ret[0], "$");
                loc.inheritFrom = sups.nextToken();
                if (sups.hasMoreElements()) {
                    LOGGER.warn("Multiple inheritence not supported. Using first one ({}) for \"{}\"", (Object)loc.inheritFrom, (Object)ocStr);
                }
                rest = ret[1];
            }
            if ((ret = LdapObjectClass.execRegex(rest, "\\s*DESC\\s+('[^']*')\\s*(.*)\\s*")) != null) {
                loc.description = ret[0];
                rest = ret[1];
            }
            if ((ret = LdapObjectClass.execRegex(rest, "\\s*MUST\\s+(\\([^\\)]+\\)|[^\\s]+)?\\s*(.*)\\s*")) != null) {
                if (ret[0].startsWith("(")) {
                    ret[0] = ret[0].substring(1, ret[0].length() - 2);
                }
                StringTokenizer musts = new StringTokenizer(ret[0], "$");
                attrs.addAll(LdapObjectClass.toList(musts));
                rest = ret[1];
            }
            if ((ret = LdapObjectClass.execRegex(rest, "\\s*MAY\\s+(\\([^\\)]+\\)|[^\\s]+)?\\s*(.*)\\s*")) != null) {
                if (ret[0].startsWith("(")) {
                    ret[0] = ret[0].substring(1, ret[0].length() - 2);
                }
                StringTokenizer mays = new StringTokenizer(ret[0], "$");
                attrs.addAll(LdapObjectClass.toList(mays));
                rest = ret[1];
            }
            if ((ret = LdapObjectClass.execRegex3(rest, "\\s*X-([^\\s]+)\\s+('[^']+')?\\s*(.*)\\s*")) != null) {
                loc.x.put(ret[0], ret[1]);
                rest = ret[2];
            }
            if ((ret = LdapObjectClass.execRegex(rest, "\\s*(STRUCTURAL|AUXILIARY|ABSTRACT)\\s*(.*)\\s*")) == null) continue;
            loc.type = ret[0];
            rest = ret[1];
        }
        if (maxPass >= 100) {
            LOGGER.error("The parser encountered an error while parsing the following string : {} while parsing {}", (Object)rest, (Object)ocStr);
            return null;
        }
        if (loc.inheritFrom == null) {
            LOGGER.debug("No inheritence found for \"{}\". Defaulting to top", (Object)ocStr);
            loc.inheritFrom = "top";
        }
        if (loc.description == null) {
            LOGGER.debug("No description found for \"{}\"", (Object)ocStr);
        }
        if (loc.type == null) {
            loc.type = "AUXILIARY";
            LOGGER.debug("No structural or abstract type found. Defaulting to auxiliary in \"{}\"", (Object)ocStr);
        }
        for (String attributeName : attrs) {
            if (attributeName.indexOf(45) != -1) {
                LdapObjectClass.badAttributeName(attributeName);
                continue;
            }
            if (ats.get(attributeName) != null && ats.get(attributeName).isSingleValue()) {
                loc.monoAttrs.add(attributeName);
                continue;
            }
            loc.multiAttrs.add(attributeName);
        }
        LOGGER.debug("Successfully parsed objectclass {}", (Object)loc.name);
        return loc;
    }

    private static List<String> toList(StringTokenizer names) {
        ArrayList<String> ret = new ArrayList<String>();
        while (names.hasMoreTokens()) {
            ret.add(names.nextToken().trim());
        }
        return ret;
    }

    public final String getInheritFrom() {
        return this.inheritFrom;
    }

    public final void setInheritFrom(String inheritFrom) {
        this.inheritFrom = inheritFrom;
    }

    public final List<String> getMultiAttrs() {
        return this.multiAttrs;
    }

    public final void setMultiAttrs(List<String> multiAttrs) {
        this.multiAttrs = multiAttrs;
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name.trim().startsWith("'") ? name.trim().substring(1, name.length() - 1) : name.trim();
    }

    public final String getDescription() {
        return this.description;
    }

    public final void setDescription(String description) {
        this.description = description;
    }

    public final List<String> getMonoAttrs() {
        return this.monoAttrs;
    }

    public final void setMonoAttrs(List<String> optionalAttrs) {
        this.monoAttrs = optionalAttrs;
    }

    public final String getType() {
        return this.type;
    }

    public final void setType(String type) {
        this.type = type;
    }

    public final String getOid() {
        return this.oid;
    }

    public final void setOid(String oid) {
        this.oid = oid;
    }

    protected static final void badAttributeName(String name) {
        LOGGER.warn("Ignoring attribute {}. It contains currently unsupported characters. See http://tools.lsc-project.org/issues/show/31", (Object)name);
    }
}

