/*
 * Decompiled with CFR 0.152.
 */
package org.lsc.runnable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.naming.CommunicationException;
import org.lsc.AbstractSynchronize;
import org.lsc.Hooks;
import org.lsc.LscDatasetModification;
import org.lsc.LscDatasets;
import org.lsc.LscModificationType;
import org.lsc.LscModifications;
import org.lsc.Task;
import org.lsc.beans.IBean;
import org.lsc.beans.InfoCounter;
import org.lsc.beans.syncoptions.ISyncOptions;
import org.lsc.exception.LscServiceException;
import org.lsc.runnable.AbstractEntryRunner;
import org.lsc.utils.ScriptingEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanEntryRunner
extends AbstractEntryRunner {
    static final Logger LOGGER = LoggerFactory.getLogger(CleanEntryRunner.class);
    private Hooks hooks = new Hooks();

    public CleanEntryRunner(Task task, InfoCounter counter, AbstractSynchronize abstractSynchronize, Map.Entry<String, LscDatasets> id) {
        super(task, counter, abstractSynchronize, id);
    }

    @Override
    public void run() {
        this.counter.incrementCountAll();
        ISyncOptions syncOptions = this.task.getSyncOptions();
        LscModifications lm = null;
        try {
            IBean taskBean = this.abstractSynchronize.getBean(this.task, this.task.getSourceService(), (String)this.id.getKey(), (LscDatasets)this.id.getValue(), false, false);
            if (taskBean == null) {
                Boolean doDelete = null;
                String conditionString = syncOptions.getDeleteCondition();
                if (conditionString.matches("true")) {
                    doDelete = true;
                } else if (conditionString.matches("false")) {
                    doDelete = false;
                } else {
                    IBean dstBean = this.abstractSynchronize.getBean(this.task, this.task.getDestinationService(), (String)this.id.getKey(), (LscDatasets)this.id.getValue(), true, false);
                    if (dstBean == null) {
                        LOGGER.error("Could not retrieve the object {} from the directory!", this.id.getKey());
                        this.counter.incrementCountError();
                        return;
                    }
                    HashMap<String, Object> conditionObjects = new HashMap<String, Object>();
                    conditionObjects.put("dstBean", dstBean);
                    conditionObjects.putAll(this.task.getScriptingVars());
                    if (this.task.getCustomLibraries() != null) {
                        conditionObjects.put("custom", this.task.getCustomLibraries());
                    }
                    doDelete = ScriptingEvaluator.evalToBoolean(this.task, conditionString, conditionObjects);
                }
                if (doDelete.booleanValue()) {
                    lm = new LscModifications(LscModificationType.DELETE_OBJECT, this.task.getName());
                    lm.setMainIdentifer((String)this.id.getKey());
                    ArrayList<LscDatasetModification> attrsMod = new ArrayList<LscDatasetModification>();
                    for (Map.Entry<String, Object> attr : ((LscDatasets)this.id.getValue()).getDatasets().entrySet()) {
                        attrsMod.add(new LscDatasetModification(LscDatasetModification.LscDatasetModificationType.DELETE_VALUES, attr.getKey(), Collections.singletonList(attr.getValue())));
                    }
                    lm.setLscAttributeModifications(attrsMod);
                    this.counter.incrementCountModifiable();
                    if (this.abstractSynchronize.nodelete) {
                        this.abstractSynchronize.logShouldAction(lm, this.task.getName());
                        return;
                    }
                } else {
                    return;
                }
                if (this.task.getDestinationService().apply(lm)) {
                    this.hooks.postSyncHook(syncOptions.getDeletePostHook(), syncOptions.getPostHookOutputFormat(), lm);
                    this.counter.incrementCountCompleted();
                    this.abstractSynchronize.logAction(lm, this.id, this.task.getName());
                } else {
                    this.counter.incrementCountError();
                    this.abstractSynchronize.logActionError(lm, this.id.getValue(), new Exception("Technical problem while applying modifications to destination service"));
                }
            }
        }
        catch (LscServiceException e) {
            this.counter.incrementCountError();
            this.abstractSynchronize.logActionError(lm, this.id.getValue(), e);
            if (e.getCause().getClass().isAssignableFrom(CommunicationException.class)) {
                LOGGER.error("Connection lost! Aborting.");
                return;
            }
            LOGGER.error("Unable to delete object {} ({})", this.id.getKey(), (Object)e.toString());
            return;
        }
    }
}

