/*
 * Decompiled with CFR 0.152.
 */
package org.lsc.service;

import com.ibatis.sqlmap.client.SqlMapClient;
import com.ibatis.sqlmap.engine.impl.SqlMapClientImpl;
import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMapping;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lsc.LscModifications;
import org.lsc.exception.LscServiceConfigurationException;
import org.lsc.exception.LscServiceException;
import org.lsc.service.AbstractJdbcService;
import org.lsc.service.IWritableService;

public abstract class AbstractJdbcDstService
extends AbstractJdbcService
implements IWritableService {
    private String serviceName;
    private static Map<String, List<String>> attributesNameCache = new HashMap<String, List<String>>();

    public AbstractJdbcDstService(String serviceName, SqlMapClient sqlMapClient, String bean) throws LscServiceConfigurationException {
        super(sqlMapClient, bean);
        this.serviceName = serviceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean apply(LscModifications lm) throws LscServiceException {
        Map<String, Object> attributeMap = AbstractJdbcDstService.getAttributesMap(lm.getLscAttributeModifications());
        try {
            this.sqlMapper.startTransaction();
            switch (lm.getOperation()) {
                case CHANGE_ID: {
                    break;
                }
                case CREATE_OBJECT: {
                    for (String request : this.getRequestsNameForInsert()) {
                        LOGGER.debug("Executing " + request + "(" + String.valueOf(attributeMap) + ")");
                        this.sqlMapper.insert(request, attributeMap);
                    }
                    break;
                }
                case DELETE_OBJECT: {
                    for (String request : this.getRequestsNameForDelete()) {
                        LOGGER.debug("Executing " + request + "(" + String.valueOf(attributeMap) + ")");
                        this.sqlMapper.delete(request, attributeMap);
                    }
                    break;
                }
                case UPDATE_OBJECT: {
                    attributeMap = AbstractJdbcDstService.fillAttributesMap(attributeMap, lm.getDestinationBean());
                    for (String request : this.getRequestsNameForUpdate()) {
                        LOGGER.debug("Executing " + request + "(" + String.valueOf(attributeMap) + ")");
                        this.sqlMapper.update(request, attributeMap);
                    }
                    break;
                }
            }
            this.sqlMapper.commitTransaction();
        }
        catch (SQLException e) {
            LOGGER.error(e.toString(), (Throwable)e);
            LOGGER.error("Error caused by operation " + lm.getOperation().getDescription() + ", attributes " + attributeMap.toString());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                this.sqlMapper.endTransaction();
            }
            catch (SQLException e) {
                LOGGER.error(e.toString(), (Throwable)e);
                return false;
            }
        }
        return true;
    }

    @Override
    public List<String> getWriteDatasetIds() {
        List<String> writeDatasetIds = attributesNameCache.get(this.serviceName);
        if (writeDatasetIds != null) {
            return writeDatasetIds;
        }
        return this.buildWriteDatasetIds();
    }

    private List<String> buildWriteDatasetIds() {
        ArrayList<String> writeDatasetIds = new ArrayList<String>();
        if (this.sqlMapper instanceof SqlMapClientImpl) {
            for (String request : this.getRequestsNameForInsert()) {
                for (ParameterMapping pm : ((SqlMapClientImpl)this.sqlMapper).getDelegate().getMappedStatement(request).getParameterMap().getParameterMappings()) {
                    writeDatasetIds.add(pm.getPropertyName());
                }
            }
            attributesNameCache.put(this.serviceName, writeDatasetIds);
        } else {
            LOGGER.error("Unable to handle an unknown SQLMap Client type : " + this.sqlMapper.getClass().getName());
        }
        return writeDatasetIds;
    }

    public abstract List<String> getRequestsNameForInsert();

    public abstract List<String> getRequestsNameForUpdate();

    public abstract List<String> getRequestsNameForDelete();
}

