/*
 * Decompiled with CFR 0.152.
 */
package org.lsc.service;

import bitronix.tm.BitronixTransactionManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.lsc.LscDatasets;
import org.lsc.LscModifications;
import org.lsc.beans.IBean;
import org.lsc.configuration.ConnectionType;
import org.lsc.configuration.LscConfiguration;
import org.lsc.configuration.TaskType;
import org.lsc.exception.LscServiceException;
import org.lsc.service.IXAWritableService;
import org.lsc.utils.output.LdifLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xadisk.bridge.proxies.interfaces.XAFileSystem;
import org.xadisk.bridge.proxies.interfaces.XAFileSystemProxy;
import org.xadisk.bridge.proxies.interfaces.XASession;
import org.xadisk.filesystem.exceptions.FileAlreadyExistsException;
import org.xadisk.filesystem.exceptions.FileNotExistsException;
import org.xadisk.filesystem.exceptions.InsufficientPermissionOnFileException;
import org.xadisk.filesystem.exceptions.LockingFailedException;
import org.xadisk.filesystem.exceptions.NoTransactionAssociatedException;
import org.xadisk.filesystem.standalone.StandaloneFileSystemConfiguration;

public class XALdifDstService
implements IXAWritableService {
    private static final Logger LOGGER = LoggerFactory.getLogger(XALdifDstService.class);
    private String id;
    private XAFileSystem xafs;
    private TransactionManager tm;
    private String outputDirectory;
    private Map<String, XASession> xaSessions = new HashMap<String, XASession>();

    public XALdifDstService(TaskType task) throws LscServiceException {
        this.id = LscConfiguration.getDestinationService(task).getName();
        this.outputDirectory = task.getXaFileDestinationService().getOutputDirectory();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Botting an XADisk instance...");
        }
        StandaloneFileSystemConfiguration configuration = new StandaloneFileSystemConfiguration(this.outputDirectory, this.id);
        this.xafs = XAFileSystemProxy.bootNativeXAFileSystem((StandaloneFileSystemConfiguration)configuration);
        try {
            this.xafs.waitForBootup(-1L);
        }
        catch (InterruptedException e) {
            throw new LscServiceException(e);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Successfully booted the XADisk instance.\n");
        }
        this.tm = new BitronixTransactionManager();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String start() throws LscServiceException {
        if (this.xaSessions.containsKey("" + Thread.currentThread().getId())) {
            LOGGER.debug("XA transaction already started in this thread !");
            return null;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Starting an XA transaction...");
        }
        try {
            this.tm.begin();
            Transaction tx1 = this.tm.getTransaction();
            XASession xaSession = this.xafs.createSessionForXATransaction();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Enlisting XADisk in the XA transaction.");
            }
            XAResource xaResource = xaSession.getXAResource();
            tx1.enlistResource(xaResource);
            this.xaSessions.put("" + Thread.currentThread().getId(), xaSession);
        }
        catch (NotSupportedException e) {
            throw new LscServiceException((Exception)((Object)e));
        }
        catch (SystemException e) {
            throw new LscServiceException((Exception)((Object)e));
        }
        catch (IllegalStateException e) {
            throw new LscServiceException(e);
        }
        catch (RollbackException e) {
            throw new LscServiceException((Exception)((Object)e));
        }
        return null;
    }

    @Override
    public void submit(String xid, LscModifications lm) throws LscServiceException {
    }

    @Override
    public void commit(String xid) throws LscServiceException {
        try {
            this.tm.commit();
        }
        catch (SecurityException e) {
            throw new LscServiceException(e);
        }
        catch (IllegalStateException e) {
            throw new LscServiceException(e);
        }
        catch (RollbackException e) {
            throw new LscServiceException((Exception)((Object)e));
        }
        catch (HeuristicMixedException e) {
            throw new LscServiceException((Exception)((Object)e));
        }
        catch (HeuristicRollbackException e) {
            throw new LscServiceException((Exception)((Object)e));
        }
        catch (SystemException e) {
            throw new LscServiceException((Exception)((Object)e));
        }
    }

    @Override
    public void end(String xid) throws LscServiceException {
    }

    @Override
    public int prepare(String xid) throws LscServiceException {
        return 0;
    }

    @Override
    public void rollback(String xid) throws LscServiceException {
        try {
            this.tm.rollback();
        }
        catch (IllegalStateException e) {
            throw new LscServiceException(e);
        }
        catch (SecurityException e) {
            throw new LscServiceException(e);
        }
        catch (SystemException e) {
            throw new LscServiceException((Exception)((Object)e));
        }
    }

    @Override
    public boolean apply(LscModifications lm) throws LscServiceException {
        XASession xaSession = this.xaSessions.get("" + Thread.currentThread().getId());
        if (xaSession != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Performing transactional work over XADisk and other involved resources (e.g. Oracle, MQ)\n");
            }
            try {
                File ldifFile = new File(this.outputDirectory, lm.getMainIdentifier());
                xaSession.createFile(ldifFile, false);
                FileOutputStream fos = new FileOutputStream(ldifFile);
                fos.write(LdifLayout.format(lm).getBytes());
                fos.close();
            }
            catch (FileAlreadyExistsException e) {
                throw new LscServiceException((Exception)((Object)e));
            }
            catch (FileNotExistsException e) {
                throw new LscServiceException((Exception)((Object)e));
            }
            catch (InsufficientPermissionOnFileException e) {
                throw new LscServiceException((Exception)((Object)e));
            }
            catch (LockingFailedException e) {
                throw new LscServiceException((Exception)((Object)e));
            }
            catch (NoTransactionAssociatedException e) {
                throw new LscServiceException((Exception)((Object)e));
            }
            catch (InterruptedException e) {
                throw new LscServiceException(e);
            }
            catch (FileNotFoundException e) {
                throw new LscServiceException(e);
            }
            catch (IOException e) {
                throw new LscServiceException(e);
            }
        }
        return false;
    }

    @Override
    public IBean getBean(String pivotName, LscDatasets pivotAttributes, boolean fromSameService) throws LscServiceException {
        return null;
    }

    @Override
    public Map<String, LscDatasets> getListPivots() throws LscServiceException {
        return null;
    }

    @Override
    public void setTransactionManager(TransactionManager xaTM) {
        this.tm = xaTM;
    }

    @Override
    public List<String> getWriteDatasetIds() {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public Collection<Class<? extends ConnectionType>> getSupportedConnectionType() {
        ArrayList<Class<? extends ConnectionType>> list = new ArrayList<Class<? extends ConnectionType>>();
        return list;
    }
}

