/*
 * Decompiled with CFR 0.152.
 */
package org.lsc.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public final class DateUtils {
    public static final String LDAP_DATE_INTERNAL_STORAGE_FORMAT = "yyyyMMddHHmmss.S'Z'";
    public static final String LDAP_DATE_SIMPLIFIED_STORAGE_FORMAT = "yyyyMMddHHmmss'Z'";
    private static final SimpleDateFormat FORMATTER = new SimpleDateFormat("yyyyMMddHHmmss.S'Z'");
    private static final SimpleDateFormat SIMPLIFIED_FORMATTER = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
    private static final TimeZone UTC_TIME_ZONE = TimeZone.getDefault();

    private DateUtils() {
    }

    public static Date parse(String date) throws ParseException {
        SimpleDateFormat simpleDateFormat = FORMATTER;
        synchronized (simpleDateFormat) {
            try {
                return FORMATTER.parse(date);
            }
            catch (ParseException pe) {
                try {
                    return SIMPLIFIED_FORMATTER.parse(date);
                }
                catch (ParseException pe2) {
                    throw pe;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String format(Date date) {
        SimpleDateFormat simpleDateFormat = FORMATTER;
        synchronized (simpleDateFormat) {
            return FORMATTER.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String simpleFormat(Date date) {
        SimpleDateFormat simpleDateFormat = SIMPLIFIED_FORMATTER;
        synchronized (simpleDateFormat) {
            return SIMPLIFIED_FORMATTER.format(date);
        }
    }

    static {
        FORMATTER.setLenient(false);
        FORMATTER.setTimeZone(UTC_TIME_ZONE);
    }
}

