/*
 * Decompiled with CFR 0.152.
 */
package org.lsc.utils;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import org.lsc.Task;
import org.lsc.exception.LscServiceException;
import org.lsc.utils.GroovyEvaluator;
import org.lsc.utils.JScriptEvaluator;
import org.lsc.utils.RhinoJScriptEvaluator;
import org.lsc.utils.ScriptableEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptingEvaluator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScriptingEvaluator.class);
    private static Cache<Object, Object> instancesCache;
    private static Map<String, Class<? extends ScriptableEvaluator>> implementetionsCache;
    public static ScriptEngineManager mgr;
    private Map<String, ScriptableEvaluator> instancesTypeCache;
    private Optional<ScriptableEvaluator> defaultImplementation;
    private Map<Pattern, String> prefixRegex = new HashMap<Pattern, String>();

    private ScriptingEvaluator() {
        this.instancesTypeCache = new HashMap<String, ScriptableEvaluator>();
        List<ScriptEngineFactory> factories = mgr.getEngineFactories();
        for (ScriptEngineFactory sef : factories) {
            boolean loaded = false;
            for (String name : sef.getNames()) {
                if ("js".equals(name)) {
                    this.instancesTypeCache.put(name, new JScriptEvaluator(sef.getScriptEngine()));
                    loaded = true;
                    break;
                }
                if ("groovy".equals(name)) {
                    this.instancesTypeCache.put("gr", new GroovyEvaluator(sef.getScriptEngine()));
                    loaded = true;
                    break;
                }
                if (!"Graal.js".equals(name)) continue;
                loaded = true;
                break;
            }
            if (loaded) continue;
            LOGGER.debug("Unsupported scripting engine: " + sef.getEngineName());
        }
        this.instancesTypeCache.put("rjs", new RhinoJScriptEvaluator(false));
        this.instancesTypeCache.put("rdjs", new RhinoJScriptEvaluator(true));
        ScriptEngine graaljsEngine = new ScriptEngineManager().getEngineByName("Graal.js");
        if (graaljsEngine != null) {
            Bindings bindings = graaljsEngine.getBindings(100);
            bindings.put("polyglot.js.allowHostAccess", (Object)true);
            bindings.put("polyglot.js.allowHostClassLookup", s -> true);
            bindings.put("polyglot.js.nashorn-compat", (Object)true);
            JScriptEvaluator graaljsevaluator = new JScriptEvaluator(graaljsEngine);
            this.instancesTypeCache.put("gj", graaljsevaluator);
            this.defaultImplementation = Optional.of(graaljsevaluator);
            LOGGER.info("Default JS implementation: GraalJS");
        } else {
            this.defaultImplementation = Optional.ofNullable(Optional.ofNullable(this.instancesTypeCache.get("js")).orElse(this.instancesTypeCache.get("rjs")));
            LOGGER.info("Default JS implementation: " + this.defaultImplementation.get().toString());
        }
        this.compileRegexPatternMatch();
        Object registeredLanguages = "";
        for (String key : this.instancesTypeCache.keySet()) {
            registeredLanguages = (String)registeredLanguages + key + "=" + this.instancesTypeCache.get(key).toString() + ", ";
        }
        LOGGER.debug("All registered JS engines: " + (String)registeredLanguages);
    }

    private static ScriptingEvaluator getInstance() {
        String threadName = Thread.currentThread().getName();
        ScriptingEvaluator scriptingEvaluator = null;
        scriptingEvaluator = (ScriptingEvaluator)instancesCache.getIfPresent((Object)threadName);
        if (scriptingEvaluator == null) {
            scriptingEvaluator = new ScriptingEvaluator();
            instancesCache.put((Object)threadName, (Object)scriptingEvaluator);
        }
        return scriptingEvaluator;
    }

    public static void contribute(String implementationName, Class<? extends ScriptableEvaluator> implementationClass) {
        implementetionsCache.put(implementationName, implementationClass);
    }

    private ScriptableEvaluator identifyScriptingEngine(String expression) throws LscServiceException {
        String[] parts = expression.split(":");
        String match = this.matchJScriptEvaluator(parts[0]);
        if (!match.isEmpty()) {
            LOGGER.debug("Selected JS engine: " + match + " = " + this.instancesTypeCache.get(match).toString());
            return this.instancesTypeCache.get(match);
        }
        return this.defaultImplementation.orElseThrow(() -> new LscServiceException("Missing Script evaluator"));
    }

    public String matchJScriptEvaluator(String jscript) {
        for (Map.Entry<Pattern, String> entry : this.prefixRegex.entrySet()) {
            if (!entry.getKey().matcher(jscript).matches()) continue;
            return entry.getValue();
        }
        return "";
    }

    public void compileRegexPatternMatch() {
        for (String jscriptEngine : this.instancesTypeCache.keySet()) {
            Pattern pattern = Pattern.compile("((\\n.*)+)" + jscriptEngine);
            this.prefixRegex.put(pattern, jscriptEngine);
            pattern = Pattern.compile(jscriptEngine);
            this.prefixRegex.put(pattern, jscriptEngine);
        }
    }

    private String removePrefix(String expression) {
        String[] parts = expression.split(":");
        if (parts != null && parts.length > 0 && parts[0].length() < 10 && this.instancesTypeCache.containsKey(parts[0])) {
            return expression.substring(expression.indexOf(":") + 1);
        }
        return expression;
    }

    public static String evalToString(Task task, String expression, Map<String, Object> params) throws LscServiceException {
        ScriptableEvaluator se = ScriptingEvaluator.getInstance().identifyScriptingEngine(expression);
        return se.evalToString(task, ScriptingEvaluator.getInstance().removePrefix(expression), params);
    }

    public static List<Object> evalToObjectList(Task task, String expression, Map<String, Object> params) throws LscServiceException {
        ScriptableEvaluator se = ScriptingEvaluator.getInstance().identifyScriptingEngine(expression);
        return se.evalToObjectList(task, ScriptingEvaluator.getInstance().removePrefix(expression), params);
    }

    public static List<byte[]> evalToByteArrayList(Task task, String expression, Map<String, Object> params) throws LscServiceException {
        ScriptableEvaluator se = ScriptingEvaluator.getInstance().identifyScriptingEngine(expression);
        return se.evalToByteArrayList(task, ScriptingEvaluator.getInstance().removePrefix(expression), params);
    }

    public static byte[] evalToByteArray(Task task, String expression, Map<String, Object> params) throws LscServiceException {
        ScriptableEvaluator se = ScriptingEvaluator.getInstance().identifyScriptingEngine(expression);
        return se.evalToByteArray(task, ScriptingEvaluator.getInstance().removePrefix(expression), params);
    }

    public static Boolean evalToBoolean(Task task, String expression, Map<String, Object> params) throws LscServiceException {
        ScriptableEvaluator se = ScriptingEvaluator.getInstance().identifyScriptingEngine(expression);
        return se.evalToBoolean(task, ScriptingEvaluator.getInstance().removePrefix(expression), params);
    }

    static {
        implementetionsCache = new HashMap<String, Class<? extends ScriptableEvaluator>>();
        instancesCache = CacheBuilder.newBuilder().maximumSize(15L).build();
        mgr = new ScriptEngineManager();
    }
}

