/*
 * Decompiled with CFR 0.152.
 */
package org.lsc.utils;

import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.BasicAttribute;

public class SetUtils {
    private SetUtils() {
    }

    public static Set<Object> attributeToSet(Attribute attr) throws NamingException {
        if (attr == null || attr.size() == 0) {
            return new HashSet<Object>();
        }
        LinkedHashSet<Object> attrValues = new LinkedHashSet<Object>(attr.size());
        NamingEnumeration<?> namingEnumeration = attr.getAll();
        while (namingEnumeration.hasMore()) {
            Object value = namingEnumeration.next();
            if (value instanceof String && ((String)value).length() == 0) continue;
            attrValues.add(value);
        }
        namingEnumeration.close();
        return attrValues;
    }

    public static Attribute setToAttribute(String attrName, Set<?> values) {
        BasicAttribute ret = new BasicAttribute(attrName);
        if (values == null || values.size() == 0) {
            return ret;
        }
        for (Object value : values) {
            ret.add(value);
        }
        return ret;
    }

    public static Set<Object> findMissingNeedles(Set<?> haystack, Set<Object> needles) {
        HashSet<Object> missingNeedles = new HashSet<Object>();
        if (needles == null) {
            return missingNeedles;
        }
        if (haystack == null) {
            return needles;
        }
        for (Object needle : needles) {
            ByteBuffer needleBuff = null;
            if (needle.getClass().isAssignableFrom(byte[].class)) {
                needleBuff = ByteBuffer.wrap((byte[])needle);
            }
            boolean foundInHaystack = false;
            for (Object haystackValue : haystack) {
                ByteBuffer haystackValueBuff = null;
                if (haystackValue.getClass().isAssignableFrom(byte[].class)) {
                    haystackValueBuff = ByteBuffer.wrap((byte[])haystackValue);
                    if (needleBuff == null) {
                        if (!needle.getClass().isAssignableFrom(String.class)) continue;
                        needleBuff = ByteBuffer.wrap(((String)needle).getBytes());
                    }
                }
                if (needleBuff != null) {
                    if (haystackValueBuff == null) {
                        if (!haystackValue.getClass().isAssignableFrom(String.class)) continue;
                        haystackValueBuff = ByteBuffer.wrap(((String)haystackValue).getBytes());
                    }
                    if (haystackValueBuff.compareTo(needleBuff) != 0) continue;
                    foundInHaystack = true;
                    continue;
                }
                if (!haystackValue.equals(needle)) continue;
                foundInHaystack = true;
            }
            if (foundInHaystack) continue;
            missingNeedles.add(needle);
        }
        return missingNeedles;
    }

    public static boolean checkOrder(Set<?> first, Set<Object> second) {
        if (first.size() != second.size()) {
            return false;
        }
        Iterator<Object> iterator = second.iterator();
        for (Object element1 : first) {
            Object element2 = iterator.next();
            ByteBuffer element1Buff = null;
            if (element1.getClass().isAssignableFrom(byte[].class)) {
                element1Buff = ByteBuffer.wrap((byte[])element1);
            }
            ByteBuffer element2Buff = null;
            if (element2.getClass().isAssignableFrom(byte[].class)) {
                element2Buff = ByteBuffer.wrap((byte[])element2);
                if (element1Buff == null) {
                    if (element1.getClass().isAssignableFrom(String.class)) {
                        element1Buff = ByteBuffer.wrap(((String)element1).getBytes());
                    } else {
                        return false;
                    }
                }
            }
            if (element1Buff != null) {
                if (element2Buff == null) {
                    if (element2.getClass().isAssignableFrom(String.class)) {
                        element2Buff = ByteBuffer.wrap(((String)element2).getBytes());
                    } else {
                        return false;
                    }
                }
                if (element2Buff.compareTo(element1Buff) == 0) continue;
                return false;
            }
            if (element2.equals(element1)) continue;
            return false;
        }
        return true;
    }

    public static boolean setContainsAll(Set<Object> haystack, Set<Object> needles) {
        return SetUtils.findMissingNeedles(haystack, needles).size() == 0;
    }

    public static boolean doSetsMatch(Set<Object> srcAttrValues, Set<Object> dstAttrValues) {
        if (srcAttrValues.size() != dstAttrValues.size()) {
            return false;
        }
        if (!SetUtils.setContainsAll(dstAttrValues, srcAttrValues)) {
            return false;
        }
        return SetUtils.setContainsAll(srcAttrValues, dstAttrValues);
    }

    public static boolean doSetsMatchWithOrder(Set<Object> srcAttrValues, Set<Object> dstAttrValues) {
        if (!SetUtils.doSetsMatch(srcAttrValues, dstAttrValues)) {
            return false;
        }
        return SetUtils.checkOrder(srcAttrValues, dstAttrValues);
    }

    public static void addAllIfNotPresent(Set<Object> set, Set<Object> values) {
        Set<Object> valuesToAdd = SetUtils.findMissingNeedles(set, values);
        set.addAll(valuesToAdd);
    }
}

