/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.wasm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.wasm.ToJSValueNode;
import java.lang.invoke.VarHandle;
import java.util.Objects;

@GeneratedBy(value=ToJSValueNode.class)
public final class ToJSValueNodeGen
extends ToJSValueNode {
    private static final Uncached UNCACHED = new Uncached();
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    @CompilerDirectives.CompilationFinal
    private int state_0_;
    @Node.Child
    private FallbackData fallback_cache;

    private ToJSValueNodeGen() {
    }

    private boolean fallbackGuard_(int state_0, Object arg0Value) {
        if ((state_0 & 2) == 0 && arg0Value instanceof Long) {
            return false;
        }
        if ((state_0 & 4) == 0 && arg0Value instanceof Float) {
            return false;
        }
        return !JSTypesGen.isImplicitDouble(arg0Value);
    }

    @Override
    public Object execute(Object arg0Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0x1F) != 0) {
            FallbackData s4_;
            if ((state_0 & 1) != 0 && arg0Value instanceof Integer) {
                int arg0Value_ = (Integer)arg0Value;
                return ToJSValueNode.i32(arg0Value_);
            }
            if ((state_0 & 2) != 0 && arg0Value instanceof Long) {
                long arg0Value_ = (Long)arg0Value;
                return ToJSValueNode.i64(arg0Value_);
            }
            if ((state_0 & 4) != 0 && arg0Value instanceof Float) {
                float arg0Value_ = ((Float)arg0Value).floatValue();
                return ToJSValueNode.f32(arg0Value_);
            }
            if ((state_0 & 8) != 0 && JSTypesGen.isImplicitDouble((state_0 & 0xE0) >>> 5, arg0Value)) {
                double arg0Value_ = JSTypesGen.asImplicitDouble((state_0 & 0xE0) >>> 5, arg0Value);
                return ToJSValueNode.f64(arg0Value_);
            }
            if ((state_0 & 0x10) != 0 && (s4_ = this.fallback_cache) != null && this.fallbackGuard_(state_0, arg0Value)) {
                return this.convert(arg0Value, s4_.isFuncLib_, s4_.funcTypeLib_, s4_.asTStringLib_, s4_.switchEncoding_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    private Object executeAndSpecialize(Object arg0Value) {
        int state_0 = this.state_0_;
        if (arg0Value instanceof Integer) {
            int arg0Value_ = (Integer)arg0Value;
            this.state_0_ = state_0 |= 1;
            return ToJSValueNode.i32(arg0Value_);
        }
        if (arg0Value instanceof Long) {
            long arg0Value_ = (Long)arg0Value;
            this.state_0_ = state_0 |= 2;
            return ToJSValueNode.i64(arg0Value_);
        }
        if (arg0Value instanceof Float) {
            float arg0Value_ = ((Float)arg0Value).floatValue();
            this.state_0_ = state_0 |= 4;
            return ToJSValueNode.f32(arg0Value_);
        }
        int doubleCast0 = JSTypesGen.specializeImplicitDouble(arg0Value);
        if (doubleCast0 != 0) {
            double arg0Value_ = JSTypesGen.asImplicitDouble(doubleCast0, arg0Value);
            state_0 |= doubleCast0 << 5;
            this.state_0_ = state_0 |= 8;
            return ToJSValueNode.f64(arg0Value_);
        }
        FallbackData s4_ = (FallbackData)this.insert(new FallbackData());
        InteropLibrary isFuncLib__ = (InteropLibrary)s4_.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.createDispatched(5)));
        Objects.requireNonNull(isFuncLib__, "Specialization 'convert(Object, InteropLibrary, InteropLibrary, InteropLibrary, SwitchEncodingNode)' cache 'isFuncLib' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
        s4_.isFuncLib_ = isFuncLib__;
        InteropLibrary funcTypeLib__ = (InteropLibrary)s4_.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.createDispatched(5)));
        Objects.requireNonNull(funcTypeLib__, "Specialization 'convert(Object, InteropLibrary, InteropLibrary, InteropLibrary, SwitchEncodingNode)' cache 'funcTypeLib' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
        s4_.funcTypeLib_ = funcTypeLib__;
        InteropLibrary asTStringLib__ = (InteropLibrary)s4_.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.createDispatched(5)));
        Objects.requireNonNull(asTStringLib__, "Specialization 'convert(Object, InteropLibrary, InteropLibrary, InteropLibrary, SwitchEncodingNode)' cache 'asTStringLib' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
        s4_.asTStringLib_ = asTStringLib__;
        TruffleString.SwitchEncodingNode switchEncoding__ = (TruffleString.SwitchEncodingNode)s4_.insert((Node)TruffleString.SwitchEncodingNode.create());
        Objects.requireNonNull(switchEncoding__, "Specialization 'convert(Object, InteropLibrary, InteropLibrary, InteropLibrary, SwitchEncodingNode)' cache 'switchEncoding' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
        s4_.switchEncoding_ = switchEncoding__;
        VarHandle.storeStoreFence();
        this.fallback_cache = s4_;
        this.state_0_ = state_0 |= 0x10;
        return this.convert(arg0Value, isFuncLib__, funcTypeLib__, asTStringLib__, switchEncoding__);
    }

    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0x1F) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & 0x1F & (state_0 & 0x1F) - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    @NeverDefault
    public static ToJSValueNode create() {
        return new ToJSValueNodeGen();
    }

    @NeverDefault
    public static ToJSValueNode getUncached() {
        return UNCACHED;
    }

    @GeneratedBy(value=ToJSValueNode.class)
    @DenyReplace
    private static final class FallbackData
    extends Node
    implements DSLSupport.SpecializationDataNode {
        @Node.Child
        InteropLibrary isFuncLib_;
        @Node.Child
        InteropLibrary funcTypeLib_;
        @Node.Child
        InteropLibrary asTStringLib_;
        @Node.Child
        TruffleString.SwitchEncodingNode switchEncoding_;

        FallbackData() {
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }
    }

    @GeneratedBy(value=ToJSValueNode.class)
    @DenyReplace
    private static final class Uncached
    extends ToJSValueNode {
        private Uncached() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object execute(Object arg0Value) {
            if (arg0Value instanceof Integer) {
                int arg0Value_ = (Integer)arg0Value;
                return ToJSValueNode.i32(arg0Value_);
            }
            if (arg0Value instanceof Long) {
                long arg0Value_ = (Long)arg0Value;
                return ToJSValueNode.i64(arg0Value_);
            }
            if (arg0Value instanceof Float) {
                float arg0Value_ = ((Float)arg0Value).floatValue();
                return ToJSValueNode.f32(arg0Value_);
            }
            if (JSTypesGen.isImplicitDouble(arg0Value)) {
                double arg0Value_ = JSTypesGen.asImplicitDouble(arg0Value);
                return ToJSValueNode.f64(arg0Value_);
            }
            return this.convert(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(), (InteropLibrary)INTEROP_LIBRARY_.getUncached(), (InteropLibrary)INTEROP_LIBRARY_.getUncached(), TruffleString.SwitchEncodingNode.getUncached());
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }
}

