/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.js.runtime.JSContextOptions;
import org.graalvm.options.OptionValues;
import org.graalvm.polyglot.SandboxPolicy;

public record JSLanguageOptions(int ecmaScriptVersion, boolean strict, boolean annexB, boolean intl402, boolean regexpMatchIndices, boolean regexpUnicodeSets, boolean sharedArrayBuffer, boolean v8RealmBuiltin, boolean nashornCompatibilityMode, int stackTraceLimit, boolean parseOnly, boolean zoneRulesBasedTimeZones, boolean agentCanBlock, boolean printNoNewline, boolean commonJSRequire, boolean awaitOptimization, boolean allowEval, boolean disableWith, boolean regexDumpAutomata, boolean regexStepExecution, boolean regexAlwaysEager, boolean scriptEngineGlobalScopeImport, boolean hasForeignObjectPrototype, boolean hasForeignHashProperties, long functionArgumentsLimit, boolean test262Mode, boolean testV8Mode, boolean validateRegExpLiterals, int functionConstructorCacheSize, int regexCacheSize, int stringLengthLimit, boolean stringLazySubstrings, boolean bindMemberFunctions, boolean regexRegressionTestMode, boolean testCloneUninitialized, boolean lazyTranslation, int maxTypedArrayLength, int maxApplyArgumentLength, int maxPrototypeChainLength, boolean asyncStackTraces, int propertyCacheLimit, int functionCacheLimit, short frequencyBasedPropertyCacheLimit, boolean topLevelAwait, boolean useUTCForLegacyDates, boolean webAssembly, boolean newSetMethods, boolean temporal, boolean iteratorHelpers, boolean shadowRealm, boolean asyncContext, boolean v8Intrinsics, JSContextOptions.UnhandledRejectionsTrackingMode unhandledRejectionsMode, boolean operatorOverloading, boolean errorCause, boolean importAssertions, boolean jsonModules, boolean wasmBigInt, boolean esmEvalReturnsExports, boolean isMLEMode, boolean privateFieldsIn, boolean esmBareSpecifierRelativeLookup, boolean scopeOptimization, boolean bigInt, boolean classFields, boolean shebang, boolean syntaxExtensions, boolean scripting, boolean functionStatementError, boolean constAsVar, boolean profileTime, String locale) {
    public static JSLanguageOptions fromOptionValues(SandboxPolicy sandboxPolicy, OptionValues optionValues) {
        return JSLanguageOptions.fromContextOptions(JSContextOptions.fromOptionValues(sandboxPolicy, optionValues));
    }

    public static JSLanguageOptions fromContextOptions(JSContextOptions options) {
        CompilerAsserts.neverPartOfCompilation();
        boolean nashornCompatibilityMode = options.isNashornCompatibilityMode();
        int ecmascriptVersion = options.getEcmaScriptVersion();
        boolean strict = options.isStrict();
        boolean annexB = options.isAnnexB();
        boolean intl402 = options.isIntl402();
        boolean regexpMatchIndices = options.isRegexpMatchIndices();
        boolean regexpUnicodeSets = options.isRegexpUnicodeSets();
        boolean sharedArrayBuffer = options.isSharedArrayBuffer();
        boolean v8RealmBuiltin = options.isV8RealmBuiltin();
        boolean parseOnly = options.isParseOnly();
        boolean zoneRulesBasedTimeZones = options.hasZoneRulesBasedTimeZones();
        boolean agentCanBlock = options.canAgentBlock();
        boolean awaitOptimization = options.isAwaitOptimization();
        boolean allowEval = options.allowEval();
        boolean disableWith = options.isDisableWith();
        boolean regexDumpAutomata = options.isRegexDumpAutomata();
        boolean regexStepExecution = options.isRegexStepExecution();
        boolean regexAlwaysEager = options.isRegexAlwaysEager();
        boolean scriptEngineGlobalScopeImport = options.isScriptEngineGlobalScopeImport();
        boolean hasForeignObjectPrototype = options.hasForeignObjectPrototype();
        boolean hasForeignHashProperties = options.hasForeignHashProperties();
        long functionArgumentsLimit = options.getFunctionArgumentsLimit();
        boolean test262Mode = options.isTest262Mode();
        boolean testV8Mode = options.isTestV8Mode();
        boolean validateRegExpLiterals = options.isValidateRegExpLiterals();
        int functionConstructorCacheSize = options.getFunctionConstructorCacheSize();
        int regexCacheSize = options.getRegexCacheSize();
        int stringLengthLimit = options.getStringLengthLimit();
        boolean stringLazySubstrings = options.isStringLazySubstrings();
        boolean bindMemberFunctions = options.bindMemberFunctions();
        boolean commonJSRequire = options.isCommonJSRequire();
        boolean regexRegressionTestMode = options.isRegexRegressionTestMode();
        boolean testCloneUninitialized = options.isTestCloneUninitialized();
        boolean lazyTranslation = options.isLazyTranslation();
        int stackTraceLimit = options.getStackTraceLimit();
        int maxTypedArrayLength = options.getMaxTypedArrayLength();
        int maxApplyArgumentLength = options.getMaxApplyArgumentLength();
        int maxPrototypeChainLength = options.getMaxPrototypeChainLength();
        boolean asyncStackTraces = options.isAsyncStackTraces();
        boolean topLevelAwait = options.isTopLevelAwait();
        boolean useUTCForLegacyDates = options.shouldUseUTCForLegacyDates();
        boolean webAssembly = options.isWebAssembly();
        JSContextOptions.UnhandledRejectionsTrackingMode unhandledRejectionsMode = options.getUnhandledRejectionsMode();
        boolean newSetMethods = options.isNewSetMethods();
        boolean iteratorHelpers = options.isIteratorHelpers();
        boolean shadowRealm = options.isShadowRealm();
        boolean asyncContext = options.isAsyncContext();
        boolean operatorOverloading = options.isOperatorOverloading();
        boolean errorCause = options.isErrorCauseEnabled();
        boolean importAssertions = options.isImportAssertions();
        boolean jsonModules = options.isJsonModules();
        boolean wasmBigInt = options.isWasmBigInt();
        boolean esmEvalReturnsExports = options.isEsmEvalReturnsExports();
        boolean printNoNewline = options.isPrintNoNewline();
        boolean mleMode = options.isMLEMode();
        boolean privateFieldsIn = options.isPrivateFieldsIn();
        boolean esmBareSpecifierRelativeLookup = options.isEsmBareSpecifierRelativeLookup();
        boolean temporal = options.isTemporal();
        int propertyCacheLimit = options.getPropertyCacheLimit();
        int functionCacheLimit = options.getFunctionCacheLimit();
        short frequencyBasedPropertyCacheLimit = options.getFrequencyBasedPropertyCacheLimit();
        boolean scopeOptimization = options.isScopeOptimization();
        boolean v8Intrinsics = options.isV8Intrinsics();
        boolean bigInt = options.isBigInt();
        boolean classFields = options.isClassFields();
        boolean shebang = options.isShebang();
        boolean syntaxExtensions = options.isSyntaxExtensions();
        boolean scripting = options.isScripting();
        boolean functionStatementError = options.isFunctionStatementError();
        boolean constAsVar = options.isConstAsVar();
        boolean profileTime = options.isProfileTime();
        String locale = options.getLocale();
        return new JSLanguageOptions(ecmascriptVersion, strict, annexB, intl402, regexpMatchIndices, regexpUnicodeSets, sharedArrayBuffer, v8RealmBuiltin, nashornCompatibilityMode, stackTraceLimit, parseOnly, zoneRulesBasedTimeZones, agentCanBlock, printNoNewline, commonJSRequire, awaitOptimization, allowEval, disableWith, regexDumpAutomata, regexStepExecution, regexAlwaysEager, scriptEngineGlobalScopeImport, hasForeignObjectPrototype, hasForeignHashProperties, functionArgumentsLimit, test262Mode, testV8Mode, validateRegExpLiterals, functionConstructorCacheSize, regexCacheSize, stringLengthLimit, stringLazySubstrings, bindMemberFunctions, regexRegressionTestMode, testCloneUninitialized, lazyTranslation, maxTypedArrayLength, maxApplyArgumentLength, maxPrototypeChainLength, asyncStackTraces, propertyCacheLimit, functionCacheLimit, frequencyBasedPropertyCacheLimit, topLevelAwait, useUTCForLegacyDates, webAssembly, newSetMethods, temporal, iteratorHelpers, shadowRealm, asyncContext, v8Intrinsics, unhandledRejectionsMode, operatorOverloading, errorCause, importAssertions, jsonModules, wasmBigInt, esmEvalReturnsExports, mleMode, privateFieldsIn, esmBareSpecifierRelativeLookup, scopeOptimization, bigInt, classFields, shebang, syntaxExtensions, scripting, functionStatementError, constAsVar, profileTime, locale);
    }
}

