/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.Enumeration;
import javax.net.ssl.KeyManagerFactory;
import javax.security.auth.x500.X500Principal;
import org.apache.directory.api.util.Strings;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public final class CertificateUtil {
    private static final boolean SELF_SIGNED = true;
    private static final boolean CA_SIGNED = false;
    private static final boolean CRITICAL = true;

    private CertificateUtil() {
    }

    public static X509Certificate generateX509Certificate(X500Principal subjectDn, X500Principal issuerDn, KeyPair keyPair, long daysValidity, String sigAlgorithm, boolean isCa) throws CertificateException {
        Instant from = Instant.now();
        Instant to = from.plus(Duration.ofDays(daysValidity));
        BigInteger serialNumber = new BigInteger(64, new SecureRandom());
        try {
            ContentSigner signer = new JcaContentSignerBuilder(sigAlgorithm).build(keyPair.getPrivate());
            InetAddress localHost = InetAddress.getLocalHost();
            GeneralName[] sanLocalHost = new GeneralName[]{new GeneralName(2, localHost.getHostName()), new GeneralName(7, localHost.getHostAddress())};
            X509v3CertificateBuilder certificateBuilder = new JcaX509v3CertificateBuilder(issuerDn, serialNumber, Date.from(from), Date.from(to), subjectDn, keyPair.getPublic()).addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(isCa)).addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)new GeneralNames(sanLocalHost));
            return new JcaX509CertificateConverter().setProvider((Provider)new BouncyCastleProvider()).getCertificate(certificateBuilder.build(signer));
        }
        catch (UnknownHostException | CertIOException | OperatorCreationException e) {
            throw new CertificateException("BouncyCastle failed to generate the X509 certificate.", e);
        }
    }

    public static X509Certificate generateSelfSignedCertificate(X500Principal issuer, KeyPair keyPair, int days, String algoStr) throws CertificateException, IOException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        return CertificateUtil.generateX509Certificate(issuer, issuer, keyPair, days, algoStr, true);
    }

    public static X509Certificate generateCertificate(X500Principal subject, X500Principal issuer, KeyPair keyPair, int days, String algoStr) throws CertificateException, IOException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        return CertificateUtil.generateX509Certificate(subject, issuer, keyPair, days, algoStr, false);
    }

    public static KeyManagerFactory loadKeyStore(String keyStoreFile, String keyStorePasswordStr) throws Exception {
        char[] keyStorePassword;
        char[] cArray = keyStorePassword = Strings.isEmpty((String)keyStorePasswordStr) ? null : keyStorePasswordStr.toCharArray();
        if (!Strings.isEmpty((String)keyStoreFile)) {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            try (InputStream is = Files.newInputStream(Paths.get(keyStoreFile, new String[0]), new OpenOption[0]);){
                keyStore.load(is, keyStorePassword);
            }
            Enumeration<String> aliases = keyStore.aliases();
            if (!aliases.hasMoreElements()) {
                throw new KeyStoreException("Key store is empty");
            }
            String alias = aliases.nextElement();
            if (aliases.hasMoreElements()) {
                throw new KeyStoreException("Key store contains more than one entry");
            }
            if (!keyStore.isKeyEntry(alias)) {
                throw new KeyStoreException("Key store must contain a key entry");
            }
            if (keyStore.getCertificateChain(alias) == null) {
                throw new KeyStoreException("Key store must contain a certificate chain");
            }
            if (keyStore.getKey(alias, keyStorePassword) == null) {
                throw new KeyStoreException("Private key must be recoverable by the key store password");
            }
            String algorithm = Security.getProperty("ssl.KeyManagerFactory.algorithm");
            if (algorithm == null) {
                algorithm = KeyManagerFactory.getDefaultAlgorithm();
            }
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(algorithm);
            keyManagerFactory.init(keyStore, keyStorePassword);
            return keyManagerFactory;
        }
        return null;
    }

    public static File createTempKeyStore(String keyStoreName, char[] keyStorePassword) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, InvalidKeyException, NoSuchProviderException, SignatureException {
        File keyStoreFile = Files.createTempFile(keyStoreName, "ks", new FileAttribute[0]).toFile();
        keyStoreFile.deleteOnExit();
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        try (FileInputStream keyStoreData = new FileInputStream(keyStoreFile);){
            keyStore.load(null, keyStorePassword);
        }
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("EC");
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        X500Principal owner = new X500Principal("CN=apacheds,OU=directory,O=apache,C=US");
        X509Certificate certificate = CertificateUtil.generateSelfSignedCertificate(owner, keyPair, 365, "SHA256WithECDSA");
        keyStore.setKeyEntry("apachedsKey", keyPair.getPrivate(), keyStorePassword, new X509Certificate[]{certificate});
        try (FileOutputStream out = new FileOutputStream(keyStoreFile);){
            keyStore.store(out, keyStorePassword);
        }
        return keyStoreFile;
    }
}

