/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.common.calc;

import org.graalvm.compiler.core.common.calc.FloatConvertCategory;
import org.graalvm.compiler.core.common.type.FloatStamp;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.PrimitiveStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.debug.GraalError;

public enum FloatConvert {
    F2I(FloatConvertCategory.FloatingPointToInteger, 32),
    D2I(FloatConvertCategory.FloatingPointToInteger, 64),
    F2L(FloatConvertCategory.FloatingPointToInteger, 32),
    D2L(FloatConvertCategory.FloatingPointToInteger, 64),
    I2F(FloatConvertCategory.IntegerToFloatingPoint, 32),
    L2F(FloatConvertCategory.IntegerToFloatingPoint, 64),
    D2F(FloatConvertCategory.FloatingPointToFloatingPoint, 64),
    I2D(FloatConvertCategory.IntegerToFloatingPoint, 32),
    L2D(FloatConvertCategory.IntegerToFloatingPoint, 64),
    F2D(FloatConvertCategory.FloatingPointToFloatingPoint, 32);

    private final FloatConvertCategory category;
    private final int inputBits;

    private FloatConvert(FloatConvertCategory category, int inputBits) {
        this.category = category;
        this.inputBits = inputBits;
    }

    public FloatConvertCategory getCategory() {
        return this.category;
    }

    public FloatConvert reverse() {
        switch (this) {
            case D2F: {
                return F2D;
            }
            case D2I: {
                return I2D;
            }
            case D2L: {
                return L2D;
            }
            case F2D: {
                return D2F;
            }
            case F2I: {
                return I2F;
            }
            case F2L: {
                return L2F;
            }
            case I2D: {
                return D2I;
            }
            case I2F: {
                return F2I;
            }
            case L2D: {
                return D2L;
            }
            case L2F: {
                return F2L;
            }
        }
        throw GraalError.shouldNotReachHereUnexpectedValue((Object)this);
    }

    public int getInputBits() {
        return this.inputBits;
    }

    public static FloatConvert forStamps(Stamp from, Stamp to) {
        int fromBits = PrimitiveStamp.getBits(from);
        int toBits = PrimitiveStamp.getBits(to);
        if (from instanceof FloatStamp) {
            if (to instanceof FloatStamp) {
                if (fromBits == 32 && toBits == 64) {
                    return F2D;
                }
                if (fromBits == 64 && toBits == 32) {
                    return D2F;
                }
            } else if (to instanceof IntegerStamp) {
                if (fromBits == 32 && toBits == 32) {
                    return F2I;
                }
                if (fromBits == 32 && toBits == 64) {
                    return F2L;
                }
                if (fromBits == 64 && toBits == 32) {
                    return D2I;
                }
                if (fromBits == 64 && toBits == 64) {
                    return D2L;
                }
            }
        } else if (from instanceof IntegerStamp && to instanceof FloatStamp) {
            if (fromBits == 32 && toBits == 32) {
                return I2F;
            }
            if (fromBits == 32 && toBits == 64) {
                return I2D;
            }
            if (fromBits == 64 && toBits == 32) {
                return L2F;
            }
            if (fromBits == 64 && toBits == 64) {
                return L2D;
            }
        }
        return null;
    }
}

