/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.common.cfg;

import java.util.Comparator;
import org.graalvm.compiler.core.common.cfg.AbstractControlFlowGraph;
import org.graalvm.compiler.core.common.cfg.Loop;

public abstract class BasicBlock<T extends BasicBlock<T>> {
    protected int id = Integer.MAX_VALUE;
    private int dominator = Integer.MAX_VALUE;
    private int firstDominated = Integer.MAX_VALUE;
    private int dominatedSibling = Integer.MAX_VALUE;
    protected int domDepth = 0;
    private int domNumber = Integer.MAX_VALUE;
    private int maxChildDomNumber = Integer.MAX_VALUE;
    private boolean indirectBranchTarget = false;
    protected final AbstractControlFlowGraph<T> cfg;
    public static final BlockIdComparator BLOCK_ID_COMPARATOR = new BlockIdComparator();

    protected BasicBlock(AbstractControlFlowGraph<T> cfg) {
        this.cfg = cfg;
    }

    public void setDominatorNumber(int domNumber) {
        this.domNumber = domNumber;
    }

    public void setMaxChildDomNumber(int maxChildDomNumber) {
        this.maxChildDomNumber = maxChildDomNumber;
    }

    public int getDominatorNumber() {
        if (this.domNumber == Integer.MAX_VALUE) {
            return -1;
        }
        return this.domNumber;
    }

    public int getMaxChildDominatorNumber() {
        if (this.maxChildDomNumber == Integer.MAX_VALUE) {
            return -1;
        }
        return this.maxChildDomNumber;
    }

    public int getId() {
        return this.id;
    }

    public T[] getBlocks() {
        return this.cfg.getBlocks();
    }

    public void setId(int id) {
        assert (id <= 0x7FFFFFFE);
        this.id = id;
    }

    public abstract int getPredecessorCount();

    public abstract int getSuccessorCount();

    private boolean contains(T key, boolean usePred) {
        for (int i = 0; i < (usePred ? this.getPredecessorCount() : this.getSuccessorCount()); ++i) {
            T b;
            T t = b = usePred ? this.getPredecessorAt(i) : this.getSuccessorAt(i);
            if (b != key) continue;
            return true;
        }
        return false;
    }

    public boolean containsPred(T key) {
        return this.contains(key, true);
    }

    public boolean containsSucc(T key) {
        return this.contains(key, false);
    }

    public abstract T getPredecessorAt(int var1);

    public abstract T getSuccessorAt(int var1);

    public abstract double getSuccessorProbabilityAt(int var1);

    public T getDominator() {
        return (T)(this.dominator != Integer.MAX_VALUE ? this.cfg.getBlocks()[this.dominator] : null);
    }

    public T getDominatorSkipLoops() {
        T d = this.getDominator();
        if (d == null) {
            return null;
        }
        if (this.isLoopHeader()) {
            assert (((BasicBlock)d).getLoopDepth() == this.getLoopDepth() - 1);
            assert (((BasicBlock)d).getLoop() != this.getLoop());
            return d;
        }
        while (((BasicBlock)d).getLoop() != this.getLoop()) {
            d = ((BasicBlock)d).getDominator();
        }
        assert (((BasicBlock)d).getLoopDepth() <= this.getLoopDepth());
        return d;
    }

    public void setDominator(T dominator) {
        this.dominator = ((BasicBlock)dominator).getId();
        this.domDepth = ((BasicBlock)dominator).domDepth + 1;
    }

    public int getDominatorDepth() {
        return this.domDepth;
    }

    public T getFirstDominated() {
        return (T)(this.firstDominated != Integer.MAX_VALUE ? this.cfg.getBlocks()[this.firstDominated] : null);
    }

    public void setFirstDominated(T block) {
        this.firstDominated = ((BasicBlock)block).getId();
    }

    public T getDominatedSibling() {
        return (T)(this.dominatedSibling != Integer.MAX_VALUE ? this.cfg.getBlocks()[this.dominatedSibling] : null);
    }

    public void setDominatedSibling(T block) {
        if (block != null) {
            this.dominatedSibling = ((BasicBlock)block).getId();
        }
    }

    public final boolean dominates(BasicBlock<?> other) {
        return AbstractControlFlowGraph.dominates(this, other);
    }

    public final boolean strictlyDominates(BasicBlock<T> other) {
        return AbstractControlFlowGraph.strictlyDominates(this, other);
    }

    public void setIndirectBranchTarget() {
        this.indirectBranchTarget = true;
    }

    public boolean isIndirectBranchTarget() {
        return this.indirectBranchTarget;
    }

    public String toString() {
        return "B" + this.id;
    }

    public abstract int getLinearScanNumber();

    public abstract void setLinearScanNumber(int var1);

    public abstract boolean isAligned();

    public abstract void setAlign(boolean var1);

    public abstract boolean isExceptionEntry();

    public abstract Loop<T> getLoop();

    public abstract int getLoopDepth();

    public abstract void delete();

    public abstract boolean isLoopEnd();

    public abstract boolean isLoopHeader();

    public abstract int numBackedges();

    public abstract T getPostdominator();

    public abstract double getRelativeFrequency();

    public abstract T getDominator(int var1);

    public abstract boolean isModifiable();

    public int hashCode() {
        return this.id;
    }

    public static class BlockIdComparator
    implements Comparator<BasicBlock<?>> {
        @Override
        public int compare(BasicBlock<?> o1, BasicBlock<?> o2) {
            return Integer.compare(o1.getId(), o2.getId());
        }
    }
}

