/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.common.memory;

import org.graalvm.compiler.core.common.type.ArithmeticOpTable;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.debug.GraalError;

public final class MemoryExtendKind
extends Enum<MemoryExtendKind> {
    public static final /* enum */ MemoryExtendKind DEFAULT = new MemoryExtendKind(false, false, 0);
    public static final /* enum */ MemoryExtendKind ZERO_16 = new MemoryExtendKind(true, false, 16);
    public static final /* enum */ MemoryExtendKind ZERO_32 = new MemoryExtendKind(true, false, 32);
    public static final /* enum */ MemoryExtendKind ZERO_64 = new MemoryExtendKind(true, false, 64);
    public static final /* enum */ MemoryExtendKind SIGN_16 = new MemoryExtendKind(false, true, 16);
    public static final /* enum */ MemoryExtendKind SIGN_32 = new MemoryExtendKind(false, true, 32);
    public static final /* enum */ MemoryExtendKind SIGN_64 = new MemoryExtendKind(false, true, 64);
    private final boolean zeroExtend;
    private final boolean signExtend;
    private final int extendedSize;
    private static final /* synthetic */ MemoryExtendKind[] $VALUES;

    public static MemoryExtendKind[] values() {
        return (MemoryExtendKind[])$VALUES.clone();
    }

    public static MemoryExtendKind valueOf(String name) {
        return Enum.valueOf(MemoryExtendKind.class, name);
    }

    private MemoryExtendKind(boolean zeroExtend, boolean signExtend, int extendedSize) {
        this.zeroExtend = zeroExtend;
        this.signExtend = signExtend;
        this.extendedSize = extendedSize;
    }

    public boolean isNotExtended() {
        return !this.zeroExtend && !this.signExtend;
    }

    public boolean isExtended() {
        return this.zeroExtend || this.signExtend;
    }

    public boolean isZeroExtend() {
        return this.zeroExtend;
    }

    public boolean isSignExtend() {
        return this.zeroExtend;
    }

    public int getExtendedBitSize() {
        return this.extendedSize;
    }

    public Stamp stampFor(IntegerStamp original) {
        assert (this.isExtended());
        int inputBits = original.getBits();
        int resultBits = this.getExtendedBitSize();
        assert (inputBits <= resultBits);
        if (this.isZeroExtend()) {
            return ArithmeticOpTable.forStamp(original).getZeroExtend().foldStamp(inputBits, resultBits, original);
        }
        return ArithmeticOpTable.forStamp(original).getSignExtend().foldStamp(inputBits, resultBits, original);
    }

    public static MemoryExtendKind getZeroExtendKind(int extendSize) {
        switch (extendSize) {
            case 16: {
                return ZERO_16;
            }
            case 32: {
                return ZERO_32;
            }
            case 64: {
                return ZERO_64;
            }
        }
        throw GraalError.shouldNotReachHereUnexpectedValue(extendSize);
    }

    public static MemoryExtendKind getSignExtendKind(int extendSize) {
        switch (extendSize) {
            case 16: {
                return SIGN_16;
            }
            case 32: {
                return SIGN_32;
            }
            case 64: {
                return SIGN_64;
            }
        }
        throw GraalError.shouldNotReachHereUnexpectedValue(extendSize);
    }

    private static /* synthetic */ MemoryExtendKind[] $values() {
        return new MemoryExtendKind[]{DEFAULT, ZERO_16, ZERO_32, ZERO_64, SIGN_16, SIGN_32, SIGN_64};
    }

    static {
        $VALUES = MemoryExtendKind.$values();
    }
}

