/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.common.util;

import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public interface PhasePlan<T> {
    public List<T> getPhases();

    default public String getPhaseName(T phase) {
        return phase.getClass().getName();
    }

    default public String getGraphStateDiff(int position) {
        return null;
    }

    default public int getFailureIndex() {
        return -1;
    }

    public static final class Printer {
        private static final String CONNECTING_INDENT = "\u2502   ";
        private static final String EMPTY_INDENT = "    ";
        private static final String CHILD = "\u251c\u2500\u2500 ";
        private static final String LAST_CHILD = "\u2514\u2500\u2500 ";
        final Map<String, String> abbreviations = new HashMap<String, String>();

        public <T> String toString(PhasePlan<T> plan) {
            return this.printPlan("", plan, new Formatter()).toString();
        }

        private <T> Formatter printPlan(String indent, PhasePlan<T> plan, Formatter buf) {
            int index = 0;
            Iterator<T> iter = plan.getPhases().iterator();
            while (iter.hasNext()) {
                T phase = iter.next();
                String className = plan.getPhaseName(phase);
                boolean hasNext = iter.hasNext();
                buf.format("%s%s%s", indent, hasNext ? CHILD : LAST_CHILD, this.abbreviate(className));
                String graphState = plan.getGraphStateDiff(index);
                if (graphState != null) {
                    buf.format(" %s", graphState);
                }
                if (plan.getFailureIndex() == index) {
                    buf.format("  /* THE FAILURE OCCURRED DURING THIS PHASE */", new Object[0]);
                }
                buf.format("%n", new Object[0]);
                if (phase instanceof PhasePlan) {
                    PhasePlan subPlan = (PhasePlan)phase;
                    String nextLevel = hasNext ? CONNECTING_INDENT : EMPTY_INDENT;
                    this.printPlan(indent + nextLevel, subPlan, buf);
                }
                ++index;
            }
            return buf;
        }

        private static int firstCapitalAfterPeriod(String s) {
            for (int i = 1; i < s.length(); ++i) {
                if (s.charAt(i - 1) != '.' || !Character.isUpperCase(s.charAt(i))) continue;
                return i;
            }
            return 0;
        }

        private String abbreviate(String className) {
            Object abbreviation = this.abbreviations.get(className);
            if (abbreviation == null) {
                int simpleClassNameStart = Printer.firstCapitalAfterPeriod(className);
                String simpleClassName = className.substring(simpleClassNameStart);
                String packageName = simpleClassNameStart != 0 ? className.substring(0, simpleClassNameStart - 1) : "";
                abbreviation = this.abbreviations.values().contains(simpleClassName) ? simpleClassName + " [" + packageName + "]" : simpleClassName;
                this.abbreviations.put(className, (String)abbreviation);
            }
            return abbreviation;
        }
    }
}

