/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.debug;

import java.io.PrintStream;
import org.graalvm.compiler.debug.LogStream;

public final class CSVUtil {
    public static final char SEPARATOR = ';';
    public static final String SEPARATOR_STR = String.valueOf(';');
    public static final char QUOTE = '\"';
    public static final char ESCAPE = '\\';

    public static String buildFormatString(String ... format) {
        return String.join((CharSequence)SEPARATOR_STR, format);
    }

    public static String buildFormatString(String format, char separator, int num) {
        StringBuilder sb = new StringBuilder(num * (format.length() + 1) - 1);
        sb.append(format);
        for (int i = 1; i < num; ++i) {
            sb.append(separator).append(format);
        }
        return sb.toString();
    }

    public static final class Escape {
        public static PrintStream println(PrintStream out, String format, Object ... args) {
            return Escape.println(out, ';', '\"', '\\', format, args);
        }

        public static LogStream println(LogStream out, String format, Object ... args) {
            return Escape.println(out, ';', '\"', '\\', format, args);
        }

        public static String escape(String str) {
            return Escape.escape(str, ';', '\"', '\\');
        }

        public static String escapeRaw(String str) {
            return Escape.escapeRaw(str, '\"', '\\');
        }

        public static PrintStream println(PrintStream out, char separator, char quote, char escape, String format, Object ... args) {
            out.printf(format, Escape.escapeArgs(separator, quote, escape, args));
            out.println();
            return out;
        }

        public static LogStream println(LogStream out, char separator, char quote, char escape, String format, Object ... args) {
            out.printf(format, Escape.escapeArgs(separator, quote, escape, args));
            out.println();
            return out;
        }

        public static Object[] escapeArgs(Object ... args) {
            return Escape.escapeArgs(';', '\"', '\\', args);
        }

        public static Object[] escapeArgsFormatString(Object ... args) {
            return Escape.escapeArgs(';', '\"', '\\', true, args);
        }

        public static Object[] escapeArgs(char separator, char quote, char escape, Object ... args) {
            return Escape.escapeArgs(separator, quote, escape, false, args);
        }

        public static Object[] escapeArgs(char separator, char quote, char escape, boolean isFormatString, Object ... args) {
            String separatorStr = String.valueOf(separator);
            for (int i = 0; i < args.length; ++i) {
                Object obj = args[i];
                if (!(obj instanceof String)) continue;
                String str = (String)obj;
                if (str.contains(separatorStr)) {
                    args[i] = Escape.escapeRaw(str, quote, escape);
                }
                if (!isFormatString || !str.contains("%")) continue;
                args[i] = str.replace("%", "%%");
            }
            return args;
        }

        public static String escape(String str, char separator, char quote, char escape) {
            String separatorStr = String.valueOf(separator);
            if (str.contains(separatorStr) || str.contains("%")) {
                return Escape.escapeRaw(str, quote, escape);
            }
            return str;
        }

        public static String escapeRaw(String str, char quote, char escape) {
            String quoteStr = String.valueOf(quote);
            String escapeStr = String.valueOf(escape);
            String escapedEscapeStr = escapeStr + escape;
            String escapedQuoteStr = escapeStr + quote;
            String str1 = str.replace(escapeStr, escapedEscapeStr);
            String str2 = str1.replace(quoteStr, escapedQuoteStr);
            String str3 = quoteStr + str2 + quote;
            return str3;
        }
    }
}

