/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hightiercodegen;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import org.graalvm.compiler.core.common.calc.CanonicalCondition;
import org.graalvm.compiler.hightiercodegen.CodeGenTool;
import org.graalvm.compiler.hightiercodegen.Keyword;
import org.graalvm.compiler.nodes.ParameterNode;

public abstract class CodeBuffer {
    protected int scopeIndent = 0;
    protected final ByteArrayOutputStream codeBytes = new ByteArrayOutputStream();
    private boolean shouldEmitIndent;

    public void emitComment(String s) {
        this.emitMultLineCommentStart();
        this.emitText(this.stripCommentMultiline(s));
        this.emitMultLineCommentEnd();
    }

    public void emitInlineComment(String s) {
        this.emitMultLineCommentStart();
        this.emitText(this.stripComment(s));
        this.emitMultLineCommentEnd();
    }

    protected abstract void emitMultLineCommentStart();

    protected abstract void emitMultLineCommentEnd();

    public int codeSize() {
        return this.codeBytes.size();
    }

    public void setCodeBytes(byte[] code) {
        assert (this.scopeIndent == 0);
        assert (!this.shouldEmitIndent);
        this.codeBytes.reset();
        this.emitCode(code);
    }

    public String getCode() {
        return this.codeBytes.toString();
    }

    public void emitImage(Path f) {
        try (BufferedOutputStream bos = new BufferedOutputStream(Files.newOutputStream(f, new OpenOption[0]));){
            bos.write(this.codeBytes.toByteArray());
            bos.flush();
        }
        catch (Exception e) {
            throw JVMCIError.shouldNotReachHere((Throwable)e);
        }
    }

    public void emitCode(byte[] b) {
        if (this.shouldEmitIndent) {
            this.shouldEmitIndent = false;
            this.emitIndent();
        }
        this.codeBytes.write(b, 0, b.length);
    }

    protected void emitSingleIndent() {
        this.emitText("\t");
    }

    private void emitIndent() {
        for (int i = 0; i < this.scopeIndent; ++i) {
            this.emitSingleIndent();
        }
    }

    public void emitIntLiteral(int i) {
        this.emitText(CodeGenTool.getEfficientIntLiteral(i));
    }

    public void emitFloatLiteral(float f) {
        this.emitText(String.valueOf(f));
    }

    public void emitDoubleLiteral(double d) {
        this.emitText(String.valueOf(d));
    }

    public void emitStringLiteral(String s) {
        this.emitText(this.getStringLiteral(s));
    }

    public void emitBoolLiteral(boolean b) {
        this.emitText(b ? "true" : "false");
    }

    public void emitKeyword(Keyword keyword) {
        this.emitText(keyword.toString());
    }

    public abstract void emitDeclarationPrefix();

    public void emitDeclarationPrefix(ResolvedJavaType type) {
        this.emitDeclarationPrefix();
    }

    public abstract void emitAnonymousClassHeader(String var1);

    public void emitDeclarationName(String name) {
        this.emitText(name);
    }

    public abstract String getStringLiteral(String var1);

    public abstract void emitInsEnd();

    public void emitText(String text) {
        this.emitCode(text.getBytes());
    }

    public void emitWhiteSpace() {
        this.emitText(" ");
    }

    public abstract void emitEscapedStringLiteral(Reader var1) throws IOException;

    public void emitFunctionEnd() {
        this.emitScopeEnd();
        this.emitNewLine();
    }

    public abstract void emitMethodHeader(ResolvedJavaMethod var1, String var2, Signature var3, List<ParameterNode> var4);

    protected abstract String stripCommentMultiline(String var1);

    String stripComment(String s) {
        return this.stripCommentMultiline(s).replace(System.lineSeparator(), "..").replace('\n', '.');
    }

    public abstract void emitIfHeaderLeft();

    public abstract void emitIfHeaderRight();

    protected void scopeBegin() {
        ++this.scopeIndent;
    }

    protected void scopeEnd() {
        --this.scopeIndent;
        assert (this.scopeIndent >= 0) : "Indenting must not go below 0 ";
    }

    public abstract void emitScopeBegin();

    public abstract void emitScopeEnd();

    public abstract void emitElse();

    public abstract void emitWhileTrueHeader();

    public void emitBreak() {
        this.emitBreakSymbol();
        this.emitInsEnd();
    }

    protected abstract void emitBreakSymbol();

    public abstract void emitBreakLabel(String var1);

    public void emitContinue() {
        this.emitContinueSymbol();
        this.emitInsEnd();
    }

    protected abstract void emitContinueSymbol();

    public void emitReturn() {
        this.emitReturnSymbol();
    }

    public abstract void emitReturnSymbol();

    public abstract void emitSwitchHeaderLeft();

    public void emitSwitchHeaderRight() {
        this.emitIfHeaderRight();
    }

    public abstract void emitLabel(String var1);

    public abstract void emitIntCaseChain(int[] var1);

    public abstract void emitDefaultCase();

    public void emitCondition(CanonicalCondition cond) {
        this.emitWhiteSpace();
        this.emitText(cond.asCondition().operator);
        this.emitWhiteSpace();
    }

    public void emitResolvedBuiltInVarDeclPostfix(String comment) {
        if (comment != null) {
            this.emitWhiteSpace();
            this.emitInlineComment(comment);
        }
        this.emitInsEnd();
    }

    public void emitDeclPrefix(String name) {
        this.emitDeclarationPrefix();
        this.emitDeclarationName(name);
        this.emitWhiteSpace();
        this.emitAssignmentSymbol();
        this.emitWhiteSpace();
    }

    public void emitDeclPrefix(String name, ResolvedJavaType type) {
        this.emitDeclarationPrefix(type);
        this.emitDeclarationName(name);
        this.emitWhiteSpace();
        this.emitAssignmentSymbol();
        this.emitWhiteSpace();
    }

    public abstract void emitAssignmentSymbol();

    public void emitNew() {
        this.emitNewSymbol();
        this.emitWhiteSpace();
    }

    protected abstract void emitNewSymbol();

    public void emitTry() {
        this.emitTrySymbol();
        this.emitScopeBegin();
    }

    protected abstract void emitTrySymbol();

    public abstract void emitCatch(String var1);

    public abstract void emitCatch(String var1, ResolvedJavaType var2);

    public void emitNewLine() {
        this.emitText(System.lineSeparator());
        this.shouldEmitIndent = true;
    }

    public int getScopeIndent() {
        return this.scopeIndent;
    }

    public void setScopeIndent(int indent) {
        assert (indent >= 0) : "Indenting must not go below 0 ";
        this.scopeIndent = indent;
    }

    public String toString() {
        return this.codeBytes.toString();
    }
}

