/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hightiercodegen;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.hightiercodegen.CodeGenTool;
import org.graalvm.compiler.hightiercodegen.IEmitter;
import org.graalvm.compiler.hightiercodegen.Keyword;
import org.graalvm.compiler.hightiercodegen.variables.ResolvedVar;
import org.graalvm.compiler.nodes.ValueNode;

public class Emitter
implements IEmitter {
    private static final Emitter NULL = new Emitter(CodeGenTool::genNull);
    private final Consumer<CodeGenTool> lowerer;

    protected Emitter(Consumer<CodeGenTool> lowerer) {
        this.lowerer = lowerer;
    }

    @Override
    public void lower(CodeGenTool codeGenTool) {
        this.lowerer.accept(codeGenTool);
    }

    public static Emitter ofNull() {
        return NULL;
    }

    public static Emitter of(String s) {
        Objects.requireNonNull(s);
        return new Emitter(t -> t.getCodeBuffer().emitText(s));
    }

    public static Emitter stringLiteral(String s) {
        Objects.requireNonNull(s);
        return new Emitter(t -> t.getCodeBuffer().emitStringLiteral(s));
    }

    public static Emitter of(ResolvedJavaMethod m) {
        Objects.requireNonNull(m);
        return new Emitter(t -> t.genMethodName(m));
    }

    public static Emitter of(ResolvedJavaField f) {
        Objects.requireNonNull(f);
        return new Emitter(t -> t.genFieldName(f));
    }

    public static Emitter of(ResolvedJavaType type) {
        Objects.requireNonNull(type);
        return new Emitter(t -> t.genTypeName(type));
    }

    public static Emitter of(ValueNode n) {
        if (n == null) {
            return Emitter.ofNull();
        }
        return new Emitter(t -> t.lowerValue(n));
    }

    public static Emitter of(ResolvedVar v) {
        Objects.requireNonNull(v);
        return new Emitter(t -> t.getCodeBuffer().emitText(v.getName()));
    }

    public static Emitter of(Class<?> c) {
        Objects.requireNonNull(c);
        return new Emitter(t -> t.genTypeName(c));
    }

    public static Emitter of(Method m) {
        Objects.requireNonNull(m);
        return new Emitter(t -> t.genMethodName(m));
    }

    public static Emitter of(Field f) {
        Objects.requireNonNull(f);
        return new Emitter(t -> t.genFieldName(f));
    }

    public static Emitter of(Integer i) {
        Objects.requireNonNull(i);
        return new Emitter(t -> t.getCodeBuffer().emitIntLiteral(i));
    }

    public static Emitter of(Byte i) {
        return Emitter.of(i.intValue());
    }

    public static Emitter of(Short i) {
        return Emitter.of(i.intValue());
    }

    public static Emitter of(Character c) {
        return Emitter.of(Integer.valueOf(c.charValue()));
    }

    public static Emitter of(Float f) {
        Objects.requireNonNull(f);
        return new Emitter(t -> t.getCodeBuffer().emitFloatLiteral(f.floatValue()));
    }

    public static Emitter of(Double d) {
        Objects.requireNonNull(d);
        return new Emitter(t -> t.getCodeBuffer().emitDoubleLiteral(d));
    }

    public static Emitter of(Boolean b) {
        Objects.requireNonNull(b);
        return new Emitter(t -> t.getCodeBuffer().emitBoolLiteral(b));
    }

    public static Emitter[] of(List<? extends ValueNode> l) {
        Emitter[] lowerList = new Emitter[l.size()];
        for (int i = 0; i < l.size(); ++i) {
            lowerList[i] = Emitter.of(l.get(i));
        }
        return lowerList;
    }

    public static Emitter of(Emitter ... emitters) {
        return new Emitter(t -> {
            for (Emitter emitter : emitters) {
                emitter.lower((CodeGenTool)t);
            }
        });
    }

    public static Emitter of(Keyword context) {
        return new Emitter(t -> t.getCodeBuffer().emitKeyword(context));
    }

    public static Emitter ofArray(Emitter ... emitters) {
        return new Emitter(t -> {
            boolean first = true;
            t.getCodeBuffer().emitText("[");
            for (Emitter emitter : emitters) {
                if (first) {
                    first = false;
                } else {
                    t.getCodeBuffer().emitText(",");
                }
                emitter.lower((CodeGenTool)t);
            }
            t.getCodeBuffer().emitText("]");
        });
    }

    public static Emitter ofObject(Map<Object, IEmitter> props) {
        return new Emitter(t -> {
            t.getCodeBuffer().emitScopeBegin();
            for (Map.Entry entry : props.entrySet()) {
                Object key = entry.getKey();
                if (key instanceof String) {
                    t.getCodeBuffer().emitStringLiteral((String)key);
                } else {
                    t.getCodeBuffer().emitText("[");
                    ((Emitter)key).lower((CodeGenTool)t);
                    t.getCodeBuffer().emitText("]");
                }
                t.getCodeBuffer().emitText(" : ");
                ((IEmitter)entry.getValue()).lower((CodeGenTool)t);
                t.getCodeBuffer().emitText(",");
                t.getCodeBuffer().emitNewLine();
            }
            t.getCodeBuffer().emitScopeEnd();
        });
    }
}

