/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hightiercodegen.irwalk;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.graalvm.compiler.core.common.cfg.BlockMap;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeMap;
import org.graalvm.compiler.hightiercodegen.CodeGenTool;
import org.graalvm.compiler.hightiercodegen.irwalk.BlockVisitHistory;
import org.graalvm.compiler.hightiercodegen.irwalk.IRWalkVerifier;
import org.graalvm.compiler.hightiercodegen.lowerer.PhiResolveLowerer;
import org.graalvm.compiler.hightiercodegen.reconstruction.ReconstructionData;
import org.graalvm.compiler.nodes.LoopEndNode;
import org.graalvm.compiler.nodes.cfg.ControlFlowGraph;
import org.graalvm.compiler.nodes.cfg.HIRBlock;

public abstract class IRWalker {
    protected final CodeGenTool codeGenTool;
    protected final ControlFlowGraph cfg;
    protected final BlockMap<List<Node>> blockToNodeMap;
    protected final NodeMap<HIRBlock> nodeToBlockMap;
    protected final IRWalkVerifier verifier;
    protected final BlockVisitHistory blockHistory;
    protected final ReconstructionData reconstructionData;

    public IRWalker(CodeGenTool codeGenTool, ControlFlowGraph cfg, BlockMap<List<Node>> blockToNodeMap, NodeMap<HIRBlock> nodeToBlockMap, ReconstructionData reconstructionData) {
        this.codeGenTool = codeGenTool;
        this.cfg = cfg;
        this.reconstructionData = reconstructionData;
        this.blockHistory = new BlockVisitHistory();
        this.blockToNodeMap = blockToNodeMap;
        this.nodeToBlockMap = nodeToBlockMap;
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (HIRBlock b : cfg.getBlocks()) {
            nodes.addAll((Collection<Node>)blockToNodeMap.get(b));
        }
        this.verifier = new IRWalkVerifier(nodes);
    }

    public void lowerFunction(DebugContext debugContext) {
        try (DebugContext.Scope s = debugContext.scope("Code Flow Verification");){
            this.lower(debugContext);
            this.verifier.verify(this.cfg.graph, this.codeGenTool, this.reconstructionData);
        }
        catch (Throwable t) {
            throw debugContext.handle(t);
        }
    }

    protected abstract void lower(DebugContext var1);

    protected void lowerLoopEndResolver(LoopEndNode node) {
        new PhiResolveLowerer(node).lower(this.codeGenTool);
    }

    protected boolean lowerNode(Node n) {
        if (this.codeGenTool.nodeLowerer().isTopLevelStatement(n)) {
            this.codeGenTool.lowerStatement(n);
            return true;
        }
        return false;
    }
}

