/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hightiercodegen.variables;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeInputList;
import org.graalvm.compiler.graph.NodeMap;
import org.graalvm.compiler.hightiercodegen.CodeGenTool;
import org.graalvm.compiler.hightiercodegen.variables.VariableMap;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValuePhiNode;
import org.graalvm.compiler.nodes.cfg.HIRBlock;

public abstract class VariableAllocation {
    public VariableMap compute(StructuredGraph g, CodeGenTool codeGenTool) {
        VariableMap varMap = new VariableMap();
        for (ValueNode node : g.getNodes().filter(ValueNode.class)) {
            if (!this.needsVariable(node, codeGenTool)) continue;
            varMap.allocate(node);
        }
        return varMap;
    }

    protected boolean isSafeToInline(ValueNode node, SafetyPolicy policy, CodeGenTool codeGenTool) {
        List<Node> effectiveUsages = VariableAllocation.getEffectiveUsages(node, codeGenTool);
        int numUsages = effectiveUsages.size();
        switch (policy) {
            case Always: {
                return true;
            }
            case SingleUsage: {
                return numUsages <= 1;
            }
            case SingleUsageAtNext: {
                if (numUsages == 1 && node instanceof FixedWithNextNode) {
                    FixedWithNextNode fixed = (FixedWithNextNode)node;
                    FixedNode next = fixed.next();
                    return effectiveUsages.get(0) == next;
                }
                return false;
            }
            case InBlockNoMerge: {
                NodeMap<HIRBlock> nodeToBlockMap = node.graph().getLastSchedule().getNodeToBlockMap();
                HIRBlock thisNodeBlock = nodeToBlockMap.get(node);
                if (!effectiveUsages.stream().allMatch(usage -> this.getBlockUsage(node, (Node)usage, nodeToBlockMap) == thisNodeBlock)) {
                    return false;
                }
                if (thisNodeBlock == null) {
                    return false;
                }
                for (int i = 0; i < thisNodeBlock.getSuccessorCount(); ++i) {
                    AbstractBeginNode b = ((HIRBlock)thisNodeBlock.getSuccessorAt(i)).getBeginNode();
                    if (!(b instanceof AbstractMergeNode)) continue;
                    return false;
                }
                return true;
            }
            case Never: {
                return false;
            }
        }
        throw GraalError.shouldNotReachHere(policy.toString());
    }

    protected HIRBlock getBlockUsage(ValueNode node, Node usage, NodeMap<HIRBlock> nodeToBlockMap) {
        HIRBlock block = nodeToBlockMap.get(usage);
        if (usage instanceof ValuePhiNode) {
            ValuePhiNode phi = (ValuePhiNode)usage;
            AbstractMergeNode merge = phi.merge();
            NodeInputList<ValueNode> values = phi.values();
            for (int i = 0; i < values.size(); ++i) {
                if (values.get(i) != node) continue;
                return nodeToBlockMap.get(merge.phiPredecessorAt(i));
            }
            throw GraalError.shouldNotReachHere("Could not find end node for " + node + " and " + usage);
        }
        return block;
    }

    public abstract Collection<SafetyPolicy> getSafeInliningPolicies(ValueNode var1, CodeGenTool var2);

    protected abstract boolean shouldInline(ValueNode var1, int var2, CodeGenTool var3);

    public boolean needsVariable(ValueNode node, CodeGenTool codeGenTool) {
        if (!codeGenTool.nodeLowerer().isActiveValueNode(node)) {
            return false;
        }
        Collection<SafetyPolicy> policies = this.getSafeInliningPolicies(node, codeGenTool);
        assert (!policies.isEmpty());
        if (!policies.stream().allMatch(policy -> this.isSafeToInline(node, (SafetyPolicy)((Object)policy), codeGenTool))) {
            return true;
        }
        return !this.shouldInline(node, VariableAllocation.getEffectiveUsages(node, codeGenTool).size(), codeGenTool);
    }

    public static List<Node> getEffectiveUsages(ValueNode node, CodeGenTool codeGenTool) {
        ArrayList<Node> usages = new ArrayList<Node>(node.getUsageCount());
        for (Node usage : codeGenTool.nodeLowerer().actualUsages(node)) {
            if (usage instanceof CallTargetNode) {
                CallTargetNode callTarget = (CallTargetNode)usage;
                for (Node callTargetUsage : codeGenTool.nodeLowerer().actualUsages(callTarget)) {
                    if (!(callTargetUsage instanceof Invoke)) continue;
                    usages.add(callTargetUsage);
                }
                continue;
            }
            usages.add(usage);
        }
        return usages;
    }

    protected static enum SafetyPolicy {
        Always,
        SingleUsage,
        SingleUsageAtNext,
        InBlockNoMerge,
        Never;

    }
}

