/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hightiercodegen.variables;

import java.util.HashMap;
import org.graalvm.compiler.hightiercodegen.variables.ResolvedVar;
import org.graalvm.compiler.nodes.ValueNode;

public final class VariableMap {
    public static final String LOCAL_PREFIX = "l";
    private int count = 0;
    private final HashMap<ValueNode, ResolvedVar> resolvedVars = new HashMap();

    public ResolvedVar getVarByNode(ValueNode n) {
        assert (n != null);
        return this.resolvedVars.get(n);
    }

    public ResolvedVar allocate(ValueNode n) {
        assert (!this.resolvedVars.containsKey(n)) : "already allocated for " + n;
        ResolvedVar var = new ResolvedVar(n);
        var.birth(LOCAL_PREFIX + this.count);
        this.resolvedVars.put(n, var);
        ++this.count;
        return var;
    }

    public String toString() {
        return "Variable count: " + this.resolvedVars.size() + "\n" + this.resolvedVars;
    }
}

