/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot;

import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.java.BytecodeParser;
import org.graalvm.compiler.java.GraphBuilderPhase;
import org.graalvm.compiler.nodes.DeoptimizeNode;
import org.graalvm.compiler.nodes.FixedGuardNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.graphbuilderconf.IntrinsicContext;

public class HotSpotBytecodeParser
extends BytecodeParser {
    protected HotSpotBytecodeParser(GraphBuilderPhase.Instance graphBuilderInstance, StructuredGraph graph, BytecodeParser parent, ResolvedJavaMethod method, int entryBCI, IntrinsicContext intrinsicContext) {
        super(graphBuilderInstance, graph, parent, method, entryBCI, intrinsicContext);
    }

    @Override
    protected Object lookupConstant(int cpi, int opcode, boolean allowBootstrapMethodInvocation) {
        try {
            return super.lookupConstant(cpi, opcode, allowBootstrapMethodInvocation);
        }
        catch (BootstrapMethodError e) {
            DeoptimizeNode deopt = this.append(new DeoptimizeNode(DeoptimizationAction.None, DeoptimizationReason.RuntimeConstraint));
            deopt.updateNodeSourcePosition(() -> this.createBytecodePosition());
            return e;
        }
    }

    @Override
    public GuardingNode intrinsicRangeCheck(LogicNode condition, boolean negated) {
        return this.add(new FixedGuardNode(condition, DeoptimizationReason.BoundsCheckException, DeoptimizationAction.None, !negated));
    }
}

