/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot;

import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotObjectConstant;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaField;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethod;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaType;
import jdk.vm.ci.hotspot.HotSpotSignature;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MemoryAccessProvider;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.MethodHandleAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import jdk.vm.ci.meta.SpeculationLog;
import jdk.vm.ci.meta.UnresolvedJavaType;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.MapCursor;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.bytecode.BytecodeProvider;
import org.graalvm.compiler.bytecode.ResolvedJavaMethodBytecode;
import org.graalvm.compiler.core.common.type.AbstractObjectStamp;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.core.common.type.SymbolicJVMCIReference;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeMap;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.hotspot.EncodedSnippets;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotReplacementsImpl;
import org.graalvm.compiler.hotspot.SnippetObjectConstant;
import org.graalvm.compiler.hotspot.SnippetResolvedJavaMethod;
import org.graalvm.compiler.hotspot.SnippetResolvedJavaType;
import org.graalvm.compiler.hotspot.meta.HotSpotForeignCallsProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.stubs.ForeignCallStub;
import org.graalvm.compiler.hotspot.word.HotSpotWordTypes;
import org.graalvm.compiler.java.BytecodeParser;
import org.graalvm.compiler.java.GraphBuilderPhase;
import org.graalvm.compiler.nodeinfo.Verbosity;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.CompressionNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.EncodedGraph;
import org.graalvm.compiler.nodes.FieldLocationIdentity;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.FullInfopointNode;
import org.graalvm.compiler.nodes.GraphEncoder;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.ProxyNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.cfg.HIRBlock;
import org.graalvm.compiler.nodes.graphbuilderconf.GeneratedInvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.IntrinsicContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.graphbuilderconf.NodePlugin;
import org.graalvm.compiler.nodes.java.AccessFieldNode;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.memory.ReadNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.spi.SnippetParameterInfo;
import org.graalvm.compiler.nodes.type.NarrowOopStamp;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.OptimisticOptimizations;
import org.graalvm.compiler.phases.schedule.SchedulePhase;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.PartialIntrinsicCallTargetNode;
import org.graalvm.compiler.replacements.ReplacementsImpl;
import org.graalvm.compiler.replacements.SnippetCounter;
import org.graalvm.compiler.replacements.SnippetIntegerHistogram;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.classfile.ClassfileBytecode;

public class SymbolicSnippetEncoder {
    private final EconomicMap<String, String> originalMethods = EconomicMap.create();
    private final HotSpotReplacementsImpl originalReplacements;
    private final EconomicMap<SnippetKey, BiFunction<OptionValues, HotSpotSnippetReplacementsImpl, StructuredGraph>> pendingSnippetGraphs = EconomicMap.create();
    private final EconomicMap<String, SnippetParameterInfo> snippetParameterInfos = EconomicMap.create();
    private final EconomicSet<InvocationPlugin> conditionalPlugins = EconomicSet.create();
    private final Set<ResolvedJavaMethod> delayedInvocationPluginMethods = new HashSet<ResolvedJavaMethod>();
    private static final Map<Class<?>, SnippetResolvedJavaType> snippetTypes = new HashMap();

    void addDelayedInvocationPluginMethod(ResolvedJavaMethod method) {
        this.delayedInvocationPluginMethods.add(method);
    }

    public void clearSnippetParameterNames() {
        for (SnippetParameterInfo info : this.snippetParameterInfos.getValues()) {
            info.clearNames();
        }
    }

    SymbolicSnippetEncoder(HotSpotReplacementsImpl replacements) {
        this.originalReplacements = replacements;
    }

    synchronized void registerConditionalPlugin(InvocationPlugin plugin) {
        this.conditionalPlugins.add((Object)plugin);
    }

    private StructuredGraph buildGraph(ResolvedJavaMethod method, ResolvedJavaMethod original, Object receiver, BitSet nonNullParameters, boolean trackNodeSourcePosition, OptionValues options, ReplacementsImpl snippetReplacements) {
        assert (method.hasBytecodes()) : "Snippet must not be abstract or native";
        Object[] args = null;
        if (receiver != null) {
            args = new Object[method.getSignature().getParameterCount(true)];
            args[0] = receiver;
        }
        IntrinsicContext.CompilationContext contextToUse = IntrinsicContext.CompilationContext.INLINE_AFTER_PARSING;
        try (DebugContext debug = snippetReplacements.openDebugContext("LibGraalBuildGraph_", method, options);){
            StructuredGraph graph;
            try (DebugContext.Scope s = debug.scope((Object)"LibGraal", method);){
                graph = snippetReplacements.makeGraph(debug, snippetReplacements.getDefaultReplacementBytecodeProvider(), method, args, nonNullParameters, original, trackNodeSourcePosition, null, contextToUse);
                for (MethodCallTargetNode callTarget : graph.getNodes(MethodCallTargetNode.TYPE)) {
                    ResolvedJavaMethod callee = callTarget.targetMethod();
                    if (this.delayedInvocationPluginMethods.contains(callee) || Objects.equals(callee, original) || Objects.equals(callee, method)) continue;
                    throw GraalError.shouldNotReachHere("method " + callee.format("%H.%n") + " not inlined in snippet " + method.getName() + " (maybe not final?)");
                }
                debug.dump(3, graph, "After buildGraph");
            }
            catch (Throwable e) {
                throw debug.handle(e);
            }
            assert (this.verifySnippetEncodeDecode(debug, method, original, args, trackNodeSourcePosition, graph));
            SymbolicSnippetEncoder.verifyGraph(graph);
            StructuredGraph structuredGraph = graph;
            return structuredGraph;
        }
    }

    private static void verifyGraph(StructuredGraph graph) {
        GraalError.guarantee(graph.getAssumptions() == null, "Graph should not have assumptions: %s", (Object)graph);
        for (Node node : graph.getNodes()) {
            GraalError.guarantee(!(node instanceof CompressionNode), "Snippet graph should not contain CompressionNodes: %s, %s", (Object)graph, (Object)node);
            if (node instanceof ReadNode) {
                GraalError.guarantee(!(((ReadNode)node).stamp(NodeView.DEFAULT) instanceof AbstractObjectStamp), "Snippet graph should not contain a lowered ReadNode with an object stamp: %s, %s", (Object)graph, (Object)node);
            }
            if (!(node instanceof ValueNode)) continue;
            GraalError.guarantee(!(((ValueNode)node).stamp(NodeView.DEFAULT) instanceof NarrowOopStamp), "Snippet graph should not contain narrow oop stamps: %s, %s", (Object)graph, (Object)node);
        }
    }

    private static void checkIllegalSnippetObjects(Object o) {
        if (o instanceof HotSpotSignature || o instanceof ClassfileBytecode) {
            throw new GraalError("Illegal object in encoded snippet: " + o);
        }
    }

    private boolean verifySnippetEncodeDecode(DebugContext debug, ResolvedJavaMethod method, ResolvedJavaMethod original, Object[] args, boolean trackNodeSourcePosition, StructuredGraph graph) {
        CheckingGraphEncoder encoder = new CheckingGraphEncoder(HotSpotJVMCIRuntime.runtime().getHostJVMCIBackend().getTarget().arch);
        encoder.prepare(graph);
        encoder.finishPrepare();
        int startOffset = encoder.encode(graph);
        EncodedGraph encodedGraph = new EncodedGraph(encoder.getEncoding(), startOffset, encoder.getObjects(), encoder.getNodeClasses(), graph);
        HotSpotProviders originalProvider = this.originalReplacements.getProviders();
        SnippetReflectionProvider snippetReflection = originalProvider.getSnippetReflection();
        HotSpotSubstrateConstantReflectionProvider constantReflection = new HotSpotSubstrateConstantReflectionProvider(originalProvider.getConstantReflection());
        HotSpotProviders newProviders = new HotSpotProviders(originalProvider.getMetaAccess(), originalProvider.getCodeCache(), constantReflection, originalProvider.getConstantFieldProvider(), originalProvider.getForeignCalls(), originalProvider.getLowerer(), null, originalProvider.getSuites(), originalProvider.getRegisters(), snippetReflection, originalProvider.getWordTypes(), originalProvider.getStampProvider(), originalProvider.getPlatformConfigurationProvider(), originalProvider.getMetaAccessExtensionProvider(), originalProvider.getLoopsDataProvider(), originalProvider.getConfig());
        HotSpotSnippetReplacementsImpl filteringReplacements = new HotSpotSnippetReplacementsImpl(newProviders, snippetReflection, originalProvider.getReplacements().getDefaultReplacementBytecodeProvider(), originalProvider.getCodeCache().getTarget());
        filteringReplacements.setGraphBuilderPlugins(originalProvider.getReplacements().getGraphBuilderPlugins());
        try (DebugContext.Scope scope = debug.scope((Object)"VerifySnippetEncodeDecode", graph);){
            String decodedSnippetString;
            SnippetObjectFilter filter = new SnippetObjectFilter(originalProvider);
            for (int i = 0; i < encodedGraph.getNumObjects(); ++i) {
                filter.filterSnippetObject(debug, encodedGraph.getObject(i));
            }
            StructuredGraph snippet = filteringReplacements.makeGraph(debug, filteringReplacements.getDefaultReplacementBytecodeProvider(), method, args, null, original, trackNodeSourcePosition, null);
            EncodedSnippets.SymbolicEncodedGraph symbolicGraph = new EncodedSnippets.SymbolicEncodedGraph(encodedGraph, method.getDeclaringClass(), null);
            StructuredGraph decodedSnippet = EncodedSnippets.decodeSnippetGraph(symbolicGraph, original != null ? original : method, original, this.originalReplacements, null, StructuredGraph.AllowAssumptions.ifNonNull(graph.getAssumptions()), graph.getOptions(), false);
            String snippetString = SymbolicSnippetEncoder.getCanonicalGraphString(snippet, true, false);
            if (snippetString.equals(decodedSnippetString = SymbolicSnippetEncoder.getCanonicalGraphString(decodedSnippet, true, false))) {
                debug.log("Snippet decode for %s produces exactly same graph", method);
                debug.dump(3, (Object)decodedSnippet, "Decoded snippet graph for %s", method);
            } else {
                debug.log("Snippet decode for %s produces different graph", method);
                debug.log("%s", (Object)SymbolicSnippetEncoder.compareGraphStrings(snippet, snippetString, decodedSnippet, decodedSnippetString));
                debug.dump(3, (Object)snippet, "Snippet graph for %s", method);
                debug.dump(3, (Object)graph, "Encoded snippet graph for %s", method);
                debug.dump(3, (Object)decodedSnippet, "Decoded snippet graph for %s", method);
            }
        }
        catch (Throwable t) {
            throw debug.handle(t);
        }
        return true;
    }

    private synchronized EncodedSnippets encodeSnippets(OptionValues options) {
        GraphBuilderConfiguration.Plugins plugins = this.originalReplacements.getGraphBuilderPlugins();
        InvocationPlugins invocationPlugins = plugins.getInvocationPlugins();
        GraphBuilderConfiguration.Plugins copy = new GraphBuilderConfiguration.Plugins(plugins, invocationPlugins);
        HotSpotProviders providers = this.originalReplacements.getProviders().copyWith(new HotSpotSubstrateConstantReflectionProvider(this.originalReplacements.getProviders().getConstantReflection()));
        HotSpotSnippetReplacementsImpl snippetReplacements = new HotSpotSnippetReplacementsImpl(this.originalReplacements, providers.copyWith());
        snippetReplacements.setGraphBuilderPlugins(copy);
        copy.clearInlineInvokePlugins();
        copy.appendInlineInvokePlugin(new SnippetInlineInvokePlugin());
        copy.appendNodePlugin(new SnippetCounterPlugin(snippetReplacements));
        EconomicMap preparedSnippetGraphs = EconomicMap.create();
        MapCursor cursor = this.pendingSnippetGraphs.getEntries();
        while (cursor.advance()) {
            SnippetKey key = (SnippetKey)cursor.getKey();
            preparedSnippetGraphs.put((Object)key, (Object)((StructuredGraph)((BiFunction)cursor.getValue()).apply(options, snippetReplacements)));
        }
        DebugContext debug = snippetReplacements.openSnippetDebugContext("SnippetEncoder", null, options);
        try (DebugContext.Scope scope = debug.scope("SnippetSupportEncode");){
            for (StructuredGraph graph : preparedSnippetGraphs.getValues()) {
                for (Node node : graph.getNodes()) {
                    node.setNodeSourcePosition(null);
                }
            }
            EncodedSnippets encodedSnippets = this.encodeSnippets(debug, (EconomicMap<SnippetKey, StructuredGraph>)preparedSnippetGraphs);
            return encodedSnippets;
        }
    }

    synchronized void registerSnippet(final ResolvedJavaMethod method, final ResolvedJavaMethod original, final Object receiver, final boolean trackNodeSourcePosition) {
        if (HotSpotReplacementsImpl.snippetsAreEncoded()) {
            throw new GraalError("Snippet encoding has already been done");
        }
        assert (method.getAnnotation(Snippet.class) != null) : "Snippet must be annotated with @" + Snippet.class.getSimpleName();
        SnippetKey key = new SnippetKey(method, original, receiver);
        this.findSnippetMethod(method);
        if (!this.pendingSnippetGraphs.containsKey((Object)key)) {
            if (original != null) {
                this.originalMethods.put((Object)key.keyString(), (Object)EncodedSnippets.methodKey(original));
            }
            final SnippetParameterInfo info = new SnippetParameterInfo(method);
            this.snippetParameterInfos.put((Object)key.keyString(), (Object)info);
            int i = 0;
            int offset = 0;
            if (!method.isStatic()) {
                assert (info.isConstantParameter(0)) : "receiver is always constant";
                this.ensureSnippetTypeAvailable(method.getDeclaringClass());
                ++i;
                offset = 1;
            }
            while (i < info.getParameterCount()) {
                if (info.isConstantParameter(i) || info.isVarargsParameter(i)) {
                    JavaType type = method.getSignature().getParameterType(i - offset, method.getDeclaringClass());
                    if (type instanceof ResolvedJavaType) {
                        ResolvedJavaType resolvedJavaType = (ResolvedJavaType)type;
                        if (info.isVarargsParameter(i)) {
                            resolvedJavaType = resolvedJavaType.getElementalType();
                        }
                        assert (resolvedJavaType.isPrimitive() || HotSpotReplacementsImpl.isGraalClass(resolvedJavaType)) : method + ": only Graal classes can be @ConstantParameter or @VarargsParameter: " + type;
                        this.ensureSnippetTypeAvailable(resolvedJavaType);
                    } else {
                        throw new InternalError(type.toString());
                    }
                }
                ++i;
            }
            this.pendingSnippetGraphs.put((Object)key, (Object)new BiFunction<OptionValues, HotSpotSnippetReplacementsImpl, StructuredGraph>(){

                @Override
                public StructuredGraph apply(OptionValues cmopileOptions, HotSpotSnippetReplacementsImpl snippetReplacements) {
                    return SymbolicSnippetEncoder.this.buildGraph(method, original, receiver, SnippetParameterInfo.getNonNullParameters(info), trackNodeSourcePosition, cmopileOptions, snippetReplacements);
                }
            });
        }
    }

    ResolvedJavaMethod findSnippetMethod(ResolvedJavaMethod method) {
        ResolvedJavaType type = method.getDeclaringClass();
        JavaConstant mirror = this.originalReplacements.getProviders().getConstantReflection().asJavaClass(type);
        Class clazz = this.originalReplacements.getProviders().getSnippetReflection().asObject(Class.class, mirror);
        SnippetResolvedJavaType snippetType = SymbolicSnippetEncoder.lookupSnippetType(clazz);
        assert (snippetType != null);
        SnippetResolvedJavaMethod m = new SnippetResolvedJavaMethod(snippetType, method);
        return snippetType.add(m);
    }

    private void ensureSnippetTypeAvailable(ResolvedJavaType type) {
        if (!type.getElementalType().isPrimitive()) {
            Objects.requireNonNull(this.getSnippetType(type));
        }
    }

    private SnippetResolvedJavaType getSnippetType(ResolvedJavaType type) {
        SymbolicSnippetEncoder.lookupSnippetType(type.getClass());
        JavaConstant mirror = this.originalReplacements.getProviders().getConstantReflection().asJavaClass(type);
        Class clazz = this.originalReplacements.getProviders().getSnippetReflection().asObject(Class.class, mirror);
        return SymbolicSnippetEncoder.lookupSnippetType(clazz);
    }

    private boolean verifySingle(DebugContext debug, StructuredGraph graph) {
        DebugContext.Scope scope = debug.scope((Object)"FilterSingleSnippet", graph);
        try {
            EncodedGraph encodedGraph = GraphEncoder.encodeSingleGraph(graph, HotSpotJVMCIRuntime.runtime().getHostJVMCIBackend().getTarget().arch);
            SnippetObjectFilter filter = new SnippetObjectFilter(this.originalReplacements.getProviders());
            for (int i = 0; i < encodedGraph.getNumObjects(); ++i) {
                filter.filterSnippetObject(debug, encodedGraph.getObject(i));
            }
            boolean bl = true;
            if (scope != null) {
                scope.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (scope != null) {
                    try {
                        scope.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable t) {
                throw debug.handle(t);
            }
        }
    }

    private synchronized EncodedSnippets encodeSnippets(DebugContext debug, EconomicMap<SnippetKey, StructuredGraph> preparedSnippetGraphs) {
        GraphEncoder encoder = new GraphEncoder(HotSpotJVMCIRuntime.runtime().getHostJVMCIBackend().getTarget().arch, debug);
        for (StructuredGraph graph : preparedSnippetGraphs.getValues()) {
            graph.resetDebug(debug);
            assert (this.verifySingle(debug, graph));
            encoder.prepare(graph);
        }
        encoder.finishPrepare();
        EconomicMap graphDatas = EconomicMap.create();
        MapCursor cursor = preparedSnippetGraphs.getEntries();
        while (cursor.advance()) {
            SnippetKey key = (SnippetKey)cursor.getKey();
            String keyString = key.keyString();
            EncodedSnippets.GraphData previous = (EncodedSnippets.GraphData)graphDatas.get((Object)keyString);
            EncodedSnippets.GraphData data = EncodedSnippets.GraphData.create(encoder.encode((StructuredGraph)cursor.getValue()), (String)this.originalMethods.get((Object)keyString), (SnippetParameterInfo)this.snippetParameterInfos.get((Object)keyString), key.receiverClass(), previous);
            graphDatas.put((Object)keyString, (Object)data);
        }
        SymbolicSnippetEncoder.lookupSnippetType(GraalHotSpotVMConfig.class);
        SymbolicSnippetEncoder.lookupSnippetType(NamedLocationIdentity.class);
        SymbolicSnippetEncoder.lookupSnippetType(SnippetTemplate.EagerSnippetInfo.class);
        SymbolicSnippetEncoder.lookupSnippetType(ForeignCallStub.class);
        SnippetObjectFilter filter = new SnippetObjectFilter(this.originalReplacements.getProviders());
        byte[] snippetEncoding = encoder.getEncoding();
        Object[] snippetObjects = encoder.getObjects();
        for (int i = 0; i < snippetObjects.length; ++i) {
            Object o = filter.filterSnippetObject(debug, snippetObjects[i]);
            debug.log("snippetObjects[%d] = %s -> %s", (Object)i, (Object)(o != null ? o.getClass().getSimpleName() : null), o);
            snippetObjects[i] = o;
        }
        debug.log("Encoded %d snippet preparedSnippetGraphs using %d bytes with %d objects", graphDatas.size(), snippetEncoding.length, snippetObjects.length);
        return new EncodedSnippets(snippetEncoding, snippetObjects, encoder.getNodeClasses(), (UnmodifiableEconomicMap<String, EncodedSnippets.GraphData>)graphDatas, snippetTypes);
    }

    public synchronized boolean encode(OptionValues options) {
        EncodedSnippets encodedSnippets = this.encodeSnippets(options);
        if (encodedSnippets != null) {
            HotSpotReplacementsImpl.setEncodedSnippets(encodedSnippets);
            return true;
        }
        return false;
    }

    private static String compareGraphStrings(StructuredGraph expectedGraph, String expectedString, StructuredGraph actualGraph, String actualString) {
        if (!expectedString.equals(actualString)) {
            CharSequence[] expectedLines = expectedString.split("\n");
            CharSequence[] actualLines = actualString.split("\n");
            int diffIndex = -1;
            int limit = Math.min(actualLines.length, expectedLines.length);
            String marker = " <<<";
            for (int i = 0; i < limit; ++i) {
                if (expectedLines[i].equals(actualLines[i])) continue;
                diffIndex = i;
                break;
            }
            if (diffIndex == -1) {
                diffIndex = limit;
                if (actualLines.length == limit) {
                    actualLines = Arrays.copyOf(actualLines, limit + 1);
                    actualLines[diffIndex] = "";
                } else {
                    assert (expectedLines.length == limit);
                    expectedLines = Arrays.copyOf(expectedLines, limit + 1);
                    expectedLines[diffIndex] = "";
                }
            }
            expectedLines[diffIndex] = expectedLines[diffIndex] + marker;
            actualLines[diffIndex] = actualLines[diffIndex] + marker;
            String ediff = String.join((CharSequence)"\n", expectedLines);
            String adiff = String.join((CharSequence)"\n", actualLines);
            return "mismatch in preparedSnippetGraphs:\n========= expected (" + expectedGraph + ") =========\n" + ediff + "\n\n========= actual (" + actualGraph + ") =========\n" + adiff;
        }
        return "mismatch in preparedSnippetGraphs";
    }

    /*
     * WARNING - void declaration
     */
    private static String getCanonicalGraphString(StructuredGraph graph, boolean excludeVirtual, boolean checkConstants) {
        void var10_12;
        SchedulePhase.runWithoutContextOptimizations(graph, SchedulePhase.SchedulingStrategy.EARLIEST);
        StructuredGraph.ScheduleResult scheduleResult = graph.getLastSchedule();
        NodeMap<Integer> canonicalId = graph.createNodeMap();
        int nextId = 0;
        ArrayList<Object> constantsLines = new ArrayList<Object>();
        StringBuilder result = new StringBuilder();
        HIRBlock[] hIRBlockArray = scheduleResult.getCFG().getBlocks();
        int n = hIRBlockArray.length;
        boolean bl = false;
        while (var10_12 < n) {
            HIRBlock block = hIRBlockArray[var10_12];
            result.append("Block ").append(block).append(' ');
            if (block == scheduleResult.getCFG().getStartBlock()) {
                result.append("* ");
            }
            result.append("-> ");
            for (int i = 0; i < block.getSuccessorCount(); ++i) {
                HIRBlock succ = (HIRBlock)block.getSuccessorAt(i);
                result.append(succ).append(' ');
            }
            result.append('\n');
            for (Node node : scheduleResult.getBlockToNodesMap().get(block)) {
                int id;
                if (!(node instanceof ValueNode) || !node.isAlive() || excludeVirtual && (node instanceof VirtualObjectNode || node instanceof ProxyNode || node instanceof FullInfopointNode || node instanceof ParameterNode)) continue;
                if (node instanceof ConstantNode) {
                    if (!checkConstants) continue;
                    String name = node.toString(Verbosity.Name);
                    if (excludeVirtual) {
                        constantsLines.add(name);
                        continue;
                    }
                    constantsLines.add(name + "    (" + SymbolicSnippetEncoder.filteredUsageCount(node) + ")");
                    continue;
                }
                if (canonicalId.get(node) != null) {
                    id = (Integer)canonicalId.get(node);
                } else {
                    id = nextId++;
                    canonicalId.set(node, id);
                }
                String name = node.getClass().getSimpleName();
                result.append("  ").append(id).append('|').append(name);
                if (node instanceof AccessFieldNode) {
                    result.append('#');
                    result.append(((AccessFieldNode)node).field());
                }
                if (!excludeVirtual) {
                    result.append("    (");
                    result.append(SymbolicSnippetEncoder.filteredUsageCount(node));
                    result.append(')');
                }
                result.append('\n');
            }
            ++var10_12;
        }
        StringBuilder constantsLinesResult = new StringBuilder();
        if (checkConstants) {
            constantsLinesResult.append(constantsLines.size()).append(" constants:\n");
        }
        Collections.sort(constantsLines);
        for (String string : constantsLines) {
            constantsLinesResult.append(string);
            constantsLinesResult.append('\n');
        }
        return constantsLinesResult.toString() + result.toString();
    }

    private static int filteredUsageCount(Node node) {
        return node.usages().filter(n -> !(n instanceof FrameState)).count();
    }

    private static synchronized SnippetResolvedJavaType lookupSnippetType(Class<?> clazz) {
        SnippetResolvedJavaType type = null;
        if (HotSpotReplacementsImpl.isGraalClass(clazz) && (type = snippetTypes.get(clazz)) == null) {
            type = SymbolicSnippetEncoder.createType(clazz);
        }
        return type;
    }

    private static synchronized SnippetResolvedJavaType createType(Class<?> clazz) {
        SnippetResolvedJavaType type = new SnippetResolvedJavaType(clazz);
        snippetTypes.put(clazz, type);
        if (clazz.isArray()) {
            Class<?> arrayClass = clazz;
            SnippetResolvedJavaType arrayType = type;
            while (arrayClass.isArray()) {
                SnippetResolvedJavaType component = SymbolicSnippetEncoder.lookupSnippetType(arrayClass.getComponentType());
                component.setArrayOfType(arrayType);
                arrayClass = arrayClass.getComponentType();
                arrayType = component;
            }
        }
        return type;
    }

    public static MetaAccessProvider noticeTypes(MetaAccessProvider metaAccess) {
        return new MetaAccessProviderDelegate(metaAccess);
    }

    private static class CheckingGraphEncoder
    extends GraphEncoder {
        CheckingGraphEncoder(Architecture architecture) {
            super(architecture);
        }

        @Override
        protected void addObject(Object object) {
            SymbolicSnippetEncoder.checkIllegalSnippetObjects(object);
            super.addObject(object);
        }
    }

    static class HotSpotSubstrateConstantReflectionProvider
    implements ConstantReflectionProvider {
        private final ConstantReflectionProvider constantReflection;
        HashSet<JavaConstant> safeConstants = new HashSet();

        HotSpotSubstrateConstantReflectionProvider(ConstantReflectionProvider constantReflection) {
            this.constantReflection = constantReflection;
        }

        public Boolean constantEquals(Constant x, Constant y) {
            return this.constantReflection.constantEquals(x, y);
        }

        public Integer readArrayLength(JavaConstant array) {
            return this.constantReflection.readArrayLength(array);
        }

        public JavaConstant readArrayElement(JavaConstant array, int index) {
            return this.constantReflection.readArrayElement(array, index);
        }

        public JavaConstant readFieldValue(ResolvedJavaField field, JavaConstant receiver) {
            JavaConstant javaConstant = this.constantReflection.readFieldValue(field, receiver);
            String fieldClass = field.getDeclaringClass().getName();
            if (fieldClass.contains("java/util/EnumMap") || field.getType().getName().contains("java/util/EnumMap")) {
                throw new GraalError("Snippets should not use EnumMaps in generated code");
            }
            if (!(this.safeConstants.contains(receiver) || fieldClass.contains("graalvm") || fieldClass.contains("com/oracle/graal") || fieldClass.contains("jdk/vm/ci/") || fieldClass.contains("jdk/internal/vm/compiler") || field.getName().equals("TYPE"))) {
                return null;
            }
            if (javaConstant.getJavaKind() == JavaKind.Object) {
                this.safeConstants.add(javaConstant);
            }
            return javaConstant;
        }

        public JavaConstant boxPrimitive(JavaConstant source) {
            return this.constantReflection.boxPrimitive(source);
        }

        public JavaConstant unboxPrimitive(JavaConstant source) {
            return this.constantReflection.unboxPrimitive(source);
        }

        public JavaConstant forString(String value) {
            return this.constantReflection.forString(value);
        }

        public ResolvedJavaType asJavaType(Constant constant) {
            return this.constantReflection.asJavaType(constant);
        }

        public MethodHandleAccessProvider getMethodHandleAccess() {
            return this.constantReflection.getMethodHandleAccess();
        }

        public MemoryAccessProvider getMemoryAccessProvider() {
            return this.constantReflection.getMemoryAccessProvider();
        }

        public JavaConstant asJavaClass(ResolvedJavaType type) {
            return this.constantReflection.asJavaClass(type);
        }

        public Constant asObjectHub(ResolvedJavaType type) {
            return this.constantReflection.asObjectHub(type);
        }
    }

    class HotSpotSnippetReplacementsImpl
    extends HotSpotReplacementsImpl {
        HotSpotSnippetReplacementsImpl(HotSpotReplacementsImpl replacements, HotSpotProviders providers) {
            super(replacements, providers);
        }

        HotSpotSnippetReplacementsImpl(HotSpotProviders providers, SnippetReflectionProvider snippetReflection, BytecodeProvider bytecodeProvider, TargetDescription target) {
            super(providers, snippetReflection, bytecodeProvider, target);
        }

        @Override
        protected ReplacementsImpl.GraphMaker createGraphMaker(ResolvedJavaMethod substitute, ResolvedJavaMethod original) {
            return new SnippetGraphMaker(this, substitute, original);
        }
    }

    class SnippetObjectFilter {
        private final HotSpotWordTypes wordTypes;
        EconomicMap<Object, Object> cachedFilteredObjects = EconomicMap.create();

        SnippetObjectFilter(HotSpotProviders providers) {
            this.wordTypes = providers.getWordTypes();
        }

        SnippetReflectionProvider getSnippetReflection() {
            return SymbolicSnippetEncoder.this.originalReplacements.getProviders().getSnippetReflection();
        }

        private Object filterSnippetObject(DebugContext debug, Object o) {
            SymbolicSnippetEncoder.checkIllegalSnippetObjects(o);
            Object cached = this.cachedFilteredObjects.get((Object)0);
            if (cached != null) {
                return cached;
            }
            if (o instanceof HotSpotResolvedJavaMethod) {
                HotSpotResolvedJavaMethod method = (HotSpotResolvedJavaMethod)o;
                if (HotSpotReplacementsImpl.isGraalClass((ResolvedJavaType)method.getDeclaringClass())) {
                    ResolvedJavaMethod snippetMethod = SymbolicSnippetEncoder.this.findSnippetMethod((ResolvedJavaMethod)method);
                    this.cachedFilteredObjects.put((Object)method, (Object)snippetMethod);
                    return snippetMethod;
                }
                return this.filterMethod(debug, (ResolvedJavaMethod)method);
            }
            if (o instanceof HotSpotResolvedJavaField) {
                return this.filterField(debug, (HotSpotResolvedJavaField)o);
            }
            if (o instanceof HotSpotResolvedJavaType) {
                return this.filterType(debug, (ResolvedJavaType)((HotSpotResolvedJavaType)o));
            }
            if (o instanceof FieldLocationIdentity) {
                FieldLocationIdentity fli = (FieldLocationIdentity)((Object)o);
                if (fli.getField() instanceof HotSpotResolvedJavaField) {
                    return this.filterFieldLocationIdentity(debug, (HotSpotResolvedJavaField)fli.getField());
                }
                return o;
            }
            if (o instanceof HotSpotObjectConstant) {
                return new SnippetObjectConstant(this.getSnippetReflection().asObject(Object.class, (JavaConstant)((HotSpotObjectConstant)o)));
            }
            if (o instanceof NodeSourcePosition) {
                return null;
            }
            if (o instanceof HotSpotForeignCallsProvider || o instanceof GraalHotSpotVMConfig || o instanceof HotSpotWordTypes || o instanceof TargetDescription || o instanceof SnippetReflectionProvider) {
                return new EncodedSnippets.GraalCapability(o.getClass());
            }
            if (o instanceof Stamp) {
                return this.filterStamp(debug, (Stamp)o);
            }
            if (o instanceof StampPair) {
                return this.filterStampPair(debug, (StampPair)o);
            }
            if (o instanceof ResolvedJavaMethodBytecode) {
                return this.filterBytecode(debug, (ResolvedJavaMethodBytecode)o);
            }
            return o;
        }

        private EncodedSnippets.SymbolicResolvedJavaMethod filterMethod(DebugContext debug, ResolvedJavaMethod method) {
            EncodedSnippets.SymbolicResolvedJavaMethod symbolic = (EncodedSnippets.SymbolicResolvedJavaMethod)this.cachedFilteredObjects.get((Object)method);
            if (symbolic != null) {
                return symbolic;
            }
            if (HotSpotReplacementsImpl.isGraalClass(method.getDeclaringClass())) {
                throw new GraalError("Graal methods shouldn't leak into image: " + method);
            }
            UnresolvedJavaType type = (UnresolvedJavaType)this.filterType(debug, method.getDeclaringClass());
            String methodName = method.getName();
            String signature = method.getSignature().toMethodDescriptor();
            symbolic = new EncodedSnippets.SymbolicResolvedJavaMethod(type, methodName, signature);
            debug.log(3, "filtered %s -> %s", (Object)method, (Object)symbolic);
            this.cachedFilteredObjects.put((Object)method, (Object)symbolic);
            return symbolic;
        }

        private EncodedSnippets.SymbolicResolvedJavaMethodBytecode filterBytecode(DebugContext debug, ResolvedJavaMethodBytecode bytecode) {
            EncodedSnippets.SymbolicResolvedJavaMethodBytecode symbolic = (EncodedSnippets.SymbolicResolvedJavaMethodBytecode)this.cachedFilteredObjects.get((Object)bytecode);
            if (symbolic != null) {
                return symbolic;
            }
            symbolic = new EncodedSnippets.SymbolicResolvedJavaMethodBytecode(this.filterMethod(debug, bytecode.getMethod()));
            debug.log(3, "filtered %s -> %s", (Object)bytecode, (Object)symbolic);
            this.cachedFilteredObjects.put((Object)bytecode, (Object)this.filterMethod(debug, bytecode.getMethod()));
            return symbolic;
        }

        private JavaType filterType(DebugContext debug, ResolvedJavaType type) {
            UnresolvedJavaType unresolvedJavaType = (UnresolvedJavaType)this.cachedFilteredObjects.get((Object)type);
            if (unresolvedJavaType != null) {
                return unresolvedJavaType;
            }
            if (HotSpotReplacementsImpl.isGraalClass(type)) {
                throw new GraalError("Graal types shouldn't leak into image: " + type);
            }
            unresolvedJavaType = UnresolvedJavaType.create((String)type.getName());
            debug.log(3, "filtered %s -> %s", (Object)type, (Object)unresolvedJavaType);
            this.cachedFilteredObjects.put((Object)type, (Object)unresolvedJavaType);
            return unresolvedJavaType;
        }

        private Object filterFieldLocationIdentity(DebugContext debug, HotSpotResolvedJavaField field) {
            return new EncodedSnippets.SymbolicResolvedJavaFieldLocationIdentity((EncodedSnippets.SymbolicResolvedJavaField)this.filterField(debug, field));
        }

        private Object filterField(DebugContext debug, HotSpotResolvedJavaField field) {
            if (!field.getDeclaringClass().getName().startsWith("Ljava/lang/")) {
                throw new InternalError("All other fields must have been resolved: " + field);
            }
            UnresolvedJavaType declaringType = (UnresolvedJavaType)this.filterType(debug, field.getDeclaringClass());
            String name = field.getName();
            UnresolvedJavaType signature = (UnresolvedJavaType)this.filterType(debug, (ResolvedJavaType)field.getType());
            boolean isStatic = field.isStatic();
            return new EncodedSnippets.SymbolicResolvedJavaField(declaringType, name, signature, isStatic);
        }

        private Object filterStampPair(DebugContext debug, StampPair stampPair) {
            if (stampPair.getTrustedStamp() instanceof AbstractObjectStamp) {
                Object cached = this.cachedFilteredObjects.get((Object)stampPair);
                if (cached != null) {
                    return cached;
                }
                Object trustedStamp = this.filterStamp(debug, stampPair.getTrustedStamp());
                Object uncheckdStamp = this.filterStamp(debug, stampPair.getUncheckedStamp());
                cached = trustedStamp instanceof ObjectStamp && uncheckdStamp instanceof ObjectStamp ? StampPair.create((Stamp)trustedStamp, (Stamp)uncheckdStamp) : new EncodedSnippets.SymbolicStampPair(trustedStamp, uncheckdStamp);
                debug.log(3, "filtered %s -> %s", (Object)stampPair, cached);
                this.cachedFilteredObjects.put((Object)stampPair, cached);
                return cached;
            }
            return stampPair;
        }

        private Object filterStamp(DebugContext debug, Stamp stamp) {
            if (stamp == null) {
                return null;
            }
            SymbolicJVMCIReference<? extends Stamp> cached = this.cachedFilteredObjects.get((Object)stamp);
            if (cached != null) {
                return cached;
            }
            if (stamp instanceof AbstractObjectStamp) {
                AbstractObjectStamp objectStamp = (AbstractObjectStamp)stamp;
                ResolvedJavaType type = objectStamp.type();
                if (type == null) {
                    return stamp;
                }
                if (this.wordTypes.isWord((JavaType)type)) {
                    throw new InternalError("should have converted Word types by now");
                }
                if (type instanceof SnippetResolvedJavaType) {
                    throw new InternalError(stamp.toString());
                }
                ResolvedJavaType elementalType = type.getElementalType();
                if (elementalType.getName().startsWith("Ljdk/vm/ci") || elementalType.getName().startsWith("Lorg/graalvm/") || elementalType.getName().startsWith("Lcom/oracle/graal/")) {
                    if (!type.equals(elementalType)) {
                        SymbolicSnippetEncoder.this.ensureSnippetTypeAvailable(elementalType);
                    }
                    type = SymbolicSnippetEncoder.this.getSnippetType(type);
                    assert (type != null) : type;
                    cached = new ObjectStamp(type, objectStamp.isExactType(), objectStamp.nonNull(), objectStamp.alwaysNull(), objectStamp.isAlwaysArray());
                } else {
                    cached = stamp.makeSymbolic();
                }
                debug.log(3, "filtered %s -> %s", (Object)stamp, cached);
                this.cachedFilteredObjects.put((Object)stamp, cached);
                return cached;
            }
            cached = stamp.makeSymbolic();
            if (cached != null) {
                this.cachedFilteredObjects.put((Object)stamp, cached);
                return cached;
            }
            return stamp;
        }
    }

    protected class SnippetInlineInvokePlugin
    implements InlineInvokePlugin {
        protected SnippetInlineInvokePlugin() {
        }

        @Override
        public InlineInvokePlugin.InlineInfo shouldInlineInvoke(GraphBuilderContext b, ResolvedJavaMethod method, ValueNode[] args) {
            if (method.getAnnotation(Fold.class) != null) {
                SymbolicSnippetEncoder.this.delayedInvocationPluginMethods.add(method);
                return InlineInvokePlugin.InlineInfo.DO_NOT_INLINE_NO_EXCEPTION;
            }
            return InlineInvokePlugin.InlineInfo.createIntrinsicInlineInfo(method, SymbolicSnippetEncoder.this.originalReplacements.getDefaultReplacementBytecodeProvider());
        }

        @Override
        public void notifyAfterInline(ResolvedJavaMethod methodToInline) {
            assert (methodToInline.getAnnotation(Fold.class) == null) : methodToInline;
        }
    }

    static final class SnippetCounterPlugin
    implements NodePlugin {
        String snippetCounterName = "L" + SnippetCounter.class.getName().replace('.', '/') + ";";
        String snippetIntegerHistogramName = "L" + SnippetIntegerHistogram.class.getName().replace('.', '/') + ";";
        private final ReplacementsImpl snippetReplacements;

        private SnippetCounterPlugin(ReplacementsImpl snippetReplacements) {
            this.snippetReplacements = snippetReplacements;
        }

        @Override
        public boolean handleLoadField(GraphBuilderContext b, ValueNode object, ResolvedJavaField field) {
            if (field.getName().equals("group") && field.getDeclaringClass().getName().equals(this.snippetCounterName)) {
                b.addPush(JavaKind.Object, ConstantNode.forConstant(JavaConstant.NULL_POINTER, b.getMetaAccess()));
                return true;
            }
            if (field.getType().getName().equals(this.snippetCounterName)) {
                b.addPush(JavaKind.Object, ConstantNode.forConstant(this.snippetReplacements.snippetReflection.forObject(SnippetCounter.DISABLED_COUNTER), b.getMetaAccess()));
                return true;
            }
            if (field.getType().getName().equals(this.snippetIntegerHistogramName)) {
                b.addPush(JavaKind.Object, ConstantNode.forConstant(this.snippetReplacements.snippetReflection.forObject(SnippetIntegerHistogram.DISABLED_COUNTER), b.getMetaAccess()));
                return true;
            }
            return false;
        }
    }

    static class SnippetKey {
        final ResolvedJavaMethod method;
        final ResolvedJavaMethod original;
        private final Class<?> receiverClass;

        SnippetKey(ResolvedJavaMethod method, ResolvedJavaMethod original, Object receiver) {
            this.method = method;
            this.original = original;
            assert (method.isStatic() == (receiver == null)) : "static must not have receiver and non-static must";
            this.receiverClass = receiver != null ? receiver.getClass() : null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SnippetKey that = (SnippetKey)o;
            return Objects.equals(this.method, that.method) && Objects.equals(this.original, that.original) && Objects.equals(this.receiverClass, that.receiverClass);
        }

        public int hashCode() {
            return Objects.hash(this.method, this.original, this.receiverClass);
        }

        public String keyString() {
            return EncodedSnippets.methodKey(this.method);
        }

        public Class<?> receiverClass() {
            return this.receiverClass;
        }

        public String toString() {
            return "SnippetKey{method=" + this.method + ", original=" + this.original + ", receiverClass=" + this.receiverClass + "}";
        }
    }

    private static class MetaAccessProviderDelegate
    implements MetaAccessProvider {
        MetaAccessProvider delegate;

        MetaAccessProviderDelegate(MetaAccessProvider metaAccess) {
            this.delegate = metaAccess;
        }

        public ResolvedJavaType lookupJavaType(Class<?> clazz) {
            SymbolicSnippetEncoder.lookupSnippetType(clazz);
            return this.delegate.lookupJavaType(clazz);
        }

        public ResolvedJavaMethod lookupJavaMethod(Executable reflectionMethod) {
            return this.delegate.lookupJavaMethod(reflectionMethod);
        }

        public ResolvedJavaField lookupJavaField(Field reflectionField) {
            return this.delegate.lookupJavaField(reflectionField);
        }

        public ResolvedJavaType lookupJavaType(JavaConstant constant) {
            return this.delegate.lookupJavaType(constant);
        }

        public long getMemorySize(JavaConstant constant) {
            return this.delegate.getMemorySize(constant);
        }

        public Signature parseMethodDescriptor(String methodDescriptor) {
            return this.delegate.parseMethodDescriptor(methodDescriptor);
        }

        public JavaConstant encodeDeoptActionAndReason(DeoptimizationAction action, DeoptimizationReason reason, int debugId) {
            return this.delegate.encodeDeoptActionAndReason(action, reason, debugId);
        }

        public JavaConstant encodeSpeculation(SpeculationLog.Speculation speculation) {
            return this.delegate.encodeSpeculation(speculation);
        }

        public SpeculationLog.Speculation decodeSpeculation(JavaConstant constant, SpeculationLog speculationLog) {
            return this.delegate.decodeSpeculation(constant, speculationLog);
        }

        public DeoptimizationReason decodeDeoptReason(JavaConstant constant) {
            return this.delegate.decodeDeoptReason(constant);
        }

        public DeoptimizationAction decodeDeoptAction(JavaConstant constant) {
            return this.delegate.decodeDeoptAction(constant);
        }

        public int decodeDebugId(JavaConstant constant) {
            return this.delegate.decodeDebugId(constant);
        }

        public int getArrayBaseOffset(JavaKind elementKind) {
            return this.delegate.getArrayBaseOffset(elementKind);
        }

        public int getArrayIndexScale(JavaKind elementKind) {
            return this.delegate.getArrayIndexScale(elementKind);
        }
    }

    class HotSpotSnippetBytecodeParser
    extends BytecodeParser {
        HotSpotSnippetBytecodeParser(GraphBuilderPhase.Instance graphBuilderInstance, StructuredGraph graph, BytecodeParser parent, ResolvedJavaMethod method, int entryBCI, IntrinsicContext intrinsicContext) {
            super(graphBuilderInstance, graph, parent, method, entryBCI, intrinsicContext);
        }

        @Override
        public boolean canDeferPlugin(GeneratedInvocationPlugin plugin) {
            return plugin.isGeneratedFromFoldOrNodeIntrinsic();
        }

        @Override
        public boolean shouldDeferPlugin(GeneratedInvocationPlugin plugin) {
            return plugin.isGeneratedFromFoldOrNodeIntrinsic();
        }

        @Override
        protected boolean canInlinePartialIntrinsicExit() {
            return false;
        }

        @Override
        protected boolean tryInvocationPlugin(CallTargetNode.InvokeKind invokeKind, ValueNode[] args, ResolvedJavaMethod targetMethod, JavaKind resultType) {
            if (this.intrinsicContext != null && this.intrinsicContext.isCallToOriginal(targetMethod)) {
                return false;
            }
            InvocationPlugin plugin = this.graphBuilderConfig.getPlugins().getInvocationPlugins().lookupInvocation(targetMethod, this.options);
            if (plugin != null && SymbolicSnippetEncoder.this.conditionalPlugins.contains((Object)plugin)) {
                throw new GraalError("conditional plugins are unsupported in snippets and method substitutions: " + targetMethod + " " + plugin);
            }
            return super.tryInvocationPlugin(invokeKind, args, targetMethod, resultType);
        }
    }

    class HotSpotSnippetGraphBuilderPhase
    extends GraphBuilderPhase.Instance {
        HotSpotSnippetGraphBuilderPhase(CoreProviders theProviders, GraphBuilderConfiguration graphBuilderConfig, OptimisticOptimizations optimisticOpts, IntrinsicContext initialIntrinsicContext) {
            super(theProviders, graphBuilderConfig, optimisticOpts, initialIntrinsicContext);
        }

        @Override
        protected BytecodeParser createBytecodeParser(StructuredGraph graph, BytecodeParser parent, ResolvedJavaMethod method, int entryBCI, IntrinsicContext intrinsicContext) {
            return new HotSpotSnippetBytecodeParser(this, graph, parent, method, entryBCI, intrinsicContext);
        }
    }

    class SnippetGraphMaker
    extends ReplacementsImpl.GraphMaker {
        SnippetGraphMaker(ReplacementsImpl replacements, ResolvedJavaMethod substitute, ResolvedJavaMethod substitutedMethod) {
            super(replacements, substitute, substitutedMethod);
        }

        @Override
        protected GraphBuilderPhase.Instance createGraphBuilder(Providers providers, GraphBuilderConfiguration graphBuilderConfig, OptimisticOptimizations optimisticOpts, IntrinsicContext initialIntrinsicContext) {
            return new HotSpotSnippetGraphBuilderPhase(providers, graphBuilderConfig, optimisticOpts, initialIntrinsicContext);
        }

        @Override
        protected void finalizeGraph(StructuredGraph graph) {
            if (this.substitutedMethod != null) {
                for (MethodCallTargetNode target : graph.getNodes(MethodCallTargetNode.TYPE)) {
                    if (!this.substitutedMethod.equals(target.targetMethod())) continue;
                    PartialIntrinsicCallTargetNode partial = graph.add(new PartialIntrinsicCallTargetNode(target.invokeKind(), this.substitutedMethod, target.returnStamp(), target.arguments().toArray((A[])ValueNode.EMPTY_ARRAY)));
                    target.replaceAndDelete(partial);
                }
            }
            super.finalizeGraph(graph);
        }
    }
}

