/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.amd64;

import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethod;
import jdk.vm.ci.meta.InvokeTarget;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotMarkId;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.amd64.AMD64Call;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.nodes.CallTargetNode;

@Opcode(value="CALL_DIRECT")
final class AMD64HotSpotDirectStaticCallOp
extends AMD64Call.DirectCallOp {
    public static final LIRInstructionClass<AMD64HotSpotDirectStaticCallOp> TYPE = LIRInstructionClass.create(AMD64HotSpotDirectStaticCallOp.class);
    private final CallTargetNode.InvokeKind invokeKind;
    private final GraalHotSpotVMConfig config;

    AMD64HotSpotDirectStaticCallOp(ResolvedJavaMethod target, Value result, Value[] parameters, Value[] temps, LIRFrameState state, CallTargetNode.InvokeKind invokeKind, GraalHotSpotVMConfig config) {
        super((LIRInstructionClass<? extends AMD64Call.DirectCallOp>)TYPE, target, result, parameters, temps, state);
        assert (invokeKind.isDirect());
        this.invokeKind = invokeKind;
        this.config = config;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        if (this.config.supportsMethodHandleDeoptimizationEntry() && this.config.isMethodHandleCall((HotSpotResolvedJavaMethod)this.callTarget) && this.invokeKind != CallTargetNode.InvokeKind.Static) {
            crb.setNeedsMHDeoptHandler();
        }
        crb.recordMark(AMD64Call.directCall(crb, masm, (InvokeTarget)this.callTarget, null, true, this.state), this.invokeKind == CallTargetNode.InvokeKind.Static ? HotSpotMarkId.INVOKESTATIC : HotSpotMarkId.INVOKESPECIAL);
    }
}

