/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.amd64;

import java.util.ArrayList;
import java.util.BitSet;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterArray;
import jdk.vm.ci.code.RegisterConfig;
import org.graalvm.compiler.core.common.alloc.RegisterAllocationConfig;

class AMD64HotSpotRegisterAllocationConfig
extends RegisterAllocationConfig {
    static final Register[] registerAllocationOrder = new Register[]{AMD64.r10, AMD64.r11, AMD64.r8, AMD64.r9, AMD64.r12, AMD64.rcx, AMD64.rbx, AMD64.rdi, AMD64.rdx, AMD64.rsi, AMD64.rax, AMD64.rbp, AMD64.r13, AMD64.r14, AMD64.xmm0, AMD64.xmm1, AMD64.xmm2, AMD64.xmm3, AMD64.xmm4, AMD64.xmm5, AMD64.xmm6, AMD64.xmm7, AMD64.xmm8, AMD64.xmm9, AMD64.xmm10, AMD64.xmm11, AMD64.xmm12, AMD64.xmm13, AMD64.xmm14, AMD64.xmm15, AMD64.k1, AMD64.k2, AMD64.k3, AMD64.k4, AMD64.k5, AMD64.k6, AMD64.k7};
    private final boolean preserveFramePointer;

    AMD64HotSpotRegisterAllocationConfig(RegisterConfig registerConfig, String[] allocationRestrictedTo, boolean preserveFramePointer) {
        super(registerConfig, allocationRestrictedTo);
        this.preserveFramePointer = preserveFramePointer;
    }

    @Override
    protected RegisterArray initAllocatable(RegisterArray registers) {
        BitSet regMap = new BitSet(this.registerConfig.getAllocatableRegisters().size());
        for (Register reg : registers) {
            regMap.set(reg.number);
        }
        if (this.preserveFramePointer) {
            regMap.clear(AMD64.rbp.number);
        }
        ArrayList<Register> allocatableRegisters = new ArrayList<Register>(registers.size());
        for (Register reg : registerAllocationOrder) {
            if (!regMap.get(reg.number)) continue;
            allocatableRegisters.add(reg);
        }
        return super.initAllocatable(new RegisterArray(allocatableRegisters));
    }
}

