/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.meta;

import java.lang.annotation.Annotation;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MutableCallSite;
import java.lang.invoke.VolatileCallSite;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.zip.CRC32;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.hotspot.VMIntrinsicMethod;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.UnresolvedJavaType;
import jdk.vm.ci.services.Services;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.calc.Condition;
import org.graalvm.compiler.core.common.memory.BarrierType;
import org.graalvm.compiler.core.common.memory.MemoryOrderMode;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotBackend;
import org.graalvm.compiler.hotspot.HotSpotGraalRuntimeProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotExceptionDispatchPlugin;
import org.graalvm.compiler.hotspot.meta.HotSpotHostForeignCallsProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotInvocationPluginProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotInvocationPlugins;
import org.graalvm.compiler.hotspot.meta.HotSpotJITClassInitializationPlugin;
import org.graalvm.compiler.hotspot.meta.HotSpotNodePlugin;
import org.graalvm.compiler.hotspot.meta.HotSpotWordOperationPlugin;
import org.graalvm.compiler.hotspot.nodes.CurrentJavaThreadNode;
import org.graalvm.compiler.hotspot.nodes.HotSpotLoadReservedReferenceNode;
import org.graalvm.compiler.hotspot.nodes.HotSpotStoreReservedReferenceNode;
import org.graalvm.compiler.hotspot.replacements.CallSiteTargetNode;
import org.graalvm.compiler.hotspot.replacements.DigestBaseSnippets;
import org.graalvm.compiler.hotspot.replacements.FastNotifyNode;
import org.graalvm.compiler.hotspot.replacements.HotSpotIdentityHashCodeNode;
import org.graalvm.compiler.hotspot.replacements.HotSpotInvocationPluginHelper;
import org.graalvm.compiler.hotspot.replacements.HotSpotReflectionGetCallerClassNode;
import org.graalvm.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import org.graalvm.compiler.hotspot.replacements.HubGetClassNode;
import org.graalvm.compiler.hotspot.replacements.ObjectCloneNode;
import org.graalvm.compiler.hotspot.replacements.UnsafeCopyMemoryNode;
import org.graalvm.compiler.hotspot.word.HotSpotWordTypes;
import org.graalvm.compiler.java.BytecodeParser;
import org.graalvm.compiler.java.BytecodeParserOptions;
import org.graalvm.compiler.lir.SyncPort;
import org.graalvm.compiler.nodes.BeginNode;
import org.graalvm.compiler.nodes.ComputeObjectAddressNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.EndNode;
import org.graalvm.compiler.nodes.FieldLocationIdentity;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.MergeNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.ProfileData;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValuePhiNode;
import org.graalvm.compiler.nodes.calc.AddNode;
import org.graalvm.compiler.nodes.calc.AndNode;
import org.graalvm.compiler.nodes.calc.ConditionalNode;
import org.graalvm.compiler.nodes.calc.IntegerEqualsNode;
import org.graalvm.compiler.nodes.calc.IntegerTestNode;
import org.graalvm.compiler.nodes.calc.IsNullNode;
import org.graalvm.compiler.nodes.calc.LeftShiftNode;
import org.graalvm.compiler.nodes.calc.ObjectEqualsNode;
import org.graalvm.compiler.nodes.calc.SignExtendNode;
import org.graalvm.compiler.nodes.calc.SubNode;
import org.graalvm.compiler.nodes.calc.UnsignedRightShiftNode;
import org.graalvm.compiler.nodes.calc.XorNode;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.nodes.extended.JavaReadNode;
import org.graalvm.compiler.nodes.extended.JavaWriteNode;
import org.graalvm.compiler.nodes.extended.LoadHubNode;
import org.graalvm.compiler.nodes.extended.ObjectIsArrayNode;
import org.graalvm.compiler.nodes.gc.BarrierSet;
import org.graalvm.compiler.nodes.graphbuilderconf.ForeignCallPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.GeneratedPluginFactory;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.java.ArrayLengthNode;
import org.graalvm.compiler.nodes.java.DynamicNewArrayNode;
import org.graalvm.compiler.nodes.java.DynamicNewInstanceNode;
import org.graalvm.compiler.nodes.java.NewArrayNode;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.memory.address.OffsetAddressNode;
import org.graalvm.compiler.nodes.spi.Replacements;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.tiers.CompilerConfiguration;
import org.graalvm.compiler.replacements.InlineDuringParsingPlugin;
import org.graalvm.compiler.replacements.IntrinsicGraphBuilder;
import org.graalvm.compiler.replacements.InvocationPluginHelper;
import org.graalvm.compiler.replacements.MethodHandlePlugin;
import org.graalvm.compiler.replacements.NodeIntrinsificationProvider;
import org.graalvm.compiler.replacements.ReplacementsImpl;
import org.graalvm.compiler.replacements.SnippetSubstitutionInvocationPlugin;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.StandardGraphBuilderPlugins;
import org.graalvm.compiler.replacements.arraycopy.ArrayCopyCallNode;
import org.graalvm.compiler.replacements.arraycopy.ArrayCopyForeignCalls;
import org.graalvm.compiler.replacements.arraycopy.ArrayCopySnippets;
import org.graalvm.compiler.replacements.nodes.AESNode;
import org.graalvm.compiler.replacements.nodes.CipherBlockChainingAESNode;
import org.graalvm.compiler.replacements.nodes.CounterModeAESNode;
import org.graalvm.compiler.replacements.nodes.MacroNode;
import org.graalvm.compiler.replacements.nodes.VectorizedMismatchNode;
import org.graalvm.compiler.serviceprovider.GraalServices;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.compiler.word.WordTypes;
import org.graalvm.word.LocationIdentity;

public class HotSpotGraphBuilderPlugins {
    public static GraphBuilderConfiguration.Plugins create(final HotSpotGraalRuntimeProvider graalRuntime, CompilerConfiguration compilerConfiguration, final GraalHotSpotVMConfig config, final HotSpotWordTypes wordTypes, final MetaAccessProvider metaAccess, ConstantReflectionProvider constantReflection, final SnippetReflectionProvider snippetReflection, final HotSpotHostForeignCallsProvider foreignCalls, final ReplacementsImpl replacements, OptionValues options, final TargetDescription target, BarrierSet barrierSet) {
        final HotSpotInvocationPlugins invocationPlugins = new HotSpotInvocationPlugins(graalRuntime, config, compilerConfiguration, target, options);
        final GraphBuilderConfiguration.Plugins plugins = new GraphBuilderConfiguration.Plugins(invocationPlugins);
        plugins.appendNodePlugin(new HotSpotExceptionDispatchPlugin(config, wordTypes.getWordKind()));
        StandardGraphBuilderPlugins.registerConstantFieldLoadPlugin(plugins);
        if (!Services.IS_IN_NATIVE_IMAGE) {
            HotSpotWordOperationPlugin wordOperationPlugin = new HotSpotWordOperationPlugin(snippetReflection, constantReflection, wordTypes, barrierSet);
            HotSpotNodePlugin nodePlugin = new HotSpotNodePlugin(wordOperationPlugin);
            plugins.appendTypePlugin(nodePlugin);
            plugins.appendNodePlugin(nodePlugin);
        }
        plugins.appendNodePlugin(new MethodHandlePlugin(constantReflection.getMethodHandleAccess(), !config.supportsMethodHandleDeoptimizationEntry()));
        plugins.appendInlineInvokePlugin(replacements);
        if (BytecodeParserOptions.InlineDuringParsing.getValue(options).booleanValue()) {
            plugins.appendInlineInvokePlugin(new InlineDuringParsingPlugin());
        }
        if (config.instanceKlassInitThreadOffset != -1) {
            plugins.setClassInitializationPlugin(new HotSpotJITClassInitializationPlugin());
        }
        compilerConfiguration.registerGraphBuilderPlugins(target.arch, plugins, options, replacements);
        invocationPlugins.defer(new Runnable(){

            @Override
            public void run() {
                HotSpotGraphBuilderPlugins.registerObjectPlugins(invocationPlugins, config, replacements);
                HotSpotGraphBuilderPlugins.registerClassPlugins(plugins, config, replacements);
                HotSpotGraphBuilderPlugins.registerSystemPlugins(invocationPlugins);
                HotSpotGraphBuilderPlugins.registerThreadPlugins(invocationPlugins, config, replacements);
                HotSpotGraphBuilderPlugins.registerVirtualThreadPlugins(invocationPlugins, config, replacements);
                HotSpotGraphBuilderPlugins.registerCallSitePlugins(invocationPlugins);
                HotSpotGraphBuilderPlugins.registerReflectionPlugins(invocationPlugins, replacements, config);
                HotSpotGraphBuilderPlugins.registerAESPlugins(invocationPlugins, config, replacements, target.arch);
                HotSpotGraphBuilderPlugins.registerAdler32Plugins(invocationPlugins, config, replacements);
                HotSpotGraphBuilderPlugins.registerCRC32Plugins(invocationPlugins, config, replacements);
                HotSpotGraphBuilderPlugins.registerCRC32CPlugins(invocationPlugins, config, replacements);
                HotSpotGraphBuilderPlugins.registerBigIntegerPlugins(invocationPlugins, config, replacements);
                HotSpotGraphBuilderPlugins.registerSHAPlugins(invocationPlugins, config, replacements);
                HotSpotGraphBuilderPlugins.registerBase64Plugins(invocationPlugins, config, metaAccess, replacements);
                HotSpotGraphBuilderPlugins.registerUnsafePlugins(invocationPlugins, config, replacements);
                StandardGraphBuilderPlugins.registerInvocationPlugins(snippetReflection, invocationPlugins, replacements, true, false, true, graalRuntime.getHostProviders().getLowerer());
                HotSpotGraphBuilderPlugins.registerArrayPlugins(invocationPlugins, replacements, config);
                HotSpotGraphBuilderPlugins.registerStringPlugins(invocationPlugins, replacements, wordTypes, foreignCalls, config);
                HotSpotGraphBuilderPlugins.registerArraysSupportPlugins(invocationPlugins, replacements);
                HotSpotGraphBuilderPlugins.registerReferencePlugins(invocationPlugins, replacements);
                HotSpotGraphBuilderPlugins.registerTrufflePlugins(invocationPlugins, wordTypes, config);
                HotSpotGraphBuilderPlugins.registerInstrumentationImplPlugins(invocationPlugins, config, replacements);
                for (HotSpotInvocationPluginProvider p : GraalServices.load(HotSpotInvocationPluginProvider.class)) {
                    p.registerInvocationPlugins(target.arch, plugins.getInvocationPlugins(), replacements);
                }
                HotSpotGraphBuilderPlugins.registerPoly1305Plugins(invocationPlugins, config, replacements);
                HotSpotGraphBuilderPlugins.registerChaCha20Plugins(invocationPlugins, config, replacements);
            }
        });
        if (!Services.IS_IN_NATIVE_IMAGE) {
            NodeIntrinsificationProvider nodeIntrinsificationProvider = new NodeIntrinsificationProvider(metaAccess, snippetReflection, foreignCalls, wordTypes, target);
            invocationPlugins.defer(() -> {
                for (GeneratedPluginFactory factory : GraalServices.load(GeneratedPluginFactory.class)) {
                    factory.registerPlugins(invocationPlugins, nodeIntrinsificationProvider);
                }
            });
        }
        return plugins;
    }

    private static void registerTrufflePlugins(InvocationPlugins plugins, final WordTypes wordTypes, final GraalHotSpotVMConfig config) {
        if (config.jvmciReservedReference0Offset == -1) {
            return;
        }
        plugins.registerIntrinsificationPredicate(t -> t.getName().equals("Lcom/oracle/truffle/runtime/hotspot/HotSpotFastThreadLocal;"));
        InvocationPlugins.Registration tl = new InvocationPlugins.Registration(plugins, "com.oracle.truffle.runtime.hotspot.HotSpotFastThreadLocal");
        tl.register(new InvocationPlugin("get", new Type[]{InvocationPlugin.Receiver.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                int jvmciReservedReference0Offset = config.jvmciReservedReference0Offset;
                GraalError.guarantee(jvmciReservedReference0Offset != -1, "jvmciReservedReference0Offset is not available but used.");
                b.addPush(JavaKind.Object, new HotSpotLoadReservedReferenceNode(b.getMetaAccess(), wordTypes, jvmciReservedReference0Offset));
                return true;
            }
        });
        tl.register(new InvocationPlugin("set", new Type[]{InvocationPlugin.Receiver.class, Object[].class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                int jvmciReservedReference0Offset = config.jvmciReservedReference0Offset;
                GraalError.guarantee(jvmciReservedReference0Offset != -1, "jvmciReservedReference0Offset is not available but used.");
                b.add(new HotSpotStoreReservedReferenceNode(wordTypes, value, jvmciReservedReference0Offset));
                return true;
            }
        });
    }

    private static void registerObjectPlugins(InvocationPlugins plugins, GraalHotSpotVMConfig config, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)Object.class), replacements);
        r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("clone", new Type[]{InvocationPlugin.Receiver.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                ValueNode object = receiver.get();
                b.addPush(JavaKind.Object, new ObjectCloneNode(MacroNode.MacroParams.of(b, targetMethod, object)));
                return true;
            }
        });
        r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("hashCode", new Type[]{InvocationPlugin.Receiver.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                ValueNode object = receiver.get();
                b.addPush(JavaKind.Int, new HotSpotIdentityHashCodeNode(object, b.bci()));
                return true;
            }
        });
        if (config.inlineNotify()) {
            r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("notify", new Type[]{InvocationPlugin.Receiver.class}){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                    ValueNode object = receiver.get();
                    b.add(new FastNotifyNode(object, false, b.bci()));
                    return true;
                }
            });
        }
        if (config.inlineNotifyAll()) {
            r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("notifyAll", new Type[]{InvocationPlugin.Receiver.class}){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                    ValueNode object = receiver.get();
                    b.add(new FastNotifyNode(object, true, b.bci()));
                    return true;
                }
            });
        }
    }

    private static void registerClassPlugins(GraphBuilderConfiguration.Plugins plugins, final GraalHotSpotVMConfig config, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins.getInvocationPlugins(), (Type)((Object)Class.class), replacements);
        r.register(new InvocationPlugin("getModifiers", new Type[]{InvocationPlugin.Receiver.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                try (HotSpotInvocationPluginHelper helper = new HotSpotInvocationPluginHelper(b, targetMethod, config);){
                    ValueNode klass = helper.readKlassFromClass(receiver.get());
                    PiNode nonNullKlass = helper.emitNullReturnGuard(klass, ConstantNode.forInt(1041), 0.25);
                    helper.emitFinalReturn(JavaKind.Int, helper.readKlassModifierFlags(nonNullKlass));
                }
                return true;
            }
        });
        r.register(new InvocationPlugin("isInterface", new Type[]{InvocationPlugin.Receiver.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                try (HotSpotInvocationPluginHelper helper = new HotSpotInvocationPluginHelper(b, targetMethod, config);){
                    ValueNode klass = helper.readKlassFromClass(receiver.get());
                    PiNode klassNonNull = helper.emitNullReturnGuard(klass, ConstantNode.forBoolean(false), 0.25);
                    ValueNode accessFlags = helper.readKlassAccessFlags(klassNonNull);
                    LogicNode test = IntegerTestNode.create(accessFlags, ConstantNode.forInt(512), NodeView.DEFAULT);
                    helper.emitFinalReturn(JavaKind.Boolean, ConditionalNode.create(test, ConstantNode.forBoolean(false), ConstantNode.forBoolean(true), NodeView.DEFAULT));
                }
                return true;
            }
        });
        r.register(new InvocationPlugin("isPrimitive", new Type[]{InvocationPlugin.Receiver.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                try (HotSpotInvocationPluginHelper helper = new HotSpotInvocationPluginHelper(b, targetMethod, config);){
                    ValueNode klass = helper.readKlassFromClass(receiver.get());
                    LogicNode isNull = b.add(IsNullNode.create(klass));
                    b.addPush(JavaKind.Boolean, ConditionalNode.create(isNull, b.add(ConstantNode.forBoolean(true)), b.add(ConstantNode.forBoolean(false)), NodeView.DEFAULT));
                }
                return true;
            }
        });
        r.register(new InvocationPlugin("getSuperclass", new Type[]{InvocationPlugin.Receiver.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                try (HotSpotInvocationPluginHelper helper = new HotSpotInvocationPluginHelper(b, targetMethod, config);){
                    ValueNode klass = helper.readKlassFromClass(receiver.get());
                    ConstantNode nullValue = ConstantNode.defaultForKind(JavaKind.Object);
                    PiNode klassNonNull = helper.emitNullReturnGuard(klass, nullValue, 0.25);
                    ValueNode accessFlags = helper.readKlassAccessFlags(klassNonNull);
                    LogicNode test = IntegerTestNode.create(accessFlags, ConstantNode.forInt(512), NodeView.DEFAULT);
                    helper.emitReturnIfNot(test, nullValue, 0.25);
                    ValueNode layoutHelper = helper.klassLayoutHelper(klassNonNull);
                    ResolvedJavaType objectType = b.getMetaAccess().lookupJavaType(Object.class);
                    ConstantNode objectClass = ConstantNode.forConstant(b.getConstantReflection().asJavaClass(objectType), b.getMetaAccess());
                    helper.emitReturnIf(layoutHelper, Condition.LT, ConstantNode.forInt(config.klassLayoutHelperNeutralValue), objectClass, 0.25);
                    ValueNode superKlass = helper.readKlassSuperKlass(klassNonNull);
                    PiNode superKlassNonNull = helper.emitNullReturnGuard(superKlass, nullValue, 0.25);
                    helper.emitFinalReturn(JavaKind.Object, new HubGetClassNode(b.getMetaAccess(), superKlassNonNull));
                }
                return true;
            }
        });
        r.registerConditional(config.jvmAccIsHiddenClass != 0, new InvocationPlugin("isHidden", new Type[]{InvocationPlugin.Receiver.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                try (HotSpotInvocationPluginHelper helper = new HotSpotInvocationPluginHelper(b, targetMethod, config);){
                    ValueNode klass = helper.readKlassFromClass(receiver.get());
                    PiNode nonNullKlass = helper.emitNullReturnGuard(klass, ConstantNode.forBoolean(false), 0.25);
                    ValueNode accessFlags = helper.readKlassAccessFlags(nonNullKlass);
                    LogicNode test = IntegerTestNode.create(accessFlags, ConstantNode.forInt(config.jvmAccIsHiddenClass), NodeView.DEFAULT);
                    helper.emitFinalReturn(JavaKind.Boolean, ConditionalNode.create(test, ConstantNode.forBoolean(false), ConstantNode.forBoolean(true), NodeView.DEFAULT));
                }
                return true;
            }
        });
    }

    private static void registerCallSitePlugins(InvocationPlugins plugins) {
        InvocationPlugin.InlineOnlyInvocationPlugin plugin = new InvocationPlugin.InlineOnlyInvocationPlugin("getTarget", new Type[]{InvocationPlugin.Receiver.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                ValueNode callSite = receiver.get();
                ConstantNode folded = CallSiteTargetNode.tryFold(GraphUtil.originalValue(callSite, true), b.getMetaAccess(), b.getAssumptions());
                if (folded != null) {
                    b.addPush(JavaKind.Object, folded);
                } else {
                    b.addPush(JavaKind.Object, new CallSiteTargetNode(MacroNode.MacroParams.of(b, targetMethod, callSite)));
                }
                return true;
            }
        };
        plugins.register((Type)((Object)ConstantCallSite.class), plugin);
        plugins.register((Type)((Object)MutableCallSite.class), plugin);
        plugins.register((Type)((Object)VolatileCallSite.class), plugin);
    }

    private static void registerReflectionPlugins(InvocationPlugins plugins, Replacements replacements, final GraalHotSpotVMConfig config) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "jdk.internal.reflect.Reflection", replacements);
        r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("getCallerClass", new Type[0]){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.addPush(JavaKind.Object, new HotSpotReflectionGetCallerClassNode(MacroNode.MacroParams.of(b, targetMethod, new ValueNode[0])));
                return true;
            }
        });
        r.register(new InvocationPlugin("getClassAccessFlags", new Type[]{Class.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg) {
                try (HotSpotInvocationPluginHelper helper = new HotSpotInvocationPluginHelper(b, targetMethod, config);){
                    ValueNode klass = helper.readKlassFromClass(b.nullCheckedValue(arg));
                    PiNode klassNonNull = helper.emitNullReturnGuard(klass, ConstantNode.forInt(1041), 0.25);
                    ValueNode accessFlags = helper.readKlassAccessFlags(klassNonNull);
                    helper.emitFinalReturn(JavaKind.Int, new AndNode(accessFlags, ConstantNode.forInt(config.jvmAccWrittenFlags)));
                }
                return true;
            }
        });
    }

    private static void registerUnsafePlugins(InvocationPlugins plugins, final GraalHotSpotVMConfig config, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "jdk.internal.misc.Unsafe", replacements);
        r.register(new InvocationPlugin("copyMemory0", new Type[]{InvocationPlugin.Receiver.class, Object.class, Long.TYPE, Object.class, Long.TYPE, Long.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode srcBase, ValueNode srcOffset, ValueNode destBase, ValueNode destOffset, ValueNode bytes) {
                b.add(new UnsafeCopyMemoryNode(config.doingUnsafeAccessOffset != Integer.MAX_VALUE, receiver.get(), srcBase, srcOffset, destBase, destOffset, bytes));
                return true;
            }
        });
        r.register(new InvocationPlugin("allocateInstance", new Type[]{InvocationPlugin.Receiver.class, Class.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unsafe, ValueNode clazz) {
                unsafe.get();
                DynamicNewInstanceNode.createAndPush(b, clazz);
                return true;
            }
        });
    }

    private static void registerSystemPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)System.class));
        r.register(new ForeignCallPlugin(HotSpotHostForeignCallsProvider.JAVA_TIME_MILLIS, "currentTimeMillis", new Type[0]));
        r.register(new ForeignCallPlugin(HotSpotHostForeignCallsProvider.JAVA_TIME_NANOS, "nanoTime", new Type[0]));
        r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("identityHashCode", new Type[]{Object.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode object) {
                b.addPush(JavaKind.Int, new HotSpotIdentityHashCodeNode(object, b.bci()));
                return true;
            }
        });
        ArrayCopySnippets.registerSystemArraycopyPlugin(r);
    }

    private static void registerArrayPlugins(InvocationPlugins plugins, Replacements replacements, final GraalHotSpotVMConfig config) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)Array.class), replacements);
        r.setAllowOverwrite(true);
        r.register(new InvocationPlugin("newArray", new Type[]{Class.class, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode componentType, ValueNode length) {
                try (HotSpotInvocationPluginHelper helper = new HotSpotInvocationPluginHelper(b, targetMethod, config);){
                    ValueNode nonNullComponentType = b.nullCheckedValue(componentType);
                    ValueNode arrayClass = helper.loadArrayKlass(nonNullComponentType);
                    helper.doFallbackIf(IsNullNode.create(arrayClass), 0.25);
                    helper.emitFinalReturn(JavaKind.Object, new DynamicNewArrayNode(nonNullComponentType, length, true));
                }
                return true;
            }
        });
    }

    private static void registerStringPlugins(InvocationPlugins plugins, Replacements replacements, final WordTypes wordTypes, final ArrayCopyForeignCalls foreignCalls, final GraalHotSpotVMConfig vmConfig) {
        InvocationPlugins.Registration utf16r = new InvocationPlugins.Registration(plugins, "java.lang.StringUTF16", replacements);
        utf16r.register(new InvocationPlugin("toBytes", new Type[]{char[].class, Integer.TYPE, Integer.TYPE}){
            private static final int MAX_LENGTH = 0x3FFFFFFF;

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value, ValueNode srcBegin, ValueNode length) {
                try (HotSpotInvocationPluginHelper helper = new HotSpotInvocationPluginHelper(b, targetMethod, vmConfig);){
                    helper.intrinsicRangeCheck(srcBegin, Condition.LT, ConstantNode.forInt(0));
                    helper.intrinsicRangeCheck(length, Condition.LT, ConstantNode.forInt(0));
                    helper.intrinsicRangeCheck(length, Condition.GT, ConstantNode.forInt(0x3FFFFFFF));
                    ValueNode valueLength = b.add(new ArrayLengthNode(value));
                    ValueNode limit = b.add(new SubNode(valueLength, length));
                    helper.intrinsicRangeCheck(srcBegin, Condition.GT, limit);
                    NewArrayNode newArray = new NewArrayNode(b.getMetaAccess().lookupJavaType(Byte.TYPE), b.add(new LeftShiftNode(length, ConstantNode.forInt(1))), false);
                    b.addPush(JavaKind.Object, newArray);
                    b.add(new ArrayCopyCallNode(foreignCalls, wordTypes, value, srcBegin, newArray, ConstantNode.forInt(0), length, JavaKind.Char, LocationIdentity.init(), false, true, true, vmConfig.heapWordSize));
                }
                return true;
            }
        });
        utf16r.register(new InvocationPlugin("getChars", new Type[]{byte[].class, Integer.TYPE, Integer.TYPE, char[].class, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value, ValueNode srcBegin, ValueNode srcEnd, ValueNode dst, ValueNode dstBegin) {
                try (HotSpotInvocationPluginHelper helper = new HotSpotInvocationPluginHelper(b, targetMethod, vmConfig);){
                    helper.emitReturnIf(srcBegin, Condition.GE, srcEnd, null, 0.010000000000000009);
                    ValueNode size = helper.sub(srcEnd, srcBegin);
                    ValueNode or = helper.or(srcBegin, size);
                    helper.intrinsicRangeCheck(or, Condition.LT, ConstantNode.forInt(0));
                    ValueNode srcLimit = helper.sub(helper.shr(helper.length(value), 1), srcBegin);
                    helper.intrinsicRangeCheck(size, Condition.GT, srcLimit);
                    ValueNode limit = helper.sub(helper.length(dst), size);
                    helper.intrinsicRangeCheck(dstBegin, Condition.GT, limit);
                    b.add(new ArrayCopyCallNode(foreignCalls, wordTypes, value, srcBegin, dst, dstBegin, size, JavaKind.Char, JavaKind.Byte, JavaKind.Char, false, true, true, vmConfig.heapWordSize));
                    helper.emitFinalReturn(JavaKind.Void, null);
                }
                return true;
            }
        });
    }

    private static boolean isAnnotatedByChangesCurrentThread(ResolvedJavaMethod method) {
        for (Annotation annotation : method.getAnnotations()) {
            if (!"jdk.internal.vm.annotation.ChangesCurrentThread".equals(annotation.annotationType().getName())) continue;
            return true;
        }
        return false;
    }

    private static void registerThreadPlugins(InvocationPlugins plugins, final GraalHotSpotVMConfig config, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)Thread.class), replacements);
        r.register(new InvocationPlugin("currentThread", new Type[0]){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                try (HotSpotInvocationPluginHelper helper = new HotSpotInvocationPluginHelper(b, targetMethod, config);){
                    ValueNode value = helper.readCurrentThreadObject(true);
                    b.push(JavaKind.Object, value);
                }
                return true;
            }
        });
        if (JavaVersionUtil.JAVA_SPEC >= 19) {
            r.register(new InvocationPlugin("currentCarrierThread", new Type[0]){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                    try (HotSpotInvocationPluginHelper helper = new HotSpotInvocationPluginHelper(b, targetMethod, config);){
                        ValueNode value = helper.readCurrentThreadObject(false);
                        b.push(JavaKind.Object, value);
                    }
                    return true;
                }
            });
            r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("setCurrentThread", new Type[]{InvocationPlugin.Receiver.class, Thread.class}){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode thread) {
                    GraalError.guarantee(Services.IS_IN_NATIVE_IMAGE || HotSpotGraphBuilderPlugins.isAnnotatedByChangesCurrentThread(b.getMethod()), "method changes current Thread but is not annotated ChangesCurrentThread");
                    try (HotSpotInvocationPluginHelper helper = new HotSpotInvocationPluginHelper(b, targetMethod, config);){
                        receiver.get();
                        helper.setCurrentThread(thread);
                    }
                    return true;
                }
            });
        }
        if (JavaVersionUtil.JAVA_SPEC >= 20) {
            r.registerConditional(config.threadScopedValueCacheOffset != -1, new InvocationPlugin("scopedValueCache", new Type[0]){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                    try (HotSpotInvocationPluginHelper helper = new HotSpotInvocationPluginHelper(b, targetMethod, config);){
                        b.push(JavaKind.Object, helper.readThreadScopedValueCache());
                    }
                    return true;
                }
            });
            r.registerConditional(config.threadScopedValueCacheOffset != -1, new InvocationPlugin("setScopedValueCache", new Type[]{Object[].class}){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode cache) {
                    try (HotSpotInvocationPluginHelper helper = new HotSpotInvocationPluginHelper(b, targetMethod, config);){
                        helper.setThreadScopedValueCache(cache);
                    }
                    return true;
                }
            });
        }
    }

    @SyncPort(from="https://github.com/openjdk/jdk/blob/1fc726a8b34fcd41dae12a6d7c63232f9ccef3f4/src/hotspot/share/opto/library_call.cpp#L2861-L2922", sha1="c2d981ab918e2ca607835df010221ba0503a0cb2")
    private static void inlineNativeNotifyJvmtiFunctions(GraalHotSpotVMConfig config, GraphBuilderContext b, ResolvedJavaMethod targetMethod, ForeignCallDescriptor descriptor, ValueNode virtualThread, ValueNode hide) {
        try (HotSpotInvocationPluginHelper helper = new HotSpotInvocationPluginHelper(b, targetMethod, config);){
            GraalError.guarantee(config.virtualThreadVTMSNotifyJvmtiEvents != -1L, "JvmtiVTMSTransitionDisabler::_VTMS_notify_jvmti_events is not exported");
            OffsetAddressNode address = OffsetAddressNode.create(helper.asWord(config.virtualThreadVTMSNotifyJvmtiEvents));
            ValueNode notifyJvmtiEnabled = b.add(new JavaReadNode(JavaKind.Boolean, address, HotSpotReplacementsUtil.HOTSPOT_VTMS_NOTIFY_JVMTI_EVENTS, BarrierType.NONE, MemoryOrderMode.PLAIN, false));
            LogicNode testNotifyJvmtiEnabled = IntegerEqualsNode.create(notifyJvmtiEnabled, ConstantNode.forBoolean(true), NodeView.DEFAULT);
            StructuredGraph graph = b.getGraph();
            CurrentJavaThreadNode javaThread = graph.addOrUniqueWithInputs(new CurrentJavaThreadNode(helper.getWordKind()));
            BeginNode trueSuccessor = graph.add(new BeginNode());
            BeginNode falseSuccessor = graph.add(new BeginNode());
            ProfileData.BranchProbabilityData probability = ProfileData.BranchProbabilityData.injected(0.09999999999999998);
            b.add(new IfNode(testNotifyJvmtiEnabled, trueSuccessor, falseSuccessor, probability));
            ForeignCallNode runtimeCall = graph.add(new ForeignCallNode(descriptor, virtualThread, hide, javaThread));
            trueSuccessor.setNext(runtimeCall);
            runtimeCall.setStateAfter(b.getInvocationPluginReturnState(JavaKind.Void, null));
            EndNode trueSuccessorEnd = graph.add(new EndNode());
            runtimeCall.setNext(trueSuccessorEnd);
            GraalError.guarantee((long)config.threadIsInVTMSTransitionOffset != -1L, "JavaThread::_is_in_VTMS_transition is not exported");
            OffsetAddressNode jtAddress = graph.addOrUniqueWithInputs(new OffsetAddressNode(javaThread, helper.asWord(config.threadIsInVTMSTransitionOffset)));
            JavaWriteNode jtWrite = b.add(new JavaWriteNode(JavaKind.Boolean, jtAddress, HotSpotReplacementsUtil.HOTSPOT_JAVA_THREAD_IS_IN_VTMS_TRANSITION, hide, BarrierType.NONE, false));
            falseSuccessor.setNext(jtWrite);
            GraalError.guarantee((long)config.javaLangThreadIsInVTMSTransitonOffset != -1L, "java_lang_Thread::_jvmti_is_in_VTMS_transition_offset is not exported");
            OffsetAddressNode vtAddress = graph.addOrUniqueWithInputs(new OffsetAddressNode(virtualThread, helper.asWord(config.javaLangThreadIsInVTMSTransitonOffset)));
            b.add(new JavaWriteNode(JavaKind.Boolean, vtAddress, HotSpotReplacementsUtil.HOTSPOT_JAVA_LANG_THREAD_IS_IN_VTMS_TRANSITION, hide, BarrierType.NONE, false));
            EndNode falseSuccessorEnd = b.add(new EndNode());
            MergeNode merge = b.add(new MergeNode());
            merge.addForwardEnd(trueSuccessorEnd);
            merge.addForwardEnd(falseSuccessorEnd);
        }
    }

    private static void registerVirtualThreadPlugins(InvocationPlugins plugins, final GraalHotSpotVMConfig config, Replacements replacements) {
        if (JavaVersionUtil.JAVA_SPEC >= 21 && config.supportJVMTIVThreadNotification()) {
            InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "java.lang.VirtualThread", replacements);
            r.register(new InvocationPlugin("notifyJvmtiStart", new Type[]{InvocationPlugin.Receiver.class}){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                    if (config.doJVMTIVirtualThreadTransitions) {
                        ValueNode nonNullReceiver = receiver.get();
                        HotSpotGraphBuilderPlugins.inlineNativeNotifyJvmtiFunctions(config, b, targetMethod, HotSpotBackend.SHAREDRUNTIME_NOTIFY_JVMTI_VTHREAD_START, nonNullReceiver, ConstantNode.forBoolean(false, b.getGraph()));
                    }
                    return true;
                }
            });
            r.register(new InvocationPlugin("notifyJvmtiEnd", new Type[]{InvocationPlugin.Receiver.class}){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                    if (config.doJVMTIVirtualThreadTransitions) {
                        ValueNode nonNullReceiver = receiver.get();
                        HotSpotGraphBuilderPlugins.inlineNativeNotifyJvmtiFunctions(config, b, targetMethod, HotSpotBackend.SHAREDRUNTIME_NOTIFY_JVMTI_VTHREAD_END, nonNullReceiver, ConstantNode.forBoolean(true, b.getGraph()));
                    }
                    return true;
                }
            });
            r.register(new InvocationPlugin("notifyJvmtiMount", new Type[]{InvocationPlugin.Receiver.class, Boolean.TYPE}){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode hide) {
                    if (config.doJVMTIVirtualThreadTransitions) {
                        ValueNode nonNullReceiver = receiver.get();
                        HotSpotGraphBuilderPlugins.inlineNativeNotifyJvmtiFunctions(config, b, targetMethod, HotSpotBackend.SHAREDRUNTIME_NOTIFY_JVMTI_VTHREAD_MOUNT, nonNullReceiver, hide);
                    }
                    return true;
                }
            });
            r.register(new InvocationPlugin("notifyJvmtiUnmount", new Type[]{InvocationPlugin.Receiver.class, Boolean.TYPE}){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode hide) {
                    if (config.doJVMTIVirtualThreadTransitions) {
                        ValueNode nonNullReceiver = receiver.get();
                        HotSpotGraphBuilderPlugins.inlineNativeNotifyJvmtiFunctions(config, b, targetMethod, HotSpotBackend.SHAREDRUNTIME_NOTIFY_JVMTI_VTHREAD_UNMOUNT, nonNullReceiver, hide);
                    }
                    return true;
                }
            });
            r.register(new InvocationPlugin("notifyJvmtiHideFrames", new Type[]{InvocationPlugin.Receiver.class, Boolean.TYPE}){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode hide) {
                    if (config.doJVMTIVirtualThreadTransitions) {
                        try (HotSpotInvocationPluginHelper helper = new HotSpotInvocationPluginHelper(b, targetMethod, config);){
                            GraalError.guarantee((long)config.threadIsInTmpVTMSTransitionOffset != -1L, "JavaThread::_is_in_tmp_VTMS_transition is not exported");
                            CurrentJavaThreadNode javaThread = b.add(new CurrentJavaThreadNode(helper.getWordKind()));
                            OffsetAddressNode address = b.add(new OffsetAddressNode(javaThread, helper.asWord(config.threadIsInTmpVTMSTransitionOffset)));
                            b.add(new JavaWriteNode(JavaKind.Boolean, address, HotSpotReplacementsUtil.HOTSPOT_JAVA_THREAD_IS_IN_TMP_VTMS_TRANSITION, hide, BarrierType.NONE, false));
                        }
                    }
                    return true;
                }
            });
        }
    }

    public static boolean isIntrinsicName(GraalHotSpotVMConfig config, String className, String name) {
        for (VMIntrinsicMethod intrinsic : config.getStore().getIntrinsics()) {
            if (!className.equals(intrinsic.declaringClass) || !name.equals(intrinsic.name)) continue;
            return true;
        }
        return false;
    }

    private static ResolvedJavaType resolveTypeAESCrypt(ResolvedJavaType context) {
        return UnresolvedJavaType.create((String)"Lcom/sun/crypto/provider/AESCrypt;").resolve(context);
    }

    private static void registerAESPlugins(InvocationPlugins plugins, GraalHotSpotVMConfig config, Replacements replacements, Architecture arch) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "com.sun.crypto.provider.CipherBlockChaining", replacements);
        r.registerConditional(CipherBlockChainingAESNode.isSupported(arch), new HotSpotCipherBlockChainingCryptPlugin(AESNode.CryptMode.ENCRYPT));
        r.registerConditional(CipherBlockChainingAESNode.isSupported(arch), new HotSpotCipherBlockChainingCryptPlugin(AESNode.CryptMode.DECRYPT));
        r = new InvocationPlugins.Registration(plugins, "com.sun.crypto.provider.ElectronicCodeBook", replacements);
        r.registerConditional(config.electronicCodeBookEncrypt != 0L, new ElectronicCodeBookCryptPlugin(AESNode.CryptMode.ENCRYPT));
        r.registerConditional(config.electronicCodeBookDecrypt != 0L, new ElectronicCodeBookCryptPlugin(AESNode.CryptMode.DECRYPT));
        if (JavaVersionUtil.JAVA_SPEC >= 18) {
            r = new InvocationPlugins.Registration(plugins, "com.sun.crypto.provider.GaloisCounterMode", replacements);
            r.registerConditional(config.galoisCounterModeCrypt != 0L, new GaloisCounterModeCryptPlugin());
        }
        r = new InvocationPlugins.Registration(plugins, "com.sun.crypto.provider.CounterMode", replacements);
        r.registerConditional(CounterModeAESNode.isSupported(arch), new StandardGraphBuilderPlugins.CounterModeCryptPlugin(){

            @Override
            protected boolean canApply(GraphBuilderContext b) {
                return b instanceof BytecodeParser || b instanceof IntrinsicGraphBuilder;
            }

            @Override
            protected ValueNode getFieldOffset(GraphBuilderContext b, ResolvedJavaField field) {
                return ConstantNode.forLong(field.getOffset());
            }

            @Override
            protected ResolvedJavaType getTypeAESCrypt(MetaAccessProvider metaAccess, ResolvedJavaType context) {
                return HotSpotGraphBuilderPlugins.resolveTypeAESCrypt(context);
            }
        });
    }

    private static void registerAdler32Plugins(InvocationPlugins plugins, GraalHotSpotVMConfig config, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "java.util.zip.Adler32", replacements);
        r.registerConditional(config.updateBytesAdler32 != 0L, new InvocationPlugin.InlineOnlyInvocationPlugin("updateBytes", new Type[]{Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode adler, ValueNode src, ValueNode off, ValueNode len) {
                try (InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);){
                    ValueNode addr = helper.arrayElementPointer(src, JavaKind.Byte, off);
                    ForeignCallNode call = new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.UPDATE_BYTES_ADLER32, adler, addr, len);
                    b.addPush(JavaKind.Int, call);
                }
                return true;
            }
        });
        r.registerConditional(config.updateBytesAdler32 != 0L, new InvocationPlugin.InlineOnlyInvocationPlugin("updateByteBuffer", new Type[]{Integer.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode adler, ValueNode addr, ValueNode off, ValueNode len) {
                ValueNode buff = b.add(new ComputeObjectAddressNode(addr, off));
                ForeignCallNode call = new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.UPDATE_BYTES_ADLER32, adler, buff, len);
                b.addPush(JavaKind.Int, call);
                return true;
            }
        });
    }

    private static void registerBigIntegerPlugins(InvocationPlugins plugins, GraalHotSpotVMConfig config, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)BigInteger.class), replacements);
        r.registerConditional(config.useMontgomeryMultiplyIntrinsic(), new InvocationPlugin("implMontgomeryMultiply", new Type[]{int[].class, int[].class, int[].class, Integer.TYPE, Long.TYPE, int[].class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode a, ValueNode bObject, ValueNode n, ValueNode len, ValueNode inv, ValueNode product) {
                try (InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);){
                    b.addPush(JavaKind.Object, product);
                    b.add(new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.MONTGOMERY_MULTIPLY, helper.arrayStart(a, JavaKind.Int), helper.arrayStart(bObject, JavaKind.Int), helper.arrayStart(n, JavaKind.Int), len, inv, helper.arrayStart(product, JavaKind.Int)));
                }
                return true;
            }
        });
        r.registerConditional(config.useMontgomerySquareIntrinsic(), new InvocationPlugin("implMontgomerySquare", new Type[]{int[].class, int[].class, Integer.TYPE, Long.TYPE, int[].class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode a, ValueNode n, ValueNode len, ValueNode inv, ValueNode product) {
                try (InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);){
                    b.addPush(JavaKind.Object, product);
                    b.add(new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.MONTGOMERY_SQUARE, helper.arrayStart(a, JavaKind.Int), helper.arrayStart(n, JavaKind.Int), len, inv, helper.arrayStart(product, JavaKind.Int)));
                }
                return true;
            }
        });
        r.registerConditional(config.bigIntegerLeftShiftWorker != 0L, new InvocationPlugin("shiftLeftImplWorker", new Type[]{int[].class, int[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode newArr, ValueNode oldArr, ValueNode newIdx, ValueNode shiftCount, ValueNode numIter) {
                try (InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);){
                    b.add(new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.BIGINTEGER_LEFT_SHIFT_WORKER, helper.arrayStart(newArr, JavaKind.Int), helper.arrayStart(oldArr, JavaKind.Int), newIdx, shiftCount, numIter));
                }
                return true;
            }
        });
        r.registerConditional(config.bigIntegerRightShiftWorker != 0L, new InvocationPlugin("shiftRightImplWorker", new Type[]{int[].class, int[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode newArr, ValueNode oldArr, ValueNode newIdx, ValueNode shiftCount, ValueNode numIter) {
                try (InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);){
                    b.add(new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.BIGINTEGER_RIGHT_SHIFT_WORKER, helper.arrayStart(newArr, JavaKind.Int), helper.arrayStart(oldArr, JavaKind.Int), newIdx, shiftCount, numIter));
                }
                return true;
            }
        });
    }

    private static void registerSHAPlugins(InvocationPlugins plugins, GraalHotSpotVMConfig config, Replacements replacements) {
        boolean useMD5 = config.md5ImplCompressMultiBlock != 0L;
        boolean useSha1 = config.useSHA1Intrinsics();
        boolean useSha256 = config.useSHA256Intrinsics();
        boolean useSha512 = config.useSHA512Intrinsics();
        boolean useSha3 = config.sha3ImplCompressMultiBlock != 0L;
        boolean implCompressMultiBlock0Enabled = HotSpotGraphBuilderPlugins.isIntrinsicName(config, "sun/security/provider/DigestBase", "implCompressMultiBlock0") && (useMD5 || useSha1 || useSha256 || useSha512 || useSha3);
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "sun.security.provider.DigestBase", replacements);
        r.registerConditional(implCompressMultiBlock0Enabled, new SnippetSubstitutionInvocationPlugin<DigestBaseSnippets.Templates>(DigestBaseSnippets.Templates.class, "implCompressMultiBlock0", new Type[]{InvocationPlugin.Receiver.class, byte[].class, Integer.TYPE, Integer.TYPE}){

            @Override
            protected Object[] getConstantArguments(ResolvedJavaMethod targetMethod) {
                ResolvedJavaType declaringClass = targetMethod.getDeclaringClass();
                return new Object[]{declaringClass, HotSpotReplacementsUtil.getType(declaringClass, "Lsun/security/provider/MD5;"), HotSpotReplacementsUtil.getType(declaringClass, "Lsun/security/provider/SHA;"), HotSpotReplacementsUtil.getType(declaringClass, "Lsun/security/provider/SHA2;"), HotSpotReplacementsUtil.getType(declaringClass, "Lsun/security/provider/SHA5;"), HotSpotReplacementsUtil.getType(declaringClass, "Lsun/security/provider/SHA3;")};
            }

            @Override
            public SnippetTemplate.SnippetInfo getSnippet(DigestBaseSnippets.Templates templates) {
                return templates.implCompressMultiBlock0;
            }
        });
    }

    private static void registerBase64Plugins(InvocationPlugins plugins, GraalHotSpotVMConfig config, final MetaAccessProvider metaAccess, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "java.util.Base64$Encoder", replacements);
        r.registerConditional(config.base64EncodeBlock != 0L, new InvocationPlugin("encodeBlock", new Type[]{InvocationPlugin.Receiver.class, byte[].class, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE, Boolean.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode src, ValueNode sp, ValueNode sl, ValueNode dst, ValueNode dp, ValueNode isURL) {
                int byteArrayBaseOffset = metaAccess.getArrayBaseOffset(JavaKind.Byte);
                ComputeObjectAddressNode srcAddress = b.add(new ComputeObjectAddressNode(src, ConstantNode.forInt(byteArrayBaseOffset)));
                ComputeObjectAddressNode dstAddress = b.add(new ComputeObjectAddressNode(dst, ConstantNode.forInt(byteArrayBaseOffset)));
                b.add(new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.BASE64_ENCODE_BLOCK, srcAddress, sp, sl, dstAddress, dp, isURL));
                return true;
            }
        });
        r = new InvocationPlugins.Registration(plugins, "java.util.Base64$Decoder", replacements);
        if (config.base64DecodeBlock != 0L) {
            if (GraalHotSpotVMConfig.base64DecodeBlockHasIsMIMEParameter()) {
                r.register(new InvocationPlugin("decodeBlock", new Type[]{InvocationPlugin.Receiver.class, byte[].class, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE}){

                    @Override
                    public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode src, ValueNode sp, ValueNode sl, ValueNode dst, ValueNode dp, ValueNode isURL, ValueNode isMime) {
                        int byteArrayBaseOffset = metaAccess.getArrayBaseOffset(JavaKind.Byte);
                        ComputeObjectAddressNode srcAddress = b.add(new ComputeObjectAddressNode(src, ConstantNode.forInt(byteArrayBaseOffset)));
                        ComputeObjectAddressNode dstAddress = b.add(new ComputeObjectAddressNode(dst, ConstantNode.forInt(byteArrayBaseOffset)));
                        ForeignCallNode call = new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.BASE64_DECODE_BLOCK, srcAddress, sp, sl, dstAddress, dp, isURL, isMime);
                        b.addPush(JavaKind.Int, call);
                        return true;
                    }
                });
            } else {
                r.register(new InvocationPlugin("decodeBlock", new Type[]{InvocationPlugin.Receiver.class, byte[].class, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE, Boolean.TYPE}){

                    @Override
                    public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode src, ValueNode sp, ValueNode sl, ValueNode dst, ValueNode dp, ValueNode isURL) {
                        int byteArrayBaseOffset = metaAccess.getArrayBaseOffset(JavaKind.Byte);
                        ComputeObjectAddressNode srcAddress = b.add(new ComputeObjectAddressNode(src, ConstantNode.forInt(byteArrayBaseOffset)));
                        ComputeObjectAddressNode dstAddress = b.add(new ComputeObjectAddressNode(dst, ConstantNode.forInt(byteArrayBaseOffset)));
                        ForeignCallNode call = new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.BASE64_DECODE_BLOCK, srcAddress, sp, sl, dstAddress, dp, isURL);
                        b.addPush(JavaKind.Int, call);
                        return true;
                    }
                });
            }
        }
    }

    private static void registerCRC32Plugins(InvocationPlugins plugins, final GraalHotSpotVMConfig config, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)CRC32.class), replacements);
        r.registerConditional(config.useCRC32Intrinsics() && config.crcTableAddress != 0L, new InvocationPlugin("update", new Type[]{Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode crc, ValueNode arg) {
                ConstantNode crcTableRawAddress = ConstantNode.forLong(config.crcTableAddress);
                XorNode c = new XorNode(crc, ConstantNode.forInt(-1));
                AndNode index = new AndNode(new XorNode(arg, c), ConstantNode.forInt(255));
                LeftShiftNode offset = new LeftShiftNode(index, ConstantNode.forInt(2));
                OffsetAddressNode address = new OffsetAddressNode(crcTableRawAddress, new SignExtendNode(offset, 32, 64));
                ValueNode result = b.add(new JavaReadNode(JavaKind.Int, address, HotSpotBackend.CRC_TABLE_LOCATION, BarrierType.NONE, MemoryOrderMode.PLAIN, false));
                result = new XorNode(result, new UnsignedRightShiftNode(c, ConstantNode.forInt(8)));
                b.addPush(JavaKind.Int, new XorNode(result, ConstantNode.forInt(-1)));
                return true;
            }
        });
        r.registerConditional(config.useCRC32Intrinsics(), new InvocationPlugin("updateBytes0", new Type[]{Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode crc, ValueNode buf, ValueNode off, ValueNode len) {
                int byteArrayBaseOffset = b.getMetaAccess().getArrayBaseOffset(JavaKind.Byte);
                ValueNode bufAddr = b.add(new ComputeObjectAddressNode(buf, new AddNode(ConstantNode.forInt(byteArrayBaseOffset), off)));
                b.addPush(JavaKind.Int, new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.UPDATE_BYTES_CRC32, crc, bufAddr, len));
                return true;
            }
        });
        r.registerConditional(config.useCRC32Intrinsics(), new InvocationPlugin("updateByteBuffer0", new Type[]{Integer.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode crc, ValueNode addr, ValueNode off, ValueNode len) {
                ValueNode bufAddr = b.add(new AddNode(addr, new SignExtendNode(off, 32, 64)));
                b.addPush(JavaKind.Int, new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.UPDATE_BYTES_CRC32, crc, bufAddr, len));
                return true;
            }
        });
    }

    private static void registerCRC32CPlugins(InvocationPlugins plugins, GraalHotSpotVMConfig config, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "java.util.zip.CRC32C", replacements);
        r.registerConditional(config.useCRC32CIntrinsics(), new InvocationPlugin("updateBytes", new Type[]{Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode crc, ValueNode buf, ValueNode off, ValueNode end) {
                int byteArrayBaseOffset = b.getMetaAccess().getArrayBaseOffset(JavaKind.Byte);
                ValueNode bufAddr = b.add(new ComputeObjectAddressNode(buf, new AddNode(ConstantNode.forInt(byteArrayBaseOffset), off)));
                b.addPush(JavaKind.Int, new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.UPDATE_BYTES_CRC32C, crc, bufAddr, new SubNode(end, off)));
                return true;
            }
        });
        r.registerConditional(config.useCRC32CIntrinsics(), new InvocationPlugin("updateDirectByteBuffer", new Type[]{Integer.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode crc, ValueNode addr, ValueNode off, ValueNode end) {
                ValueNode bufAddr = b.add(new AddNode(addr, new SignExtendNode(off, 32, 64)));
                b.addPush(JavaKind.Int, new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.UPDATE_BYTES_CRC32C, crc, bufAddr, new SubNode(end, off)));
                return true;
            }
        });
    }

    private static void registerPoly1305Plugins(InvocationPlugins plugins, GraalHotSpotVMConfig config, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "com.sun.crypto.provider.Poly1305", replacements);
        r.registerConditional(config.poly1305ProcessBlocks != 0L, new InvocationPlugin("processMultipleBlocks", new Type[]{InvocationPlugin.Receiver.class, byte[].class, Integer.TYPE, Integer.TYPE, long[].class, long[].class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode input, ValueNode offset, ValueNode length, ValueNode aLimbs, ValueNode rLimbs) {
                try (InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);){
                    ValueNode inputNotNull = b.nullCheckedValue(input);
                    ValueNode aLimbsNotNull = b.nullCheckedValue(aLimbs);
                    ValueNode rLimbsNotNull = b.nullCheckedValue(rLimbs);
                    ValueNode inputStart = helper.arrayElementPointer(inputNotNull, JavaKind.Byte, offset);
                    ValueNode aLimbsStart = helper.arrayStart(aLimbsNotNull, JavaKind.Long);
                    ValueNode rLimbsStart = helper.arrayStart(rLimbsNotNull, JavaKind.Long);
                    b.add(new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.POLY1305_PROCESSBLOCKS, inputStart, length, aLimbsStart, rLimbsStart));
                }
                return true;
            }
        });
    }

    private static void registerChaCha20Plugins(InvocationPlugins plugins, GraalHotSpotVMConfig config, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "com.sun.crypto.provider.ChaCha20Cipher", replacements);
        r.registerConditional(config.chacha20Block != 0L, new InvocationPlugin("implChaCha20Block", new Type[]{int[].class, byte[].class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode initState, ValueNode result) {
                try (InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);){
                    ValueNode stateNotNull = b.nullCheckedValue(initState);
                    ValueNode resultNotNull = b.nullCheckedValue(result);
                    ValueNode stateStart = helper.arrayStart(stateNotNull, JavaKind.Int);
                    ValueNode resultStart = helper.arrayStart(resultNotNull, JavaKind.Byte);
                    ForeignCallNode call = new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.CHACHA20Block, stateStart, resultStart);
                    b.addPush(JavaKind.Int, call);
                }
                return true;
            }
        });
    }

    private static void registerArraysSupportPlugins(InvocationPlugins plugins, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "jdk.internal.util.ArraysSupport", replacements);
        r.register(new InvocationPlugin("vectorizedMismatch", new Type[]{Object.class, Long.TYPE, Object.class, Long.TYPE, Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode aObject, ValueNode aOffset, ValueNode bObject, ValueNode bOffset, ValueNode length, ValueNode log2ArrayIndexScale) {
                ValueNode aAddr = b.add(new ComputeObjectAddressNode(aObject, aOffset));
                ValueNode bAddr = b.add(new ComputeObjectAddressNode(bObject, bOffset));
                b.addPush(JavaKind.Int, new VectorizedMismatchNode(aAddr, bAddr, length, log2ArrayIndexScale));
                return true;
            }
        });
    }

    private static void registerReferencePlugins(InvocationPlugins plugins, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)Reference.class), replacements);
        r.register(new StandardGraphBuilderPlugins.ReachabilityFencePlugin(){

            @Override
            protected boolean useExplicitReachabilityFence(GraphBuilderContext b) {
                return Options.ForceExplicitReachabilityFence.getValue(b.getOptions());
            }
        });
        r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("refersTo0", new Type[]{InvocationPlugin.Receiver.class, Object.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode o) {
                ValueNode offset = b.add(ConstantNode.forLong(HotSpotReplacementsUtil.referentOffset(b.getMetaAccess())));
                AddressNode address = b.add(new OffsetAddressNode(receiver.get(), offset));
                FieldLocationIdentity locationIdentity = new FieldLocationIdentity(HotSpotReplacementsUtil.referentField(b.getMetaAccess()));
                JavaReadNode read = b.add(new JavaReadNode(StampFactory.object(), JavaKind.Object, address, locationIdentity, BarrierType.WEAK_REFERS_TO, MemoryOrderMode.PLAIN, true));
                LogicNode objectEquals = b.add(ObjectEqualsNode.create(b.getConstantReflection(), b.getMetaAccess(), b.getOptions(), read, o, NodeView.DEFAULT));
                b.addPush(JavaKind.Boolean, ConditionalNode.create(objectEquals, b.add(ConstantNode.forBoolean(true)), b.add(ConstantNode.forBoolean(false)), NodeView.DEFAULT));
                return true;
            }
        });
        r = new InvocationPlugins.Registration(plugins, (Type)((Object)PhantomReference.class), replacements);
        r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("refersTo0", new Type[]{InvocationPlugin.Receiver.class, Object.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode o) {
                ValueNode offset = b.add(ConstantNode.forLong(HotSpotReplacementsUtil.referentOffset(b.getMetaAccess())));
                AddressNode address = b.add(new OffsetAddressNode(receiver.get(), offset));
                FieldLocationIdentity locationIdentity = new FieldLocationIdentity(HotSpotReplacementsUtil.referentField(b.getMetaAccess()));
                JavaReadNode read = b.add(new JavaReadNode(StampFactory.object(), JavaKind.Object, address, locationIdentity, BarrierType.PHANTOM_REFERS_TO, MemoryOrderMode.PLAIN, true));
                LogicNode objectEquals = b.add(ObjectEqualsNode.create(b.getConstantReflection(), b.getMetaAccess(), b.getOptions(), read, o, NodeView.DEFAULT));
                b.addPush(JavaKind.Boolean, ConditionalNode.create(objectEquals, b.add(ConstantNode.forBoolean(true)), b.add(ConstantNode.forBoolean(false)), NodeView.DEFAULT));
                return true;
            }
        });
    }

    private static void registerInstrumentationImplPlugins(InvocationPlugins plugins, final GraalHotSpotVMConfig config, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "sun.instrument.InstrumentationImpl", replacements);
        r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("getObjectSize0", new Type[]{InvocationPlugin.Receiver.class, Long.TYPE, Object.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode nativeAgent, ValueNode objectToSize) {
                try (HotSpotInvocationPluginHelper helper = new HotSpotInvocationPluginHelper(b, targetMethod, config);){
                    ValueNode objectNonNull = b.nullCheckedValue(objectToSize);
                    StructuredGraph graph = b.getGraph();
                    LoadHubNode hub = b.add(new LoadHubNode(b.getStampProvider(), objectNonNull));
                    ValueNode layoutHelper = helper.klassLayoutHelper(hub);
                    LogicNode isArray = b.add(ObjectIsArrayNode.create(objectNonNull));
                    ArrayLengthNode arrayLengthNode = graph.add(new ArrayLengthNode(objectNonNull));
                    EndNode arrayBranch = graph.add(new EndNode());
                    arrayLengthNode.setNext(arrayBranch);
                    ValueNode arrayHeaderSizeInt = b.add(UnsignedRightShiftNode.create(layoutHelper, ConstantNode.forInt(config.layoutHelperHeaderSizeShift), NodeView.DEFAULT));
                    ValueNode arrayHeaderSizeMaskedInt = b.add(AndNode.create(arrayHeaderSizeInt, ConstantNode.forInt(config.layoutHelperHeaderSizeMask), NodeView.DEFAULT));
                    ValueNode arrayHeaderSizeMaskedLong = b.add(SignExtendNode.create(arrayHeaderSizeMaskedInt, JavaKind.Long.getBitCount(), NodeView.DEFAULT));
                    ValueNode arrayLengthLong = b.add(SignExtendNode.create(arrayLengthNode, JavaKind.Long.getBitCount(), NodeView.DEFAULT));
                    ValueNode arraySizeLong = b.add(LeftShiftNode.create(arrayLengthLong, layoutHelper, NodeView.DEFAULT));
                    ValueNode arrayInstanceSizeLong = b.add(AddNode.create(arrayHeaderSizeMaskedLong, arraySizeLong, NodeView.DEFAULT));
                    long objectAlignmentMask = config.objectAlignment - 1;
                    ValueNode arrayInstanceSizeMaskedLong = b.add(AndNode.create(AddNode.create(arrayInstanceSizeLong, ConstantNode.forLong(objectAlignmentMask), NodeView.DEFAULT), ConstantNode.forLong(objectAlignmentMask ^ 0xFFFFFFFFFFFFFFFFL), NodeView.DEFAULT));
                    EndNode instanceBranch = graph.add(new EndNode());
                    ValueNode layoutHelperLong = b.add(SignExtendNode.create(layoutHelper, JavaKind.Long.getBitCount(), NodeView.DEFAULT));
                    ValueNode instanceSizeLong = b.add(AndNode.create(layoutHelperLong, ConstantNode.forLong(-((long)JavaKind.Long.getByteCount())), NodeView.DEFAULT));
                    b.add(new IfNode(isArray, arrayLengthNode, instanceBranch, ProfileData.BranchProbabilityData.injected(0.5)));
                    MergeNode merge = b.append(new MergeNode());
                    merge.addForwardEnd(arrayBranch);
                    merge.addForwardEnd(instanceBranch);
                    b.addPush(JavaKind.Long, new ValuePhiNode(StampFactory.forKind(JavaKind.Long), merge, arrayInstanceSizeMaskedLong, instanceSizeLong));
                    b.setStateAfter(merge);
                }
                return true;
            }
        });
    }

    public static class HotSpotCipherBlockChainingCryptPlugin
    extends StandardGraphBuilderPlugins.CipherBlockChainingCryptPlugin {
        HotSpotCipherBlockChainingCryptPlugin(AESNode.CryptMode mode) {
            super(mode);
        }

        @Override
        protected boolean canApply(GraphBuilderContext b) {
            return b instanceof BytecodeParser || b instanceof IntrinsicGraphBuilder;
        }

        @Override
        protected ResolvedJavaType getTypeAESCrypt(MetaAccessProvider metaAccess, ResolvedJavaType context) {
            return HotSpotGraphBuilderPlugins.resolveTypeAESCrypt(context);
        }
    }

    public static class ElectronicCodeBookCryptPlugin
    extends StandardGraphBuilderPlugins.AESCryptDelegatePlugin {
        ElectronicCodeBookCryptPlugin(AESNode.CryptMode mode) {
            super(mode, mode.isEncrypt() ? "implECBEncrypt" : "implECBDecrypt", new Type[]{InvocationPlugin.Receiver.class, byte[].class, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE});
        }

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode in, ValueNode inOffset, ValueNode len, ValueNode out, ValueNode outOffset) {
            try (InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);){
                ResolvedJavaType receiverType = targetMethod.getDeclaringClass();
                ResolvedJavaType typeAESCrypt = this.getTypeAESCrypt(b.getMetaAccess(), receiverType);
                ValueNode nonNullReceiver = receiver.get();
                ValueNode inAddr = helper.arrayElementPointer(in, JavaKind.Byte, inOffset);
                ValueNode outAddr = helper.arrayElementPointer(out, JavaKind.Byte, outOffset);
                ValueNode kAddr = this.readEmbeddedAESCryptKArrayStart(b, helper, receiverType, typeAESCrypt, nonNullReceiver);
                ForeignCallNode call = new ForeignCallNode((ForeignCallDescriptor)(this.mode.isEncrypt() ? HotSpotBackend.ELECTRONIC_CODEBOOK_ENCRYPT_AESCRYPT : HotSpotBackend.ELECTRONIC_CODEBOOK_DECRYPT_AESCRYPT), inAddr, outAddr, kAddr, len);
                helper.emitFinalReturn(JavaKind.Int, call);
                boolean bl = true;
                return bl;
            }
        }

        @Override
        protected ResolvedJavaType getTypeAESCrypt(MetaAccessProvider metaAccess, ResolvedJavaType context) {
            return HotSpotGraphBuilderPlugins.resolveTypeAESCrypt(context);
        }
    }

    public static class GaloisCounterModeCryptPlugin
    extends StandardGraphBuilderPlugins.AESCryptDelegatePlugin {
        GaloisCounterModeCryptPlugin() {
            super(AESNode.CryptMode.ENCRYPT, "implGCMCrypt0", new Type[]{byte[].class, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE, byte[].class, Integer.TYPE, new InvocationPlugins.OptionalLazySymbol("com.sun.crypto.provider.GCTR"), new InvocationPlugins.OptionalLazySymbol("com.sun.crypto.provider.GHASH")});
        }

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode in, ValueNode inOffset, ValueNode len, ValueNode ct, ValueNode ctOffset, ValueNode out, ValueNode outOffset, ValueNode gctr, ValueNode ghash) {
            try (InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);){
                ResolvedJavaType receiverType = targetMethod.getDeclaringClass();
                ResolvedJavaType typeAESCrypt = this.getTypeAESCrypt(b.getMetaAccess(), receiverType);
                ResolvedJavaType typeGCTR = GaloisCounterModeCryptPlugin.getTypeGCTR(receiverType);
                ResolvedJavaType typeGHASH = GaloisCounterModeCryptPlugin.getTypeGHASH(receiverType);
                ValueNode nonNullGCTR = b.nullCheckedValue(gctr);
                ValueNode nonNullGHASH = b.nullCheckedValue(ghash);
                ValueNode inAddr = helper.arrayElementPointer(in, JavaKind.Byte, inOffset);
                ValueNode ctAddr = helper.arrayElementPointer(ct, JavaKind.Byte, ctOffset);
                ValueNode outAddr = helper.arrayElementPointer(out, JavaKind.Byte, outOffset);
                ValueNode kAddr = this.readEmbeddedAESCryptKArrayStart(b, helper, typeGCTR, typeAESCrypt, nonNullGCTR);
                ValueNode counterAddr = GaloisCounterModeCryptPlugin.readFieldArrayStart(b, helper, typeGCTR, "counter", nonNullGCTR, JavaKind.Byte);
                ValueNode stateAddr = GaloisCounterModeCryptPlugin.readFieldArrayStart(b, helper, typeGHASH, "state", nonNullGHASH, JavaKind.Long);
                ValueNode subkeyHtblAddr = GaloisCounterModeCryptPlugin.readFieldArrayStart(b, helper, typeGHASH, "subkeyHtbl", nonNullGHASH, JavaKind.Long);
                ForeignCallNode call = new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.GALOIS_COUNTER_MODE_CRYPT, inAddr, len, ctAddr, outAddr, kAddr, stateAddr, subkeyHtblAddr, counterAddr);
                helper.emitFinalReturn(JavaKind.Int, call);
                boolean bl = true;
                return bl;
            }
        }

        private static ResolvedJavaType getTypeGCTR(ResolvedJavaType context) {
            return UnresolvedJavaType.create((String)"Lcom/sun/crypto/provider/GCTR;").resolve(context);
        }

        private static ResolvedJavaType getTypeGHASH(ResolvedJavaType context) {
            return UnresolvedJavaType.create((String)"Lcom/sun/crypto/provider/GHASH;").resolve(context);
        }

        @Override
        protected ResolvedJavaType getTypeAESCrypt(MetaAccessProvider metaAccess, ResolvedJavaType context) {
            return HotSpotGraphBuilderPlugins.resolveTypeAESCrypt(context);
        }
    }

    static class DigestInvocationPlugin
    extends InvocationPlugin {
        private final ForeignCallDescriptor descriptor;

        DigestInvocationPlugin(ForeignCallDescriptor descriptor) {
            super("implCompress0", new Type[]{InvocationPlugin.Receiver.class, byte[].class, Integer.TYPE});
            this.descriptor = descriptor;
        }

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode buf, ValueNode ofs) {
            try (InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);){
                ValueNode realReceiver = b.add(new PiNode(receiver.get(), targetMethod.getDeclaringClass(), false, true));
                ResolvedJavaField stateField = helper.getField(targetMethod.getDeclaringClass(), "state");
                ValueNode state = helper.loadField(realReceiver, stateField);
                ValueNode bufAddr = helper.arrayElementPointer(buf, JavaKind.Byte, ofs);
                ValueNode stateAddr = helper.arrayStart(state, stateField.getType().getComponentType().getJavaKind());
                if (this.descriptor.equals(HotSpotBackend.SHA3_IMPL_COMPRESS)) {
                    ResolvedJavaField blockSizeField = helper.getField(targetMethod.getDeclaringClass(), "blockSize");
                    ValueNode blockSize = helper.loadField(realReceiver, blockSizeField);
                    b.add(new ForeignCallNode(this.descriptor, bufAddr, stateAddr, blockSize));
                } else {
                    b.add(new ForeignCallNode(this.descriptor, bufAddr, stateAddr));
                }
            }
            return true;
        }
    }

    public static class Options {
        public static final OptionKey<Boolean> ForceExplicitReachabilityFence = new OptionKey<Boolean>(false);
    }
}

