/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.meta;

import java.util.function.Supplier;
import jdk.vm.ci.hotspot.HotSpotResolvedObjectType;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.hotspot.nodes.KlassBeingInitializedCheckNode;
import org.graalvm.compiler.hotspot.nodes.type.KlassPointerStamp;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.graphbuilderconf.ClassInitializationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;

public final class HotSpotJITClassInitializationPlugin
implements ClassInitializationPlugin {
    @Override
    public boolean apply(GraphBuilderContext builder, ResolvedJavaType type, Supplier<FrameState> frameState) {
        if (!type.isInitialized() && (type.isInstanceClass() || type.isInterface())) {
            int code = builder.getCode().getCode()[builder.bci()] & 0xFF;
            switch (code) {
                case 178: 
                case 179: 
                case 184: 
                case 187: {
                    ConstantNode typeConstant = ConstantNode.forConstant(KlassPointerStamp.klass(), ((HotSpotResolvedObjectType)type).klass(), builder.getMetaAccess());
                    builder.add(new KlassBeingInitializedCheckNode(typeConstant));
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean supportsLazyInitialization(ConstantPool cp) {
        return false;
    }

    @Override
    public void loadReferencedType(GraphBuilderContext builder, ConstantPool cp, int cpi, int opcode) {
        cp.loadReferencedType(cpi, opcode);
    }
}

