/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.meta;

import java.util.Arrays;
import java.util.Collection;
import java.util.Formatter;
import java.util.Set;
import java.util.TreeSet;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Architecture;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.meta.HotSpotGraphBuilderPlugins;
import org.graalvm.compiler.replacements.nodes.AESNode;
import org.graalvm.compiler.replacements.nodes.CipherBlockChainingAESNode;
import org.graalvm.compiler.replacements.nodes.CounterModeAESNode;
import org.graalvm.compiler.replacements.nodes.GHASHProcessBlocksNode;
import org.graalvm.compiler.replacements.nodes.MessageDigestNode;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;

public final class UnimplementedGraalIntrinsics {
    public final Set<String> ignore = new TreeSet<String>();
    public final Set<String> enterprise = new TreeSet<String>();
    public final Set<String> toBeInvestigated = new TreeSet<String>();

    private static void add(Collection<String> c, String ... elements) {
        Object[] sorted = (String[])elements.clone();
        Arrays.sort(sorted);
        if (!Arrays.equals(elements, sorted)) {
            int width = 2 + Arrays.stream(elements).map(String::length).reduce(0, Integer::max);
            Formatter fmt = new Formatter();
            fmt.format("%-" + width + "s | sorted%n", "original");
            fmt.format("%s%n", new String(new char[width * 2 + 2]).replace('\u0000', '='));
            for (int i = 0; i < elements.length; ++i) {
                fmt.format("%-" + width + "s | %s%n", elements[i], sorted[i]);
            }
            throw GraalError.shouldNotReachHere(String.format("Elements not sorted alphabetically:%n%s", fmt));
        }
        c.addAll(Arrays.asList(elements));
    }

    public UnimplementedGraalIntrinsics(GraalHotSpotVMConfig config, Architecture arch) {
        UnimplementedGraalIntrinsics.add(this.ignore, "java/lang/Math.atan2(DD)D", "jdk/internal/misc/Unsafe.park(ZJ)V", "jdk/internal/misc/Unsafe.unpark(Ljava/lang/Object;)V", "sun/misc/Unsafe.park(ZJ)V", "sun/misc/Unsafe.prefetchRead(Ljava/lang/Object;J)V", "sun/misc/Unsafe.prefetchReadStatic(Ljava/lang/Object;J)V", "sun/misc/Unsafe.prefetchWrite(Ljava/lang/Object;J)V", "sun/misc/Unsafe.prefetchWriteStatic(Ljava/lang/Object;J)V", "sun/misc/Unsafe.unpark(Ljava/lang/Object;)V");
        UnimplementedGraalIntrinsics.add(this.ignore, "java/lang/Throwable.fillInStackTrace()Ljava/lang/Throwable;");
        UnimplementedGraalIntrinsics.add(this.ignore, "java/lang/reflect/Method.invoke(Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;");
        UnimplementedGraalIntrinsics.add(this.ignore, "java/lang/invoke/MethodHandle.<compiledLambdaForm>*", "java/lang/invoke/MethodHandle.invoke*");
        UnimplementedGraalIntrinsics.add(this.ignore, "java/lang/ref/Reference.get()Ljava/lang/Object;");
        UnimplementedGraalIntrinsics.add(this.ignore, "java/nio/Buffer.checkIndex(I)I");
        UnimplementedGraalIntrinsics.add(this.ignore, "java/lang/Math.max(II)I", "java/lang/Math.min(II)I");
        UnimplementedGraalIntrinsics.add(this.ignore, "jdk/jfr/internal/JVM.commit(J)J", "jdk/jfr/internal/JVM.counterTime()J", "jdk/jfr/internal/JVM.getBufferWriter()Ljava/lang/Object;", "jdk/jfr/internal/JVM.getClassId(Ljava/lang/Class;)J", "jdk/jfr/internal/JVM.getEventWriter()Ljava/lang/Object;", "oracle/jrockit/jfr/Timing.counterTime()J", "oracle/jrockit/jfr/VMJFR.classID0(Ljava/lang/Class;)J", "oracle/jrockit/jfr/VMJFR.threadID()I");
        UnimplementedGraalIntrinsics.add(this.ignore, "java/lang/CharacterDataLatin1.isLowerCase(I)Z", "java/lang/CharacterDataLatin1.isUpperCase(I)Z", "java/lang/CharacterDataLatin1.isWhitespace(I)Z", "java/lang/StringLatin1.equals([B[B)Z", "java/lang/StringLatin1.indexOf([B[B)I", "java/lang/StringUTF16.equals([B[B)Z", "java/lang/StringUTF16.indexOf([BI[BII)I", "java/lang/StringUTF16.indexOf([B[B)I", "java/lang/StringUTF16.indexOfChar([BIII)I", "java/lang/StringUTF16.indexOfLatin1([BI[BII)I", "java/lang/StringUTF16.indexOfLatin1([B[B)I");
        UnimplementedGraalIntrinsics.add(this.ignore, "java/util/stream/Streams$RangeIntSpliterator.forEachRemaining(Ljava/util/function/IntConsumer;)V");
        UnimplementedGraalIntrinsics.add(this.ignore, "java/lang/Object.<blackhole>*");
        if (arch instanceof AMD64) {
            if (!((AMD64)arch).getFeatures().contains(AMD64.CPUFeature.POPCNT)) {
                UnimplementedGraalIntrinsics.add(this.ignore, "java/lang/Integer.bitCount(I)I", "java/lang/Long.bitCount(J)I");
            }
            if (!((AMD64)arch).getFeatures().contains(AMD64.CPUFeature.AVX)) {
                UnimplementedGraalIntrinsics.add(this.ignore, "java/lang/Math.max(DD)D", "java/lang/Math.max(FF)F", "java/lang/Math.min(DD)D", "java/lang/Math.min(FF)F");
            }
            if (!((AMD64)arch).getFeatures().contains(AMD64.CPUFeature.AVX512VL)) {
                UnimplementedGraalIntrinsics.add(this.ignore, "java/lang/Math.copySign(DD)D", "java/lang/Math.copySign(FF)F");
            }
        }
        if (!config.inlineNotify()) {
            UnimplementedGraalIntrinsics.add(this.ignore, "java/lang/Object.notify()V");
        }
        if (!config.inlineNotifyAll()) {
            UnimplementedGraalIntrinsics.add(this.ignore, "java/lang/Object.notifyAll()V");
        }
        if (config.base64EncodeBlock == 0L) {
            UnimplementedGraalIntrinsics.add(this.ignore, "java/util/Base64$Encoder.encodeBlock([BII[BIZ)V");
        }
        if (config.base64DecodeBlock == 0L) {
            UnimplementedGraalIntrinsics.add(this.ignore, "java/util/Base64$Decoder.decodeBlock([BII[BIZ)I", "java/util/Base64$Decoder.decodeBlock([BII[BIZZ)I");
        }
        if (!GHASHProcessBlocksNode.isSupported(arch)) {
            UnimplementedGraalIntrinsics.add(this.ignore, "com/sun/crypto/provider/GHASH.processBlocks([BII[J[J)V");
        }
        if (!config.useFMAIntrinsics) {
            UnimplementedGraalIntrinsics.add(this.ignore, "java/lang/Math.fma(DDD)D", "java/lang/Math.fma(FFF)F");
        }
        if (!config.useCRC32Intrinsics) {
            UnimplementedGraalIntrinsics.add(this.ignore, "java/util/zip/CRC32.update(II)I", "java/util/zip/CRC32.updateByteBuffer0(IJII)I", "java/util/zip/CRC32.updateBytes0(I[BII)I");
        }
        if (!config.useCRC32CIntrinsics) {
            UnimplementedGraalIntrinsics.add(this.ignore, "java/util/zip/CRC32C.updateBytes(I[BII)I", "java/util/zip/CRC32C.updateDirectByteBuffer(IJII)I");
        }
        if (!AESNode.isSupported(arch)) {
            UnimplementedGraalIntrinsics.add(this.ignore, "com/sun/crypto/provider/AESCrypt.implDecryptBlock([BI[BI)V", "com/sun/crypto/provider/AESCrypt.implEncryptBlock([BI[BI)V");
        }
        if (!CounterModeAESNode.isSupported(arch)) {
            UnimplementedGraalIntrinsics.add(this.ignore, "com/sun/crypto/provider/CounterMode.implCrypt([BII[BI)I");
        }
        if (!CipherBlockChainingAESNode.isSupported(arch)) {
            UnimplementedGraalIntrinsics.add(this.ignore, "com/sun/crypto/provider/CipherBlockChaining.implDecrypt([BII[BI)I", "com/sun/crypto/provider/CipherBlockChaining.implEncrypt([BII[BI)I");
        }
        if (!config.useMontgomeryMultiplyIntrinsic()) {
            UnimplementedGraalIntrinsics.add(this.ignore, "java/math/BigInteger.implMontgomeryMultiply([I[I[IIJ[I)[I");
        }
        if (!config.useMontgomerySquareIntrinsic()) {
            UnimplementedGraalIntrinsics.add(this.ignore, "java/math/BigInteger.implMontgomerySquare([I[IIJ[I)[I");
        }
        if (HotSpotGraphBuilderPlugins.isIntrinsicName(config, "sun/security/provider/DigestBase", "implCompressMultiBlock0") && config.md5ImplCompressMultiBlock == 0L && !config.useSHA1Intrinsics() && !config.useSHA256Intrinsics() && !config.useSHA512Intrinsics() && config.sha3ImplCompressMultiBlock == 0L) {
            UnimplementedGraalIntrinsics.add(this.ignore, "sun/security/provider/DigestBase.implCompressMultiBlock0([BII)I");
        }
        if (!MessageDigestNode.SHA1Node.isSupported(arch)) {
            UnimplementedGraalIntrinsics.add(this.ignore, "sun/security/provider/SHA.implCompress0([BI)V");
        }
        if (!MessageDigestNode.SHA256Node.isSupported(arch)) {
            UnimplementedGraalIntrinsics.add(this.ignore, "sun/security/provider/SHA2.implCompress0([BI)V");
        }
        if (!MessageDigestNode.SHA3Node.isSupported(arch)) {
            UnimplementedGraalIntrinsics.add(this.ignore, "sun/security/provider/SHA3.implCompress0([BI)V");
        }
        if (!MessageDigestNode.SHA512Node.isSupported(arch)) {
            UnimplementedGraalIntrinsics.add(this.ignore, "sun/security/provider/SHA5.implCompress0([BI)V");
        }
        if (config.updateBytesAdler32 == 0L) {
            UnimplementedGraalIntrinsics.add(this.ignore, "java/util/zip/Adler32.updateByteBuffer(IJII)I", "java/util/zip/Adler32.updateBytes(I[BII)I");
        }
        if (config.bigIntegerLeftShiftWorker == 0L) {
            UnimplementedGraalIntrinsics.add(this.ignore, "java/math/BigInteger.shiftLeftImplWorker([I[IIII)V");
        }
        if (config.bigIntegerRightShiftWorker == 0L) {
            UnimplementedGraalIntrinsics.add(this.ignore, "java/math/BigInteger.shiftRightImplWorker([I[IIII)V");
        }
        if (config.electronicCodeBookEncrypt == 0L) {
            UnimplementedGraalIntrinsics.add(this.ignore, "com/sun/crypto/provider/ElectronicCodeBook.implECBDecrypt([BII[BI)I");
        }
        if (config.electronicCodeBookDecrypt == 0L) {
            UnimplementedGraalIntrinsics.add(this.ignore, "com/sun/crypto/provider/ElectronicCodeBook.implECBEncrypt([BII[BI)I");
        }
        if (config.poly1305ProcessBlocks == 0L) {
            UnimplementedGraalIntrinsics.add(this.ignore, "com/sun/crypto/provider/Poly1305.processMultipleBlocks([BII[J[J)V");
        }
        if (config.chacha20Block == 0L) {
            UnimplementedGraalIntrinsics.add(this.ignore, "com/sun/crypto/provider/ChaCha20Cipher.implChaCha20Block([I[B)I");
        }
        if (JavaVersionUtil.JAVA_SPEC >= 18) {
            UnimplementedGraalIntrinsics.add(this.ignore, "java/lang/StrictMath.max(II)I", "java/lang/StrictMath.min(II)I");
            if (arch instanceof AMD64 && !((AMD64)arch).getFeatures().contains(AMD64.CPUFeature.AVX)) {
                UnimplementedGraalIntrinsics.add(this.ignore, "java/lang/StrictMath.max(DD)D", "java/lang/StrictMath.max(FF)F", "java/lang/StrictMath.min(DD)D", "java/lang/StrictMath.min(FF)F");
            }
            if (config.galoisCounterModeCrypt == 0L) {
                UnimplementedGraalIntrinsics.add(this.ignore, "com/sun/crypto/provider/GaloisCounterMode.implGCMCrypt0([BII[BI[BILcom/sun/crypto/provider/GCTR;Lcom/sun/crypto/provider/GHASH;)I");
            }
        }
        if (JavaVersionUtil.JAVA_SPEC >= 19) {
            if ((long)config.threadScopedValueCacheOffset == -1L) {
                UnimplementedGraalIntrinsics.add(this.ignore, "java/lang/Thread.scopedValueCache()[Ljava/lang/Object;", "java/lang/Thread.setScopedValueCache([Ljava/lang/Object;)V");
            }
            if (arch instanceof AMD64 && !((AMD64)arch).getFeatures().contains(AMD64.CPUFeature.AVX512DQ)) {
                UnimplementedGraalIntrinsics.add(this.ignore, "java/lang/Double.isInfinite(D)Z", "java/lang/Float.isInfinite(F)Z");
            }
        }
        if (JavaVersionUtil.JAVA_SPEC >= 20) {
            UnimplementedGraalIntrinsics.add(this.ignore, "java/lang/Thread.findScopedValueBindings()Ljava/lang/Object;", "jdk/internal/vm/Continuation.doYield()I", "jdk/internal/vm/Continuation.enter(Ljdk/internal/vm/Continuation;Z)V", "jdk/internal/vm/Continuation.enterSpecial(Ljdk/internal/vm/Continuation;ZZ)V");
            UnimplementedGraalIntrinsics.add(this.ignore, "jdk/jfr/internal/JVM.getEventWriter()Ljdk/jfr/internal/event/EventWriter;");
            if (arch instanceof AMD64 && !((AMD64)arch).getFeatures().contains(AMD64.CPUFeature.valueOf((String)"GFNI"))) {
                UnimplementedGraalIntrinsics.add(this.ignore, "java/lang/Integer.reverse(I)I", "java/lang/Long.reverse(J)J");
            }
        }
        UnimplementedGraalIntrinsics.add(this.toBeInvestigated, "java/lang/invoke/MethodHandle.linkToNative*");
        if (JavaVersionUtil.JAVA_SPEC == 17) {
            UnimplementedGraalIntrinsics.add(this.toBeInvestigated, "jdk/internal/vm/vector/VectorSupport.binaryOp(ILjava/lang/Class;Ljava/lang/Class;ILjava/lang/Object;Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;", "jdk/internal/vm/vector/VectorSupport.blend(Ljava/lang/Class;Ljava/lang/Class;Ljava/lang/Class;ILjdk/internal/vm/vector/VectorSupport$Vector;Ljdk/internal/vm/vector/VectorSupport$Vector;Ljdk/internal/vm/vector/VectorSupport$VectorMask;Ljdk/internal/vm/vector/VectorSupport$VectorBlendOp;)Ljdk/internal/vm/vector/VectorSupport$Vector;", "jdk/internal/vm/vector/VectorSupport.broadcastCoerced(Ljava/lang/Class;Ljava/lang/Class;IJLjdk/internal/vm/vector/VectorSupport$VectorSpecies;Ljdk/internal/vm/vector/VectorSupport$BroadcastOperation;)Ljava/lang/Object;", "jdk/internal/vm/vector/VectorSupport.broadcastInt(ILjava/lang/Class;Ljava/lang/Class;ILjdk/internal/vm/vector/VectorSupport$Vector;ILjdk/internal/vm/vector/VectorSupport$VectorBroadcastIntOp;)Ljdk/internal/vm/vector/VectorSupport$Vector;", "jdk/internal/vm/vector/VectorSupport.compare(ILjava/lang/Class;Ljava/lang/Class;Ljava/lang/Class;ILjdk/internal/vm/vector/VectorSupport$Vector;Ljdk/internal/vm/vector/VectorSupport$Vector;Ljdk/internal/vm/vector/VectorSupport$VectorCompareOp;)Ljdk/internal/vm/vector/VectorSupport$VectorMask;", "jdk/internal/vm/vector/VectorSupport.convert(ILjava/lang/Class;Ljava/lang/Class;ILjava/lang/Class;Ljava/lang/Class;ILjdk/internal/vm/vector/VectorSupport$VectorPayload;Ljdk/internal/vm/vector/VectorSupport$VectorSpecies;Ljdk/internal/vm/vector/VectorSupport$VectorConvertOp;)Ljdk/internal/vm/vector/VectorSupport$VectorPayload;", "jdk/internal/vm/vector/VectorSupport.extract(Ljava/lang/Class;Ljava/lang/Class;ILjdk/internal/vm/vector/VectorSupport$Vector;ILjdk/internal/vm/vector/VectorSupport$VecExtractOp;)J", "jdk/internal/vm/vector/VectorSupport.insert(Ljava/lang/Class;Ljava/lang/Class;ILjdk/internal/vm/vector/VectorSupport$Vector;IJLjdk/internal/vm/vector/VectorSupport$VecInsertOp;)Ljdk/internal/vm/vector/VectorSupport$Vector;", "jdk/internal/vm/vector/VectorSupport.load(Ljava/lang/Class;Ljava/lang/Class;ILjava/lang/Object;JLjava/lang/Object;ILjdk/internal/vm/vector/VectorSupport$VectorSpecies;Ljdk/internal/vm/vector/VectorSupport$LoadOperation;)Ljava/lang/Object;", "jdk/internal/vm/vector/VectorSupport.loadWithMap(Ljava/lang/Class;Ljava/lang/Class;ILjava/lang/Class;Ljava/lang/Object;JLjdk/internal/vm/vector/VectorSupport$Vector;Ljava/lang/Object;I[IILjdk/internal/vm/vector/VectorSupport$VectorSpecies;Ljdk/internal/vm/vector/VectorSupport$LoadVectorOperationWithMap;)Ljdk/internal/vm/vector/VectorSupport$Vector;", "jdk/internal/vm/vector/VectorSupport.maskReductionCoerced(ILjava/lang/Class;Ljava/lang/Class;ILjava/lang/Object;Ljdk/internal/vm/vector/VectorSupport$VectorMaskOp;)I", "jdk/internal/vm/vector/VectorSupport.maybeRebox(Ljava/lang/Object;)Ljava/lang/Object;", "jdk/internal/vm/vector/VectorSupport.rearrangeOp(Ljava/lang/Class;Ljava/lang/Class;Ljava/lang/Class;ILjdk/internal/vm/vector/VectorSupport$Vector;Ljdk/internal/vm/vector/VectorSupport$VectorShuffle;Ljdk/internal/vm/vector/VectorSupport$VectorRearrangeOp;)Ljdk/internal/vm/vector/VectorSupport$Vector;", "jdk/internal/vm/vector/VectorSupport.reductionCoerced(ILjava/lang/Class;Ljava/lang/Class;ILjdk/internal/vm/vector/VectorSupport$Vector;Ljava/util/function/Function;)J", "jdk/internal/vm/vector/VectorSupport.shuffleIota(Ljava/lang/Class;Ljava/lang/Class;Ljdk/internal/vm/vector/VectorSupport$VectorSpecies;IIIILjdk/internal/vm/vector/VectorSupport$ShuffleIotaOperation;)Ljdk/internal/vm/vector/VectorSupport$VectorShuffle;", "jdk/internal/vm/vector/VectorSupport.shuffleToVector(Ljava/lang/Class;Ljava/lang/Class;Ljava/lang/Class;Ljdk/internal/vm/vector/VectorSupport$VectorShuffle;ILjdk/internal/vm/vector/VectorSupport$ShuffleToVectorOperation;)Ljava/lang/Object;", "jdk/internal/vm/vector/VectorSupport.store(Ljava/lang/Class;Ljava/lang/Class;ILjava/lang/Object;JLjdk/internal/vm/vector/VectorSupport$Vector;Ljava/lang/Object;ILjdk/internal/vm/vector/VectorSupport$StoreVectorOperation;)V", "jdk/internal/vm/vector/VectorSupport.storeWithMap(Ljava/lang/Class;Ljava/lang/Class;ILjava/lang/Class;Ljava/lang/Object;JLjdk/internal/vm/vector/VectorSupport$Vector;Ljdk/internal/vm/vector/VectorSupport$Vector;Ljava/lang/Object;I[IILjdk/internal/vm/vector/VectorSupport$StoreVectorOperationWithMap;)V", "jdk/internal/vm/vector/VectorSupport.ternaryOp(ILjava/lang/Class;Ljava/lang/Class;ILjava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljdk/internal/vm/vector/VectorSupport$TernaryOperation;)Ljava/lang/Object;", "jdk/internal/vm/vector/VectorSupport.test(ILjava/lang/Class;Ljava/lang/Class;ILjava/lang/Object;Ljava/lang/Object;Ljava/util/function/BiFunction;)Z", "jdk/internal/vm/vector/VectorSupport.unaryOp(ILjava/lang/Class;Ljava/lang/Class;ILjava/lang/Object;Ljava/util/function/Function;)Ljava/lang/Object;");
        }
        if (JavaVersionUtil.JAVA_SPEC >= 20) {
            UnimplementedGraalIntrinsics.add(this.toBeInvestigated, "jdk/internal/vm/vector/VectorSupport.compressExpandOp(ILjava/lang/Class;Ljava/lang/Class;Ljava/lang/Class;ILjdk/internal/vm/vector/VectorSupport$Vector;Ljdk/internal/vm/vector/VectorSupport$VectorMask;Ljdk/internal/vm/vector/VectorSupport$CompressExpandOperation;)Ljdk/internal/vm/vector/VectorSupport$VectorPayload;", "jdk/internal/vm/vector/VectorSupport.extract(Ljava/lang/Class;Ljava/lang/Class;ILjdk/internal/vm/vector/VectorSupport$Vector;ILjdk/internal/vm/vector/VectorSupport$VecExtractOp;)J", "jdk/internal/vm/vector/VectorSupport.indexPartiallyInUpperRange(Ljava/lang/Class;Ljava/lang/Class;IJJLjdk/internal/vm/vector/VectorSupport$IndexPartiallyInUpperRangeOperation;)Ljdk/internal/vm/vector/VectorSupport$VectorMask;", "jdk/internal/vm/vector/VectorSupport.indexVector(Ljava/lang/Class;Ljava/lang/Class;ILjdk/internal/vm/vector/VectorSupport$Vector;ILjdk/internal/vm/vector/VectorSupport$VectorSpecies;Ljdk/internal/vm/vector/VectorSupport$IndexOperation;)Ljdk/internal/vm/vector/VectorSupport$Vector;", "jdk/internal/vm/vector/VectorSupport.insert(Ljava/lang/Class;Ljava/lang/Class;ILjdk/internal/vm/vector/VectorSupport$Vector;IJLjdk/internal/vm/vector/VectorSupport$VecInsertOp;)Ljdk/internal/vm/vector/VectorSupport$Vector;", "jdk/internal/vm/vector/VectorSupport.loadMasked(Ljava/lang/Class;Ljava/lang/Class;Ljava/lang/Class;ILjava/lang/Object;JLjdk/internal/vm/vector/VectorSupport$VectorMask;ILjava/lang/Object;JLjdk/internal/vm/vector/VectorSupport$VectorSpecies;Ljdk/internal/vm/vector/VectorSupport$LoadVectorMaskedOperation;)Ljdk/internal/vm/vector/VectorSupport$Vector;", "jdk/internal/vm/vector/VectorSupport.loadWithMap(Ljava/lang/Class;Ljava/lang/Class;Ljava/lang/Class;ILjava/lang/Class;Ljava/lang/Object;JLjdk/internal/vm/vector/VectorSupport$Vector;Ljdk/internal/vm/vector/VectorSupport$VectorMask;Ljava/lang/Object;I[IILjdk/internal/vm/vector/VectorSupport$VectorSpecies;Ljdk/internal/vm/vector/VectorSupport$LoadVectorOperationWithMap;)Ljdk/internal/vm/vector/VectorSupport$Vector;", "jdk/internal/vm/vector/VectorSupport.maskReductionCoerced(ILjava/lang/Class;Ljava/lang/Class;ILjdk/internal/vm/vector/VectorSupport$VectorMask;Ljdk/internal/vm/vector/VectorSupport$VectorMaskOp;)J", "jdk/internal/vm/vector/VectorSupport.maybeRebox(Ljdk/internal/vm/vector/VectorSupport$VectorPayload;)Ljdk/internal/vm/vector/VectorSupport$VectorPayload;", "jdk/internal/vm/vector/VectorSupport.rearrangeOp(Ljava/lang/Class;Ljava/lang/Class;Ljava/lang/Class;Ljava/lang/Class;ILjdk/internal/vm/vector/VectorSupport$Vector;Ljdk/internal/vm/vector/VectorSupport$VectorShuffle;Ljdk/internal/vm/vector/VectorSupport$VectorMask;Ljdk/internal/vm/vector/VectorSupport$VectorRearrangeOp;)Ljdk/internal/vm/vector/VectorSupport$Vector;", "jdk/internal/vm/vector/VectorSupport.storeMasked(Ljava/lang/Class;Ljava/lang/Class;Ljava/lang/Class;ILjava/lang/Object;JLjdk/internal/vm/vector/VectorSupport$Vector;Ljdk/internal/vm/vector/VectorSupport$VectorMask;Ljava/lang/Object;JLjdk/internal/vm/vector/VectorSupport$StoreVectorMaskedOperation;)V", "jdk/internal/vm/vector/VectorSupport.storeWithMap(Ljava/lang/Class;Ljava/lang/Class;Ljava/lang/Class;ILjava/lang/Class;Ljava/lang/Object;JLjdk/internal/vm/vector/VectorSupport$Vector;Ljdk/internal/vm/vector/VectorSupport$Vector;Ljdk/internal/vm/vector/VectorSupport$VectorMask;Ljava/lang/Object;I[IILjdk/internal/vm/vector/VectorSupport$StoreVectorOperationWithMap;)V", "jdk/internal/vm/vector/VectorSupport.ternaryOp(ILjava/lang/Class;Ljava/lang/Class;Ljava/lang/Class;ILjdk/internal/vm/vector/VectorSupport$Vector;Ljdk/internal/vm/vector/VectorSupport$Vector;Ljdk/internal/vm/vector/VectorSupport$Vector;Ljdk/internal/vm/vector/VectorSupport$VectorMask;Ljdk/internal/vm/vector/VectorSupport$TernaryOperation;)Ljdk/internal/vm/vector/VectorSupport$Vector;");
            UnimplementedGraalIntrinsics.add(this.toBeInvestigated, "java/lang/Double.isFinite(D)Z", "java/lang/Float.isFinite(F)Z");
            if (arch instanceof AArch64) {
                UnimplementedGraalIntrinsics.add(this.toBeInvestigated, "java/lang/Double.isInfinite(D)Z", "java/lang/Float.isInfinite(F)Z");
                UnimplementedGraalIntrinsics.add(this.toBeInvestigated, "java/lang/Integer.compress(II)I", "java/lang/Integer.expand(II)I", "java/lang/Long.compress(JJ)J", "java/lang/Long.expand(JJ)J");
                if (JavaVersionUtil.JAVA_SPEC >= 21) {
                    UnimplementedGraalIntrinsics.add(this.toBeInvestigated, "jdk/internal/util/ArraysSupport.vectorizedHashCode(Ljava/lang/Object;IIII)I");
                }
            }
        }
        UnimplementedGraalIntrinsics.add(this.enterprise, "java/lang/Integer.toString(I)Ljava/lang/String;", "java/lang/String.<init>(Ljava/lang/String;)V", "java/lang/StringBuffer.<init>()V", "java/lang/StringBuffer.<init>(I)V", "java/lang/StringBuffer.<init>(Ljava/lang/String;)V", "java/lang/StringBuffer.append(C)Ljava/lang/StringBuffer;", "java/lang/StringBuffer.append(I)Ljava/lang/StringBuffer;", "java/lang/StringBuffer.append(Ljava/lang/String;)Ljava/lang/StringBuffer;", "java/lang/StringBuffer.toString()Ljava/lang/String;", "java/lang/StringBuilder.<init>()V", "java/lang/StringBuilder.<init>(I)V", "java/lang/StringBuilder.<init>(Ljava/lang/String;)V", "java/lang/StringBuilder.append(C)Ljava/lang/StringBuilder;", "java/lang/StringBuilder.append(I)Ljava/lang/StringBuilder;", "java/lang/StringBuilder.append(Ljava/lang/String;)Ljava/lang/StringBuilder;", "java/lang/StringBuilder.toString()Ljava/lang/String;", "java/util/Arrays.copyOf([Ljava/lang/Object;ILjava/lang/Class;)[Ljava/lang/Object;", "java/util/Arrays.copyOfRange([Ljava/lang/Object;IILjava/lang/Class;)[Ljava/lang/Object;", "jdk/internal/vm/vector/VectorSupport.binaryOp(ILjava/lang/Class;Ljava/lang/Class;Ljava/lang/Class;ILjdk/internal/vm/vector/VectorSupport$VectorPayload;Ljdk/internal/vm/vector/VectorSupport$VectorPayload;Ljdk/internal/vm/vector/VectorSupport$VectorMask;Ljdk/internal/vm/vector/VectorSupport$BinaryOperation;)Ljdk/internal/vm/vector/VectorSupport$VectorPayload;", "jdk/internal/vm/vector/VectorSupport.blend(Ljava/lang/Class;Ljava/lang/Class;Ljava/lang/Class;ILjdk/internal/vm/vector/VectorSupport$Vector;Ljdk/internal/vm/vector/VectorSupport$Vector;Ljdk/internal/vm/vector/VectorSupport$VectorMask;Ljdk/internal/vm/vector/VectorSupport$VectorBlendOp;)Ljdk/internal/vm/vector/VectorSupport$Vector;", "jdk/internal/vm/vector/VectorSupport.broadcastInt(ILjava/lang/Class;Ljava/lang/Class;Ljava/lang/Class;ILjdk/internal/vm/vector/VectorSupport$Vector;ILjdk/internal/vm/vector/VectorSupport$VectorMask;Ljdk/internal/vm/vector/VectorSupport$VectorBroadcastIntOp;)Ljdk/internal/vm/vector/VectorSupport$Vector;", "jdk/internal/vm/vector/VectorSupport.compare(ILjava/lang/Class;Ljava/lang/Class;Ljava/lang/Class;ILjdk/internal/vm/vector/VectorSupport$Vector;Ljdk/internal/vm/vector/VectorSupport$Vector;Ljdk/internal/vm/vector/VectorSupport$VectorMask;Ljdk/internal/vm/vector/VectorSupport$VectorCompareOp;)Ljdk/internal/vm/vector/VectorSupport$VectorMask;", "jdk/internal/vm/vector/VectorSupport.convert(ILjava/lang/Class;Ljava/lang/Class;ILjava/lang/Class;Ljava/lang/Class;ILjdk/internal/vm/vector/VectorSupport$VectorPayload;Ljdk/internal/vm/vector/VectorSupport$VectorSpecies;Ljdk/internal/vm/vector/VectorSupport$VectorConvertOp;)Ljdk/internal/vm/vector/VectorSupport$VectorPayload;", "jdk/internal/vm/vector/VectorSupport.fromBitsCoerced(Ljava/lang/Class;Ljava/lang/Class;IJILjdk/internal/vm/vector/VectorSupport$VectorSpecies;Ljdk/internal/vm/vector/VectorSupport$FromBitsCoercedOperation;)Ljdk/internal/vm/vector/VectorSupport$VectorPayload;", "jdk/internal/vm/vector/VectorSupport.load(Ljava/lang/Class;Ljava/lang/Class;ILjava/lang/Object;JLjava/lang/Object;JLjdk/internal/vm/vector/VectorSupport$VectorSpecies;Ljdk/internal/vm/vector/VectorSupport$LoadOperation;)Ljdk/internal/vm/vector/VectorSupport$VectorPayload;", "jdk/internal/vm/vector/VectorSupport.reductionCoerced(ILjava/lang/Class;Ljava/lang/Class;Ljava/lang/Class;ILjdk/internal/vm/vector/VectorSupport$Vector;Ljdk/internal/vm/vector/VectorSupport$VectorMask;Ljdk/internal/vm/vector/VectorSupport$ReductionOperation;)J", "jdk/internal/vm/vector/VectorSupport.shuffleIota(Ljava/lang/Class;Ljava/lang/Class;Ljdk/internal/vm/vector/VectorSupport$VectorSpecies;IIIILjdk/internal/vm/vector/VectorSupport$ShuffleIotaOperation;)Ljdk/internal/vm/vector/VectorSupport$VectorShuffle;", "jdk/internal/vm/vector/VectorSupport.shuffleToVector(Ljava/lang/Class;Ljava/lang/Class;Ljava/lang/Class;Ljdk/internal/vm/vector/VectorSupport$VectorShuffle;ILjdk/internal/vm/vector/VectorSupport$ShuffleToVectorOperation;)Ljdk/internal/vm/vector/VectorSupport$Vector;", "jdk/internal/vm/vector/VectorSupport.store(Ljava/lang/Class;Ljava/lang/Class;ILjava/lang/Object;JLjdk/internal/vm/vector/VectorSupport$VectorPayload;Ljava/lang/Object;JLjdk/internal/vm/vector/VectorSupport$StoreVectorOperation;)V", "jdk/internal/vm/vector/VectorSupport.test(ILjava/lang/Class;Ljava/lang/Class;ILjdk/internal/vm/vector/VectorSupport$VectorMask;Ljdk/internal/vm/vector/VectorSupport$VectorMask;Ljava/util/function/BiFunction;)Z", "jdk/internal/vm/vector/VectorSupport.unaryOp(ILjava/lang/Class;Ljava/lang/Class;Ljava/lang/Class;ILjdk/internal/vm/vector/VectorSupport$Vector;Ljdk/internal/vm/vector/VectorSupport$VectorMask;Ljdk/internal/vm/vector/VectorSupport$UnaryOperation;)Ljdk/internal/vm/vector/VectorSupport$Vector;");
    }

    public boolean isIgnored(String method) {
        return this.ignore.contains(method);
    }

    public boolean isImplementedInEnterprise(String method) {
        return this.enterprise.contains(method);
    }

    public boolean isMissing(String method) {
        return this.toBeInvestigated.contains(method);
    }

    public boolean isDocumented(String method) {
        return this.isIgnored(method) || this.isImplementedInEnterprise(method) || this.isMissing(method);
    }
}

