/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.nodes;

import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.VirtualStackSlot;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.word.Word;
import org.graalvm.compiler.word.WordTypes;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_1)
public final class AllocaNode
extends FixedWithNextNode
implements LIRLowerable {
    public static final NodeClass<AllocaNode> TYPE = NodeClass.create(AllocaNode.class);
    private final int sizeInBytes;
    private final int alignmentInBytes;

    public AllocaNode(@Node.InjectedNodeParameter WordTypes wordTypes, int sizeInBytes, int alignmentInBytes) {
        super((NodeClass<? extends FixedWithNextNode>)TYPE, StampFactory.forKind(wordTypes.getWordKind()));
        assert (sizeInBytes > 0 && alignmentInBytes > 0);
        this.sizeInBytes = sizeInBytes;
        this.alignmentInBytes = alignmentInBytes;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        VirtualStackSlot array = gen.getLIRGeneratorTool().allocateStackMemory(this.sizeInBytes, this.alignmentInBytes);
        Variable result = gen.getLIRGeneratorTool().emitAddress(array);
        gen.setResult(this, (Value)result);
    }

    @Node.NodeIntrinsic
    public static native Word alloca(@Node.ConstantNodeParameter int var0, @Node.ConstantNodeParameter int var1);
}

