/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.nodes;

import jdk.vm.ci.hotspot.HotSpotCompressedNullConstant;
import jdk.vm.ci.hotspot.HotSpotConstant;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.compiler.core.common.CompressEncoding;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.hotspot.nodes.type.HotSpotNarrowOopStamp;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.CompressionNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;

@NodeInfo(nameTemplate="{p#op/s}", cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_2)
public final class HotSpotCompressionNode
extends CompressionNode {
    public static final NodeClass<HotSpotCompressionNode> TYPE = NodeClass.create(HotSpotCompressionNode.class);

    public HotSpotCompressionNode(CompressionNode.CompressionOp op, ValueNode input, CompressEncoding encoding) {
        super(TYPE, op, input, HotSpotNarrowOopStamp.mkStamp(op, input.stamp(NodeView.DEFAULT), encoding), encoding);
    }

    public static HotSpotCompressionNode compress(StructuredGraph graph, ValueNode input, CompressEncoding encoding) {
        return graph.unique(HotSpotCompressionNode.compress(input, encoding));
    }

    public static CompressionNode uncompress(StructuredGraph graph, ValueNode input, CompressEncoding encoding) {
        return graph.unique(HotSpotCompressionNode.uncompress(input, encoding));
    }

    private static HotSpotCompressionNode compress(ValueNode input, CompressEncoding encoding) {
        return new HotSpotCompressionNode(CompressionNode.CompressionOp.Compress, input, encoding);
    }

    private static CompressionNode uncompress(ValueNode input, CompressEncoding encoding) {
        return new HotSpotCompressionNode(CompressionNode.CompressionOp.Uncompress, input, encoding);
    }

    @Override
    protected Constant compress(Constant c) {
        if (JavaConstant.NULL_POINTER.equals(c)) {
            return HotSpotCompressedNullConstant.COMPRESSED_NULL;
        }
        if (c instanceof HotSpotConstant) {
            return ((HotSpotConstant)c).compress();
        }
        throw GraalError.shouldNotReachHere("invalid constant input for compress op: " + c);
    }

    @Override
    protected Constant uncompress(Constant c) {
        if (c instanceof HotSpotConstant) {
            return ((HotSpotConstant)c).uncompress();
        }
        throw GraalError.shouldNotReachHere("invalid constant input for uncompress op: " + c);
    }

    @Override
    public ValueNode reverse(ValueNode input) {
        switch (this.op) {
            case Compress: {
                return HotSpotCompressionNode.uncompress(input, this.encoding);
            }
            case Uncompress: {
                return HotSpotCompressionNode.compress(input, this.encoding);
            }
        }
        throw GraalError.shouldNotReachHereUnexpectedValue((Object)this.op);
    }

    @Override
    protected Stamp mkStamp(Stamp input) {
        return HotSpotNarrowOopStamp.mkStamp(this.op, input, this.encoding);
    }
}

