/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.nodes;

import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.bytecode.Bytecode;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.spi.ForeignCallLinkage;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.hotspot.HotSpotBackend;
import org.graalvm.compiler.hotspot.nodes.DeoptimizingStubCall;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.replacements.nodes.CStringConstant;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, size=NodeSize.SIZE_UNKNOWN)
public final class VMErrorNode
extends DeoptimizingStubCall
implements LIRLowerable {
    public static final NodeClass<VMErrorNode> TYPE = NodeClass.create(VMErrorNode.class);
    protected final CStringConstant format;
    @Node.Input
    ValueNode value;

    public VMErrorNode(CStringConstant format, ValueNode value) {
        super((NodeClass<? extends DeoptimizingStubCall>)TYPE, StampFactory.forVoid());
        this.format = format;
        this.value = value;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        Object whereString;
        if (this.stateBefore() != null) {
            String nl = CodeUtil.NEW_LINE;
            StringBuilder sb = new StringBuilder("in compiled code associated with frame state:");
            for (FrameState fs = this.stateBefore(); fs != null; fs = fs.outerFrameState()) {
                Bytecode.appendLocation(sb.append(nl).append("\t"), fs.getCode(), fs.bci);
            }
            whereString = sb.toString();
        } else {
            ResolvedJavaMethod method = this.graph().method();
            whereString = "in compiled code for " + (method == null ? this.graph().toString() : method.format("%H.%n(%p)"));
        }
        LIRKind wordKind = gen.getLIRGeneratorTool().getLIRKind(StampFactory.pointer());
        Value whereArg = gen.getLIRGeneratorTool().emitConstant(wordKind, (Constant)new CStringConstant((String)whereString));
        Value formatArg = gen.getLIRGeneratorTool().emitConstant(wordKind, (Constant)this.format);
        ForeignCallLinkage linkage = gen.getLIRGeneratorTool().getForeignCalls().lookupForeignCall(HotSpotBackend.VM_ERROR);
        gen.getLIRGeneratorTool().emitForeignCall(linkage, null, whereArg, formatArg, gen.operand(this.value));
    }

    @Node.NodeIntrinsic
    public static native void vmError(@Node.ConstantNodeParameter CStringConstant var0, long var1);
}

