/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.replacements;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.bytecode.ResolvedJavaMethodBytecode;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.iterators.NodeIterable;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfigAccess;
import org.graalvm.compiler.hotspot.meta.HotSpotForeignCallDescriptor;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.meta.HotSpotRegistersProvider;
import org.graalvm.compiler.hotspot.nodes.AcquiredCASLockNode;
import org.graalvm.compiler.hotspot.nodes.BeginLockScopeNode;
import org.graalvm.compiler.hotspot.nodes.CurrentLockNode;
import org.graalvm.compiler.hotspot.nodes.EndLockScopeNode;
import org.graalvm.compiler.hotspot.nodes.FastAcquireBiasedLockNode;
import org.graalvm.compiler.hotspot.nodes.MonitorCounterNode;
import org.graalvm.compiler.hotspot.nodes.VMErrorNode;
import org.graalvm.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import org.graalvm.compiler.hotspot.replacements.HotspotSnippetsOptions;
import org.graalvm.compiler.hotspot.replacements.Log;
import org.graalvm.compiler.hotspot.word.KlassPointer;
import org.graalvm.compiler.lir.SyncPort;
import org.graalvm.compiler.nodes.BreakpointNode;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.DeoptimizeNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.InvokeNode;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ReturnNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.debug.DynamicCounterNode;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.nodes.extended.MembarNode;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.java.MonitorEnterNode;
import org.graalvm.compiler.nodes.java.MonitorExitNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.nodes.type.StampTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.common.inlining.InliningUtil;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.SnippetCounter;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.compiler.replacements.nodes.CStringConstant;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

@SyncPort(from="https://github.com/openjdk/jdk/blob/12358e6c94bc96e618efc3ec5299a2cfe1b4669d/src/hotspot/cpu/x86/c2_MacroAssembler_x86.cpp#L474-L932", ignore="GR-46070", sha1="156f7ed664c43a213c5eb3c417c8c5c29432cd2e")
public class MonitorSnippets
implements Snippets {
    private static final boolean PROFILE_CONTEXT = false;
    private static final boolean ENABLE_BREAKPOINT = false;
    private static final LocationIdentity MONITOR_COUNTER_LOCATION = NamedLocationIdentity.mutable("MonitorCounter");
    public static final HotSpotForeignCallDescriptor MONITORENTER = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.SAFEPOINT, HotSpotForeignCallDescriptor.Reexecutability.NOT_REEXECUTABLE, LocationIdentity.any(), "monitorenter", Void.TYPE, Object.class, Word.class);
    public static final HotSpotForeignCallDescriptor MONITOREXIT = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.STACK_INSPECTABLE_LEAF, HotSpotForeignCallDescriptor.Reexecutability.NOT_REEXECUTABLE, LocationIdentity.any(), "monitorexit", Void.TYPE, Object.class, Word.class);

    @Fold
    static boolean doProfile(@Fold.InjectedParameter OptionValues options) {
        return HotspotSnippetsOptions.ProfileMonitors.getValue(options);
    }

    @Snippet
    public static void monitorenter(Object object, KlassPointer hub, @Snippet.ConstantParameter int lockDepth, @Snippet.ConstantParameter Register threadRegister, @Snippet.ConstantParameter Register stackPointerRegister, @Snippet.ConstantParameter boolean trace, @Snippet.ConstantParameter Counters counters) {
        HotSpotReplacementsUtil.verifyOop(object);
        Word thread = HotSpotReplacementsUtil.registerAsWord(threadRegister);
        Word mark = HotSpotReplacementsUtil.loadWordFromObject(object, HotSpotReplacementsUtil.markOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG));
        Word lock = BeginLockScopeNode.beginLockScope(lockDepth);
        Word objectPointer = Word.objectToTrackedPointer(object);
        MonitorSnippets.trace(trace, "           object: 0x%016lx\n", (WordBase)objectPointer);
        MonitorSnippets.trace(trace, "             lock: 0x%016lx\n", (WordBase)lock);
        MonitorSnippets.trace(trace, "             mark: 0x%016lx\n", (WordBase)mark);
        MonitorSnippets.incCounter();
        if (HotSpotReplacementsUtil.diagnoseSyncOnValueBasedClasses(GraalHotSpotVMConfig.INJECTED_VMCONFIG) && hub.readWord(HotSpotReplacementsUtil.klassAccessFlagsOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), HotSpotReplacementsUtil.KLASS_ACCESS_FLAGS_LOCATION).and(HotSpotReplacementsUtil.jvmAccIsValueBasedClass(GraalHotSpotVMConfig.INJECTED_VMCONFIG)).notEqual(0)) {
            MonitorSnippets.monitorenterStubC(MONITORENTER, object, lock);
            return;
        }
        if (BranchProbabilityNode.probability(0.4, GraalHotSpotVMConfigAccess.JDK < 18) && HotSpotReplacementsUtil.useBiasedLocking(GraalHotSpotVMConfig.INJECTED_VMCONFIG) && MonitorSnippets.tryEnterBiased(object, hub, lock, mark, thread, trace, counters)) {
            return;
        }
        if (MonitorSnippets.inlineFastLockSupported() && BranchProbabilityNode.probability(0.010000000000000009, mark.and(HotSpotReplacementsUtil.monitorMask(GraalHotSpotVMConfig.INJECTED_VMCONFIG)).notEqual(0))) {
            if (MonitorSnippets.tryEnterInflated(object, lock, mark, thread, trace, counters)) {
                return;
            }
        } else if (!HotSpotReplacementsUtil.useHeavyMonitors(GraalHotSpotVMConfig.INJECTED_VMCONFIG)) {
            Word unlockedMark = mark.or(HotSpotReplacementsUtil.unlockedMask(GraalHotSpotVMConfig.INJECTED_VMCONFIG));
            MonitorSnippets.trace(trace, "     unlockedMark: 0x%016lx\n", (WordBase)unlockedMark);
            lock.writeWord(HotSpotReplacementsUtil.lockDisplacedMarkOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), (WordBase)unlockedMark, HotSpotReplacementsUtil.DISPLACED_MARK_WORD_LOCATION);
            Word currentMark = (Word)objectPointer.compareAndSwapWord(HotSpotReplacementsUtil.markOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), (WordBase)unlockedMark, (WordBase)lock, HotSpotReplacementsUtil.MARK_WORD_LOCATION);
            if (BranchProbabilityNode.probability(0.99, currentMark.equal(unlockedMark))) {
                MonitorSnippets.traceObject(trace, "+lock{cas}", object, true);
                counters.lockCas.inc();
                AcquiredCASLockNode.mark(object);
                MonitorSnippets.incrementHeldMonitorCount(thread);
                return;
            }
            MonitorSnippets.trace(trace, "      currentMark: 0x%016lx\n", (WordBase)currentMark);
            Word alignedMask = (Word)WordFactory.unsigned((int)(HotSpotReplacementsUtil.wordSize() - 1));
            Word stackPointer = HotSpotReplacementsUtil.registerAsWord(stackPointerRegister);
            if (BranchProbabilityNode.probability(0.99, currentMark.subtract(stackPointer).and(alignedMask.subtract(HotSpotReplacementsUtil.pageSize(GraalHotSpotVMConfig.INJECTED_VMCONFIG))).equal(0))) {
                lock.writeWord(HotSpotReplacementsUtil.lockDisplacedMarkOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), WordFactory.zero(), HotSpotReplacementsUtil.DISPLACED_MARK_WORD_LOCATION);
                MonitorSnippets.traceObject(trace, "+lock{cas:recursive}", object, true);
                counters.lockCasRecursive.inc();
                MonitorSnippets.incrementHeldMonitorCount(thread);
                return;
            }
            MonitorSnippets.traceObject(trace, "+lock{stub:failed-cas/stack}", object, true);
            counters.lockStubFailedCas.inc();
        }
        MonitorSnippets.monitorenterStubC(MONITORENTER, object, lock);
    }

    private static boolean tryEnterBiased(Object object, KlassPointer hub, Word lock, Word mark, Word thread, boolean trace, Counters counters) {
        Word biasableLockBits = mark.and(HotSpotReplacementsUtil.lockMaskInPlace(GraalHotSpotVMConfig.INJECTED_VMCONFIG));
        Word prototypeMarkWord = hub.readWord(HotSpotReplacementsUtil.prototypeMarkWordOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), HotSpotReplacementsUtil.PROTOTYPE_MARK_WORD_LOCATION);
        Word tmp = prototypeMarkWord.or(thread).xor(mark).and(~HotSpotReplacementsUtil.ageMaskInPlace(GraalHotSpotVMConfig.INJECTED_VMCONFIG));
        MonitorSnippets.trace(trace, "prototypeMarkWord: 0x%016lx\n", (WordBase)prototypeMarkWord);
        MonitorSnippets.trace(trace, "           thread: 0x%016lx\n", (WordBase)thread);
        MonitorSnippets.trace(trace, "              tmp: 0x%016lx\n", (WordBase)tmp);
        if (BranchProbabilityNode.probability(0.99, tmp.equal(0))) {
            MonitorSnippets.traceObject(trace, "+lock{bias:existing}", object, true);
            counters.lockBiasExisting.inc();
            FastAcquireBiasedLockNode.mark(object);
            return true;
        }
        if (BranchProbabilityNode.probability(0.09999999999999998, biasableLockBits.equal((Word)WordFactory.unsigned((int)HotSpotReplacementsUtil.biasedLockPattern(GraalHotSpotVMConfig.INJECTED_VMCONFIG))))) {
            Word objectPointer = Word.objectToTrackedPointer(object);
            if (BranchProbabilityNode.probability(0.9, tmp.and(HotSpotReplacementsUtil.lockMaskInPlace(GraalHotSpotVMConfig.INJECTED_VMCONFIG)).equal(0))) {
                if (BranchProbabilityNode.probability(0.9, tmp.and(HotSpotReplacementsUtil.epochMaskInPlace(GraalHotSpotVMConfig.INJECTED_VMCONFIG)).equal(0))) {
                    Word unbiasedMark = mark.and(HotSpotReplacementsUtil.lockMaskInPlace(GraalHotSpotVMConfig.INJECTED_VMCONFIG) | HotSpotReplacementsUtil.ageMaskInPlace(GraalHotSpotVMConfig.INJECTED_VMCONFIG) | HotSpotReplacementsUtil.epochMaskInPlace(GraalHotSpotVMConfig.INJECTED_VMCONFIG));
                    Word biasedMark = unbiasedMark.or(thread);
                    MonitorSnippets.trace(trace, "     unbiasedMark: 0x%016lx\n", (WordBase)unbiasedMark);
                    MonitorSnippets.trace(trace, "       biasedMark: 0x%016lx\n", (WordBase)biasedMark);
                    if (BranchProbabilityNode.probability(0.999, objectPointer.logicCompareAndSwapWord(HotSpotReplacementsUtil.markOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), (WordBase)unbiasedMark, (WordBase)biasedMark, HotSpotReplacementsUtil.MARK_WORD_LOCATION))) {
                        MonitorSnippets.traceObject(trace, "+lock{bias:acquired}", object, true);
                        counters.lockBiasAcquired.inc();
                        return true;
                    }
                    MonitorSnippets.traceObject(trace, "+lock{stub:revoke}", object, true);
                    counters.lockStubRevoke.inc();
                } else {
                    Word biasedMark = prototypeMarkWord.or(thread);
                    MonitorSnippets.trace(trace, "       biasedMark: 0x%016lx\n", (WordBase)biasedMark);
                    if (BranchProbabilityNode.probability(0.999, objectPointer.logicCompareAndSwapWord(HotSpotReplacementsUtil.markOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), (WordBase)mark, (WordBase)biasedMark, HotSpotReplacementsUtil.MARK_WORD_LOCATION))) {
                        MonitorSnippets.traceObject(trace, "+lock{bias:transfer}", object, true);
                        counters.lockBiasTransfer.inc();
                        return true;
                    }
                    MonitorSnippets.traceObject(trace, "+lock{stub:epoch-expired}", object, true);
                    counters.lockStubEpochExpired.inc();
                }
                MonitorSnippets.monitorenterStubC(MONITORENTER, object, lock);
                return true;
            }
            Word result = (Word)objectPointer.compareAndSwapWord(HotSpotReplacementsUtil.markOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), (WordBase)mark, (WordBase)prototypeMarkWord, HotSpotReplacementsUtil.MARK_WORD_LOCATION);
            counters.revokeBias.inc();
            return false;
        }
        counters.unbiasable.inc();
        return false;
    }

    @Fold
    public static boolean useFastInflatedLocking(@Fold.InjectedParameter OptionValues options) {
        return HotspotSnippetsOptions.SimpleFastInflatedLocking.getValue(options);
    }

    private static boolean inlineFastLockSupported() {
        return MonitorSnippets.inlineFastLockSupported(GraalHotSpotVMConfig.INJECTED_VMCONFIG, GraalHotSpotVMConfig.INJECTED_OPTIONVALUES);
    }

    private static boolean inlineFastLockSupported(GraalHotSpotVMConfig config, OptionValues options) {
        return MonitorSnippets.useFastInflatedLocking(options) && HotSpotReplacementsUtil.monitorMask(config) >= 0 && HotSpotReplacementsUtil.objectMonitorOwnerOffset(config) >= 0;
    }

    private static boolean tryEnterInflated(Object object, Word lock, Word mark, Word thread, boolean trace, Counters counters) {
        lock.writeWord(HotSpotReplacementsUtil.lockDisplacedMarkOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), (WordBase)WordFactory.unsigned((int)3), HotSpotReplacementsUtil.DISPLACED_MARK_WORD_LOCATION);
        Word monitor = mark.subtract(HotSpotReplacementsUtil.monitorMask(GraalHotSpotVMConfig.INJECTED_VMCONFIG));
        int ownerOffset = HotSpotReplacementsUtil.objectMonitorOwnerOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG);
        Word owner = (Word)monitor.readWord(ownerOffset, HotSpotReplacementsUtil.OBJECT_MONITOR_OWNER_LOCATION);
        if (BranchProbabilityNode.probability(0.9, owner.equal(0))) {
            if (BranchProbabilityNode.probability(0.9, monitor.logicCompareAndSwapWord(ownerOffset, (WordBase)owner, (WordBase)thread, HotSpotReplacementsUtil.OBJECT_MONITOR_OWNER_LOCATION))) {
                MonitorSnippets.traceObject(trace, "+lock{inflated:cas}", object, true);
                counters.inflatedCas.inc();
                MonitorSnippets.incrementHeldMonitorCount(thread);
                return true;
            }
            MonitorSnippets.traceObject(trace, "+lock{stub:inflated:failed-cas}", object, true);
            counters.inflatedFailedCas.inc();
        } else {
            if (BranchProbabilityNode.probability(0.4, owner.equal(thread))) {
                int recursionsOffset = HotSpotReplacementsUtil.objectMonitorRecursionsOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG);
                Word recursions = (Word)monitor.readWord(recursionsOffset, HotSpotReplacementsUtil.OBJECT_MONITOR_RECURSION_LOCATION);
                monitor.writeWord(recursionsOffset, (WordBase)recursions.add(1), HotSpotReplacementsUtil.OBJECT_MONITOR_RECURSION_LOCATION);
                MonitorSnippets.traceObject(trace, "+lock{inflated:recursive}", object, true);
                counters.inflatedRecursive.inc();
                MonitorSnippets.incrementHeldMonitorCount(thread);
                return true;
            }
            MonitorSnippets.traceObject(trace, "+lock{stub:inflated:owned}", object, true);
            counters.inflatedOwned.inc();
        }
        return false;
    }

    @Snippet
    public static void monitorenterStub(Object object, @Snippet.ConstantParameter int lockDepth, @Snippet.ConstantParameter boolean trace) {
        HotSpotReplacementsUtil.verifyOop(object);
        MonitorSnippets.incCounter();
        if (BranchProbabilityNode.probability(0.0, object == null)) {
            DeoptimizeNode.deopt(DeoptimizationAction.InvalidateReprofile, DeoptimizationReason.NullCheckException);
        }
        Word lock = BeginLockScopeNode.beginLockScope(lockDepth);
        MonitorSnippets.traceObject(trace, "+lock{stub}", object, true);
        MonitorSnippets.monitorenterStubC(MONITORENTER, object, lock);
    }

    @Snippet
    public static void monitorexit(Object object, @Snippet.ConstantParameter int lockDepth, @Snippet.ConstantParameter Register threadRegister, @Snippet.ConstantParameter boolean trace, @Snippet.ConstantParameter Counters counters) {
        Word thread = HotSpotReplacementsUtil.registerAsWord(threadRegister);
        MonitorSnippets.trace(trace, "           object: 0x%016lx\n", (WordBase)Word.objectToTrackedPointer(object));
        if (BranchProbabilityNode.probability(0.4, GraalHotSpotVMConfigAccess.JDK < 18) && HotSpotReplacementsUtil.useBiasedLocking(GraalHotSpotVMConfig.INJECTED_VMCONFIG)) {
            Word mark = HotSpotReplacementsUtil.loadWordFromObject(object, HotSpotReplacementsUtil.markOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG));
            MonitorSnippets.trace(trace, "             mark: 0x%016lx\n", (WordBase)mark);
            if (BranchProbabilityNode.probability(0.9, mark.and(HotSpotReplacementsUtil.lockMaskInPlace(GraalHotSpotVMConfig.INJECTED_VMCONFIG)).equal((Word)WordFactory.unsigned((int)HotSpotReplacementsUtil.biasedLockPattern(GraalHotSpotVMConfig.INJECTED_VMCONFIG))))) {
                EndLockScopeNode.endLockScope();
                MonitorSnippets.decCounter();
                MonitorSnippets.traceObject(trace, "-lock{bias}", object, false);
                counters.unlockBias.inc();
                return;
            }
        }
        Word lock = CurrentLockNode.currentLock(lockDepth);
        Word displacedMark = (Word)lock.readWord(HotSpotReplacementsUtil.lockDisplacedMarkOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), HotSpotReplacementsUtil.DISPLACED_MARK_WORD_LOCATION);
        MonitorSnippets.trace(trace, "    displacedMark: 0x%016lx\n", (WordBase)displacedMark);
        if (!HotSpotReplacementsUtil.useHeavyMonitors(GraalHotSpotVMConfig.INJECTED_VMCONFIG) && BranchProbabilityNode.probability(0.4, displacedMark.equal(0))) {
            MonitorSnippets.traceObject(trace, "-lock{recursive}", object, false);
            counters.unlockCasRecursive.inc();
            MonitorSnippets.decrementHeldMonitorCount(thread);
        } else {
            Word mark = HotSpotReplacementsUtil.loadWordFromObject(object, HotSpotReplacementsUtil.markOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG));
            if (!MonitorSnippets.tryExitInflated(object, mark, lock, thread, trace, counters)) {
                HotSpotReplacementsUtil.verifyOop(object);
                Word objectPointer = Word.objectToTrackedPointer(object);
                if (!HotSpotReplacementsUtil.useHeavyMonitors(GraalHotSpotVMConfig.INJECTED_VMCONFIG) && BranchProbabilityNode.probability(0.999, objectPointer.logicCompareAndSwapWord(HotSpotReplacementsUtil.markOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), (WordBase)lock, (WordBase)displacedMark, HotSpotReplacementsUtil.MARK_WORD_LOCATION))) {
                    MonitorSnippets.traceObject(trace, "-lock{cas}", object, false);
                    counters.unlockCas.inc();
                    MonitorSnippets.decrementHeldMonitorCount(thread);
                } else {
                    MonitorSnippets.traceObject(trace, "-lock{stub}", object, false);
                    counters.unlockStub.inc();
                    MonitorSnippets.monitorexitStubC(MONITOREXIT, object, lock);
                }
            }
        }
        EndLockScopeNode.endLockScope();
        MonitorSnippets.decCounter();
    }

    private static void incrementHeldMonitorCount(Word thread) {
        MonitorSnippets.updateHeldMonitorCount(thread, 1);
    }

    public static void decrementHeldMonitorCount(Word thread) {
        MonitorSnippets.updateHeldMonitorCount(thread, -1);
    }

    private static void updateHeldMonitorCount(Word thread, int increment) {
        if (HotSpotReplacementsUtil.updateHeldMonitorCount(GraalHotSpotVMConfig.INJECTED_VMCONFIG)) {
            if (HotSpotReplacementsUtil.heldMonitorCountIsWord(GraalHotSpotVMConfig.INJECTED_VMCONFIG)) {
                Word heldMonitorCount = (Word)thread.readWord(HotSpotReplacementsUtil.heldMonitorCountOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), HotSpotReplacementsUtil.JAVA_THREAD_HOLD_MONITOR_COUNT_LOCATION);
                thread.writeWord(HotSpotReplacementsUtil.heldMonitorCountOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), (WordBase)heldMonitorCount.add(increment), HotSpotReplacementsUtil.JAVA_THREAD_HOLD_MONITOR_COUNT_LOCATION);
            } else {
                int heldMonitorCount = thread.readInt(HotSpotReplacementsUtil.heldMonitorCountOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), HotSpotReplacementsUtil.JAVA_THREAD_HOLD_MONITOR_COUNT_LOCATION);
                thread.writeInt(HotSpotReplacementsUtil.heldMonitorCountOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), heldMonitorCount + increment, HotSpotReplacementsUtil.JAVA_THREAD_HOLD_MONITOR_COUNT_LOCATION);
            }
        }
    }

    private static boolean inlineFastUnlockSupported(OptionValues options) {
        return MonitorSnippets.inlineFastUnlockSupported(GraalHotSpotVMConfig.INJECTED_VMCONFIG, options);
    }

    private static boolean inlineFastUnlockSupported(GraalHotSpotVMConfig config, OptionValues options) {
        return MonitorSnippets.useFastInflatedLocking(options) && HotSpotReplacementsUtil.objectMonitorEntryListOffset(config) >= 0 && HotSpotReplacementsUtil.objectMonitorCxqOffset(config) >= 0 && HotSpotReplacementsUtil.monitorMask(config) >= 0 && HotSpotReplacementsUtil.objectMonitorOwnerOffset(config) >= 0 && HotSpotReplacementsUtil.objectMonitorRecursionsOffset(config) >= 0;
    }

    private static boolean tryExitInflated(Object object, Word mark, Word lock, Word thread, boolean trace, Counters counters) {
        if (!MonitorSnippets.inlineFastUnlockSupported(GraalHotSpotVMConfig.INJECTED_OPTIONVALUES)) {
            return false;
        }
        if (HotSpotReplacementsUtil.useHeavyMonitors(GraalHotSpotVMConfig.INJECTED_VMCONFIG) || BranchProbabilityNode.probability(0.010000000000000009, mark.and(HotSpotReplacementsUtil.monitorMask(GraalHotSpotVMConfig.INJECTED_VMCONFIG)).notEqual(0))) {
            Word monitor = mark.subtract(HotSpotReplacementsUtil.monitorMask(GraalHotSpotVMConfig.INJECTED_VMCONFIG));
            int ownerOffset = HotSpotReplacementsUtil.objectMonitorOwnerOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG);
            int recursionsOffset = HotSpotReplacementsUtil.objectMonitorRecursionsOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG);
            Word recursions = (Word)monitor.readWord(recursionsOffset, HotSpotReplacementsUtil.OBJECT_MONITOR_RECURSION_LOCATION);
            if (BranchProbabilityNode.probability(0.99, recursions.equal(0))) {
                int entryListOffset;
                Word entryList;
                int cxqOffset = HotSpotReplacementsUtil.objectMonitorCxqOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG);
                Word cxq = (Word)monitor.readWord(cxqOffset, HotSpotReplacementsUtil.OBJECT_MONITOR_CXQ_LOCATION);
                if (BranchProbabilityNode.probability(0.9, cxq.or(entryList = (Word)monitor.readWord(entryListOffset = HotSpotReplacementsUtil.objectMonitorEntryListOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), HotSpotReplacementsUtil.OBJECT_MONITOR_ENTRY_LIST_LOCATION)).equal(0))) {
                    MembarNode.memoryBarrier(MembarNode.FenceKind.STORE_RELEASE);
                    monitor.writeWord(ownerOffset, WordFactory.zero());
                    MonitorSnippets.traceObject(trace, "-lock{inflated:simple}", object, false);
                    counters.unlockInflatedSimple.inc();
                    MonitorSnippets.decrementHeldMonitorCount(thread);
                    return true;
                }
                int succOffset = HotSpotReplacementsUtil.objectMonitorSuccOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG);
                Word succ = (Word)monitor.readWord(succOffset, HotSpotReplacementsUtil.OBJECT_MONITOR_SUCC_LOCATION);
                if (BranchProbabilityNode.probability(0.9, succ.isNonNull())) {
                    monitor.writeWordVolatile(ownerOffset, WordFactory.zero());
                    succ = (Word)monitor.readWordVolatile(succOffset, HotSpotReplacementsUtil.OBJECT_MONITOR_SUCC_LOCATION);
                    if (BranchProbabilityNode.probability(0.09999999999999998, succ.isNonNull())) {
                        MonitorSnippets.traceObject(trace, "-lock{inflated:transfer}", object, false);
                        counters.unlockInflatedTransfer.inc();
                        MonitorSnippets.decrementHeldMonitorCount(thread);
                        return true;
                    }
                    if (BranchProbabilityNode.probability(0.9, !monitor.logicCompareAndSwapWord(ownerOffset, WordFactory.zero(), (WordBase)thread, HotSpotReplacementsUtil.OBJECT_MONITOR_OWNER_LOCATION))) {
                        MonitorSnippets.traceObject(trace, "-lock{inflated:transfer}", object, false);
                        counters.unlockInflatedTransfer.inc();
                        MonitorSnippets.decrementHeldMonitorCount(thread);
                        return true;
                    }
                }
            } else {
                monitor.writeWord(recursionsOffset, (WordBase)recursions.subtract(1), HotSpotReplacementsUtil.OBJECT_MONITOR_RECURSION_LOCATION);
                counters.unlockInflatedRecursive.inc();
                MonitorSnippets.traceObject(trace, "-lock{stub:recursive}", object, false);
                MonitorSnippets.decrementHeldMonitorCount(thread);
                return true;
            }
            counters.unlockStubInflated.inc();
            MonitorSnippets.traceObject(trace, "-lock{stub:inflated}", object, false);
            MonitorSnippets.monitorexitStubC(MONITOREXIT, object, lock);
            return true;
        }
        return false;
    }

    @Snippet
    public static void monitorexitStub(Object object, @Snippet.ConstantParameter int lockDepth, @Snippet.ConstantParameter boolean trace) {
        HotSpotReplacementsUtil.verifyOop(object);
        MonitorSnippets.traceObject(trace, "-lock{stub}", object, false);
        Word lock = CurrentLockNode.currentLock(lockDepth);
        MonitorSnippets.monitorexitStubC(MONITOREXIT, object, lock);
        EndLockScopeNode.endLockScope();
        MonitorSnippets.decCounter();
    }

    public static void traceObject(boolean enabled, String action, Object object, boolean enter) {
        if (MonitorSnippets.doProfile(GraalHotSpotVMConfig.INJECTED_OPTIONVALUES)) {
            DynamicCounterNode.counter(enter ? "number of monitor enters" : "number of monitor exits", action, 1L, false);
        }
        if (enabled) {
            Log.print(action);
            Log.print(' ');
            Log.printlnObject(object);
        }
    }

    public static void trace(boolean enabled, String format, WordBase value) {
        if (enabled) {
            Log.printf(format, value.rawValue());
        }
    }

    @Node.NodeIntrinsic(value=BreakpointNode.class)
    static native void bkpt(Object var0, Word var1, Word var2, Word var3);

    @Fold
    static boolean verifyBalancedMonitors(@Fold.InjectedParameter OptionValues options) {
        return HotspotSnippetsOptions.VerifyBalancedMonitors.getValue(options);
    }

    static void incCounter() {
        if (MonitorSnippets.verifyBalancedMonitors(GraalHotSpotVMConfig.INJECTED_OPTIONVALUES)) {
            Word counter = MonitorCounterNode.counter();
            int count = counter.readInt(0, MONITOR_COUNTER_LOCATION);
            counter.writeInt(0, count + 1, MONITOR_COUNTER_LOCATION);
        }
    }

    public static void decCounter() {
        if (MonitorSnippets.verifyBalancedMonitors(GraalHotSpotVMConfig.INJECTED_OPTIONVALUES)) {
            Word counter = MonitorCounterNode.counter();
            int count = counter.readInt(0, MONITOR_COUNTER_LOCATION);
            counter.writeInt(0, count - 1, MONITOR_COUNTER_LOCATION);
        }
    }

    @Snippet
    private static void initCounter() {
        Word counter = MonitorCounterNode.counter();
        counter.writeInt(0, 0, MONITOR_COUNTER_LOCATION);
    }

    @Snippet
    private static void checkCounter(@Snippet.ConstantParameter CStringConstant errMsg) {
        Word counter = MonitorCounterNode.counter();
        int count = counter.readInt(0, MONITOR_COUNTER_LOCATION);
        if (count != 0) {
            VMErrorNode.vmError(errMsg, count);
        }
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native void monitorenterStubC(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Object var1, Word var2);

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    public static native void monitorexitStubC(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Object var1, Word var2);

    public static class Counters {
        public final SnippetCounter lockBiasExisting;
        public final SnippetCounter lockBiasAcquired;
        public final SnippetCounter lockBiasTransfer;
        public final SnippetCounter lockCas;
        public final SnippetCounter lockCasRecursive;
        public final SnippetCounter lockStubEpochExpired;
        public final SnippetCounter lockStubRevoke;
        public final SnippetCounter lockStubFailedCas;
        public final SnippetCounter inflatedCas;
        public final SnippetCounter inflatedFailedCas;
        public final SnippetCounter inflatedRecursive;
        public final SnippetCounter inflatedOwned;
        public final SnippetCounter unbiasable;
        public final SnippetCounter revokeBias;
        public final SnippetCounter unlockBias;
        public final SnippetCounter unlockCas;
        public final SnippetCounter unlockCasRecursive;
        public final SnippetCounter unlockStub;
        public final SnippetCounter unlockStubInflated;
        public final SnippetCounter unlockInflatedSimple;
        public final SnippetCounter unlockInflatedTransfer;
        public final SnippetCounter unlockInflatedRecursive;

        public Counters(SnippetCounter.Group.Factory factory) {
            SnippetCounter.Group enter = factory.createSnippetCounterGroup("MonitorEnters");
            SnippetCounter.Group exit = factory.createSnippetCounterGroup("MonitorExits");
            this.lockBiasExisting = new SnippetCounter(enter, "lock{bias:existing}", "bias-locked previously biased object");
            this.lockBiasAcquired = new SnippetCounter(enter, "lock{bias:acquired}", "bias-locked newly biased object");
            this.lockBiasTransfer = new SnippetCounter(enter, "lock{bias:transfer}", "bias-locked, biased transferred");
            this.lockCas = new SnippetCounter(enter, "lock{cas}", "cas-locked an object");
            this.lockCasRecursive = new SnippetCounter(enter, "lock{cas:recursive}", "cas-locked, recursive");
            this.lockStubEpochExpired = new SnippetCounter(enter, "lock{stub:epoch-expired}", "stub-locked, epoch expired");
            this.lockStubRevoke = new SnippetCounter(enter, "lock{stub:revoke}", "stub-locked, biased revoked");
            this.lockStubFailedCas = new SnippetCounter(enter, "lock{stub:failed-cas/stack}", "stub-locked, failed cas and stack locking");
            this.inflatedCas = new SnippetCounter(enter, "lock{inflated:cas}", "heavyweight-locked, cas-locked");
            this.inflatedFailedCas = new SnippetCounter(enter, "lock{inflated:failed-cas}", "heavyweight-locked, failed cas");
            this.inflatedRecursive = new SnippetCounter(enter, "lock{inflated:recursive}", "heavyweight-locked, recursive");
            this.inflatedOwned = new SnippetCounter(enter, "lock{inflated:owned}", "heavyweight-locked, already owned");
            this.unbiasable = new SnippetCounter(enter, "unbiasable", "object with unbiasable type");
            this.revokeBias = new SnippetCounter(enter, "revokeBias", "object had bias revoked");
            this.unlockBias = new SnippetCounter(exit, "unlock{bias}", "bias-unlocked an object");
            this.unlockCas = new SnippetCounter(exit, "unlock{cas}", "cas-unlocked an object");
            this.unlockCasRecursive = new SnippetCounter(exit, "unlock{cas:recursive}", "cas-unlocked an object, recursive");
            this.unlockStub = new SnippetCounter(exit, "unlock{stub}", "stub-unlocked an object");
            this.unlockStubInflated = new SnippetCounter(exit, "unlock{stub:inflated}", "stub-unlocked an object with inflated monitor");
            this.unlockInflatedSimple = new SnippetCounter(exit, "unlock{inflated}", "unlocked an object monitor");
            this.unlockInflatedTransfer = new SnippetCounter(exit, "unlock{inflated:transfer}", "unlocked an object monitor in the presence of ObjectMonitor::_succ");
            this.unlockInflatedRecursive = new SnippetCounter(exit, "unlock{inflated:recursive}", "unlocked an object monitor, recursive");
        }
    }

    public static class Templates
    extends SnippetTemplate.AbstractTemplates {
        private final SnippetTemplate.SnippetInfo monitorenter;
        private final SnippetTemplate.SnippetInfo monitorexit;
        private final SnippetTemplate.SnippetInfo monitorenterStub;
        private final SnippetTemplate.SnippetInfo monitorexitStub;
        private final SnippetTemplate.SnippetInfo initCounter;
        private final SnippetTemplate.SnippetInfo checkCounter;
        private final boolean useFastLocking;
        public final Counters counters;

        public Templates(OptionValues options, SnippetCounter.Group.Factory factory, HotSpotProviders providers, boolean useFastLocking) {
            super(options, providers);
            LocationIdentity[] enterLocations = new LocationIdentity[]{};
            LocationIdentity[] exitLocations = new LocationIdentity[]{HotSpotReplacementsUtil.DISPLACED_MARK_WORD_LOCATION, HotSpotReplacementsUtil.OBJECT_MONITOR_OWNER_LOCATION, HotSpotReplacementsUtil.OBJECT_MONITOR_CXQ_LOCATION, HotSpotReplacementsUtil.OBJECT_MONITOR_ENTRY_LIST_LOCATION, HotSpotReplacementsUtil.OBJECT_MONITOR_RECURSION_LOCATION, HotSpotReplacementsUtil.OBJECT_MONITOR_SUCC_LOCATION, HotSpotReplacementsUtil.MARK_WORD_LOCATION};
            if (providers.getConfig().updateHeldMonitorCount) {
                enterLocations = new LocationIdentity[]{HotSpotReplacementsUtil.JAVA_THREAD_HOLD_MONITOR_COUNT_LOCATION};
                exitLocations = Arrays.copyOf(exitLocations, exitLocations.length + 1);
                exitLocations[exitLocations.length - 1] = HotSpotReplacementsUtil.JAVA_THREAD_HOLD_MONITOR_COUNT_LOCATION;
            }
            this.monitorenter = this.snippet((Providers)providers, MonitorSnippets.class, "monitorenter", enterLocations);
            this.monitorexit = this.snippet((Providers)providers, MonitorSnippets.class, "monitorexit", exitLocations);
            this.monitorenterStub = this.snippet((Providers)providers, MonitorSnippets.class, "monitorenterStub", new LocationIdentity[0]);
            this.monitorexitStub = this.snippet((Providers)providers, MonitorSnippets.class, "monitorexitStub", new LocationIdentity[0]);
            this.initCounter = this.snippet((Providers)providers, MonitorSnippets.class, "initCounter", new LocationIdentity[0]);
            this.checkCounter = this.snippet((Providers)providers, MonitorSnippets.class, "checkCounter", new LocationIdentity[0]);
            this.useFastLocking = useFastLocking;
            this.counters = new Counters(factory);
        }

        public void lower(MonitorEnterNode monitorenterNode, HotSpotRegistersProvider registers, LoweringTool tool) {
            SnippetTemplate.Arguments args;
            StructuredGraph graph = monitorenterNode.graph();
            this.checkBalancedMonitors(graph, tool);
            assert (((ObjectStamp)monitorenterNode.object().stamp(NodeView.DEFAULT)).nonNull());
            if (this.useFastLocking) {
                args = new SnippetTemplate.Arguments(this.monitorenter, graph.getGuardsStage(), tool.getLoweringStage());
                args.add("object", monitorenterNode.object());
                args.add("hub", Objects.requireNonNull(monitorenterNode.getObjectData()));
                args.addConst("lockDepth", monitorenterNode.getMonitorId().getLockDepth());
                args.addConst("threadRegister", registers.getThreadRegister());
                args.addConst("stackPointerRegister", registers.getStackPointerRegister());
                args.addConst("trace", Templates.isTracingEnabledForType(monitorenterNode.object()) || Templates.isTracingEnabledForMethod(graph));
                args.addConst("counters", this.counters);
            } else {
                args = new SnippetTemplate.Arguments(this.monitorenterStub, graph.getGuardsStage(), tool.getLoweringStage());
                args.add("object", monitorenterNode.object());
                args.addConst("lockDepth", monitorenterNode.getMonitorId().getLockDepth());
                args.addConst("trace", Templates.isTracingEnabledForType(monitorenterNode.object()) || Templates.isTracingEnabledForMethod(graph));
                args.addConst("counters", this.counters);
            }
            this.template(tool, monitorenterNode, args).instantiate(tool.getMetaAccess(), monitorenterNode, SnippetTemplate.DEFAULT_REPLACER, args);
        }

        public void lower(MonitorExitNode monitorexitNode, HotSpotRegistersProvider registers, LoweringTool tool) {
            StructuredGraph graph = monitorexitNode.graph();
            SnippetTemplate.Arguments args = this.useFastLocking ? new SnippetTemplate.Arguments(this.monitorexit, graph.getGuardsStage(), tool.getLoweringStage()) : new SnippetTemplate.Arguments(this.monitorexitStub, graph.getGuardsStage(), tool.getLoweringStage());
            args.add("object", monitorexitNode.object());
            args.addConst("lockDepth", monitorexitNode.getMonitorId().getLockDepth());
            args.addConst("threadRegister", registers.getThreadRegister());
            args.addConst("trace", Templates.isTracingEnabledForType(monitorexitNode.object()) || Templates.isTracingEnabledForMethod(graph));
            args.addConst("counters", this.counters);
            this.template(tool, monitorexitNode, args).instantiate(tool.getMetaAccess(), monitorexitNode, SnippetTemplate.DEFAULT_REPLACER, args);
        }

        public static boolean isTracingEnabledForType(ValueNode object) {
            ResolvedJavaType type = StampTool.typeOrNull(object.stamp(NodeView.DEFAULT));
            String filter = HotspotSnippetsOptions.TraceMonitorsTypeFilter.getValue(object.getOptions());
            if (filter == null) {
                return false;
            }
            if (filter.length() == 0) {
                return true;
            }
            if (type == null) {
                return false;
            }
            return type.getName().contains(filter);
        }

        public static boolean isTracingEnabledForMethod(StructuredGraph graph) {
            String filter = HotspotSnippetsOptions.TraceMonitorsMethodFilter.getValue(graph.getOptions());
            if (filter == null) {
                return false;
            }
            if (filter.length() == 0) {
                return true;
            }
            if (graph.method() == null) {
                return false;
            }
            return graph.method().format("%H.%n").contains(filter);
        }

        private void checkBalancedMonitors(StructuredGraph graph, LoweringTool tool) {
            NodeIterable<MonitorCounterNode> nodes;
            if (HotspotSnippetsOptions.VerifyBalancedMonitors.getValue(this.options).booleanValue() && (nodes = graph.getNodes().filter(MonitorCounterNode.class)).isEmpty()) {
                JavaType returnType = this.initCounter.getMethod().getSignature().getReturnType(this.initCounter.getMethod().getDeclaringClass());
                StampPair returnStamp = StampFactory.forDeclaredType(graph.getAssumptions(), returnType, false);
                MethodCallTargetNode callTarget = graph.add(new MethodCallTargetNode(CallTargetNode.InvokeKind.Static, this.initCounter.getMethod(), ValueNode.EMPTY_ARRAY, returnStamp, null));
                InvokeNode invoke = graph.add(new InvokeNode(callTarget, 0));
                invoke.setStateAfter(graph.start().stateAfter());
                graph.addAfterFixed(graph.start(), invoke);
                StructuredGraph inlineeGraph = tool.getReplacements().getSnippet(this.initCounter.getMethod(), null, null, null, invoke.graph().trackNodeSourcePosition(), invoke.getNodeSourcePosition(), invoke.getOptions());
                InliningUtil.inline(invoke, inlineeGraph, false, null);
                List<ReturnNode> rets = graph.getNodes(ReturnNode.TYPE).snapshot();
                for (ReturnNode ret : rets) {
                    returnType = this.checkCounter.getMethod().getSignature().getReturnType(this.checkCounter.getMethod().getDeclaringClass());
                    String msg = "unbalanced monitors in " + graph.method().format("%H.%n(%p)") + ", count = %d";
                    ConstantNode errMsg = ConstantNode.forConstant(tool.getConstantReflection().forString(msg), tool.getMetaAccess(), graph);
                    returnStamp = StampFactory.forDeclaredType(graph.getAssumptions(), returnType, false);
                    callTarget = graph.add(new MethodCallTargetNode(CallTargetNode.InvokeKind.Static, this.checkCounter.getMethod(), new ValueNode[]{errMsg}, returnStamp, null));
                    invoke = graph.add(new InvokeNode(callTarget, 0));
                    ResolvedJavaMethodBytecode code = new ResolvedJavaMethodBytecode(graph.method());
                    FrameState stateAfter = new FrameState(null, code, -3, ValueNode.EMPTY_ARRAY, ValueNode.EMPTY_ARRAY, 0, null, null, ValueNode.EMPTY_ARRAY, null, false, false);
                    invoke.setStateAfter(graph.add(stateAfter));
                    graph.addBeforeFixed(ret, invoke);
                    SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.checkCounter, graph.getGuardsStage(), tool.getLoweringStage());
                    args.addConst("errMsg", new CStringConstant(msg));
                    inlineeGraph = this.template(tool, invoke, args).copySpecializedGraph(graph.getDebug());
                    InliningUtil.inline(invoke, inlineeGraph, false, null);
                }
            }
        }
    }
}

