/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.replacements.arraycopy;

import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.spi.ForeignCallsProvider;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.hotspot.meta.HotSpotHostForeignCallsProvider;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.GetObjectAddressNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.nodes.memory.AbstractMemoryCheckpoint;
import org.graalvm.compiler.nodes.memory.SingleMemoryKill;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.word.LocationIdentity;

@NodeInfo(allowedUsageTypes={InputType.Memory, InputType.Value}, cycles=NodeCycles.CYCLES_UNKNOWN, size=NodeSize.SIZE_UNKNOWN)
public final class GenericArrayCopyCallNode
extends AbstractMemoryCheckpoint
implements Lowerable,
SingleMemoryKill {
    public static final NodeClass<GenericArrayCopyCallNode> TYPE = NodeClass.create(GenericArrayCopyCallNode.class);
    private final ForeignCallsProvider foreignCalls;
    @Node.Input
    ValueNode src;
    @Node.Input
    ValueNode srcPos;
    @Node.Input
    ValueNode dest;
    @Node.Input
    ValueNode destPos;
    @Node.Input
    ValueNode length;

    private ForeignCallsProvider getForeignCalls() {
        return this.foreignCalls;
    }

    protected GenericArrayCopyCallNode(@Node.InjectedNodeParameter ForeignCallsProvider foreignCalls, ValueNode src, ValueNode srcPos, ValueNode dest, ValueNode destPos, ValueNode length) {
        super((NodeClass<? extends AbstractMemoryCheckpoint>)TYPE, StampFactory.forKind(JavaKind.Int));
        this.foreignCalls = foreignCalls;
        this.src = src;
        this.srcPos = srcPos;
        this.dest = dest;
        this.destPos = destPos;
        this.length = length;
    }

    public ValueNode getSource() {
        return this.src;
    }

    public ValueNode getDestination() {
        return this.dest;
    }

    public ValueNode getLength() {
        return this.length;
    }

    @Override
    public void lower(LoweringTool tool) {
        if (this.graph().getGuardsStage().areFrameStatesAtDeopts()) {
            StructuredGraph graph = this.graph();
            ValueNode srcAddr = this.objectAddress(this.getSource());
            ValueNode destAddr = this.objectAddress(this.getDestination());
            ForeignCallNode call = graph.add(new ForeignCallNode(this.getForeignCalls(), HotSpotHostForeignCallsProvider.GENERIC_ARRAYCOPY, srcAddr, this.srcPos, destAddr, this.destPos, this.length));
            call.setStateAfter(this.stateAfter());
            graph.replaceFixedWithFixed(this, call);
        }
    }

    private ValueNode objectAddress(ValueNode obj) {
        GetObjectAddressNode result = this.graph().add(new GetObjectAddressNode(obj));
        this.graph().addBeforeFixed(this, result);
        return result;
    }

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        return LocationIdentity.any();
    }

    @Node.NodeIntrinsic
    public static native int genericArraycopy(Object var0, int var1, Object var2, int var3, int var4);
}

