/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.riscv64;

import java.util.ArrayList;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.hotspot.HotSpotCodeCacheProvider;
import jdk.vm.ci.hotspot.HotSpotConstantReflectionProvider;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.alloc.RegisterAllocationConfig;
import org.graalvm.compiler.core.riscv64.RISCV64ReflectionUtil;
import org.graalvm.compiler.core.riscv64.ShadowedRISCV64;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotBackend;
import org.graalvm.compiler.hotspot.HotSpotBackendFactory;
import org.graalvm.compiler.hotspot.HotSpotGraalRuntimeProvider;
import org.graalvm.compiler.hotspot.HotSpotReplacementsImpl;
import org.graalvm.compiler.hotspot.meta.AddressLoweringHotSpotSuitesProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotGraphBuilderPlugins;
import org.graalvm.compiler.hotspot.meta.HotSpotHostForeignCallsProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotLoweringProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotMetaAccessExtensionProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotPlatformConfigurationProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.meta.HotSpotRegisters;
import org.graalvm.compiler.hotspot.meta.HotSpotRegistersProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotSnippetReflectionProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotSuitesProvider;
import org.graalvm.compiler.hotspot.riscv64.RISCV64HotSpotForeignCallsProvider;
import org.graalvm.compiler.hotspot.riscv64.RISCV64HotSpotLoweringProvider;
import org.graalvm.compiler.hotspot.riscv64.RISCV64HotSpotSuitesCreator;
import org.graalvm.compiler.hotspot.word.HotSpotWordTypes;
import org.graalvm.compiler.lir.framemap.ReferenceMapBuilder;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.gc.BarrierSet;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.common.AddressLoweringPhase;
import org.graalvm.compiler.phases.tiers.CompilerConfiguration;
import org.graalvm.compiler.serviceprovider.ServiceProvider;

@ServiceProvider(value=HotSpotBackendFactory.class)
public class RISCV64HotSpotBackendFactory
extends HotSpotBackendFactory {
    @Override
    public String getName() {
        return "community";
    }

    @Override
    public Class<? extends Architecture> getArchitecture() {
        if (ShadowedRISCV64.riscv64OrNull != null) {
            return ShadowedRISCV64.riscv64OrNull.asSubclass(Architecture.class);
        }
        return null;
    }

    @Override
    protected GraphBuilderConfiguration.Plugins createGraphBuilderPlugins(HotSpotGraalRuntimeProvider graalRuntime, CompilerConfiguration compilerConfiguration, GraalHotSpotVMConfig config, TargetDescription target, HotSpotConstantReflectionProvider constantReflection, HotSpotHostForeignCallsProvider foreignCalls, MetaAccessProvider metaAccess, HotSpotSnippetReflectionProvider snippetReflection, HotSpotReplacementsImpl replacements, HotSpotWordTypes wordTypes, OptionValues options, BarrierSet barrierSet) {
        GraphBuilderConfiguration.Plugins plugins = HotSpotGraphBuilderPlugins.create(graalRuntime, compilerConfiguration, config, wordTypes, metaAccess, (ConstantReflectionProvider)constantReflection, snippetReflection, foreignCalls, replacements, options, target, barrierSet);
        return plugins;
    }

    @Override
    protected HotSpotBackend createBackend(GraalHotSpotVMConfig config, HotSpotGraalRuntimeProvider runtime, HotSpotProviders providers) {
        return new HotSpotBackend(runtime, providers){

            @Override
            public RegisterAllocationConfig newRegisterAllocationConfig(RegisterConfig registerConfig, String[] allocationRestrictedTo) {
                throw GraalError.unimplementedOverride();
            }

            @Override
            public ReferenceMapBuilder newReferenceMapBuilder(int totalFrameSize) {
                throw GraalError.unimplementedOverride();
            }
        };
    }

    @Override
    protected HotSpotRegistersProvider createRegisters() {
        Class<?> riscv64HotSpotRegisterConfig = RISCV64ReflectionUtil.lookupClass(false, "jdk.vm.ci.hotspot.riscv64.RISCV64HotSpotRegisterConfig");
        Register tp = (Register)RISCV64ReflectionUtil.readStaticField(riscv64HotSpotRegisterConfig, "tp");
        Register x27 = ShadowedRISCV64.x27;
        Register sp = (Register)RISCV64ReflectionUtil.readStaticField(riscv64HotSpotRegisterConfig, "sp");
        return new HotSpotRegisters(tp, x27, sp);
    }

    @Override
    protected HotSpotHostForeignCallsProvider createForeignCalls(HotSpotJVMCIRuntime jvmciRuntime, HotSpotGraalRuntimeProvider graalRuntime, MetaAccessProvider metaAccess, HotSpotCodeCacheProvider codeCache, HotSpotWordTypes wordTypes, Value[] nativeABICallerSaveRegisters) {
        return new RISCV64HotSpotForeignCallsProvider(jvmciRuntime, graalRuntime, metaAccess, codeCache, wordTypes, nativeABICallerSaveRegisters);
    }

    @Override
    protected HotSpotSuitesProvider createSuites(GraalHotSpotVMConfig config, HotSpotGraalRuntimeProvider runtime, CompilerConfiguration compilerConfiguration, GraphBuilderConfiguration.Plugins plugins, HotSpotRegistersProvider registers, HotSpotReplacementsImpl replacements, OptionValues options) {
        RISCV64HotSpotSuitesCreator suitesCreator = new RISCV64HotSpotSuitesCreator(compilerConfiguration, plugins);
        EmptyAddressLoweringPhase addressLoweringPhase = new EmptyAddressLoweringPhase();
        return new AddressLoweringHotSpotSuitesProvider(suitesCreator, config, runtime, addressLoweringPhase);
    }

    @Override
    protected HotSpotLoweringProvider createLowerer(HotSpotGraalRuntimeProvider graalRuntime, MetaAccessProvider metaAccess, HotSpotHostForeignCallsProvider foreignCalls, HotSpotRegistersProvider registers, HotSpotConstantReflectionProvider constantReflection, HotSpotPlatformConfigurationProvider platformConfig, HotSpotMetaAccessExtensionProvider metaAccessExtensionProvider, TargetDescription target) {
        return new RISCV64HotSpotLoweringProvider(graalRuntime, metaAccess, foreignCalls, registers, constantReflection, platformConfig, metaAccessExtensionProvider, target);
    }

    @Override
    protected Value[] createNativeABICallerSaveRegisters(GraalHotSpotVMConfig config, RegisterConfig regConfig) {
        ArrayList callerSave = new ArrayList(regConfig.getAllocatableRegisters().asList());
        callerSave.remove(ShadowedRISCV64.x2);
        callerSave.remove(ShadowedRISCV64.x8);
        callerSave.remove(ShadowedRISCV64.x9);
        callerSave.remove(ShadowedRISCV64.x18);
        callerSave.remove(ShadowedRISCV64.x19);
        callerSave.remove(ShadowedRISCV64.x20);
        callerSave.remove(ShadowedRISCV64.x21);
        callerSave.remove(ShadowedRISCV64.x22);
        callerSave.remove(ShadowedRISCV64.x23);
        callerSave.remove(ShadowedRISCV64.x24);
        callerSave.remove(ShadowedRISCV64.x25);
        callerSave.remove(ShadowedRISCV64.x26);
        callerSave.remove(ShadowedRISCV64.x27);
        callerSave.remove(ShadowedRISCV64.f8);
        callerSave.remove(ShadowedRISCV64.f9);
        callerSave.remove(ShadowedRISCV64.f18);
        callerSave.remove(ShadowedRISCV64.f19);
        callerSave.remove(ShadowedRISCV64.f20);
        callerSave.remove(ShadowedRISCV64.f21);
        callerSave.remove(ShadowedRISCV64.f22);
        callerSave.remove(ShadowedRISCV64.f23);
        callerSave.remove(ShadowedRISCV64.f24);
        callerSave.remove(ShadowedRISCV64.f25);
        callerSave.remove(ShadowedRISCV64.f26);
        callerSave.remove(ShadowedRISCV64.f27);
        Value[] nativeABICallerSaveRegisters = new Value[callerSave.size()];
        for (int i = 0; i < callerSave.size(); ++i) {
            nativeABICallerSaveRegisters[i] = ((Register)callerSave.get(i)).asValue();
        }
        return nativeABICallerSaveRegisters;
    }

    public String toString() {
        return "RISCV64";
    }

    public static class EmptyAddressLoweringPhase
    extends AddressLoweringPhase {
        @Override
        protected void run(StructuredGraph graph, CoreProviders context) {
        }
    }
}

