/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir;

import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.core.common.cfg.BasicBlock;
import org.graalvm.compiler.lir.LIR;
import org.graalvm.compiler.lir.StandardOp;

public final class LabelRef {
    private final LIR lir;
    private final BasicBlock<?> block;
    private final int suxIndex;

    public static LabelRef forSuccessor(LIR lir, BasicBlock<?> block, int suxIndex) {
        return new LabelRef(lir, block, suxIndex);
    }

    private LabelRef(LIR lir, BasicBlock<?> block, int suxIndex) {
        this.lir = lir;
        this.block = block;
        this.suxIndex = suxIndex;
    }

    public BasicBlock<?> getSourceBlock() {
        return this.block;
    }

    public BasicBlock<?> getTargetBlock() {
        return this.block.getSuccessorAt(this.suxIndex);
    }

    public Label label() {
        return ((StandardOp.LabelOp)this.lir.getLIRforBlock(this.getTargetBlock()).get(0)).getLabel();
    }

    public String toString() {
        return this.getSourceBlock() + " -> " + (this.suxIndex < this.block.getSuccessorCount() ? this.getTargetBlock() : "?");
    }
}

