/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.aarch64;

import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.SyncPort;
import org.graalvm.compiler.lir.aarch64.AArch64BigIntegerMultiplyToLenOp;
import org.graalvm.compiler.lir.aarch64.AArch64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

@SyncPort(from="https://github.com/openjdk/jdk/blob/d7b941640638b35f9ac1ef11cd6bf6ccb795c29a/src/hotspot/cpu/aarch64/stubGenerator_aarch64.cpp#L4665-L4699", sha1="0ad03e74934e230a64b9eb107a413248daa5be88")
public final class AArch64BigIntegerSquareToLenOp
extends AArch64LIRInstruction {
    public static final LIRInstructionClass<AArch64BigIntegerSquareToLenOp> TYPE = LIRInstructionClass.create(AArch64BigIntegerSquareToLenOp.class);
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    private Value xValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    private Value lenValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    private Value zValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    private Value zlenValue;
    @LIRInstruction.Temp
    protected Value[] temps;

    public AArch64BigIntegerSquareToLenOp(Value xValue, Value lenValue, Value zValue, Value zlenValue) {
        super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
        this.xValue = xValue;
        this.lenValue = lenValue;
        this.zValue = zValue;
        this.zlenValue = zlenValue;
        this.temps = new Value[]{AArch64.r5.asValue(), AArch64.r6.asValue(), AArch64.r10.asValue(), AArch64.r11.asValue(), AArch64.r12.asValue(), AArch64.r13.asValue(), AArch64.r14.asValue(), AArch64.r15.asValue(), AArch64.r16.asValue(), AArch64.r17.asValue(), AArch64.r19.asValue(), AArch64.r20.asValue(), AArch64.r21.asValue(), AArch64.r22.asValue(), AArch64.r23.asValue()};
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        GraalError.guarantee(this.xValue.getPlatformKind().equals(AArch64Kind.QWORD), "Invalid xValue kind: %s", (Object)this.xValue);
        GraalError.guarantee(this.lenValue.getPlatformKind().equals(AArch64Kind.DWORD), "Invalid lenValue kind: %s", (Object)this.lenValue);
        GraalError.guarantee(this.zValue.getPlatformKind().equals(AArch64Kind.QWORD), "Invalid zValue kind: %s", (Object)this.zValue);
        GraalError.guarantee(this.zlenValue.getPlatformKind().equals(AArch64Kind.DWORD), "Invalid zlenValue kind: %s", (Object)this.zlenValue);
        Register x = ValueUtil.asRegister((Value)this.xValue);
        Register xlen = ValueUtil.asRegister((Value)this.lenValue);
        Register y = AArch64.r5;
        Register ylen = AArch64.r6;
        Register z = ValueUtil.asRegister((Value)this.zValue);
        Register zlen = ValueUtil.asRegister((Value)this.zlenValue);
        masm.mov(64, y, x);
        masm.mov(32, ylen, xlen);
        AArch64BigIntegerMultiplyToLenOp.multiplyToLen(masm, x, xlen, y, ylen, z, zlen, AArch64.r10, AArch64.r11, AArch64.r12, AArch64.r13, AArch64.r14, AArch64.r15, AArch64.r16, AArch64.r17, AArch64.r19, AArch64.r20, AArch64.r21, AArch64.r22, AArch64.r23);
    }
}

