/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.aarch64;

import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.aarch64.AArch64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;

public class AArch64BitManipulationOp
extends AArch64LIRInstruction {
    private static final LIRInstructionClass<AArch64BitManipulationOp> TYPE = LIRInstructionClass.create(AArch64BitManipulationOp.class);
    @Opcode
    private final BitManipulationOpCode opcode;
    @LIRInstruction.Def
    protected AllocatableValue result;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue input;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    protected Value temp;

    public AArch64BitManipulationOp(LIRGeneratorTool tool, BitManipulationOpCode opcode, AllocatableValue result, AllocatableValue input) {
        super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
        this.opcode = opcode;
        this.result = result;
        this.input = input;
        this.temp = BitManipulationOpCode.POPCNT == opcode ? tool.newVariable(LIRKind.value((PlatformKind)AArch64Kind.V64_BYTE)) : Value.ILLEGAL;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        Register dst = ValueUtil.asRegister((Value)this.result);
        Register src = ValueUtil.asRegister((Value)this.input);
        int size = this.input.getPlatformKind().getSizeInBytes() * 8;
        switch (this.opcode) {
            case CLZ: {
                masm.clz(size, dst, src);
                break;
            }
            case BSR: {
                masm.clz(size, dst, src);
                masm.neg(size, dst, dst);
                masm.add(size, dst, dst, size - 1);
                break;
            }
            case CTZ: {
                masm.rbit(size, dst, src);
                masm.clz(size, dst, dst);
                break;
            }
            case BSWP: {
                masm.rev(size, dst, src);
                break;
            }
            case POPCNT: {
                assert (!Value.ILLEGAL.equals((Object)this.temp)) : "Auxiliary register not allocated.";
                Register vreg = ValueUtil.asRegister((Value)this.temp);
                masm.popcnt(size, dst, src, vreg);
                break;
            }
            default: {
                throw GraalError.shouldNotReachHereUnexpectedValue((Object)this.opcode);
            }
        }
    }

    public static enum BitManipulationOpCode {
        CTZ,
        BSR,
        BSWP,
        CLZ,
        POPCNT;

    }
}

