/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.aarch64;

import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.SyncPort;
import org.graalvm.compiler.lir.aarch64.AArch64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

@SyncPort(from="https://github.com/openjdk/jdk/blob/83d92672d4c2637fc37ddd873533c85a9b083904/src/hotspot/cpu/aarch64/aarch64.ad#L14131-L14155", sha1="5e7655c00a9d610fa3c992305c0f6aeba32b2d6c")
public class AArch64BitSwapOp
extends AArch64LIRInstruction {
    public static final LIRInstructionClass<AArch64BitSwapOp> TYPE = LIRInstructionClass.create(AArch64BitSwapOp.class);
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue result;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue input;

    public AArch64BitSwapOp(AllocatableValue result, AllocatableValue input) {
        super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
        AArch64Kind kind = (AArch64Kind)input.getPlatformKind();
        assert (kind == AArch64Kind.DWORD || kind == AArch64Kind.QWORD);
        this.result = result;
        this.input = input;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        int size = this.input.getPlatformKind().getSizeInBytes() * 8;
        masm.rbit(size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.input));
    }
}

