/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.aarch64;

import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.aarch64.AArch64ASIMDAssembler;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.SyncPort;
import org.graalvm.compiler.lir.aarch64.AArch64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;

@SyncPort(from="https://github.com/openjdk/jdk/blob/1fc726a8b34fcd41dae12a6d7c63232f9ccef3f4/src/hotspot/cpu/aarch64/macroAssembler_aarch64.hpp#L517-L520", sha1="95116a9e350c16c09e5eed9db1328a39cb909474")
public class AArch64FloatToHalfFloatOp
extends AArch64LIRInstruction {
    public static final LIRInstructionClass<AArch64FloatToHalfFloatOp> TYPE = LIRInstructionClass.create(AArch64FloatToHalfFloatOp.class);
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
    protected Value dstValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected Value srcValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected Value tmpValue;

    public AArch64FloatToHalfFloatOp(LIRGeneratorTool tool, Value dstValue, Value srcValue) {
        super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
        this.dstValue = dstValue;
        this.srcValue = srcValue;
        this.tmpValue = tool.newVariable(srcValue.getValueKind());
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        Register dst = ValueUtil.asRegister((Value)this.dstValue);
        Register src = ValueUtil.asRegister((Value)this.srcValue);
        Register tmp = ValueUtil.asRegister((Value)this.tmpValue);
        masm.fcvt(16, 32, tmp, src);
        masm.neon.smovGX(AArch64ASIMDAssembler.ElementSize.DoubleWord, AArch64ASIMDAssembler.ElementSize.HalfWord, dst, tmp, 0);
    }
}

