/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.aarch64;

import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.aarch64.AArch64Assembler;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.SyncPort;
import org.graalvm.compiler.lir.aarch64.AArch64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;

@Opcode(value="AARCH64_ROUND_FLOAT_TO_INTEGER")
@SyncPort(from="https://github.com/openjdk/jdk/blob/1fc726a8b34fcd41dae12a6d7c63232f9ccef3f4/src/hotspot/cpu/aarch64/macroAssembler_aarch64.cpp#L5774-L5822", sha1="76d47473bf8d1408bf6e7bf6b8a3d93c19dab9c6")
public class AArch64RoundFloatToIntegerOp
extends AArch64LIRInstruction {
    public static final LIRInstructionClass<AArch64RoundFloatToIntegerOp> TYPE = LIRInstructionClass.create(AArch64RoundFloatToIntegerOp.class);
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.HINT})
    protected AllocatableValue result;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue input;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue tmp;

    public AArch64RoundFloatToIntegerOp(LIRGeneratorTool tool, AllocatableValue result, AllocatableValue input) {
        super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
        this.result = result;
        this.input = input;
        this.tmp = tool.newVariable(input.getValueKind());
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        Register dst = ValueUtil.asRegister((Value)this.result);
        Register src = ValueUtil.asRegister((Value)this.input);
        Register ftmp = ValueUtil.asRegister((Value)this.tmp);
        Label labelDONE = new Label();
        try (AArch64MacroAssembler.ScratchRegister sc1 = masm.getScratchRegister();
             AArch64MacroAssembler.ScratchRegister sc2 = masm.getScratchRegister();){
            Register rscratch1 = sc1.getRegister();
            Register rscratch2 = sc2.getRegister();
            if (this.input.getPlatformKind() == AArch64Kind.SINGLE) {
                masm.fmov(32, rscratch1, src);
                masm.fcvtas(32, 32, dst, src);
                masm.eor(32, rscratch1, rscratch1, Integer.MIN_VALUE);
                masm.mov(rscratch2, Float.floatToIntBits(8388608.0f));
                masm.cmp(32, rscratch1, rscratch2);
                masm.branchConditionally(AArch64Assembler.ConditionFlag.HS, labelDONE);
                masm.fmov(32, ftmp, 0.5);
                masm.fadd(32, ftmp, src, ftmp);
                masm.fcvtms(32, 32, dst, ftmp);
            } else {
                masm.fmov(64, rscratch1, src);
                masm.fcvtas(64, 64, dst, src);
                masm.eor(64, rscratch1, rscratch1, Long.MIN_VALUE);
                masm.mov(rscratch2, Double.doubleToLongBits(4.503599627370496E15));
                masm.cmp(64, rscratch1, rscratch2);
                masm.branchConditionally(AArch64Assembler.ConditionFlag.HS, labelDONE);
                masm.fmov(64, ftmp, 0.5);
                masm.fadd(64, ftmp, src, ftmp);
                masm.fcvtms(64, 64, dst, ftmp);
            }
        }
        masm.bind(labelDONE);
    }
}

