/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.alloc.lsra;

import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.Indent;
import org.graalvm.compiler.lir.alloc.lsra.Interval;
import org.graalvm.compiler.lir.alloc.lsra.LinearScan;

public class IntervalWalker {
    protected final LinearScan allocator;
    protected Interval.RegisterBindingLists unhandledLists;
    protected Interval.RegisterBindingLists activeLists;
    protected Interval.RegisterBindingLists inactiveLists;
    protected int currentPosition;
    protected Interval.RegisterBinding currentBinding;

    protected boolean activateCurrent(Interval currentInterval) {
        return true;
    }

    void walk() {
        this.walkTo(Integer.MAX_VALUE);
    }

    IntervalWalker(LinearScan allocator, Interval unhandledFixed, Interval unhandledAny) {
        this.allocator = allocator;
        this.unhandledLists = new Interval.RegisterBindingLists(unhandledFixed, unhandledAny, allocator.intervalEndMarker);
        this.activeLists = new Interval.RegisterBindingLists(allocator.intervalEndMarker, allocator.intervalEndMarker, allocator.intervalEndMarker);
        this.inactiveLists = new Interval.RegisterBindingLists(allocator.intervalEndMarker, allocator.intervalEndMarker, allocator.intervalEndMarker);
        this.currentPosition = -1;
    }

    protected void removeFromList(Interval interval) {
        if (interval.state == Interval.State.Active) {
            this.activeLists.remove(Interval.RegisterBinding.Any, interval);
        } else {
            assert (interval.state == Interval.State.Inactive) : "invalid state";
            this.inactiveLists.remove(Interval.RegisterBinding.Any, interval);
        }
    }

    private void walkTo(Interval.State state, int from) {
        assert (state == Interval.State.Active || state == Interval.State.Inactive) : "wrong state";
        for (Interval.RegisterBinding binding : Interval.RegisterBinding.VALUES) {
            this.walkTo(state, from, binding);
        }
    }

    private void walkTo(Interval.State state, int from, Interval.RegisterBinding binding) {
        Interval prev;
        Interval prevprev = null;
        Interval next = prev = state == Interval.State.Active ? this.activeLists.get(binding) : this.inactiveLists.get(binding);
        while (next.currentFrom() <= from) {
            Interval cur = next;
            next = cur.next;
            boolean rangeHasChanged = false;
            while (cur.currentTo() <= from) {
                cur.nextRange();
                rangeHasChanged = true;
            }
            boolean bl = rangeHasChanged = rangeHasChanged || state == Interval.State.Inactive && cur.currentFrom() <= from;
            if (rangeHasChanged) {
                Interval.State newState;
                if (prevprev == null) {
                    if (state == Interval.State.Active) {
                        this.activeLists.set(binding, next);
                    } else {
                        this.inactiveLists.set(binding, next);
                    }
                } else {
                    prevprev.next = next;
                }
                prev = next;
                if (cur.currentAtEnd()) {
                    cur.state = newState = Interval.State.Handled;
                } else {
                    if (cur.currentFrom() <= from) {
                        this.activeLists.addToListSortedByCurrentFromPositions(binding, cur);
                        newState = Interval.State.Active;
                    } else {
                        this.inactiveLists.addToListSortedByCurrentFromPositions(binding, cur);
                        newState = Interval.State.Inactive;
                    }
                    cur.state = newState;
                    if (prev == cur) {
                        assert (state == newState);
                        prevprev = prev;
                        prev = cur.next;
                    }
                }
                this.intervalMoved(cur, state, newState);
                continue;
            }
            prevprev = prev;
            prev = cur.next;
        }
    }

    private Interval nextInterval(int toOpId) {
        Interval currentInterval;
        Interval.RegisterBinding binding;
        Interval any = this.unhandledLists.any;
        Interval fixed = this.unhandledLists.fixed;
        if (!any.isEndMarker()) {
            Interval.RegisterBinding registerBinding = binding = !fixed.isEndMarker() && fixed.from() <= any.from() ? Interval.RegisterBinding.Fixed : Interval.RegisterBinding.Any;
            assert (binding == Interval.RegisterBinding.Fixed && fixed.from() <= any.from() || binding == Interval.RegisterBinding.Any && any.from() <= fixed.from()) : "wrong interval!!!";
            assert (any.isEndMarker() || fixed.isEndMarker() || any.from() != fixed.from() || binding == Interval.RegisterBinding.Fixed) : "if fixed and any-Interval start at same position, fixed must be processed first";
        } else if (!fixed.isEndMarker()) {
            binding = Interval.RegisterBinding.Fixed;
        } else {
            return null;
        }
        if (toOpId < (currentInterval = this.unhandledLists.get(binding)).from()) {
            return null;
        }
        this.currentBinding = binding;
        this.unhandledLists.set(binding, currentInterval.next);
        currentInterval.next = this.allocator.intervalEndMarker;
        currentInterval.rewindRange();
        return currentInterval;
    }

    protected void walkTo(int toOpId) {
        assert (this.currentPosition <= toOpId) : "can not walk backwards";
        Interval currentInterval = this.nextInterval(toOpId);
        while (currentInterval != null) {
            int opId;
            this.currentPosition = opId = currentInterval.from();
            this.updateUnhandledStackIntervals(opId);
            this.walkTo(Interval.State.Active, opId);
            this.walkTo(Interval.State.Inactive, opId);
            DebugContext debug = this.allocator.getDebug();
            try (Indent indent = debug.logAndIndent("walk to op %d", opId);){
                currentInterval.state = Interval.State.Active;
                if (this.activateCurrent(currentInterval)) {
                    this.activeLists.addToListSortedByCurrentFromPositions(this.currentBinding, currentInterval);
                    this.intervalMoved(currentInterval, Interval.State.Unhandled, Interval.State.Active);
                }
            }
            currentInterval = this.nextInterval(toOpId);
        }
        this.currentPosition = toOpId;
        if (this.currentPosition <= this.allocator.maxOpId()) {
            this.updateUnhandledStackIntervals(toOpId);
            this.walkTo(Interval.State.Active, toOpId);
            this.walkTo(Interval.State.Inactive, toOpId);
        }
    }

    private void intervalMoved(Interval interval, Interval.State from, Interval.State to) {
        DebugContext debug = this.allocator.getDebug();
        if (debug.isLogEnabled()) {
            debug.log("interval moved from %s to %s: %s", (Object)from, (Object)to, (Object)interval.logString(this.allocator));
        }
    }

    private void updateUnhandledStackIntervals(int opId) {
        Interval currentInterval = this.unhandledLists.get(Interval.RegisterBinding.Stack);
        while (!currentInterval.isEndMarker() && currentInterval.from() <= opId) {
            Interval next = currentInterval.next;
            if (currentInterval.to() > opId) {
                currentInterval.state = Interval.State.Active;
                this.activeLists.addToListSortedByCurrentFromPositions(Interval.RegisterBinding.Stack, currentInterval);
                this.intervalMoved(currentInterval, Interval.State.Unhandled, Interval.State.Active);
            } else {
                currentInterval.state = Interval.State.Handled;
                this.intervalMoved(currentInterval, Interval.State.Unhandled, Interval.State.Handled);
            }
            currentInterval = next;
        }
        this.unhandledLists.set(Interval.RegisterBinding.Stack, currentInterval);
    }
}

