/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.alloc.lsra;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.cfg.BasicBlock;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.debug.Indent;
import org.graalvm.compiler.lir.CastValue;
import org.graalvm.compiler.lir.ConstantValue;
import org.graalvm.compiler.lir.InstructionValueProcedure;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRValueUtil;
import org.graalvm.compiler.lir.StandardOp;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.alloc.lsra.Interval;
import org.graalvm.compiler.lir.alloc.lsra.LinearScan;
import org.graalvm.compiler.lir.alloc.lsra.LinearScanAllocationPhase;
import org.graalvm.compiler.lir.gen.LIRGenerationResult;
import org.graalvm.compiler.lir.phases.AllocationPhase;

public class LinearScanAssignLocationsPhase
extends LinearScanAllocationPhase {
    protected final LinearScan allocator;
    private final InstructionValueProcedure assignProc = new InstructionValueProcedure(){

        @Override
        public Value doValue(LIRInstruction instruction, Value value, LIRInstruction.OperandMode mode, EnumSet<LIRInstruction.OperandFlag> flags) {
            if (LIRValueUtil.isVariable(value)) {
                Value location = LinearScanAssignLocationsPhase.this.colorLirOperand(instruction, LIRValueUtil.asVariable(value), mode);
                if (LIRValueUtil.isCast(value)) {
                    GraalError.guarantee(mode == LIRInstruction.OperandMode.USE || mode == LIRInstruction.OperandMode.ALIVE, "Invalid application of CastValue");
                    CastValue cast = (CastValue)value;
                    return LIRValueUtil.changeValueKind(location, cast.getValueKind(), true);
                }
                return location;
            }
            if (LIRValueUtil.isCast(value)) {
                GraalError.guarantee(mode == LIRInstruction.OperandMode.USE || mode == LIRInstruction.OperandMode.ALIVE, "Invalid application of CastValue");
                CastValue cast = (CastValue)value;
                return LIRValueUtil.changeValueKind((Value)cast.underlyingValue(), cast.getValueKind(), false);
            }
            return value;
        }
    };
    private final InstructionValueProcedure debugInfoProc = new InstructionValueProcedure(){

        @Override
        public Value doValue(LIRInstruction instruction, Value value, LIRInstruction.OperandMode mode, EnumSet<LIRInstruction.OperandFlag> flags) {
            return LinearScanAssignLocationsPhase.this.debugInfoProcedure(instruction, value);
        }
    };

    public LinearScanAssignLocationsPhase(LinearScan allocator) {
        this.allocator = allocator;
    }

    @Override
    protected void run(TargetDescription target, LIRGenerationResult lirGenRes, AllocationPhase.AllocationContext context) {
        this.assignLocations();
    }

    protected Value colorLirOperand(LIRInstruction op, Variable operand, LIRInstruction.OperandMode mode) {
        int opId = op.id();
        Interval interval = this.allocator.intervalFor((Value)operand);
        assert (interval != null) : "interval must exist";
        if (opId != -1) {
            LIRInstruction instr;
            BasicBlock<?> block;
            if (this.allocator.detailedAsserts && (block = this.allocator.blockForId(opId)).getSuccessorCount() <= 1 && opId == this.allocator.getLastLirInstructionId(block) && (instr = this.allocator.getLIR().getLIRforBlock(block).get(this.allocator.getLIR().getLIRforBlock(block).size() - 1)) instanceof StandardOp.JumpOp && this.allocator.getBlockData(block).liveOut.get(this.allocator.operandNumber((Value)operand))) assert (false) : String.format("can't get split child for the last branch of a block because the information would be incorrect (moves are inserted before the branch in resolveDataFlow) block=%s, instruction=%s, operand=%s", new Object[]{block, instr, operand});
            interval = this.allocator.splitChildAtOpId(interval, opId, mode);
        }
        if (ValueUtil.isIllegal((Value)interval.location()) && interval.canMaterialize()) {
            assert (mode != LIRInstruction.OperandMode.DEF);
            return new ConstantValue(interval.kind(), interval.getMaterializedValue());
        }
        return interval.location();
    }

    private Value debugInfoProcedure(LIRInstruction op, Value operand) {
        LIRInstruction instr;
        if (LIRValueUtil.isVirtualStackSlot(operand) || ValueUtil.isRegister((Value)operand)) {
            return operand;
        }
        int tempOpId = op.id();
        LIRInstruction.OperandMode mode = LIRInstruction.OperandMode.USE;
        BasicBlock<?> block = this.allocator.blockForId(tempOpId);
        if (block.getSuccessorCount() == 1 && tempOpId == this.allocator.getLastLirInstructionId(block) && (instr = this.allocator.getLIR().getLIRforBlock(block).get(this.allocator.getLIR().getLIRforBlock(block).size() - 1)) instanceof StandardOp.JumpOp && this.allocator.getBlockData(block).liveOut.get(this.allocator.operandNumber(operand))) {
            tempOpId = this.allocator.getFirstLirInstructionId((BasicBlock<?>)block.getSuccessorAt(0));
            mode = LIRInstruction.OperandMode.DEF;
        }
        Value result = this.colorLirOperand(op, LIRValueUtil.asVariable(operand), mode);
        assert (!this.allocator.hasCall(tempOpId) || LIRValueUtil.isStackSlotValue(result) || LIRValueUtil.isJavaConstant(result) || !this.allocator.isCallerSave(result)) : "cannot have caller-save register operands at calls";
        return result;
    }

    private void assignLocations(ArrayList<LIRInstruction> instructions) {
        int numInst = instructions.size();
        boolean hasDead = false;
        for (int j = 0; j < numInst; ++j) {
            LIRInstruction op = instructions.get(j);
            if (op == null) {
                hasDead = true;
                continue;
            }
            try {
                LIRInstruction newOp = this.assignLocations(op);
                if (op != newOp) {
                    instructions.set(j, newOp);
                }
                if (newOp != null) continue;
                hasDead = true;
                continue;
            }
            catch (GraalError e) {
                throw e.addContext("lir instruction", "@" + op.id() + " " + op.getClass().getName() + " " + op);
            }
        }
        if (hasDead) {
            instructions.removeAll(Collections.singleton(null));
        }
    }

    protected LIRInstruction assignLocations(LIRInstruction inputOp) {
        StandardOp.ValueMoveOp move;
        Value inputOperand;
        StandardOp.ValueMoveOp valueMoveOp;
        AllocatableValue input;
        AllocatableValue result;
        assert (inputOp != null);
        LIRInstruction op = inputOp;
        if (StandardOp.MoveOp.isMoveOp(op) && LIRValueUtil.isVariable((Value)(result = StandardOp.MoveOp.asMoveOp(op).getResult())) && this.allocator.isMaterialized(result, op.id(), LIRInstruction.OperandMode.DEF)) {
            return null;
        }
        if (StandardOp.ValueMoveOp.isValueMoveOp(op) && LIRValueUtil.isVariable((Value)(input = (valueMoveOp = StandardOp.ValueMoveOp.asValueMoveOp(op)).getInput())) && (inputOperand = this.colorLirOperand(op, LIRValueUtil.asVariable((Value)input), LIRInstruction.OperandMode.USE)) instanceof ConstantValue) {
            op = this.allocator.getSpillMoveFactory().createLoad(valueMoveOp.getResult(), ((ConstantValue)inputOperand).getConstant());
        }
        op.forEachInput(this.assignProc);
        op.forEachAlive(this.assignProc);
        op.forEachTemp(this.assignProc);
        op.forEachOutput(this.assignProc);
        op.forEachState(this.debugInfoProc);
        if (StandardOp.ValueMoveOp.isValueMoveOp(op) && (move = StandardOp.ValueMoveOp.asValueMoveOp(op)).getInput().equals((Object)move.getResult())) {
            return null;
        }
        return op;
    }

    private void assignLocations() {
        DebugContext debug = this.allocator.getDebug();
        try (Indent indent = debug.logAndIndent("assign locations");){
            for (int blockId : this.allocator.sortedBlocks()) {
                BasicBlock<?> block = this.allocator.getLIR().getBlockById(blockId);
                try (Indent indent2 = debug.logAndIndent("assign locations in block B%d", block.getId());){
                    this.assignLocations(this.allocator.getLIR().getLIRforBlock(block));
                }
            }
        }
    }
}

