/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.alloc.lsra;

import java.util.ArrayList;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.cfg.BasicBlock;
import org.graalvm.compiler.debug.Assertions;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.Indent;
import org.graalvm.compiler.lir.LIRInsertionBuffer;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRValueUtil;
import org.graalvm.compiler.lir.StandardOp;
import org.graalvm.compiler.lir.alloc.lsra.Interval;
import org.graalvm.compiler.lir.alloc.lsra.LinearScan;
import org.graalvm.compiler.lir.alloc.lsra.LinearScanAllocationPhase;
import org.graalvm.compiler.lir.gen.LIRGenerationResult;
import org.graalvm.compiler.lir.phases.AllocationPhase;
import org.graalvm.compiler.lir.phases.LIRPhase;
import org.graalvm.compiler.options.NestedBooleanOptionKey;
import org.graalvm.compiler.options.OptionKey;

public class LinearScanEliminateSpillMovePhase
extends LinearScanAllocationPhase {
    private static final LinearScan.IntervalPredicate mustStoreAtDefinition = new LinearScan.IntervalPredicate(){

        @Override
        public boolean apply(Interval i) {
            return i.isSplitParent() && i.spillState() == Interval.SpillState.StoreAtDefinition;
        }
    };
    protected final LinearScan allocator;

    protected LinearScanEliminateSpillMovePhase(LinearScan allocator) {
        this.allocator = allocator;
    }

    @Override
    protected void run(TargetDescription target, LIRGenerationResult lirGenRes, AllocationPhase.AllocationContext context) {
        this.eliminateSpillMoves(lirGenRes);
    }

    protected int firstInstructionOfInterest() {
        return 1;
    }

    void eliminateSpillMoves(LIRGenerationResult res) {
        DebugContext debug = this.allocator.getDebug();
        try (Indent indent = debug.logAndIndent("Eliminating unnecessary spill moves");){
            Interval interval = (Interval)this.allocator.createUnhandledLists(mustStoreAtDefinition, null).getLeft();
            if (Assertions.detailedAssertionsEnabled(this.allocator.getOptions())) {
                LinearScanEliminateSpillMovePhase.checkIntervals(debug, interval);
            }
            LIRInsertionBuffer insertionBuffer = new LIRInsertionBuffer();
            for (int blockId : this.allocator.sortedBlocks()) {
                BasicBlock<?> block = this.allocator.getLIR().getBlockById(blockId);
                try (Indent indent1 = debug.logAndIndent("Handle %s", block);){
                    ArrayList<LIRInstruction> instructions = this.allocator.getLIR().getLIRforBlock(block);
                    int numInst = instructions.size();
                    for (int j = this.firstInstructionOfInterest(); j < numInst; ++j) {
                        LIRInstruction op = instructions.get(j);
                        int opId = op.id();
                        if (opId == -1) {
                            StandardOp.MoveOp move = StandardOp.MoveOp.asMoveOp(op);
                            if (!Options.LIROptLSRAEliminateSpillMoves.getValue(this.allocator.getOptions()).booleanValue() || !this.canEliminateSpillMove(block, move)) continue;
                            if (debug.isLogEnabled()) {
                                if (StandardOp.ValueMoveOp.isValueMoveOp(op)) {
                                    StandardOp.ValueMoveOp vmove = StandardOp.ValueMoveOp.asValueMoveOp(op);
                                    debug.log("eliminating move from interval %d (%s) to %d (%s) in block %s", this.allocator.operandNumber((Value)vmove.getInput()), (Object)vmove.getInput(), (Object)this.allocator.operandNumber((Value)vmove.getResult()), (Object)vmove.getResult(), block);
                                } else {
                                    StandardOp.LoadConstantOp load = StandardOp.LoadConstantOp.asLoadConstantOp(op);
                                    debug.log("eliminating constant load from %s to %d (%s) in block %s", load.getConstant(), (Object)this.allocator.operandNumber((Value)load.getResult()), (Object)load.getResult(), block);
                                }
                            }
                            instructions.set(j, null);
                            continue;
                        }
                        assert (interval.isEndMarker() || interval.spillDefinitionPos() >= opId) : "invalid order";
                        assert (interval.isEndMarker() || interval.isSplitParent() && interval.spillState() == Interval.SpillState.StoreAtDefinition) : "invalid interval";
                        while (!interval.isEndMarker() && interval.spillDefinitionPos() == opId) {
                            if (!interval.canMaterialize()) {
                                AllocatableValue toLocation;
                                AllocatableValue fromLocation;
                                if (!insertionBuffer.initialized()) {
                                    insertionBuffer.init(instructions);
                                }
                                if (!(fromLocation = interval.location()).equals((Object)(toLocation = LinearScan.canonicalSpillOpr(interval)))) {
                                    assert (ValueUtil.isRegister((Value)fromLocation)) : "from operand must be a register but is: " + fromLocation + " toLocation=" + toLocation + " spillState=" + interval.spillState();
                                    assert (LIRValueUtil.isStackSlotValue((Value)toLocation)) : "to operand must be a stack slot";
                                    LIRInstruction move = this.allocator.getSpillMoveFactory().createMove(toLocation, (Value)fromLocation);
                                    insertionBuffer.append(j + 1, move);
                                    move.setComment(res, "LSRAEliminateSpillMove: store at definition");
                                    if (debug.isLogEnabled()) {
                                        debug.log("inserting move after definition of interval %d to stack slot %s at opId %d", (Object)interval.operandNumber, (Object)interval.spillSlot(), (Object)opId);
                                    }
                                }
                            }
                            interval = interval.next;
                        }
                    }
                    if (!insertionBuffer.initialized()) continue;
                    insertionBuffer.finish();
                }
            }
            assert (interval.isEndMarker()) : "missed an interval";
        }
    }

    protected boolean canEliminateSpillMove(BasicBlock<?> block, StandardOp.MoveOp move) {
        assert (LIRValueUtil.isVariable((Value)move.getResult())) : "LinearScan inserts only moves to variables: " + move;
        Interval curInterval = this.allocator.intervalFor((Value)move.getResult());
        if (!ValueUtil.isRegister((Value)curInterval.location()) && curInterval.alwaysInMemory()) {
            assert (LIRValueUtil.isStackSlotValue((Value)curInterval.location())) : "Not a stack slot: " + curInterval.location();
            return true;
        }
        return false;
    }

    private static void checkIntervals(DebugContext debug, Interval interval) {
        Interval prev = null;
        Interval temp = interval;
        while (!temp.isEndMarker()) {
            assert (temp.spillDefinitionPos() > 0) : "invalid spill definition pos";
            if (prev != null) {
                assert (temp.from() >= prev.from()) : "intervals not sorted";
                assert (temp.spillDefinitionPos() >= prev.spillDefinitionPos()) : "when intervals are sorted by from :  then they must also be sorted by spillDefinitionPos";
            }
            assert (temp.spillSlot() != null || temp.canMaterialize()) : "interval has no spill slot assigned";
            assert (temp.spillDefinitionPos() >= temp.from()) : "invalid order";
            assert (temp.spillDefinitionPos() <= temp.from() + 2) : "only intervals defined once at their start-pos can be optimized";
            if (debug.isLogEnabled()) {
                debug.log("interval %d (from %d to %d) must be stored at %d", temp.operandNumber, (Object)temp.from(), (Object)temp.to(), (Object)temp.spillDefinitionPos());
            }
            prev = temp;
            temp = temp.next;
        }
    }

    public static class Options {
        public static final OptionKey<Boolean> LIROptLSRAEliminateSpillMoves = new NestedBooleanOptionKey(LIRPhase.Options.LIROptimization, true);
    }
}

