/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.alloc.lsra;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.EnumSet;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterArray;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.PermanentBailoutException;
import org.graalvm.compiler.core.common.cfg.BasicBlock;
import org.graalvm.compiler.core.common.util.BitMap2D;
import org.graalvm.compiler.debug.Assertions;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.debug.Indent;
import org.graalvm.compiler.lir.InstructionStateProcedure;
import org.graalvm.compiler.lir.InstructionValueConsumer;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRValueUtil;
import org.graalvm.compiler.lir.StandardOp;
import org.graalvm.compiler.lir.ValueConsumer;
import org.graalvm.compiler.lir.alloc.lsra.Interval;
import org.graalvm.compiler.lir.alloc.lsra.LinearScan;
import org.graalvm.compiler.lir.alloc.lsra.LinearScanAllocationPhase;
import org.graalvm.compiler.lir.alloc.lsra.Range;
import org.graalvm.compiler.lir.debug.LIRGenerationDebugContext;
import org.graalvm.compiler.lir.gen.LIRGenerationResult;
import org.graalvm.compiler.lir.phases.AllocationPhase;
import org.graalvm.compiler.lir.util.IndexedValueMap;

public class LinearScanLifetimeAnalysisPhase
extends LinearScanAllocationPhase {
    protected final LinearScan allocator;
    protected final DebugContext debug;
    private BitMap2D intervalInLoop;

    protected LinearScanLifetimeAnalysisPhase(LinearScan linearScan) {
        this.allocator = linearScan;
        this.debug = this.allocator.getDebug();
    }

    @Override
    protected void run(TargetDescription target, LIRGenerationResult lirGenRes, AllocationPhase.AllocationContext context) {
        this.numberInstructions();
        this.debug.dump(3, lirGenRes.getLIR(), "Before register allocation");
        this.computeLocalLiveSets();
        this.computeGlobalLiveSets();
        this.buildIntervals(Assertions.detailedAssertionsEnabled(this.allocator.getOptions()));
    }

    boolean isIntervalInLoop(int interval, int loop) {
        return this.intervalInLoop.at(interval, loop);
    }

    protected void numberInstructions() {
        this.allocator.initIntervals();
        ValueConsumer setVariableConsumer = (value, mode, flags) -> {
            if (LIRValueUtil.isVariable(value)) {
                this.allocator.getOrCreateInterval(LIRValueUtil.asVariable(value));
            }
        };
        int numInstructions = 0;
        for (int blockId : this.allocator.sortedBlocks()) {
            BasicBlock<?> block = this.allocator.getLIR().getBlockById(blockId);
            numInstructions += this.allocator.getLIR().getLIRforBlock(block).size();
        }
        this.allocator.initOpIdMaps(numInstructions);
        int opId = 0;
        int index = 0;
        for (int blockId : this.allocator.sortedBlocks()) {
            BasicBlock<?> block = this.allocator.getLIR().getBlockById(blockId);
            this.allocator.initBlockData(block);
            ArrayList<LIRInstruction> instructions = this.allocator.getLIR().getLIRforBlock(block);
            int numInst = instructions.size();
            for (int j = 0; j < numInst; ++j) {
                LIRInstruction op = instructions.get(j);
                op.setId(opId);
                this.allocator.putOpIdMaps(index, op, block);
                assert (this.allocator.instructionForId(opId) == op) : "must match";
                op.visitEachTemp(setVariableConsumer);
                op.visitEachOutput(setVariableConsumer);
                ++index;
                opId += 2;
            }
        }
        assert (index == numInstructions) : "must match";
        assert (index << 1 == opId) : "must match: " + (index << 1);
    }

    void computeLocalLiveSets() {
        int liveSize = this.allocator.liveSetSize();
        int variables = this.allocator.operandSize();
        int loops = this.allocator.numLoops();
        long nBits = (long)variables * (long)loops;
        try {
            if (nBits > Integer.MAX_VALUE) {
                throw new OutOfMemoryError();
            }
            this.intervalInLoop = new BitMap2D(variables, loops);
        }
        catch (OutOfMemoryError e) {
            throw new PermanentBailoutException(e, "Cannot handle %d variables in %d loops", variables, loops);
        }
        try {
            BitSet liveGenScratch = new BitSet(liveSize);
            BitSet liveKillScratch = new BitSet(liveSize);
            for (int blockId : this.allocator.sortedBlocks()) {
                BasicBlock<?> block = this.allocator.getLIR().getBlockById(blockId);
                try (Indent indent = this.debug.logAndIndent("compute local live sets for block %s", block);){
                    liveGenScratch.clear();
                    liveKillScratch.clear();
                    ArrayList<LIRInstruction> instructions = this.allocator.getLIR().getLIRforBlock(block);
                    int numInst = instructions.size();
                    ValueConsumer useConsumer = (operand, mode, flags) -> {
                        if (LIRValueUtil.isVariable(operand)) {
                            int operandNum = this.getOperandNumber(operand);
                            if (!liveKillScratch.get(operandNum)) {
                                liveGenScratch.set(operandNum);
                                if (this.debug.isLogEnabled()) {
                                    this.debug.log("liveGen for operand %d(%s)", operandNum, (Object)operand);
                                }
                            }
                            if (block.getLoop() != null) {
                                this.intervalInLoop.setBit(operandNum, block.getLoop().getIndex());
                            }
                        }
                        if (this.allocator.detailedAsserts) {
                            this.verifyInput(block, liveKillScratch, operand);
                        }
                    };
                    ValueConsumer stateConsumer = (operand, mode, flags) -> {
                        int operandNum;
                        if (LinearScan.isVariableOrRegister(operand) && this.allocator.isProcessed(operand) && !liveKillScratch.get(operandNum = this.getOperandNumber(operand))) {
                            liveGenScratch.set(operandNum);
                            if (this.debug.isLogEnabled()) {
                                this.debug.log("liveGen in state for operand %d(%s)", operandNum, (Object)operand);
                            }
                        }
                    };
                    ValueConsumer defConsumer = (operand, mode, flags) -> {
                        if (LIRValueUtil.isVariable(operand)) {
                            int varNum = this.getOperandNumber(operand);
                            liveKillScratch.set(varNum);
                            if (this.debug.isLogEnabled()) {
                                this.debug.log("liveKill for operand %d(%s)", varNum, (Object)operand);
                            }
                            if (block.getLoop() != null) {
                                this.intervalInLoop.setBit(varNum, block.getLoop().getIndex());
                            }
                        }
                        if (this.allocator.detailedAsserts) {
                            this.verifyTemp(liveKillScratch, operand);
                        }
                    };
                    for (int j = 0; j < numInst; ++j) {
                        LIRInstruction op = instructions.get(j);
                        try (Indent indent2 = this.debug.logAndIndent("handle op %d: %s", op.id(), (Object)op);){
                            op.visitEachInput(useConsumer);
                            op.visitEachAlive(useConsumer);
                            op.visitEachState(stateConsumer);
                            op.visitEachTemp(defConsumer);
                            op.visitEachOutput(defConsumer);
                            continue;
                        }
                    }
                    LinearScan.BlockData blockSets = this.allocator.getBlockData(block);
                    blockSets.liveGen = LinearScanLifetimeAnalysisPhase.trimClone(liveGenScratch);
                    blockSets.liveKill = LinearScanLifetimeAnalysisPhase.trimClone(liveKillScratch);
                    blockSets.liveIn = new BitSet(0);
                    blockSets.liveOut = new BitSet(0);
                    if (!this.debug.isLogEnabled()) continue;
                    this.debug.log("liveGen  B%d %s", block.getId(), (Object)blockSets.liveGen);
                    this.debug.log("liveKill B%d %s", block.getId(), (Object)blockSets.liveKill);
                }
            }
        }
        catch (OutOfMemoryError oom) {
            throw new PermanentBailoutException(oom, "Out-of-memory during live set allocation of size %d", liveSize);
        }
    }

    private void verifyTemp(BitSet liveKill, Value operand) {
        if (ValueUtil.isRegister((Value)operand) && this.allocator.isProcessed(operand)) {
            liveKill.set(this.getOperandNumber(operand));
        }
    }

    private void verifyInput(BasicBlock<?> block, BitSet liveKill, Value operand) {
        if (ValueUtil.isRegister((Value)operand) && block != this.allocator.getLIR().getControlFlowGraph().getStartBlock() && this.allocator.isProcessed(operand)) assert (liveKill.get(this.getOperandNumber(operand))) : "using fixed register " + ValueUtil.asRegister((Value)operand) + " that is not defined in this block " + block;
    }

    protected int getOperandNumber(Value operand) {
        return this.allocator.operandNumber(operand);
    }

    protected void computeGlobalLiveSets() {
        try (Indent indent = this.debug.logAndIndent("compute global live sets");){
            boolean changeOccurred;
            int numBlocks = this.allocator.blockCount();
            int iterationCount = 0;
            BitSet scratch = new BitSet(this.allocator.liveSetSize());
            do {
                changeOccurred = false;
                try (Indent indent2 = this.debug.logAndIndent("new iteration %d", iterationCount);){
                    for (int i = numBlocks - 1; i >= 0; --i) {
                        BasicBlock<?> block = this.allocator.blockAt(i);
                        LinearScan.BlockData blockSets = this.allocator.getBlockData(block);
                        boolean changeOccurredInBlock = false;
                        int n = block.getSuccessorCount();
                        if (n > 0) {
                            scratch.clear();
                            if (n > 0) {
                                for (int j = 0; j < block.getSuccessorCount(); ++j) {
                                    Object successor = block.getSuccessorAt(j);
                                    scratch.or(this.allocator.getBlockData(successor).liveIn);
                                }
                            }
                            if (!blockSets.liveOut.equals(scratch)) {
                                blockSets.liveOut = LinearScanLifetimeAnalysisPhase.trimClone(scratch);
                                changeOccurred = true;
                                changeOccurredInBlock = true;
                            }
                        }
                        if (iterationCount != 0 && !changeOccurredInBlock) continue;
                        BitSet liveIn = blockSets.liveIn;
                        liveIn.or(blockSets.liveOut);
                        liveIn.andNot(blockSets.liveKill);
                        liveIn.or(blockSets.liveGen);
                        liveIn.clone();
                        if (!this.debug.isLogEnabled()) continue;
                        this.debug.log("block %d: livein = %s,  liveout = %s", (Object)block.getId(), (Object)liveIn, (Object)blockSets.liveOut);
                    }
                    if (changeOccurred && ++iterationCount > 50) {
                        throw new PermanentBailoutException("too many iterations in computeGlobalLiveSets");
                    }
                }
            } while (changeOccurred);
            if (Assertions.detailedAssertionsEnabled(this.allocator.getOptions())) {
                this.verifyLiveness();
            }
            Object startBlock = this.allocator.getLIR().getControlFlowGraph().getStartBlock();
            if (this.allocator.getBlockData(startBlock).liveIn.cardinality() != 0) {
                if (Assertions.detailedAssertionsEnabled(this.allocator.getOptions())) {
                    this.reportFailure(numBlocks);
                }
                BitSet bs = this.allocator.getBlockData(startBlock).liveIn;
                StringBuilder sb = new StringBuilder();
                int i = bs.nextSetBit(0);
                while (i >= 0) {
                    int variableNumber = this.allocator.getVariableNumber(i);
                    if (variableNumber >= 0) {
                        sb.append("v").append(variableNumber);
                    } else {
                        sb.append(this.allocator.getRegisters().get(i));
                    }
                    sb.append(System.lineSeparator());
                    if (i == Integer.MAX_VALUE) break;
                    i = bs.nextSetBit(i + 1);
                }
                throw new GraalError("liveIn set of first block must be empty: " + this.allocator.getBlockData(startBlock).liveIn + " Live operands:" + sb.toString());
            }
        }
    }

    private static BitSet trimClone(BitSet set) {
        BitSet trimmedSet = new BitSet(0);
        trimmedSet.or(set);
        return trimmedSet;
    }

    protected void reportFailure(int numBlocks) {
        try (DebugContext.Scope s = this.debug.forceLog();
             Indent indent = this.debug.logAndIndent("report failure");){
            BitSet startBlockLiveIn = this.allocator.getBlockData(this.allocator.getLIR().getControlFlowGraph().getStartBlock()).liveIn;
            try (Indent indent2 = this.debug.logAndIndent("Error: liveIn set of first block must be empty (when this fails, variables are used before they are defined):");){
                int operandNum = startBlockLiveIn.nextSetBit(0);
                while (operandNum >= 0) {
                    Interval interval = this.allocator.intervalFor(operandNum);
                    if (interval != null) {
                        AllocatableValue operand = interval.operand;
                        this.debug.log("var %d; operand=%s; node=%s", (Object)operandNum, (Object)operand, LIRGenerationDebugContext.getSourceForOperandFromDebugContext(this.debug, (Value)operand));
                    } else {
                        this.debug.log("var %d; missing operand", operandNum);
                    }
                    operandNum = startBlockLiveIn.nextSetBit(operandNum + 1);
                }
            }
            int operandNum = startBlockLiveIn.nextSetBit(0);
            while (operandNum >= 0) {
                Interval interval = this.allocator.intervalFor(operandNum);
                AllocatableValue operand = null;
                Object valueForOperandFromDebugContext = null;
                if (interval != null) {
                    operand = interval.operand;
                    valueForOperandFromDebugContext = LIRGenerationDebugContext.getSourceForOperandFromDebugContext(this.debug, (Value)operand);
                }
                try (Indent indent2 = this.debug.logAndIndent("---- Detailed information for var %d; operand=%s; node=%s ----", (Object)operandNum, (Object)operand, valueForOperandFromDebugContext);){
                    ArrayDeque<BasicBlock<Object>> definedIn = new ArrayDeque<BasicBlock<Object>>();
                    EconomicSet usedIn = EconomicSet.create((Equivalence)Equivalence.IDENTITY);
                    for (int blockId : this.allocator.sortedBlocks()) {
                        Indent indent3;
                        BasicBlock<?> block = this.allocator.getLIR().getBlockById(blockId);
                        if (this.allocator.getBlockData(block).liveGen.get(operandNum)) {
                            usedIn.add(block);
                            indent3 = this.debug.logAndIndent("used in block B%d", block.getId());
                            try {
                                for (LIRInstruction ins : this.allocator.getLIR().getLIRforBlock(block)) {
                                    Indent indent4 = this.debug.logAndIndent("%d: %s", ins.id(), (Object)ins);
                                    try {
                                        ins.forEachState((liveStateOperand, mode, flags) -> {
                                            this.debug.log("operand=%s", liveStateOperand);
                                            return liveStateOperand;
                                        });
                                    }
                                    finally {
                                        if (indent4 == null) continue;
                                        indent4.close();
                                    }
                                }
                            }
                            finally {
                                if (indent3 != null) {
                                    indent3.close();
                                }
                            }
                        }
                        if (!this.allocator.getBlockData(block).liveKill.get(operandNum)) continue;
                        definedIn.add(block);
                        indent3 = this.debug.logAndIndent("defined in block B%d", block.getId());
                        try {
                            for (LIRInstruction ins : this.allocator.getLIR().getLIRforBlock(block)) {
                                this.debug.log("%d: %s", ins.id(), (Object)ins);
                            }
                        }
                        finally {
                            if (indent3 != null) {
                                indent3.close();
                            }
                        }
                    }
                    int[] hitCount = new int[numBlocks];
                    while (!definedIn.isEmpty()) {
                        BasicBlock block = (BasicBlock)definedIn.removeFirst();
                        usedIn.remove((Object)block);
                        for (int i = 0; i < block.getSuccessorCount(); ++i) {
                            Object successor = block.getSuccessorAt(i);
                            if (((BasicBlock)successor).isLoopHeader()) {
                                if (block.isLoopEnd()) continue;
                                definedIn.add((BasicBlock<Object>)successor);
                                continue;
                            }
                            int n = ((BasicBlock)successor).getId();
                            hitCount[n] = hitCount[n] + 1;
                            if (hitCount[n] != ((BasicBlock)successor).getPredecessorCount()) continue;
                            definedIn.add((BasicBlock<Object>)successor);
                        }
                    }
                    try (Indent indent3 = this.debug.logAndIndent("**** offending usages are in: ");){
                        for (BasicBlock block : usedIn) {
                            this.debug.log("B%d", block.getId());
                        }
                    }
                }
                operandNum = startBlockLiveIn.nextSetBit(operandNum + 1);
            }
        }
        catch (Throwable e) {
            throw this.debug.handle(e);
        }
    }

    protected void verifyLiveness() {
        for (int blockId : this.allocator.sortedBlocks()) {
            BasicBlock<?> block = this.allocator.getLIR().getBlockById(blockId);
            for (int j = 0; j <= this.allocator.maxRegisterNumber(); ++j) {
                assert (!this.allocator.getBlockData(block).liveIn.get(j)) : "liveIn  set of fixed register must be empty";
                assert (!this.allocator.getBlockData(block).liveOut.get(j)) : "liveOut set of fixed register must be empty";
                assert (!this.allocator.getBlockData(block).liveGen.get(j)) : "liveGen set of fixed register must be empty";
            }
        }
    }

    protected void addUse(AllocatableValue operand, int from, int to, Interval.RegisterPriority registerPriority, ValueKind<?> kind, boolean detailedAsserts) {
        if (!this.allocator.isProcessed((Value)operand)) {
            return;
        }
        Interval interval = this.allocator.getOrCreateInterval(operand);
        if (!kind.equals((Object)LIRKind.Illegal) && !LIRValueUtil.isCast((Value)operand)) {
            interval.setKind(kind);
        }
        interval.addRange(from, to);
        interval.addUsePos(to & 0xFFFFFFFE, registerPriority, detailedAsserts);
        if (this.debug.isLogEnabled()) {
            this.debug.log("add use: %s, from %d to %d (%s)", interval, (Object)from, (Object)to, (Object)registerPriority.name());
        }
    }

    protected void addTemp(AllocatableValue operand, int tempPos, Interval.RegisterPriority registerPriority, ValueKind<?> kind, boolean detailedAsserts) {
        if (!this.allocator.isProcessed((Value)operand)) {
            return;
        }
        Interval interval = this.allocator.getOrCreateInterval(operand);
        if (!kind.equals((Object)LIRKind.Illegal) && !LIRValueUtil.isCast((Value)operand)) {
            interval.setKind(kind);
        }
        interval.addRange(tempPos, tempPos + 1);
        interval.addUsePos(tempPos, registerPriority, detailedAsserts);
        interval.addMaterializationValue(null);
        if (this.debug.isLogEnabled()) {
            this.debug.log("add temp: %s tempPos %d (%s)", interval, (Object)tempPos, (Object)Interval.RegisterPriority.MustHaveRegister.name());
        }
    }

    protected void addDef(AllocatableValue operand, LIRInstruction op, Interval.RegisterPriority registerPriority, ValueKind<?> kind, boolean detailedAsserts) {
        if (!this.allocator.isProcessed((Value)operand)) {
            return;
        }
        int defPos = op.id();
        Interval interval = this.allocator.getOrCreateInterval(operand);
        if (!kind.equals((Object)LIRKind.Illegal)) {
            interval.setKind(kind);
        }
        Range r = interval.first();
        if (r.from <= defPos) {
            r.from = defPos;
            interval.addUsePos(defPos, registerPriority, detailedAsserts);
        } else {
            interval.addRange(defPos, defPos + 1);
            interval.addUsePos(defPos, registerPriority, detailedAsserts);
            if (this.debug.isLogEnabled()) {
                this.debug.log("Warning: def of operand %s at %d occurs without use", (Object)operand, defPos);
            }
        }
        this.changeSpillDefinitionPos(op, operand, interval, defPos);
        if (registerPriority == Interval.RegisterPriority.None && interval.spillState().ordinal() <= Interval.SpillState.StartInMemory.ordinal() && ValueUtil.isStackSlot((Value)operand)) {
            interval.setSpillState(Interval.SpillState.StartInMemory);
        }
        interval.addMaterializationValue(this.getMaterializedValue(op, (Value)operand, interval));
        if (this.debug.isLogEnabled()) {
            this.debug.log("add def: %s defPos %d (%s)", interval, (Object)defPos, (Object)registerPriority.name());
        }
    }

    protected void handleMethodArguments(LIRInstruction op) {
        StandardOp.ValueMoveOp move;
        if (StandardOp.ValueMoveOp.isValueMoveOp(op) && LinearScanLifetimeAnalysisPhase.optimizeMethodArgument((Value)(move = StandardOp.ValueMoveOp.asValueMoveOp(op)).getInput())) {
            StackSlot slot = ValueUtil.asStackSlot((Value)move.getInput());
            if (Assertions.detailedAssertionsEnabled(this.allocator.getOptions())) {
                assert (op.id() > 0) : "invalid id";
                assert (this.allocator.blockForId(op.id()).getPredecessorCount() == 0) : "move from stack must be in first block";
                assert (LIRValueUtil.isVariable((Value)move.getResult())) : "result of move must be a variable";
                if (this.debug.isLogEnabled()) {
                    this.debug.log("found move from stack slot %s to %s", (Object)slot, (Object)move.getResult());
                }
            }
            Interval interval = this.allocator.intervalFor((Value)move.getResult());
            interval.setSpillSlot((AllocatableValue)slot);
            interval.assignLocation((AllocatableValue)slot);
        }
    }

    protected void addRegisterHint(LIRInstruction op, Value targetValue, LIRInstruction.OperandMode mode, EnumSet<LIRInstruction.OperandFlag> flags, boolean hintAtDef) {
        if (flags.contains((Object)LIRInstruction.OperandFlag.HINT) && LinearScan.isVariableOrRegister(targetValue)) {
            op.forEachRegisterHint(targetValue, mode, (registerHint, valueMode, valueFlags) -> {
                if (LinearScan.isVariableOrRegister(registerHint)) {
                    Interval from = this.allocator.getOrCreateInterval((AllocatableValue)registerHint);
                    Interval to = this.allocator.getOrCreateInterval((AllocatableValue)targetValue);
                    if (hintAtDef) {
                        to.setLocationHint(from);
                    } else {
                        from.setLocationHint(to);
                    }
                    if (this.debug.isLogEnabled()) {
                        this.debug.log("operation at opId %d: added hint from interval %d to %d", op.id(), from.operandNumber, to.operandNumber);
                    }
                    return registerHint;
                }
                return null;
            });
        }
    }

    protected void changeSpillDefinitionPos(LIRInstruction op, AllocatableValue operand, Interval interval, int defPos) {
        assert (interval.isSplitParent()) : "can only be called for split parents";
        switch (interval.spillState()) {
            case NoDefinitionFound: {
                assert (interval.spillDefinitionPos() == -1) : "must no be set before";
                interval.setSpillDefinitionPos(defPos);
                interval.setSpillState(Interval.SpillState.NoSpillStore);
                break;
            }
            case NoSpillStore: {
                assert (defPos <= interval.spillDefinitionPos()) : "positions are processed in reverse order when intervals are created";
                if (defPos < interval.spillDefinitionPos() - 2) {
                    interval.setSpillState(Interval.SpillState.NoOptimization);
                    break;
                }
                assert (this.allocator.blockForId(defPos) == this.allocator.blockForId(interval.spillDefinitionPos())) : "block must be equal";
                break;
            }
            case NoOptimization: {
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere("other states not allowed at this time");
            }
        }
    }

    private static boolean optimizeMethodArgument(Value value) {
        return ValueUtil.isStackSlot((Value)value) && ValueUtil.asStackSlot((Value)value).isInCallerFrame() && LIRKind.isValue(value);
    }

    protected Interval.RegisterPriority registerPriorityOfOutputOperand(LIRInstruction op) {
        StandardOp.ValueMoveOp move;
        if (StandardOp.ValueMoveOp.isValueMoveOp(op) && LinearScanLifetimeAnalysisPhase.optimizeMethodArgument((Value)(move = StandardOp.ValueMoveOp.asValueMoveOp(op)).getInput())) {
            return Interval.RegisterPriority.None;
        }
        return Interval.RegisterPriority.MustHaveRegister;
    }

    protected static Interval.RegisterPriority registerPriorityOfInputOperand(EnumSet<LIRInstruction.OperandFlag> flags) {
        if (flags.contains((Object)LIRInstruction.OperandFlag.STACK)) {
            return Interval.RegisterPriority.ShouldHaveRegister;
        }
        return Interval.RegisterPriority.MustHaveRegister;
    }

    protected void buildIntervals(boolean detailedAsserts) {
        try (Indent indent = this.debug.logAndIndent("build intervals");){
            InstructionValueConsumer outputConsumer = (op, operand, mode, flags) -> {
                if (LinearScan.isVariableOrRegister(operand)) {
                    this.addDef((AllocatableValue)operand, op, this.registerPriorityOfOutputOperand(op), operand.getValueKind(), detailedAsserts);
                    this.addRegisterHint(op, operand, mode, flags, true);
                }
            };
            InstructionValueConsumer tempConsumer = (op, operand, mode, flags) -> {
                if (LinearScan.isVariableOrRegister(operand)) {
                    this.addTemp((AllocatableValue)operand, op.id(), Interval.RegisterPriority.MustHaveRegister, operand.getValueKind(), detailedAsserts);
                    this.addRegisterHint(op, operand, mode, flags, false);
                }
            };
            InstructionValueConsumer aliveConsumer = (op, operand, mode, flags) -> {
                if (LinearScan.isVariableOrRegister(operand)) {
                    Interval.RegisterPriority p = LinearScanLifetimeAnalysisPhase.registerPriorityOfInputOperand(flags);
                    int opId = op.id();
                    int blockFrom = this.allocator.getFirstLirInstructionId(this.allocator.blockForId(opId));
                    this.addUse((AllocatableValue)operand, blockFrom, opId + 1, p, operand.getValueKind(), detailedAsserts);
                    this.addRegisterHint(op, operand, mode, flags, false);
                }
            };
            InstructionValueConsumer inputConsumer = (op, operand, mode, flags) -> {
                if (LinearScan.isVariableOrRegister(operand)) {
                    int opId = op.id();
                    int blockFrom = this.allocator.getFirstLirInstructionId(this.allocator.blockForId(opId));
                    Interval.RegisterPriority p = LinearScanLifetimeAnalysisPhase.registerPriorityOfInputOperand(flags);
                    this.addUse((AllocatableValue)operand, blockFrom, opId, p, operand.getValueKind(), detailedAsserts);
                    this.addRegisterHint(op, operand, mode, flags, false);
                }
            };
            InstructionValueConsumer nonBasePointersStateProc = (op, operand, mode, flags) -> {
                if (LinearScan.isVariableOrRegister(operand)) {
                    int opId = op.id();
                    int blockFrom = this.allocator.getFirstLirInstructionId(this.allocator.blockForId(opId));
                    Interval.RegisterPriority priority = Interval.RegisterPriority.None;
                    if (operand.getPlatformKind().getVectorLength() > 1) {
                        priority = Interval.RegisterPriority.ShouldHaveRegister;
                    }
                    this.addUse((AllocatableValue)operand, blockFrom, opId + 1, priority, operand.getValueKind(), detailedAsserts);
                }
            };
            InstructionValueConsumer basePointerStateProc = (op, operand, mode, flags) -> {
                if (LinearScan.isVariableOrRegister(operand)) {
                    int opId = op.id();
                    int blockFrom = this.allocator.getFirstLirInstructionId(this.allocator.blockForId(opId));
                    this.addUse((AllocatableValue)operand, blockFrom, opId + 1, Interval.RegisterPriority.ShouldHaveRegister, operand.getValueKind(), detailedAsserts);
                }
            };
            InstructionStateProcedure stateProc = (op, state) -> {
                IndexedValueMap liveBasePointers = state.getLiveBasePointers();
                state.setLiveBasePointers(null);
                state.visitEachState(op, nonBasePointersStateProc);
                liveBasePointers.visitEach(op, LIRInstruction.OperandMode.ALIVE, null, basePointerStateProc);
                state.setLiveBasePointers(liveBasePointers);
            };
            RegisterArray callerSaveRegs = this.allocator.getRegisterAllocationConfig().getRegisterConfig().getCallerSaveRegisters();
            for (int i = this.allocator.blockCount() - 1; i >= 0; --i) {
                BasicBlock<?> block = this.allocator.blockAt(i);
                try (Indent indent2 = this.debug.logAndIndent("handle block %d", block.getId());){
                    ArrayList<LIRInstruction> instructions = this.allocator.getLIR().getLIRforBlock(block);
                    int blockFrom = this.allocator.getFirstLirInstructionId(block);
                    int blockTo = this.allocator.getLastLirInstructionId(block);
                    assert (blockFrom == instructions.get(0).id());
                    assert (blockTo == instructions.get(instructions.size() - 1).id());
                    BitSet live = this.allocator.getBlockData(block).liveOut;
                    int operandNum = live.nextSetBit(0);
                    while (operandNum >= 0) {
                        assert (live.get(operandNum)) : "should not stop here otherwise";
                        AllocatableValue operand2 = this.allocator.intervalFor((int)operandNum).operand;
                        if (this.debug.isLogEnabled()) {
                            this.debug.log("live in %d: %s", operandNum, (Object)operand2);
                        }
                        this.addUse(operand2, blockFrom, blockTo + 2, Interval.RegisterPriority.None, LIRKind.Illegal, detailedAsserts);
                        if (block.isLoopEnd() && block.getLoop() != null && this.isIntervalInLoop(operandNum, block.getLoop().getIndex())) {
                            this.allocator.intervalFor(operandNum).addUsePos(blockTo + 1, Interval.RegisterPriority.LiveAtLoopEnd, detailedAsserts);
                        }
                        operandNum = live.nextSetBit(operandNum + 1);
                    }
                    for (int j = instructions.size() - 1; j >= 0; --j) {
                        LIRInstruction op2 = instructions.get(j);
                        int opId = op2.id();
                        try (Indent indent3 = this.debug.logAndIndent("handle inst %d: %s", opId, (Object)op2);){
                            if (op2.destroysCallerSavedRegisters()) {
                                for (Register r : callerSaveRegs) {
                                    if (!this.allocator.attributes(r).isAllocatable()) continue;
                                    this.addTemp((AllocatableValue)r.asValue(), opId, Interval.RegisterPriority.None, LIRKind.Illegal, detailedAsserts);
                                }
                                if (this.debug.isLogEnabled()) {
                                    this.debug.log("operation destroys all caller-save registers");
                                }
                            }
                            op2.visitEachOutput(outputConsumer);
                            op2.visitEachTemp(tempConsumer);
                            op2.visitEachAlive(aliveConsumer);
                            op2.visitEachInput(inputConsumer);
                            op2.forEachState(stateProc);
                            this.handleMethodArguments(op2);
                            continue;
                        }
                    }
                    continue;
                }
            }
            for (Interval interval : this.allocator.intervals()) {
                if (interval == null || !ValueUtil.isRegister((Value)interval.operand)) continue;
                interval.addRange(0, 1);
            }
        }
    }

    protected Constant getMaterializedValue(LIRInstruction op, Value operand, Interval interval) {
        if (StandardOp.LoadConstantOp.isLoadConstantOp(op)) {
            StandardOp.LoadConstantOp move = StandardOp.LoadConstantOp.asLoadConstantOp(op);
            if (!this.allocator.neverSpillConstants()) {
                Interval.UsePosList usePosList = interval.usePosList();
                int numUsePos = usePosList.size();
                for (int useIdx = 0; useIdx < numUsePos; ++useIdx) {
                    Interval.RegisterPriority priority = usePosList.registerPriority(useIdx);
                    if (priority != Interval.RegisterPriority.ShouldHaveRegister) continue;
                    return null;
                }
            }
            return move.getConstant();
        }
        return null;
    }
}

