/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.amd64;

import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.VMConstant;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.amd64.AMD64Address;
import org.graalvm.compiler.asm.amd64.AMD64Assembler;
import org.graalvm.compiler.asm.amd64.AMD64BaseAssembler;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.StandardOp;
import org.graalvm.compiler.lir.amd64.AMD64AddressValue;
import org.graalvm.compiler.lir.amd64.AMD64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

public class AMD64BinaryConsumer {

    public static class MemoryVMConstOp
    extends MemoryConstOp {
        public static final LIRInstructionClass<MemoryVMConstOp> TYPE = LIRInstructionClass.create(MemoryVMConstOp.class);
        protected final VMConstant c;

        public MemoryVMConstOp(AMD64Assembler.AMD64MIOp opcode, AMD64AddressValue x, VMConstant c, LIRFrameState state) {
            super(TYPE, opcode, AMD64BaseAssembler.OperandSize.DWORD, x, -559030611, state);
            this.c = c;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            crb.recordInlineDataInCode((Constant)this.c);
            super.emitCode(crb, masm);
        }

        @Override
        protected boolean shouldAnnotate() {
            return true;
        }
    }

    public static class MemoryConstOp
    extends AMD64LIRInstruction
    implements StandardOp.ImplicitNullCheck {
        public static final LIRInstructionClass<MemoryConstOp> TYPE = LIRInstructionClass.create(MemoryConstOp.class);
        @Opcode
        private final AMD64Assembler.AMD64MIOp opcode;
        private final AMD64BaseAssembler.OperandSize size;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.COMPOSITE})
        protected AMD64AddressValue x;
        private final int y;
        @LIRInstruction.State
        protected LIRFrameState state;

        public MemoryConstOp(AMD64Assembler.AMD64MIOp opcode, AMD64BaseAssembler.OperandSize size, AMD64AddressValue x, int y, LIRFrameState state) {
            this(TYPE, opcode, size, x, y, state);
        }

        protected MemoryConstOp(LIRInstructionClass<? extends MemoryConstOp> c, AMD64Assembler.AMD64MIOp opcode, AMD64BaseAssembler.OperandSize size, AMD64AddressValue x, int y, LIRFrameState state) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)c);
            this.opcode = opcode;
            this.size = size;
            this.x = x;
            this.y = y;
            this.state = state;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            if (this.state != null) {
                crb.recordImplicitException(masm.position(), this.state);
            }
            this.opcode.emit((AMD64Assembler)masm, this.size, this.x.toAddress(), this.y, this.shouldAnnotate());
        }

        protected boolean shouldAnnotate() {
            return false;
        }

        @Override
        public boolean makeNullCheckFor(Value value, LIRFrameState nullCheckState, int implicitNullCheckLimit) {
            if (this.state == null && this.x.isValidImplicitNullCheckFor(value, implicitNullCheckLimit)) {
                this.state = nullCheckState;
                return true;
            }
            return false;
        }

        public AMD64Assembler.AMD64MIOp getOpcode() {
            return this.opcode;
        }
    }

    public static class MemoryMROp
    extends AMD64LIRInstruction
    implements StandardOp.ImplicitNullCheck {
        public static final LIRInstructionClass<MemoryMROp> TYPE = LIRInstructionClass.create(MemoryMROp.class);
        @Opcode
        private final AMD64Assembler.AMD64MROp opcode;
        private final AMD64BaseAssembler.OperandSize size;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.COMPOSITE})
        protected AMD64AddressValue x;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue y;
        @LIRInstruction.State
        protected LIRFrameState state;

        public MemoryMROp(AMD64Assembler.AMD64MROp opcode, AMD64BaseAssembler.OperandSize size, AMD64AddressValue x, AllocatableValue y, LIRFrameState state) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.opcode = opcode;
            this.size = size;
            this.x = x;
            this.y = y;
            this.state = state;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            if (this.state != null) {
                crb.recordImplicitException(masm.position(), this.state);
            }
            this.opcode.emit((AMD64Assembler)masm, this.size, this.x.toAddress(), ValueUtil.asRegister((Value)this.y));
        }

        @Override
        public boolean makeNullCheckFor(Value value, LIRFrameState nullCheckState, int implicitNullCheckLimit) {
            if (this.state == null && this.x.isValidImplicitNullCheckFor(value, implicitNullCheckLimit)) {
                this.state = nullCheckState;
                return true;
            }
            return false;
        }

        public AMD64Assembler.AMD64MROp getOpcode() {
            return this.opcode;
        }
    }

    public static class MemoryRMOp
    extends AMD64LIRInstruction
    implements StandardOp.ImplicitNullCheck {
        public static final LIRInstructionClass<MemoryRMOp> TYPE = LIRInstructionClass.create(MemoryRMOp.class);
        @Opcode
        private final AMD64Assembler.AMD64RMOp opcode;
        private final AMD64BaseAssembler.OperandSize size;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue x;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.COMPOSITE})
        protected AMD64AddressValue y;
        @LIRInstruction.State
        protected LIRFrameState state;

        public MemoryRMOp(AMD64Assembler.AMD64RMOp opcode, AMD64BaseAssembler.OperandSize size, AllocatableValue x, AMD64AddressValue y, LIRFrameState state) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.opcode = opcode;
            this.size = size;
            this.x = x;
            this.y = y;
            this.state = state;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            if (this.state != null) {
                crb.recordImplicitException(masm.position(), this.state);
            }
            this.opcode.emit((AMD64Assembler)masm, this.size, ValueUtil.asRegister((Value)this.x), this.y.toAddress());
        }

        @Override
        public boolean makeNullCheckFor(Value value, LIRFrameState nullCheckState, int implicitNullCheckLimit) {
            if (this.state == null && this.y.isValidImplicitNullCheckFor(value, implicitNullCheckLimit)) {
                this.state = nullCheckState;
                return true;
            }
            return false;
        }
    }

    public static class DataOp
    extends AMD64LIRInstruction {
        public static final LIRInstructionClass<DataOp> TYPE = LIRInstructionClass.create(DataOp.class);
        @Opcode
        private final AMD64Assembler.AMD64RMOp opcode;
        private final AMD64BaseAssembler.OperandSize size;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue x;
        private final Constant y;
        private final int alignment;

        public DataOp(AMD64Assembler.AMD64RMOp opcode, AMD64BaseAssembler.OperandSize size, AllocatableValue x, Constant y) {
            this(opcode, size, x, y, size.getBytes());
        }

        public DataOp(AMD64Assembler.AMD64RMOp opcode, AMD64BaseAssembler.OperandSize size, AllocatableValue x, Constant y, int alignment) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.opcode = opcode;
            this.size = size;
            this.x = x;
            this.y = y;
            this.alignment = alignment;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            this.opcode.emit((AMD64Assembler)masm, this.size, ValueUtil.asRegister((Value)this.x), (AMD64Address)crb.recordDataReferenceInCode(this.y, this.alignment));
        }
    }

    public static class VMConstOp
    extends ConstOp {
        public static final LIRInstructionClass<VMConstOp> TYPE = LIRInstructionClass.create(VMConstOp.class);
        protected final VMConstant c;

        public VMConstOp(AMD64Assembler.AMD64MIOp opcode, AllocatableValue x, VMConstant c) {
            super(TYPE, opcode, AMD64BaseAssembler.OperandSize.DWORD, x, -559030611);
            this.c = c;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            crb.recordInlineDataInCode((Constant)this.c);
            super.emitCode(crb, masm);
        }

        @Override
        protected boolean shouldAnnotate() {
            return true;
        }
    }

    public static class ConstOp
    extends AMD64LIRInstruction {
        public static final LIRInstructionClass<ConstOp> TYPE = LIRInstructionClass.create(ConstOp.class);
        @Opcode
        private final AMD64Assembler.AMD64MIOp opcode;
        private final AMD64BaseAssembler.OperandSize size;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
        protected AllocatableValue x;
        private final int y;

        public ConstOp(AMD64Assembler.AMD64BinaryArithmetic opcode, AMD64BaseAssembler.OperandSize size, AllocatableValue x, int y) {
            this(opcode.getMIOpcode(size, NumUtil.isByte(y)), size, x, y);
        }

        public ConstOp(AMD64Assembler.AMD64MIOp opcode, AMD64BaseAssembler.OperandSize size, AllocatableValue x, int y) {
            this(TYPE, opcode, size, x, y);
        }

        protected ConstOp(LIRInstructionClass<? extends ConstOp> c, AMD64Assembler.AMD64MIOp opcode, AMD64BaseAssembler.OperandSize size, AllocatableValue x, int y) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)c);
            this.opcode = opcode;
            this.size = size;
            this.x = x;
            this.y = y;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            if (ValueUtil.isRegister((Value)this.x)) {
                this.opcode.emit((AMD64Assembler)masm, this.size, ValueUtil.asRegister((Value)this.x), this.y, this.shouldAnnotate());
            } else {
                assert (ValueUtil.isStackSlot((Value)this.x));
                this.opcode.emit((AMD64Assembler)masm, this.size, (AMD64Address)crb.asAddress((Value)this.x), this.y, this.shouldAnnotate());
            }
        }

        protected boolean shouldAnnotate() {
            return false;
        }

        public AMD64Assembler.AMD64MIOp getOpcode() {
            return this.opcode;
        }
    }

    public static class Op
    extends AMD64LIRInstruction {
        public static final LIRInstructionClass<Op> TYPE = LIRInstructionClass.create(Op.class);
        @Opcode
        private final AMD64Assembler.AMD64RMOp opcode;
        private final AMD64BaseAssembler.OperandSize size;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue x;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
        protected AllocatableValue y;

        public Op(AMD64Assembler.AMD64RMOp opcode, AMD64BaseAssembler.OperandSize size, AllocatableValue x, AllocatableValue y) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.opcode = opcode;
            this.size = size;
            this.x = x;
            this.y = y;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            if (ValueUtil.isRegister((Value)this.y)) {
                this.opcode.emit((AMD64Assembler)masm, this.size, ValueUtil.asRegister((Value)this.x), ValueUtil.asRegister((Value)this.y));
            } else {
                assert (ValueUtil.isStackSlot((Value)this.y));
                this.opcode.emit((AMD64Assembler)masm, this.size, ValueUtil.asRegister((Value)this.x), (AMD64Address)crb.asAddress((Value)this.y));
            }
        }
    }
}

