/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.amd64.vector;

import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.amd64.AMD64Address;
import org.graalvm.compiler.asm.amd64.AMD64Assembler;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.asm.amd64.AVXKind;
import org.graalvm.compiler.core.common.type.DataPointerConstant;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.StandardOp;
import org.graalvm.compiler.lir.amd64.AMD64AddressValue;
import org.graalvm.compiler.lir.amd64.AMD64LIRInstruction;
import org.graalvm.compiler.lir.amd64.AMD64Move;
import org.graalvm.compiler.lir.amd64.AMD64RestoreRegistersOp;
import org.graalvm.compiler.lir.amd64.AMD64SaveRegistersOp;
import org.graalvm.compiler.lir.amd64.vector.AMD64VectorInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

public class AMD64VectorMove {
    private static AMD64Assembler.VexMoveOp getScalarMoveOp(AMD64Kind kind) {
        switch (kind) {
            case SINGLE: {
                return AMD64Assembler.VexMoveOp.VMOVSS;
            }
            case DOUBLE: {
                return AMD64Assembler.VexMoveOp.VMOVSD;
            }
        }
        throw GraalError.shouldNotReachHereUnexpectedValue(kind);
    }

    private static AMD64Assembler.VexMoveOp getVectorMoveOp(AMD64Kind kind) {
        switch (kind) {
            case SINGLE: {
                return AMD64Assembler.VexMoveOp.VMOVUPS;
            }
            case DOUBLE: {
                return AMD64Assembler.VexMoveOp.VMOVUPD;
            }
        }
        return AMD64Assembler.VexMoveOp.VMOVDQU32;
    }

    public static AMD64Assembler.VexMoveOp getVectorMemMoveOp(AMD64Kind kind) {
        switch (AVXKind.getDataSize(kind)) {
            case DWORD: {
                return AMD64Assembler.VexMoveOp.VMOVD;
            }
            case QWORD: {
                return AMD64Assembler.VexMoveOp.VMOVQ;
            }
        }
        return AMD64VectorMove.getVectorMoveOp(kind.getScalar());
    }

    private static void move(CompilationResultBuilder crb, AMD64MacroAssembler masm, AllocatableValue result, Value input) {
        AMD64Assembler.VexMoveOp op;
        AVXKind.AVXSize size;
        AMD64Kind kind = (AMD64Kind)result.getPlatformKind();
        if (kind.getVectorLength() > 1) {
            size = AVXKind.getRegisterSize(kind);
            op = ValueUtil.isRegister((Value)input) && ValueUtil.isRegister((Value)result) ? AMD64VectorMove.getVectorMoveOp(kind.getScalar()) : AMD64VectorMove.getVectorMemMoveOp(kind);
        } else {
            size = AVXKind.AVXSize.XMM;
            op = ValueUtil.isRegister((Value)input) && ValueUtil.isRegister((Value)result) ? AMD64VectorMove.getVectorMoveOp(kind) : AMD64VectorMove.getScalarMoveOp(kind);
        }
        if (ValueUtil.isRegister((Value)input)) {
            if (ValueUtil.isRegister((Value)result)) {
                if (!ValueUtil.asRegister((Value)input).equals((Object)ValueUtil.asRegister((Value)result))) {
                    op.emit((AMD64Assembler)masm, size, ValueUtil.asRegister((Value)result), ValueUtil.asRegister((Value)input));
                }
            } else {
                assert (ValueUtil.isStackSlot((Value)result));
                op.emit((AMD64Assembler)masm, size, (AMD64Address)crb.asAddress((Value)result), ValueUtil.asRegister((Value)input));
            }
        } else {
            assert (ValueUtil.isStackSlot((Value)input) && ValueUtil.isRegister((Value)result));
            op.emit((AMD64Assembler)masm, size, ValueUtil.asRegister((Value)result), (AMD64Address)crb.asAddress(input));
        }
    }

    private static void const2reg(CompilationResultBuilder crb, AMD64MacroAssembler masm, RegisterValue result, JavaConstant input) {
        if (input.isDefaultForKind()) {
            AMD64Kind kind = (AMD64Kind)result.getPlatformKind();
            Register register = result.getRegister();
            AMD64Assembler.VexRVMOp.VXORPD.emit((AMD64Assembler)masm, AVXKind.getRegisterSize(kind), register, register, register);
            return;
        }
        AMD64Address address = switch (input.getJavaKind()) {
            case JavaKind.Float -> (AMD64Address)crb.asFloatConstRef(input);
            case JavaKind.Double -> (AMD64Address)crb.asDoubleConstRef(input);
            default -> throw GraalError.shouldNotReachHereUnexpectedValue(input.getJavaKind());
        };
        AMD64Assembler.VexMoveOp op = AMD64VectorMove.getScalarMoveOp((AMD64Kind)result.getPlatformKind());
        op.emit((AMD64Assembler)masm, AVXKind.AVXSize.XMM, ValueUtil.asRegister((Value)result), address);
    }

    public static final class AVXMoveToIntOp
    extends AMD64LIRInstruction {
        public static final LIRInstructionClass<AVXMoveToIntOp> TYPE = LIRInstructionClass.create(AVXMoveToIntOp.class);
        @Opcode
        private final AMD64Assembler.VexMoveOp opcode;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue input;

        public AVXMoveToIntOp(AMD64Assembler.VexMoveOp opcode, AllocatableValue result, AllocatableValue input) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.opcode = opcode;
            this.result = result;
            this.input = input;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            if (ValueUtil.isRegister((Value)this.result)) {
                this.opcode.emitReverse(masm, AVXKind.AVXSize.XMM, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.input));
            } else {
                this.opcode.emit((AMD64Assembler)masm, AVXKind.AVXSize.XMM, (AMD64Address)crb.asAddress((Value)this.result), ValueUtil.asRegister((Value)this.input));
            }
        }
    }

    @Opcode(value="RESTORE_REGISTER")
    public static final class RestoreRegistersOp
    extends AMD64RestoreRegistersOp {
        public static final LIRInstructionClass<RestoreRegistersOp> TYPE = LIRInstructionClass.create(RestoreRegistersOp.class);

        public RestoreRegistersOp(AllocatableValue[] source, AMD64SaveRegistersOp save) {
            super(TYPE, source, save);
        }

        @Override
        protected void restoreRegister(CompilationResultBuilder crb, AMD64MacroAssembler masm, Register register, StackSlot input) {
            AMD64Kind kind = (AMD64Kind)input.getPlatformKind();
            if (kind.isXMM()) {
                AMD64Assembler.VexMoveOp op = kind.getVectorLength() > 1 ? AMD64VectorMove.getVectorMoveOp(kind.getScalar()) : AMD64VectorMove.getScalarMoveOp(kind);
                AMD64Address addr = (AMD64Address)crb.asAddress((Value)input);
                op.emit((AMD64Assembler)masm, AVXKind.getRegisterSize(kind), register, addr);
            } else {
                super.restoreRegister(crb, masm, register, input);
            }
        }
    }

    @Opcode(value="SAVE_REGISTER")
    public static class SaveRegistersOp
    extends AMD64SaveRegistersOp {
        public static final LIRInstructionClass<SaveRegistersOp> TYPE = LIRInstructionClass.create(SaveRegistersOp.class);

        public SaveRegistersOp(Register[] savedRegisters, AllocatableValue[] slots) {
            super(TYPE, savedRegisters, slots);
        }

        @Override
        protected void saveRegister(CompilationResultBuilder crb, AMD64MacroAssembler masm, StackSlot result, Register register) {
            AMD64Kind kind = (AMD64Kind)result.getPlatformKind();
            if (kind.isXMM()) {
                AMD64Assembler.VexMoveOp op = kind.getVectorLength() > 1 ? AMD64VectorMove.getVectorMoveOp(kind.getScalar()) : AMD64VectorMove.getScalarMoveOp(kind);
                AMD64Address addr = (AMD64Address)crb.asAddress((Value)result);
                op.emit((AMD64Assembler)masm, AVXKind.getRegisterSize(kind), addr, register);
            } else {
                super.saveRegister(crb, masm, result, register);
            }
        }
    }

    public static class VectorStoreOp
    extends VectorMemOp {
        public static final LIRInstructionClass<VectorStoreOp> TYPE = LIRInstructionClass.create(VectorStoreOp.class);
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue input;

        public VectorStoreOp(AVXKind.AVXSize size, AMD64Assembler.VexMoveOp op, AMD64AddressValue address, AllocatableValue input, LIRFrameState state) {
            super(TYPE, size, op, address, state);
            this.input = input;
        }

        @Override
        public void emitMemAccess(AMD64MacroAssembler masm) {
            this.op.emit((AMD64Assembler)masm, this.size, this.address.toAddress(), ValueUtil.asRegister((Value)this.input));
        }
    }

    public static final class VectorLoadOp
    extends VectorMemOp {
        public static final LIRInstructionClass<VectorLoadOp> TYPE = LIRInstructionClass.create(VectorLoadOp.class);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;

        public VectorLoadOp(AVXKind.AVXSize size, AMD64Assembler.VexMoveOp op, AllocatableValue result, AMD64AddressValue address, LIRFrameState state) {
            super(TYPE, size, op, address, state);
            this.result = result;
        }

        @Override
        public void emitMemAccess(AMD64MacroAssembler masm) {
            this.op.emit((AMD64Assembler)masm, this.size, ValueUtil.asRegister((Value)this.result), this.address.toAddress());
        }
    }

    public static abstract class VectorMemOp
    extends AMD64VectorInstruction {
        protected final AMD64Assembler.VexMoveOp op;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.COMPOSITE})
        protected AMD64AddressValue address;
        @LIRInstruction.State
        protected LIRFrameState state;

        protected VectorMemOp(LIRInstructionClass<? extends VectorMemOp> c, AVXKind.AVXSize size, AMD64Assembler.VexMoveOp op, AMD64AddressValue address, LIRFrameState state) {
            super(c, size);
            this.op = op;
            this.address = address;
            this.state = state;
        }

        protected abstract void emitMemAccess(AMD64MacroAssembler var1);

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            if (this.state != null) {
                crb.recordImplicitException(masm.position(), this.state);
            }
            this.emitMemAccess(masm);
        }
    }

    @Opcode(value="VSTACKMOVE")
    public static final class StackMoveOp
    extends AMD64LIRInstruction
    implements StandardOp.ValueMoveOp {
        public static final LIRInstructionClass<StackMoveOp> TYPE = LIRInstructionClass.create(StackMoveOp.class);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.STACK})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.STACK, LIRInstruction.OperandFlag.HINT})
        protected AllocatableValue input;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.STACK, LIRInstruction.OperandFlag.UNINITIALIZED})
        private AllocatableValue backupSlot;
        private Register scratch;

        public StackMoveOp(AllocatableValue result, AllocatableValue input, Register scratch, AllocatableValue backupSlot) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.result = result;
            this.input = input;
            this.backupSlot = backupSlot;
            this.scratch = scratch;
        }

        @Override
        public AllocatableValue getInput() {
            return this.input;
        }

        @Override
        public AllocatableValue getResult() {
            return this.result;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            AMD64VectorMove.move(crb, masm, this.backupSlot, (Value)this.scratch.asValue(this.backupSlot.getValueKind()));
            AMD64VectorMove.move(crb, masm, (AllocatableValue)this.scratch.asValue(this.getInput().getValueKind()), (Value)this.getInput());
            AMD64VectorMove.move(crb, masm, this.getResult(), (Value)this.scratch.asValue(this.getResult().getValueKind()));
            AMD64VectorMove.move(crb, masm, (AllocatableValue)this.scratch.asValue(this.backupSlot.getValueKind()), (Value)this.backupSlot);
        }
    }

    @Opcode(value="VMOVE")
    public static class MoveFromArrayConstOp
    extends AMD64LIRInstruction
    implements StandardOp.LoadConstantOp {
        public static final LIRInstructionClass<MoveFromArrayConstOp> TYPE = LIRInstructionClass.create(MoveFromArrayConstOp.class);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
        protected AllocatableValue result;
        private final DataPointerConstant input;

        public MoveFromArrayConstOp(AllocatableValue result, DataPointerConstant input) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.result = result;
            this.input = input;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            AMD64Kind kind = (AMD64Kind)this.result.getPlatformKind();
            assert (kind.isXMM()) : "Can only move array to XMM register";
            int alignment = crb.dataBuilder.ensureValidDataAlignment(this.input.getAlignment());
            AMD64Assembler.VexMoveOp.VMOVDQU32.emit((AMD64Assembler)masm, AVXKind.getRegisterSize((Value)this.result), ValueUtil.asRegister((Value)this.result), (AMD64Address)crb.recordDataReferenceInCode((Constant)this.input, alignment));
        }

        @Override
        public Constant getConstant() {
            return this.input;
        }

        @Override
        public AllocatableValue getResult() {
            return this.result;
        }
    }

    @Opcode(value="VMOVE")
    public static class MoveFromConstOp
    extends AMD64LIRInstruction
    implements StandardOp.LoadConstantOp {
        public static final LIRInstructionClass<MoveFromConstOp> TYPE = LIRInstructionClass.create(MoveFromConstOp.class);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
        protected AllocatableValue result;
        private final JavaConstant input;

        public MoveFromConstOp(AllocatableValue result, JavaConstant input) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.result = result;
            this.input = input;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            if (ValueUtil.isRegister((Value)this.result)) {
                AMD64VectorMove.const2reg(crb, masm, (RegisterValue)this.result, this.input);
            } else {
                assert (ValueUtil.isStackSlot((Value)this.result));
                AMD64Move.const2stack(crb, masm, (Value)this.result, this.input);
            }
        }

        @Override
        public Constant getConstant() {
            return this.input;
        }

        @Override
        public AllocatableValue getResult() {
            return this.result;
        }
    }

    @Opcode(value="VMOVE")
    public static final class MoveFromRegOp
    extends AMD64LIRInstruction
    implements StandardOp.ValueMoveOp {
        public static final LIRInstructionClass<MoveFromRegOp> TYPE = LIRInstructionClass.create(MoveFromRegOp.class);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.HINT})
        protected AllocatableValue input;

        public MoveFromRegOp(AllocatableValue result, AllocatableValue input) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.result = result;
            this.input = input;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            AMD64VectorMove.move(crb, masm, this.result, (Value)this.input);
        }

        @Override
        public AllocatableValue getInput() {
            return this.input;
        }

        @Override
        public AllocatableValue getResult() {
            return this.result;
        }
    }

    @Opcode(value="VMOVE")
    public static final class MoveToRegOp
    extends AMD64LIRInstruction
    implements StandardOp.ValueMoveOp {
        public static final LIRInstructionClass<MoveToRegOp> TYPE = LIRInstructionClass.create(MoveToRegOp.class);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK, LIRInstruction.OperandFlag.HINT})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
        protected AllocatableValue input;

        public MoveToRegOp(AllocatableValue result, AllocatableValue input) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.result = result;
            this.input = input;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            AMD64VectorMove.move(crb, masm, this.result, (Value)this.input);
        }

        @Override
        public AllocatableValue getInput() {
            return this.input;
        }

        @Override
        public AllocatableValue getResult() {
            return this.result;
        }
    }
}

