/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.constopt;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Deque;
import java.util.List;
import org.graalvm.compiler.core.common.cfg.BasicBlock;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.Indent;
import org.graalvm.compiler.lir.constopt.ConstantTree;
import org.graalvm.compiler.lir.constopt.UseEntry;

public final class ConstantTreeAnalyzer {
    private final ConstantTree tree;
    private final BitSet visited;

    public static ConstantTree.NodeCost analyze(DebugContext debug, ConstantTree tree, BasicBlock<?> startBlock) {
        DebugContext.Scope s = debug.scope("ConstantTreeAnalyzer");
        try {
            ConstantTreeAnalyzer analyzer = new ConstantTreeAnalyzer(tree);
            analyzer.analyzeBlocks(debug, startBlock);
            ConstantTree.NodeCost nodeCost = (ConstantTree.NodeCost)tree.getCost(startBlock);
            if (s != null) {
                s.close();
            }
            return nodeCost;
        }
        catch (Throwable throwable) {
            try {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw debug.handle(e);
            }
        }
    }

    private ConstantTreeAnalyzer(ConstantTree tree) {
        this.tree = tree;
        this.visited = new BitSet(tree.size());
    }

    private void analyzeBlocks(DebugContext debug, BasicBlock<?> startBlock) {
        ArrayDeque worklist = new ArrayDeque();
        worklist.offerLast(startBlock);
        while (!worklist.isEmpty()) {
            BasicBlock block = (BasicBlock)worklist.pollLast();
            Indent i = debug.logAndIndent(3, "analyze: %s", (Object)block);
            try {
                assert (block != null) : "worklist is empty!";
                assert (this.isMarked(block)) : "Block not part of the dominator tree: " + block;
                if (this.isLeafBlock(block)) {
                    debug.log(3, "leaf block");
                    this.leafCost(block);
                    continue;
                }
                if (!this.visited.get(block.getId())) {
                    debug.log(3, "not marked");
                    worklist.offerLast(block);
                    for (Object dominated = block.getFirstDominated(); dominated != null; dominated = ((BasicBlock)dominated).getDominatedSibling()) {
                        this.filteredPush(debug, worklist, (BasicBlock<?>)dominated);
                    }
                    this.visited.set(block.getId());
                    continue;
                }
                debug.log(3, "marked");
                this.process(block);
            }
            finally {
                if (i == null) continue;
                i.close();
            }
        }
    }

    private void process(BasicBlock<?> block) {
        ArrayList<UseEntry> usages = new ArrayList<UseEntry>();
        double bestCost = 0.0;
        int numMat = 0;
        for (Object child = block.getFirstDominated(); child != null; child = ((BasicBlock)child).getDominatedSibling()) {
            if (!this.isMarked((BasicBlock<?>)child)) continue;
            ConstantTree.NodeCost childCost = (ConstantTree.NodeCost)this.tree.getCost((BasicBlock<?>)child);
            assert (childCost != null) : "Child with null cost? block: " + child;
            usages.addAll(childCost.getUsages());
            numMat += childCost.getNumMaterializations();
            bestCost += childCost.getBestCost();
        }
        assert (numMat > 0) : "No materialization? " + numMat;
        List<UseEntry> usagesBlock = this.tree.getUsages(block);
        double probabilityBlock = block.getRelativeFrequency();
        if (!usagesBlock.isEmpty() || ConstantTreeAnalyzer.shouldMaterializerInCurrentBlock(probabilityBlock, bestCost, numMat)) {
            usages.addAll(usagesBlock);
            bestCost = probabilityBlock;
            numMat = 1;
            this.tree.set(ConstantTree.Flags.CANDIDATE, block);
        }
        ConstantTree.NodeCost nodeCost = new ConstantTree.NodeCost(bestCost, usages, numMat);
        this.tree.setCost(block, nodeCost);
    }

    private static boolean shouldMaterializerInCurrentBlock(double probabilityBlock, double probabilityChildren, int numMat) {
        return probabilityBlock * Math.pow(0.9, numMat - 1) < probabilityChildren;
    }

    private void filteredPush(DebugContext debug, Deque<BasicBlock<?>> worklist, BasicBlock<?> block) {
        if (this.isMarked(block)) {
            debug.log(3, "adding %s to the worklist", block);
            worklist.offerLast(block);
        }
    }

    private void leafCost(BasicBlock<?> block) {
        this.tree.set(ConstantTree.Flags.CANDIDATE, block);
        this.tree.getOrInitCost(block);
    }

    private boolean isMarked(BasicBlock<?> block) {
        return this.tree.isMarked(block);
    }

    private boolean isLeafBlock(BasicBlock<?> block) {
        return this.tree.isLeafBlock(block);
    }
}

