/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.framemap;

import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.RegisterSaveLayout;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.core.common.PermanentBailoutException;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.framemap.ReferenceMapBuilder;

public abstract class FrameMap {
    private final TargetDescription target;
    private final RegisterConfig registerConfig;
    private final ReferenceMapBuilderFactory referenceMapFactory;
    private int frameSize;
    protected int initialSpillSize;
    protected int spillSize;
    protected int outgoingSize;
    protected boolean hasOutgoingStackArguments;
    private boolean accessesCallerFrame;

    public FrameMap(CodeCacheProvider codeCache, RegisterConfig registerConfig, ReferenceMapBuilderFactory referenceMapFactory) {
        this.target = codeCache.getTarget();
        this.registerConfig = registerConfig == null ? codeCache.getRegisterConfig() : registerConfig;
        this.frameSize = -1;
        this.outgoingSize = codeCache.getMinimumOutgoingSize();
        this.referenceMapFactory = referenceMapFactory;
    }

    public RegisterConfig getRegisterConfig() {
        return this.registerConfig;
    }

    public TargetDescription getTarget() {
        return this.target;
    }

    protected int returnAddressSize() {
        return this.getTarget().arch.getReturnAddressSize();
    }

    public boolean accessesCallerFrame() {
        return this.accessesCallerFrame;
    }

    public int frameSize() {
        assert (this.frameSize != -1) : "frame size not computed yet";
        return this.frameSize;
    }

    public boolean frameNeedsAllocating() {
        int unalignedFrameSize = this.spillSize - this.returnAddressSize();
        return this.hasOutgoingStackArguments || unalignedFrameSize != 0;
    }

    public abstract int totalFrameSize();

    public abstract int currentFrameSize();

    protected int alignFrameSize(int size) {
        return NumUtil.roundUp(size, this.getTarget().stackAlignment);
    }

    public void finish() {
        this.frameSize = this.currentFrameSize();
        if (this.frameSize > this.getRegisterConfig().getMaximumFrameSize()) {
            throw new PermanentBailoutException("Frame size (%d) exceeded maximum allowed frame size (%d).", this.frameSize, this.getRegisterConfig().getMaximumFrameSize());
        }
    }

    public int offsetForStackSlot(StackSlot slot) {
        if (slot.isInCallerFrame()) {
            this.accessesCallerFrame = true;
        }
        return slot.getOffset(this.totalFrameSize());
    }

    public void callsMethod(CallingConvention cc) {
        this.reserveOutgoing(cc.getStackSize());
    }

    public void reserveOutgoing(int argsSize) {
        assert (this.frameSize == -1) : "frame size must not yet be fixed";
        this.outgoingSize = Math.max(this.outgoingSize, argsSize);
        this.hasOutgoingStackArguments = this.hasOutgoingStackArguments || argsSize > 0;
    }

    public int spillSlotSize(ValueKind<?> kind) {
        return kind.getPlatformKind().getSizeInBytes();
    }

    public StackSlot allocateSpillSlot(ValueKind<?> kind) {
        assert (this.frameSize == -1) : "frame size must not yet be fixed";
        int size = this.spillSlotSize(kind);
        this.spillSize = NumUtil.roundUp(this.spillSize + size, size);
        return this.newStackSlot(kind);
    }

    private StackSlot newStackSlot(ValueKind<?> kind) {
        return StackSlot.get(kind, (int)(-this.spillSize), (boolean)true);
    }

    public StackSlot allocateStackMemory(int sizeInBytes, int alignmentInBytes) {
        assert (this.frameSize == -1) : "frame size must not yet be fixed";
        GraalError.guarantee(sizeInBytes > 0, "Invalid size");
        GraalError.guarantee(alignmentInBytes > 0 && CodeUtil.isPowerOf2((int)alignmentInBytes), "Invalid alignment");
        if (alignmentInBytes > this.getTarget().stackAlignment) {
            throw GraalError.shouldNotReachHere("Stack memory alignment cannot be larger than OS alignment of stack frames: " + alignmentInBytes + " > " + this.getTarget().stackAlignment);
        }
        this.spillSize = NumUtil.roundUp(this.spillSize + sizeInBytes, alignmentInBytes);
        return this.newStackSlot(LIRKind.Illegal);
    }

    public ReferenceMapBuilder newReferenceMapBuilder() {
        return this.referenceMapFactory.newReferenceMapBuilder(this.totalFrameSize());
    }

    public RegisterSaveLayout getRegisterSaveLayout(Register[] savedRegisters, AllocatableValue[] slots) {
        Register[] filteredSavedRegisters = this.filterSavedRegisters(savedRegisters);
        int total = 0;
        for (int i = 0; i < filteredSavedRegisters.length; ++i) {
            if (filteredSavedRegisters[i] == null) continue;
            ++total;
        }
        Register[] keys = new Register[total];
        int[] values = new int[total];
        if (total != 0) {
            int mapIndex = 0;
            for (int i = 0; i < filteredSavedRegisters.length; ++i) {
                if (filteredSavedRegisters[i] == null) continue;
                keys[mapIndex] = filteredSavedRegisters[i];
                assert (ValueUtil.isStackSlot((Value)slots[i])) : "not a StackSlot: " + slots[i];
                StackSlot slot = ValueUtil.asStackSlot((Value)slots[i]);
                values[mapIndex] = this.indexForStackSlot(slot);
                ++mapIndex;
            }
            assert (mapIndex == total);
        }
        return new RegisterSaveLayout(keys, values);
    }

    protected Register[] filterSavedRegisters(Register[] savedRegisters) {
        return savedRegisters;
    }

    private int indexForStackSlot(StackSlot slot) {
        assert (this.offsetForStackSlot(slot) % this.getTarget().wordSize == 0);
        return this.offsetForStackSlot(slot) / this.getTarget().wordSize;
    }

    public static interface ReferenceMapBuilderFactory {
        public ReferenceMapBuilder newReferenceMapBuilder(int var1);
    }
}

