/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.framemap;

import java.util.ArrayList;
import java.util.List;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.cfg.BasicBlock;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.InstructionValueConsumer;
import org.graalvm.compiler.lir.LIR;
import org.graalvm.compiler.lir.LIRValueUtil;
import org.graalvm.compiler.lir.VirtualStackSlot;
import org.graalvm.compiler.lir.framemap.FrameMap;
import org.graalvm.compiler.lir.framemap.FrameMapBuilderTool;
import org.graalvm.compiler.lir.framemap.SimpleVirtualStackSlot;
import org.graalvm.compiler.lir.framemap.VirtualStackSlotRange;
import org.graalvm.compiler.lir.gen.LIRGenerationResult;

public class FrameMapBuilderImpl
extends FrameMapBuilderTool {
    private final RegisterConfig registerConfig;
    private final CodeCacheProvider codeCache;
    private final FrameMap frameMap;
    private final List<VirtualStackSlot> stackSlots;
    private final List<CallingConvention> calls;
    private int numStackSlots;

    public FrameMapBuilderImpl(FrameMap frameMap, CodeCacheProvider codeCache, RegisterConfig registerConfig) {
        assert (registerConfig != null) : "No register config!";
        this.registerConfig = registerConfig == null ? codeCache.getRegisterConfig() : registerConfig;
        this.codeCache = codeCache;
        this.frameMap = frameMap;
        this.stackSlots = new ArrayList<VirtualStackSlot>();
        this.calls = new ArrayList<CallingConvention>();
        this.numStackSlots = 0;
    }

    @Override
    public VirtualStackSlot allocateSpillSlot(ValueKind<?> kind) {
        SimpleVirtualStackSlot slot = new SimpleVirtualStackSlot(this.numStackSlots++, kind);
        this.stackSlots.add(slot);
        return slot;
    }

    @Override
    public VirtualStackSlot allocateStackMemory(int sizeInBytes, int alignmentInBytes) {
        GraalError.guarantee(sizeInBytes > 0, "Invalid size");
        GraalError.guarantee(alignmentInBytes > 0 && CodeUtil.isPowerOf2((int)alignmentInBytes), "Invalid alignment");
        VirtualStackSlotRange slot = new VirtualStackSlotRange(this.numStackSlots++, sizeInBytes, alignmentInBytes, LIRKind.Illegal);
        this.stackSlots.add(slot);
        return slot;
    }

    @Override
    public RegisterConfig getRegisterConfig() {
        return this.registerConfig;
    }

    @Override
    public CodeCacheProvider getCodeCache() {
        return this.codeCache;
    }

    @Override
    public FrameMap getFrameMap() {
        return this.frameMap;
    }

    @Override
    public int getNumberOfStackSlots() {
        return this.numStackSlots;
    }

    @Override
    public void callsMethod(CallingConvention cc) {
        this.calls.add(cc);
    }

    @Override
    public FrameMap buildFrameMap(LIRGenerationResult res) {
        DebugContext debug = res.getLIR().getDebug();
        if (debug.areScopesEnabled()) {
            FrameMapBuilderImpl.verifyStackSlotAllocation(res);
        }
        for (CallingConvention cc : this.calls) {
            this.frameMap.callsMethod(cc);
        }
        this.frameMap.finish();
        return this.frameMap;
    }

    private static void verifyStackSlotAllocation(LIRGenerationResult res) {
        LIR lir = res.getLIR();
        InstructionValueConsumer verifySlots = (op, value, mode, flags) -> {
            assert (!LIRValueUtil.isVirtualStackSlot(value)) : String.format("Instruction %s contains a virtual stack slot %s", op, value);
        };
        for (BasicBlock block : lir.getControlFlowGraph().getBlocks()) {
            lir.getLIRforBlock(block).forEach(op -> {
                op.visitEachInput(verifySlots);
                op.visitEachAlive(verifySlots);
                op.visitEachState(verifySlots);
                op.visitEachTemp(verifySlots);
                op.visitEachOutput(verifySlots);
            });
        }
    }

    @Override
    public List<VirtualStackSlot> getStackSlots() {
        return this.stackSlots;
    }
}

